Unit UseTCP4W;
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{                                                                 }
{                                                                 }
{                                                                 }
{   TCP4W.DLL  (Version 1.0)                                      }
{                                                                 }
{                                                                 }
{                                                   By Ph. Jounin }
{                                        Internet ark@ifh.sncf.fr }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{  Pascal Interface written by Andreas Tikart AStA Uni Konstanz   }
{  (Andreas.Tikart@uni-konstanz.de) in cooperation with Polarwolf }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }

Interface

Uses WinTypes, WinProcs;

Type PSocket = ^TSocket;
     TSocket = THandle;

     TIP = Record
       Case Byte Of
         0: (B1, B2, B3, B4: Byte);
         1: (L: Longint);
       End;

Const
{ ------------------------------- }
{ Return codes of TCP4W functions }
{ ------------------------------- }
IP_SUCCESS         =  1;  { >=1 function OK            }
IP_ERROR           = -1;  { error                      }
IP_TIMEOUT         = -2;  { timeout has occured        }
IP_BUFFERFREED     = -3;  { the buffer has been freed  }
IP_HOSTUNKNOWN     = -4;  { connect to unknown host    }
IP_NOMORESOCKET    = -5;  { all socket has been used   }
IP_NOMORERESOURCE  = -5;  { or no more free resource   }
IP_CONNECTFAILED   = -6;  { connect function has failed}
IP_UNMATCHEDLENGTH = -7;  { TcpPPRecv : Error in length}
IP_BINDERROR       = -8;  { bind failed (Task already started?) }
IP_OVERFLOW        = -9;  { Overflow during TcpPPRecv  }
IP_EMPTYBUFFER     =-10;  { TcpPPRecv receives 0 byte  }
IP_CANCELLED       =-11;  { Call cancelled by TcpAbort }
IP_INSMEMORY       =-12;  { Not enough memory          }
IP_SOCKETCLOSED    =  0;  { Host has close connection  }

{ ------------------------------ }
{ Return codes of TN4W functions }
{ ------------------------------ }
TN_SUCCESS       =  IP_SUCCESS;
TN_ERROR         =  IP_ERROR;
TN_TIMEOUT       =  IP_TIMEOUT;
TN_BUFFERFREED   =  IP_BUFFERFREED;
TN_SOCKETCLOSED  =  IP_SOCKETCLOSED;
TN_OVERFLOW      = 2;

Type
{ ------------------------------------------------- }
{ Registration functions                            }
{ ------------------------------------------------- }
TTcp4wInit = Function: Integer;
TTcp4wCleanup = Function: Integer;
TTcp4wVer = Function (szVerStr: PChar; nStrSize: Integer): Integer;

{ ------------------------------------------------- }
{ TCP functions                                     }
{ ------------------------------------------------- }
TTcpAbort = Function: Integer;
TTcpAccept = Function (Var CSock: TSocket; ListenSock: TSocket; nTO: Integer): Integer;
TTcpConnect = Function (Var S: TSocket; szServer, szService: PChar; Var lpPort: Integer): Integer;
TTcpClose = Function (Var S: TSocket): Integer;
TTcpFlush = Function (S: TSocket): Integer;
TTcpGetListenSocket = Function (Var S: TSocket; szService: PChar; Var lpPort: Integer; nPendingConnection: Integer): Integer;
TTcpGetLocalID = Function (szStrName: PChar; NameSize: Integer; Var lpAddress: TIP): Integer;
TTcpGetRemoteID = Function (S: TSocket; szStrName: PChar; NameSize: Integer; Var lpAddress: TIP): Integer;
TTcpRecv = Function (S: TSocket; szBuf: PChar; BufSize, TimeOut: Integer; hf: Integer): Integer;
TTcpSend = Function (S: TSocket; szBuf: PChar; BufSize: Integer; bHighPriority: Bool; hf: Integer): Integer;
TTcpIsDataAvail = Function (S: TSocket): Integer;

{ PP protocole (2 first bytes contain length of data) }
TTcpPPRecv = Function (S: TSocket; szBuf: PChar; BufSize, TimeOut: Integer; bExact: Bool; hLogFile: Integer): Integer;
TTcpPPSend = Function (S: TSocket; szBuf: PChar; BufSize: Integer; hLogFile: Integer): Integer;

TTcpRecvUntilStr = Function (S: TSocket; szBuf: PChar; Var lpBufSize: Integer;
    szStop: PChar; StopSize: Integer; bCaseSensitive: Bool; TimeOut: Integer; hLogFile: Integer): Integer;

{ ------------------------------------------------- }
{ Telnet functions                                  }
{ ------------------------------------------------- }
TTnReadLine = Function (S: TSocket; szBuf: PChar; BufSize, TimeOut: Integer; hf: Integer): Integer;
TTnSend = Function (S: TSocket; szString: PChar; bHighPriority: Bool; hf: Integer): Integer;
TTnGetAnswerCode = Function (ctrl_skt: TSocket; szInBuf: PChar; BufSize, TimeOut: Integer; hf: Integer): Integer;

Var
{ ------------------------------------------------- }
{ Var's                                             }
{ ------------------------------------------------- }
Tcp4wInit: TTcp4wInit;
Tcp4wCleanup: TTcp4wCleanup;
Tcp4wVer: TTcp4wVer;
TcpAbort: TTcpAbort;
TcpAccept: TTcpAccept;
TcpConnect: TTcpConnect;
TcpClose: TTcpClose;
TcpFlush: TTcpFlush;
TcpGetListenSocket: TTcpGetListenSocket;
TcpGetLocalID: TTcpGetLocalID;
TcpGetRemoteID: TTcpGetRemoteID;
TcpRecv: TTcpRecv;
TcpSend: TTcpSend;
TcpIsDataAvail: TTcpIsDataAvail;
TcpPPRecv: TTcpPPRecv;
TcpPPSend: TTcpPPSend;
TcpRecvUntilStr: TTcpRecvUntilStr;
TnReadLine: TTnReadLine;
TnSend: TTnSend;
TnGetAnswerCode: TTnGetAnswerCode;

{Extra Functions}
Function  TCP4W_Error (ErrorValue: Integer): PChar;

Implementation

Var hTcp4w: THandle;
    SaveExitProc : Pointer;

Procedure OpenTcp4wDLL;
  Var FP: TFarProc;
  Begin
    hTcp4w := LoadLibrary ('TCP4W.DLL');
    If hTcp4w < 32 Then Exit;
    FP := GetProcAddress (hTcp4W, 'Tcp4wInit');
    Tcp4wInit := TTcp4wInit (FP);
    FP := GetProcAddress (hTcp4W, 'Tcp4wCleanup');
    Tcp4wCleanup := TTcp4wCleanup (FP);
    FP := GetProcAddress (hTcp4W, 'Tcp4wVer');
    Tcp4wVer := TTcp4wVer (FP);
    FP := GetProcAddress (hTcp4W, 'TcpAbort');
    TcpAbort := TTcpAbort (FP);
    FP := GetProcAddress (hTcp4W, 'TcpAccept');
    TcpAccept := TTcpAccept (FP);
    FP := GetProcAddress (hTcp4W, 'TcpConnect');
    TcpConnect := TTcpConnect (FP);
    FP := GetProcAddress (hTcp4W, 'TcpClose');
    TcpClose := TTcpClose (FP);
    FP := GetProcAddress (hTcp4W, 'TcpFlush');
    TcpFlush := TTcpFlush (FP);
    FP := GetProcAddress (hTcp4W, 'TcpGetListenSocket');
    TcpGetListenSocket := TTcpGetListenSocket (FP);
    FP := GetProcAddress (hTcp4W, 'TcpGetLocalID');
    TcpGetLocalID := TTcpGetLocalID (FP);
    FP := GetProcAddress (hTcp4W, 'TcpGetRemoteID');
    TcpGetRemoteID := TTcpGetRemoteID (FP);
    FP := GetProcAddress (hTcp4W, 'TcpRecv');
    TcpRecv := TTcpRecv (FP);
    FP := GetProcAddress (hTcp4W, 'TcpSend');
    TcpSend := TTcpSend (FP);
    FP := GetProcAddress (hTcp4W, 'TcpIsDataAvail');
    TcpIsDataAvail := TTcpIsDataAvail (FP);
    FP := GetProcAddress (hTcp4W, 'TcpPPRecv');
    TcpPPRecv := TTcpPPRecv (FP);
    FP := GetProcAddress (hTcp4W, 'TcpPPSend');
    TcpPPSend := TTcpPPSend (FP);
    FP := GetProcAddress (hTcp4W, 'TcpRecvUntilStr');
    TcpRecvUntilStr := TTcpRecvUntilStr (FP);
    FP := GetProcAddress (hTcp4W, 'TnReadLine');
    TnReadLine := TTnReadLine (FP);
    FP := GetProcAddress (hTcp4W, 'TnSend');
    TnSend := TTnSend (FP);
    FP := GetProcAddress (hTcp4W, 'TnGetAnswerCode');
    TnGetAnswerCode := TTnGetAnswerCode (FP);
  End;

Function TCP4W_Error (ErrorValue: Integer): PChar;
  {return a PChar related to the ErrorValue given}
  {as a parameter}
  Var Msg: PChar;
  Begin
    Case ErrorValue Of
        IP_ERROR           : Msg :=  'error';
        IP_TIMEOUT         : Msg :=  'timeout has occured';
        IP_BUFFERFREED     : Msg :=  'the buffer has been freed';
        IP_HOSTUNKNOWN     : Msg :=  'connect to unknown host';
        IP_NOMORESOCKET    : Msg :=  'all socket has been used';
        IP_NOMORERESOURCE  : Msg :=  'or no more free resource';
        IP_CONNECTFAILED   : Msg :=  'connect function has failed';
        IP_UNMATCHEDLENGTH : Msg :=  'Error in length';
        IP_BINDERROR       : Msg :=  'bind failed (Task already started?)';
        IP_OVERFLOW        : Msg :=  'Overflow during TcpPPRecv';
        IP_EMPTYBUFFER     : Msg :=  'TcpPPRecv receives 0 byte';
        IP_CANCELLED       : Msg :=  'Call cancelled by TcpAbort';
        IP_INSMEMORY       : Msg :=  'Not enough memory';
        IP_SOCKETCLOSED    : Msg :=  'Host has close connection';
      Else Msg := 'Unknown Error';
      End;
    TCP4W_Error := MSG;
  End;

Procedure MyExitProc; Far;
  Begin
    ExitProc := SaveExitProc;
    If hTcp4W >= 32 Then
      Begin
        Tcp4WCleanUp;
        FreeLibrary (hTcp4W);
      End;
  End;

Begin
  hTcp4W := 0;
  SaveExitProc := ExitProc;
  ExitProc := @MyExitProc;
  OpenTcp4wDLL;
  If hTcp4W < 32 Then
    Begin
      MessageBox (0, 'TCP4W not found', '', mb_IconStop + mb_SystemModal + mb_Ok);
      Halt
    End
End.
