.*! html2ipf 0.2

:userdoc.:title.fte Manual

:h1.About 
:i1 id=about.About

:lines align=center.
fte
.br
Version :hp2.0.32b:ehp2.
.br
(c) Copyright 1995 Marko Macek
.br
:elines.
:p.
:hp1.fte:ehp1. is an OS/2 text mode editor, with a lot of features&colon.
:ul compact.
 :li.Powerful Color Syntax Highlighting for&colon.
  :ul compact.
   :li.C/C++
   :li.REXX
   :li.HTML
   :li.IPF
   :li.Perl
   :li.Ada
   :li.Pascal
   :li.Java
   :li.and various other files...
  :eul.
 :li.Smart Indentation for C/C++ and REXX
 :li.Multiple files/windows
 :li.File limited only by virtual memory
 :li.Configurable keyboard/menus/colors
 :li.Undo/Redo of any number of commands
 :li.Stream/Line/Column blocks
 :li.Ability to edit binary files
 :li.Regular expression search and replace
 :li.Background compilation and compiler error parsing support
 :li.Mouse support
 :li.Automatic word wrap.
 :li.Incremental search.
 :li.Folding
:eul.
:p.
:lines align=center.
The latest version can be always downloaded from&colon.
.br
:hp2.http&colon.//ixtas.fer.uni-lj.si/~markom/fte:ehp2.
.br
:p.
Please send comments/suggestions/bug reports to&colon.
.br
:hp2.Marko.Macek@snet.fer.uni-lj.si:ehp2.
.br
or
.br
:hp2.mark@hermes.si:ehp2.
.br
:elines.


.br
:h1.Configuration 
:i1 id=config.Configuration

:p.
This section covers installation and configuration of editor.

.br
:h2.Installation 
:i1 id=install.Installation

:p.
The following files are included in the archive&colon.
:dl compact tsize=8 break=all.
:dt.:hp2.README:ehp2.
:dd.Release notes, read first
:dt.:hp2.fte.exe:ehp2.
:dd.Main executable (:hp2.REQUIRED:ehp2.)
:dt.:hp2.fte.cfg:ehp2.
:dd.Main configuration file
:dt.:hp2.fte.inf:ehp2.
:dd.This file.
:dt.:hp2.config\*.fte:ehp2.
:dt.Configuration files
:dt.:hp2.clipserv.exe:ehp2.
:dd.Clipboard server (required for PM clipboard support).
:dt.:hp2.cliputil.exe:ehp2.
:dd.Utility to manage clipboard from command line.
:dt.:hp2.file_id.diz:ehp2.
:dd.Program description for BBS upload.
:edl.
:p.
To install, copy :hp1.FTE.EXE:ehp1., :hp1.CLIPSERV.EXE:ehp1., :hp1.CLIPUTIL.EXE:ehp1., 
:hp1.FTE.CFG:ehp1., :hp1.FTE.INF:ehp1. into one directory and and :hp1.*.FTE:ehp1. files
into the other. Then change :hp1.FTE.CFG:ehp1. to point to the :hp1.MAIN.FTE:ehp1. 
file. Then, make sure that :hp1.PATH:ehp1. environment variable points to 
the directory containing the executable.

:hp2.fte.exe:ehp2.

.br
:h2.Command line options 
:i1 id=cmdarg.Command line options

:p.
The command syntax is&colon.
:p.
:hp2.fte [[options] [files] ...]:ehp2.
:p.
Options&colon.
:dl compact tsize=8 break=all.
:dt.:hp2.-!:ehp2.
:dd.Ignore any external configuration file.
:dt.:hp2.-c<file>:ehp2.
:dd.Use specified configuration file.
:dt.:hp2.-#<line>[,<column>]:ehp2.
:dd.Go to line (and column) in next file on command line
:dt.:hp2.-m<MODE>:ehp2.
:dd.Set mode for next files to <MODE>
:dt.:hp2.-m:ehp2.
:dd.Reset to default mode
:dt.:hp2.--:ehp2.
:dd.The rest of the arguments are not options
:dt.:hp2.-+:ehp2.
:dd.The next argument is not an option even if starting with a '-'.
:edl.
:p.
Examples&colon.
:dl compact tsize=8 break=all.
:dt.:hp2.fte -mBIN fte.exe:ehp2.
:dd.load fte.exe in BIN mode
:dt.:hp2.fte -#100,30 win.c:ehp2.
:dd.go to (100,30) in win.c
:dt.:hp2.fte window.cpp:ehp2.
:dd.load file window.cpp
:dt.:hp2.fte -mBIN fte.exe -m fte.cpp:ehp2.
:dd.load fte.exe in binary mode, window.cpp in default mode (C/C++)
:dt.:hp2.fte -mBIN -+ -bla-:ehp2.
:dd.load file -bla- in BIN mode
:dt.:hp2.fte -- -1 -2 -3 -4 -5 -6:ehp2.
:dd..load files -1, -2, -3, -4, -5, -6
:edl.

.br
:h2.Configuration file 
:i1 id=cfgfile.Configuration file

:p.
If the command line option :hp2.-!:ehp2. is used, editor will not attemp to load
a configuration file and will use default settings built into the
editor executable.
:p.
All configuration is done in :hp2.fte.cfg:ehp2.. file which must reside
in the same directory as the :hp2.fte.Exe:ehp2. executable. Most of
the settings in configuration file are :hp2.CASE SENSITIVE:ehp2..
:hp2.'#':ehp2.. is used to start a comment to the end of line.

.br
:h2.Global Settings 
:i1 id=global.Global Settings


The following settings can be used in the :hp2.GLOBAL:ehp2. section of
the configuration file.
:dl compact tsize=8 break=all.
:dt.:hp2.ScreenSizeX:ehp2.
:dd.Number of columns visible on screen or window
:dt.:hp2.ScreenSizeY:ehp2.
:dd.Number of lines visible on screen or window
:dt.:hp2.CursorInsertStart:ehp2.
:dd.Starting percentage of cursor size (from top) when in insert mode.
:dt.:hp2.CursorInsertEnd:ehp2.
:dd.Ending percentage of cursor size when in insert mode.
:dt.:hp2.CursorOverStart:ehp2.
:dd.Starting percentage of cursor size when in overstrike mode
:dt.:hp2.CursorOverEnd:ehp2.
:dd.Ending percentage of cursor size when in overstrike mode.
:dt.:hp2.SysClipboard:ehp2.
:dd.When set to 1, editor will use external (PM) clipboard instead of internal one.
:dt.:hp2.SelectPathname:ehp2.
:dd.If set to 1, pathname will be selected by default when prompting for a file.
:dt.:hp2.LoadAfterQuit:ehp2.
:dd.If set to 1, editor will prompt for another file when all are closed.
:dt.:hp2.ShowMenuBar:ehp2.
:dd.If set to 1, main menu bar will be visible by default.
:dt.:hp2.ShowScrollBar:ehp2.
:dd.If set to 1, scroll bar will be visible by default.
:dt.:hp2.ScrollBarWidth:ehp2.
:dd.Scroll bar width in characters
:dt.:hp2.DefaultModeName:ehp2.
:dd.Default mode name for loading files. If not set or invalid, first mode 
in the configuration file will be used instead.
:dt.:hp2.CompletionFilter:ehp2.
:dd.Files matching this regexp are ignored when doing filename completion.
:dt.:hp2.WSStyleSearch:ehp2.
:dd.If set to 1, editor will use WordStar style prompts with separate prompts 
for search, replace string and options instead of the default search/replace/options
style.
:dt.:hp2.CompileRx:ehp2.
:dd.Defines regexp and subpatterns to match when searching for errors/warnings
in compilation output. First number is a number of the subpattern that matches 
filename. The second must match the line number, the third parameter is 
the regular expression to match to each line of the compiler output.
:dt.:hp2.C_:ehp2.:hp1.*:ehp1.
:dd.Define the C mode smart indentation parameters
:dt.:hp2.REXX_Indent:ehp2.
:dd.Defines the REXX basic indentation level
:edl.


.br
:h2.Editing Modes 
:i1 id=editmode.Editing Modes

:p.
fte allows each file extension to have a different editing mode. Mode
is a collection of editor settings such as keybindings, tab settings,
autoindent settings, syntax highlighting,...
:p.
Syntax of :hp2.mode:ehp2. command is
:p.
:xmp.
mode NAME { mode settings }
mode NAME&colon. PARENT { mode settings }
mode NAME&colon. PARENT, :hp1."filename regexp":ehp1. { mode settings }
mode NAME&colon. PARENT, :hp1."filename regexp":ehp1., :hp1."first line regexp":ehp1. { mode settings }
:exmp.
:p.
Mode with name :hp1.NAME:ehp1.inherits settings from mode :hp1.PARENT:ehp1. if 
parent mode is specified at mode declaration.
:p.
When editor is searching for a mode to use for a file it will first check 
if the mode has been overriden by a :hp2.FileLoadInMode:ehp2. command or a
command line option (:hp2.-m:ehp2.).
:p.
Then it will check if the file name matches any of the :hp1."filename regexps":ehp1.
listed with mode declarations. 
:p.
If the mode has still not been found, it will read the first line
(max 80 chars) of the file, and attempt to match the :hp1."first line regexp":ehp1.
with the first line. 
:p.
If this fails, editor will use mode specified by :hp2.DefaultModeName:ehp2. 
setting to load a file. If that mode does not exist, first mode defined
in the configuration file will be used.


.br
:h2.Mode Settings 
:i1 id=modesetup.Mode Settings

:p.
The following settings can be specified for each mode&colon.
:dl compact tsize=8 break=all.
:dt.:hp2.ExpandTabs:ehp2. {0,1}
:dd.Should be set to 1 if tabs are to be expanded when displayed.
:dt.:hp2.TabSize:ehp2. {1-32}
:dd.Tab size when tabs are shown expanded on display.
:dt.:hp2.AutoIndent:ehp2. {0,1}
:dd.Should be set to 1 if autoindent is to be used.
:dt.:hp2.Insert:ehp2. {0,1}
:dd.If set to :hp2.1:ehp2., Insert mode is active by default. 
If set to :hp2.0:ehp2., Overwrite mode is activated.
:dt.:hp2.StripChar:ehp2. {ASCII code}
:dd.This characted will be stripped if at the end of line when the 
file is being loaded. If it is set to :hp2.-1:ehp2., no characted will 
be stripped.
:dt.:hp2.LineChar:ehp2. {ASCII code}
:dd.This character is used as a line separator when loading a file.
If set to :hp2.-1:ehp2., there is no line separator. (:hp2.WARNING&colon. File will
be loaded as one line if LineChar is set to -1:ehp2.). 
:dt.:hp2.AddCR:ehp2. {0,1}
:dd.If set to :hp2.1:ehp2., CR (13, \r) character will be added to end of line when saving.
:dt.:hp2.AddLF:ehp2. {0,1}
:dd.If set to :hp2.1:ehp2., LF (10, \n) characted will be added to end if line when saving.
:dt.:hp2.ForceNewLine:ehp2. {0,1}
:dd.Normally, when saving, the last line is saved without any CR/LF characters. This setting will override that behaviour.
:dt.:hp2.Hilit:ehp2. {0,1}
:dd.If set to :hp2.1:ehp2., syntax highliting will be active
:dt.:hp2.ShowTab:ehp2. {0,1}
:dd.If set to :hp2.1:ehp2., tabs will be visible as circles (EPM-like).
:dt.:hp2.IndentMode:ehp2. {PLAIN,C,REXX}
:dd.Activates the specified smart indent mode. (PLAIN is not really smart &colon.))
:dt.:hp2.HilitMode:ehp2. {PLAIN,C,HTML,MAKE,REXX,DIFF,IPF,PERL,MERGE,Ada}
:dd.Activates the specified coloring mode. :hp2.PLAIN:ehp2. specifies no coloring.
:dt.:hp2.UndoLimit:ehp2. {Number}
:dd.Limit undo to this many recent commands (-1 = unlimited)
:dt.:hp2.KeepBackups:ehp2. {0,1}
:dd.If set to :hp2.0:ehp2., backup files will be deleted after a successful save operation.
:dt.:hp2.MatchCase:ehp2. {0,1}
:dd.If set to :hp2.0:ehp2., searches will be case insensitive. This
can be toggled via :hp2.ToggleMatchCase:ehp2.(:hp2.C-O_C-C:ehp2.) command when editor is running.
:dt.:hp2.BackSpKillTab:ehp2. {0,1}
:dd.If set to 1, :hp2.BackSpace:ehp2. will kill entire tabs instead of converting them to spaces.
:dt.:hp2.DeleteKillTab:ehp2. {0,1}
:dd.If set to 1, :hp2.Delete:ehp2. will kill entire tabs instead of converting them to spaces.
:dt.:hp2.BackSpUnindents:ehp2. {0,1}
:dd.If set to 1, :hp2.BackSpace:ehp2. will inindent to previous indentation level if issued on beginning of line.
:dt.:hp2.SpaceTabs:ehp2. {0,1}
:dd.If set to 1, :hp2.InsertTab:ehp2. command will insert spaces instead of tabs.
:dt.:hp2.IndentWithTabs:ehp2. {0,1}
:dd.If set to 1, indentation will be done using tabs instead of spaces.
:dt.:hp2.WordWrap:ehp2. {0,1,2}
:dd.If set to 1, editor wrap current line when right margin is reached. If set to 2, editor will wrap current paragraph continously.
:dt.:hp2.LeftMargin:ehp2. {1-xx}
:dd.Left margin for word wrap.
:dt.:hp2.RightMargin:ehp2. {1-xx}
:dd.Right margin for word wrap.
:dt.:hp2.Trim:ehp2. {0,1}
:dd.If set to 1, spaces on the end of line will be trimmed when editing.
:dt.:hp2.ShowMarkers:ehp2. {0,1}
:dd.If set to 1, end of line and end of file markers will be shown.
:dt.:hp2.CursorTroughTabs:ehp2. {0,1}
:dd.If set to 1, editor will allow cursor position inside tabs.
:dt.:hp2.DefFindOpt:ehp2. 'options'
:dd.Default search options for :hp2.Find:ehp2. command.
:dt.:hp2.DefFindReplaceOpt:ehp2. 'options'
:dd.Default search/replace options for :hp2.FindReplace:ehp2. command.
:dt.:hp2.MainMenu:ehp2. "menu"
:dd.Main menu displayed when editing in this mode.
:dt.:hp2.LocalMenu:ehp2. "menu"
:dd.Local menu used when editing in this mode.
:dt.:hp2.SaveFolds:ehp2. {0,1,2}
:dd.If 0, folds are not saved. If 1, folds are saved at BOL, if 2 folds are saved at EOL.
:dt.:hp2.CommentStart:ehp2. "comment-start-string"
:dd.String that starts comments (for saving folds)
:dt.:hp2.CommentEnd:ehp2. "comment-ent-string"
:dd.String that ends comments
:edl.

.br
:h3.Loading files in various formats 
:i1 id=loading.Loading files in various formats

:p.
Here are settings for loading files in various formats&colon.
:p.
:dl compact tsize=8 break=all.
:dt.DOS/Win/OS2/NT text files (CR/LF delimited)&colon.
:dd.
:xmp.
          StripChar      13
          LineChar       10
          AddCR          1
          AddLF          1
:exmp.

.br
:dt.UNIX text files (LF delimited)&colon.
:dd.
:xmp.
          StripChar      -1
          LineChar       10
          AddCR          0
          AddLF          1
:exmp.
:dt.MAC text files (CR delimited)&colon.
:dd.
:xmp.
          StripChar      -1
          LineChar       13
          AddCR          1
          AddLF          0
:exmp.
:dt.Binary files (fixed record length)&colon.
:dd.
:xmp.
          StripChar      -1
          LineChar       -1
          AddCR          0
          AddLF          0
          LoadMargin     64
          ForceNewLine   0
:exmp.          
:edl.

.br
:h2.Mode Keyboard Mappings 
:i1 id=modekeys.Mode Keyboard Mappings

:p.
Keybindings are inherited from parent modes unless overriden.
:p.
Here are some examples of key specifiactions&colon.
:dl compact tsize=8 break=all.
:dt.[A]:dd.Uppercase a
:dt.[a]:dd.Lowercase a 
:dt.[;]:dd.Semicolon
:dt.[A-A]:dd.Alt+A
:dt.[C-B]:dd.Ctrl+B
:dt.[A-C-F1]:dd.Alt+Ctrl+F1
:dt.[A-C-S-F1]:dd.Alt+Ctrl+Shift+F1
:dt.[A-Space]:dd.Alt+Space
:dt.[C-K_C-B]:dd.Ctrl+K and then Ctrl+B (two keys)
:dt.[C-A_C-B_C-C]:dd.Ctrl+A Ctrl+B Ctrl+C must be pressed in sequence.
:dt.[G--]:dd.Gray -
:dt.[G-+]:dd.Gray +
:dt.[C-\\]:dd.Ctrl+Backslash
:dt.[C-\[]:dd.Ctrl+[
:edl.
:p.The following special keys are available (case sensitive)&colon.
:p.:hp2.F1-F12 Home End PgUp PgDn Insert Delete Up Down Left Right 
Enter Esc BackSp Space Tab:ehp2.
:p.Keys are bound using the :hp2.key:ehp2. command&colon.
:p.:hp2.key:ehp2. :hp2.[keyspec]:ehp2. { :hp1.editor commands:ehp1. }
:p.ASCII characters >= 32 are bound to SelfInsert by default.
:p.See fte.Cfg for examples and default configuration.

.br
:h2.Colors 
:i1 id=colors.Colors

Colors are configured in COLOR.FTE file.
:p.
Syntax for color settings is&colon.
:p.:hp2.color:ehp2. { { 'name', 'value' } ... } 
:p.Value is the PC character attribute first char is background color, the second is foreground color.
:p.Colors are as follows&colon.
:xmp.
        0        Black
        1        Dark Blue
        2        Dark Green 
        3        Dark Cyan
        4        Dark Red
        5        Dark Magenta
        6        Orange
        7        Pale Gray
        8        Dark Gray
        9        Blue
        A        Green
        B        Cyan
        C        Red
        D        Magenta
        E        Yellow
        F        White
:exmp.

.br
:h1.Status Line 
:i1 id=status.Status Line

:p.Status line displays the following status information&colon.
:p.:hp2.position flags modename [curchar] mod? filename:ehp2.
:p.:hp2.position:ehp2. = visible_line, actual_line&colon. column, character_number
:p.:hp2.flags:ehp2.
:dl compact tsize=8 break=all.
:dt.I:dd.Insert
:dt.A:dd.Autoindent
:dt.T:dd.Tabs Expanded (only on display, not file)
:dt.C:dd.Matches are case sensitive
:dt.wW:dd.Automatic word wrap active (w = line, W = paragraph).
:dt.U:dd.Undo/Redo active
:dt.E:dd.Trim active (spaces at EOL trimmed)
:dt.SLC:dd.Stream, Line, Column block-mode
:dt.X:dd.AutoExtend block-mode
:edl.
:p.:hp2.mode:ehp2.      = Mode name as specified in configuration file
:p.:hp2.curchar:ehp2.   = Dec,Hex ASCII code of current character
:p.:hp2.mod?:ehp2.      = :hp2.*:ehp2. if file was modified, :hp2.%:ehp2. if file is read-only


.br
:h1.Editor Commands 
:i1 id=editcmds.Editor Commands

:p.These commands can be bound to keys in configuration file&colon.

.br
:h2.Cursor Movement 
:i1 id=cmdcursor.Cursor Movement

:dl compact tsize=8 break=all.
:dt.:hp2.MoveLeft:ehp2.:dd.Move cursor left one character
:dt.:hp2.MoveRight:ehp2.:dd.Move cursor right one character
:dt.:hp2.MoveUp:ehp2.:dd.Move cursor up one line
:dt.:hp2.MoveDown:ehp2.:dd.Move cursor down one line
:dt.:hp2.MovePrev:ehp2.:dd.Move cursor to previous character
:dt.:hp2.MoveNext:ehp2.:dd.Move cursor to next character
:dt.:hp2.MoveWordLeft:ehp2.:dd.Move cursor one word left
:dt.:hp2.MoveWordRight:ehp2.:dd.Move cursor one word right
:dt.:hp2.MoveWordPrev:ehp2.:dd.Move cursor to start of previous word
:dt.:hp2.MoveWordNext:ehp2.:dd.Move cursor to start of next word
:dt.:hp2.MoveLineStart:ehp2.:dd.Move cursor to beginning of line
:dt.:hp2.MoveLineEnd:ehp2.:dd.Move cursor to end of line
:dt.:hp2.MovePageUp:ehp2.:dd.Move cursor to previous page
:dt.:hp2.MovePageDown:ehp2.:dd.Move cursor to next page
:dt.:hp2.MovePageLeft:ehp2.:dd.Move cursor one page left
:dt.:hp2.MovePageRight:ehp2.:dd.Move cursor one page right
:dt.:hp2.MovePageStart:ehp2.:dd.Move cursor to top of page
:dt.:hp2.MovePageEnd:ehp2.:dd.Move cursor top bottom of page
:dt.:hp2.MoveFileStart:ehp2.:dd.Move cursor to start of buffer
:dt.:hp2.MoveFileEnd:ehp2.:dd.Move cursor to end of buffer
:dt.:hp2.MoveBlockStart:ehp2.:dd.Move cursor to beginning of block
:dt.:hp2.MoveBlockEnd:ehp2.:dd.Move cursor to end of block
:dt.:hp2.ScrollLeft:ehp2.:dd.Scroll screen left 8 characters
:dt.:hp2.ScrollRight:ehp2.:dd.Scroll screen right 8 characters
:dt.:hp2.ScrollDown:ehp2.:dd.Scroll screen down 1 line
:dt.:hp2.ScrollUp:ehp2.:dd.Scroll screen up 1 line
:dt.:hp2.MoveFirstNonWhite:ehp2.:dd.Move to first non whitespace character on line
:dt.:hp2.MoveLastNonWhite:ehp2.:dd.Move after last non whitespace character on line
:dt.:hp2.MovePrevEqualIndent:ehp2.:dd.Move to previous line with indentation equal to current.
:dt.:hp2.MoveNextEqualIndent:ehp2.:dd.Move to next line with indentation equal to current.
:dt.:hp2.MovePrevTab:ehp2.:dd.Move cursor to previous tab stop.
:dt.:hp2.MoveNextTab:ehp2.:dd.Move cursor to next tab stop.
:dt.:hp2.MovePrevPos:ehp2.:dd.Move to previous position
:dt.:hp2.SavePos:ehp2.:dd.Save current position
:dt.:hp2.MoveSavedPos:ehp2.:dd.Restore saved position
:dt.:hp2.MoveSavedPosCol:ehp2.:dd.Restore saved position column
:dt.:hp2.MoveSavedPosRow:ehp2.:dd.Restore saved position row
:dt.:hp2.MoveLineTop:ehp2.:dd.Move current line to top of window
:dt.:hp2.MoveLineCenter:ehp2.:dd.Move current line to center of window
:dt.:hp2.MoveLineBottom:ehp2.:dd.Move current line to bottom of window
:edl.

.br
:h2.Text deleting 
:i1 id=cmddelete.Text deleting

:dl compact tsize=8 break=all.
:dt.:hp2.KillLine:ehp2.:dd.Delete current line
:dt.:hp2.KillChar:ehp2.:dd.Delete character under cursor
:dt.:hp2.KillCharPrev:ehp2.:dd.Delete character before cursor
:dt.:hp2.KillWord:ehp2.:dd.Delete next word
:dt.:hp2.KillWordPrev:ehp2.:dd.Delete previous word
:dt.:hp2.KillToLineStart:ehp2.:dd.Delete text to line start
:dt.:hp2.KillToLineEnd:ehp2.:dd.Delete text to line end
:dt.:hp2.KillBlock:ehp2.:dd.Kill text in block
:dt.:hp2.BackSpace:ehp2.:dd.Delete character before cursor (configurable)
:dt.:hp2.Delete:ehp2.:dd.Delete character under cursor (configurable)
:edl.

.br
:h2.Line commands 
:i1 id=cmdsline.Line commands

:dl compact tsize=8 break=all.
:dt.:hp2.LineInsert:ehp2.:dd.Insert empty line before current line
:dt.:hp2.LineAdd:ehp2.:dd.Add line after current
:dt.:hp2.LineSplit:ehp2.:dd.Split line at current cursor position
:dt.:hp2.LineJoin:ehp2.:dd.Join line with next one
:dt.:hp2.LineNew:ehp2.:dd.Add new line after current one, move to next line and autoindent
:dt.:hp2.LineIndent:ehp2.:dd.Reindent current line
:dt.:hp2.LineTrim:ehp2.:dd.Trim spaces at the end of current line
:edl.

.br
:h2.Text insertion 
:i1 id=cmdinsert.Text insertion

:dl compact tsize=8 break=all.
:dt.:hp2.InsertTab:ehp2.:dd.Insert Tab character
:dt.:hp2.SelfInsert:ehp2.:dd.Insert character defined by last key
:dt.:hp2.WrapPara:ehp2.:dd.Word wrap paragraph (to next blank line).
:dt.:hp2.LineDuplicate:ehp2.:dd.Duplicate current line.
:dt.:hp2.InsPrevLineChar:ehp2.:dd.Insert character above current character.
:dt.:hp2.InsPrevLineToEol:ehp2.:dd.Insert previous line from current char to eol.
:dt.:hp2.CompleteWord:ehp2.:dd.Complete word to previous word starting with text before cursor.
:edl.

.br
:h2.Blocks 
:i1 id=cmdblock.Blocks

:dl compact tsize=8 break=all.
:dt.:hp2.BlockBegin:ehp2.:dd.Set block beginning to current position
:dt.:hp2.BlockEnd:ehp2.:dd.Set block end to current position
:dt.:hp2.BlockUnmark:ehp2.:dd.Unmark selected block
:dt.:hp2.BlockCut:ehp2.:dd.Cut selected block to clipboard
:dt.:hp2.BlockCopy:ehp2.:dd.Copy selected block to clipboard
:dt.:hp2.BlockPaste:ehp2.:dd.Paste clipboard to current position
:dt.:hp2.BlockPasteStream:ehp2.:dd.Paste clipboard to current position as stream block.
:dt.:hp2.BlockPasteLine:ehp2.:dd.Paste clipboard to current position as line block.
:dt.:hp2.BlockPasteColumn:ehp2.:dd.Paste clipboard to current position as column block.
:dt.:hp2.BlockKill:ehp2.:dd.Delete selected text
:dt.:hp2.BlockIndent:ehp2.:dd.Indent block by 1 character
:dt.:hp2.BlockUnindent:ehp2.:dd.Unindent block by 1 character
:dt.:hp2.BlockMarkStream:ehp2.:dd.Begin/end marking stream block
:dt.:hp2.BlockMarkLine:ehp2.:dd.Begin/end marking line block
:dt.:hp2.BlockMarkColumn:ehp2.:dd.Begin/end marking column block
:dt.:hp2.BlockExtendBegin:ehp2.:dd.Begin extending selected block
:dt.:hp2.BlockExtendEnd:ehp2.:dd.End extending selected block
:dt.:hp2.BlockReIndent:ehp2.:dd.Reindent entire block (C/REXX mode)
:dt.:hp2.BlockRead:ehp2.:dd.Read block from file
:dt.:hp2.BlockWrite:ehp2.:dd.Write marked block to file
:edl.

.br
:h2.File commands 
:i1 id=cmdfile.File commands

:dl compact tsize=8 break=all.
:dt.:hp2.FileSave:ehp2.:dd.Save current file
:dt.:hp2.FileSaveAll:ehp2.:dd.Save all loaded files
:dt.:hp2.FileSaveAs:ehp2.:dd.Save current file under a new name
:dt.:hp2.FileQuit:ehp2.:dd.Close current file
:dt.:hp2.FileQuitAll:ehp2.:dd.Close all files
:dt.:hp2.FileLoad:ehp2.:dd.Load a file
:dt.:hp2.FileLoadInMode:ehp2.:dd.Load a file in a specified mode.
:dt.:hp2.FileReload:ehp2.:dd.Reload current file
:dt.:hp2.FileNext:ehp2.:dd.Select next file in buffer ring
:dt.:hp2.FilePrev:ehp2.:dd.Select previous file in buffer ring
:edl.

.br
:h2.Window commands 
:i1 id=cmdwin.Window commands

:dl compact tsize=8 break=all.
:dt.:hp2.WinHSplit:ehp2.:dd.Split window horizontally
:dt.:hp2.WinNext:ehp2.:dd.Activate next window
:dt.:hp2.WinPrev:ehp2.:dd.Activate previous window
:dt.:hp2.WinZoom:ehp2.:dd.Make current window the only one (close all others)
:dt.:hp2.WinRefresh:ehp2.:dd.Repaint entire screen.
:edl.

.br
:h2.Undo/Redo 
:i1 id=cmdundo.Undo/Redo

:dl compact tsize=8 break=all.
:dt.:hp2.Undo:ehp2.:dd.Undo last operation
:dt.:hp2.Redo:ehp2.:dd.Redo last undone operation
:edl.

.br
:h2.Case conversion 
:i1 id=cmdcase.Case conversion

:dl compact tsize=8 break=all.
:dt.:hp2.CharCaseUp:ehp2.:dd.Convert current character to uppercase
:dt.:hp2.CharCaseDown:ehp2.:dd.Convert current character to lowercase
:dt.:hp2.CharCaseToggle:ehp2.:dd.Toggle case of current characters
:dt.:hp2.LineCaseUp:ehp2.:dd.Convert characters on current line to uppercase
:dt.:hp2.LineCaseDown:ehp2.:dd.Convert characters on current line to lowercase
:dt.:hp2.LineCaseToggle:ehp2.:dd.Toggle case of characters on current line
:dt.:hp2.BlockCaseUp:ehp2.:dd.Convert characters in selected block to uppercase
:dt.:hp2.BlockCaseDown:ehp2.:dd.Convert characters in selected block to lowercase
:dt.:hp2.BlockCaseToggle:ehp2.:dd.Toggle case of characters in selected block
:edl.

.br
:h2.Searching 
:i1 id=cmdfind.Searching

:dl compact tsize=8 break=all.
:dt.:hp2.Find:ehp2.:dd.Search for text, w/options
:dt.:hp2.FindReplace:ehp2.:dd.Search and replace text w/options. 
:dt.:hp2.FindRepeat:ehp2.:dd.Repeat last search/replace operation
:dt.:hp2.FindRepeatReverse:ehp2.:dd.Repeat last search/replace operation in opposite direction
:dt.:hp2.FindRepeatOnce:ehp2.:dd.Repeat last search/replace operation only once.
:dt.:hp2.MatchBracket:ehp2.:dd.Search for matching bracket
:dt.:hp2.IncrementalSearch:ehp2.:dd.Search incrementally for text.
:dt.:hp2.Search:ehp2.:dd.Search for text
:dt.:hp2.SearchB:ehp2.:dd.Search for text backwards
:dt.:hp2.SearchRx:ehp2.:dd.Search for regexp
:dt.:hp2.SearchReplaceRx:ehp2.:dd.Search and replace using regexp
:dt.:hp2.SearchAgain:ehp2.:dd.Search for text again
:dt.:hp2.SearchAgainB:ehp2.:dd.Search for text again backwards
:dt.:hp2.SearchReplace:ehp2.:dd.Search for text and replace
:dt.:hp2.SearchReplaceB:ehp2.:dd.Search and replace backwards
:edl.

.br
:h2.Folding 
:i1 id=cmdfold.Folding

:dl compact tsize=8 break=all.
:dt.:hp2.FoldCreate:ehp2.:dd.Create fold
:dt.:hp2.FoldCreateByRegexp:ehp2.:dd.Create folds at lines matching regexp
:dt.:hp2.FoldDestroy:ehp2.:dd.Destroy fold at current line
:dt.:hp2.FoldDestroyAll:ehp2.:dd.Destroy all folds in file
:dt.:hp2.FoldOpen:ehp2.:dd.Open fold at current line
:dt.:hp2.FoldOpenAll:ehp2.:dd.Open all folds in file
:dt.:hp2.FoldOpenNested:ehp2.:dd.Open current fold and all nested folds
:dt.:hp2.FoldClose:ehp2.:dd.Close current fold
:dt.:hp2.FoldCloseAll:ehp2.:dd.Close all folds in file
:dt.:hp2.FoldToggleOpenClose:ehp2.:dd.Toggle open/close fold.
:dt.:hp2.FoldPromote:ehp2.:dd.Make fold a higher level fold
:dt.:hp2.FoldDemote:ehp2.:dd.Make fold a lower level fold
:edl.

.br
:h2.Compile commands 
:i1 id=cmdcompile.Compile commands

:dl compact tsize=8 break=all.
:dt.:hp2.Compile:ehp2.:dd.Run compile command in background
:dt.:hp2.CompileViewErrors:ehp2.:dd.View compiler output
:dt.:hp2.CompilePrevError:ehp2.:dd.Jump to previous compiler error
:dt.:hp2.CompileNextError:ehp2.:dd.Jump to next compiler error
:edl.

.br
:h2.Settings 
:i1 id=cmdsets.Settings

:dl compact tsize=8 break=all.
:dt.:hp2.ToggleAutoIndent:ehp2.:dd.Toggle automatic indentation
:dt.:hp2.ToggleInsert:ehp2.:dd.Toggle insert/overwrite mode
:dt.:hp2.ToggleExpandTabs:ehp2.:dd.Toggle tab expansion on display
:dt.:hp2.ToggleShowTabs:ehp2.:dd.Toggle tab visibility (as circles).
:dt.:hp2.ToggleUndo:ehp2.:dd.Toggle undo/redo information saving.
:dt.:hp2.ToggleReadOnly:ehp2.:dd.Toggle read only file.
:dt.:hp2.ToggleKeepBackups:ehp2.:dd.Toggle backup files.
:dt.:hp2.ToggleMatchCase:ehp2.:dd.Toggle case sensitivity for searches
:dt.:hp2.ToggleBackSpKillTab:ehp2.:dd.Enable/disable BackSp killing entire tabs.
:dt.:hp2.ToggleDeleteKillTab:ehp2.:dd.Enable/disable Delete killing entire tabs.
:dt.:hp2.ToggleSpaceTabs:ehp2.:dd.Toggle insertion of spaces instead of tabs on Tab key.
:dt.:hp2.ToggleIndentWithTabs:ehp2.:dd.Toggle indentation with tabs.
:dt.:hp2.ToggleBackSpUnindents:ehp2.:dd.Toggle unindentation on previous indent level on BackSp.
:dt.:hp2.ToggleWordWrap:ehp2.:dd.Toggle automatic word wrap.
:dt.:hp2.ToggleTrim:ehp2.:dd.Toggle trimming of spaces at end of line.
:dt.:hp2.ToggleShowMarkers:ehp2.:dd.Toggle EOL/EOF marker visibility.
:dt.:hp2.ToggleSysClipboard:ehp2.:dd.Toggle usage of system clipboard.
:dt.:hp2.SetLeftMargin:ehp2.:dd.Set left margin to current cursor column.
:dt.:hp2.SetRightMargin:ehp2.:dd.Set right margin to current cursor column.
:dt.:hp2.ChangeTabSize:ehp2.:dd.Prompt for tab size.
:dt.:hp2.ChangeCIndent:ehp2.:dd.Prompt for indentation level for CMode smart indentation.
:dt.:hp2.ChangeCBraceOfs:ehp2.:dd.Change brace offset for CMode smart indentation.
:dt.:hp2.ChangeREXXIndent:ehp2.:dd.Prompt for indentation level for REXX smart indentation
:dt.:hp2.ChangeLeftMargin:ehp2.:dd.Prompt for left margin for word wrap.
:dt.:hp2.ChangeRightMargin:ehp2.:dd.Prompt for right margin for word wrap.
:edl.

.br
:h2.Other 
:i1 id=cmdother.Other

:dl compact tsize=8 break=all.
:dt.:hp2.ExitEditor:ehp2.:dd.Close all files and exit editor
:dt.:hp2.RunCommand:ehp2.:dd.Run command in foreground.
:dt.:hp2.ViewBuffers:ehp2.:dd.View buffer list
:dt.:hp2.ViewModeMap:ehp2.:dd.View keyboard mappings for current mode
:dt.:hp2.ChangeMode:ehp2.:dd.Activate another mode
:dt.:hp2.GetPMClip:ehp2.:dd.Copy PM clipboard to editor clipboard
:dt.:hp2.PutPMClip:ehp2.:dd.Copy editor clipboard to PM clipboard
:dt.:hp2.ShowEntryScreen:ehp2.:dd.Show saved shell screen.
:dt.:hp2.SwitchTo:ehp2.:dd.Switch to buffer with a number.
:dt.:hp2.ChangeKeys:ehp2.:dd.Change current keymap to keymap of another mode.
:dt.:hp2.ChangeFlags:ehp2.:dd.Change current flags to flags of another mode.
:dt.:hp2.ShowMenu:ehp2.:dd.Show and select from menu.
:dt.:hp2.MainMenu:ehp2.:dd.Activate menu bar.
:dt.:hp2.LocalMenu:ehp2.:dd.Activate local popup menu.
:dt.:hp2.ASCIITable:ehp2.:dd.Show a popup ASCII table.
:dt.:hp2.PlaceBookmark:ehp2.:dd.Place a named bookmark at current buffer position
:dt.:hp2.GotoBookmark:ehp2.:dd.Goto a named bookmark in current buffer
:dt.:hp2.RemoveBookmark:ehp2.:dd.Remove a named bookmark from current buffer
:edl.


.br
:h1.Regular Expressions 
:i1 id=regexp.Regular Expressions

:p.
Regular expressions are a way to specify text patterns when searching for
a text in a buffer. Regular expressions consist of normal characters
and special operator characters with a special meanings. Operators
allow you to anchor matches, match classes of characters, match given
pattern several times or match alternate patterns. Operators can be
also used to group patterns.
:p.
:hp2.Search Operators:ehp2. 
:dl compact tsize=8 break=all.
 :dt.:hp2.\:ehp2.
 :dd.Quotes next character. Character will lose it's special meaning. Can also be used to match special characters.
 :dt.:hp2.\n:ehp2.
 :dd.Matches a 0x0A (LF) character.
 :dt.:hp2.\r:ehp2.
 :dd.Matches a 0x0D (CR) character.
 :dt.:hp2.\t:ehp2.
 :dd.Matches a 0x09 (TAB) character.
 :dt.:hp2.\e:ehp2.
 :dd.Matches an escape character (0x1B)
 :dt.:hp2.\s:ehp2.
 :dd.Matches whitespace (CR, LF, TAB, SPACE) characters.
 :dt.:hp2.\S:ehp2.
 :dd.Matches non-whitespace (the reverse of \s)
 :dt.:hp2.\w:ehp2.
 :dd.Matches word character [a-zA-Z0-9]
 :dt.:hp2.\W:ehp2.
 :dd.Matches non-word character
 :dt.:hp2.\d:ehp2.
 :dd.Matches a digit [0-9].
 :dt.:hp2.\D:ehp2.
 :dd.Matches a non-digit.
 :dt.:hp2.\U:ehp2.
 :dd.Matches uppercase characters (A-Z)
 :dt.:hp2.\L:ehp2.
 :dd.Matches lowercase characters (a-z)
 :dt.:hp2.\x##:ehp2.
 :dd.Matches specified hex value (\x0A, \x0D, \x09, etc.)
 :dt.:hp2.\o###:ehp2.
 :dd.Matches specified octal value (\o000, \o015, etc.)
 :dt.:hp2.\N###:ehp2.
 :dd.Matches specified decimal value (\N000, \N013, \N009, etc.)
 :dt.:hp2.\C:ehp2.
 :dd.Starts case sensitive matching.
 :dt.:hp2.\c:ehp2.
 :dd.Starts case insensitive matching.
 :dt.:hp2.^:ehp2.
 :dd.Match a beginning of line.
 :dt.:hp2.$:ehp2.
 :dd.Match an end of line.
 :dt.:hp2..:ehp2.
 :dd.Match any character.
 :dt.:hp2.<:ehp2.
 :dd.Match beginning of word (word consists of [A-Za-z0-9]).
 :dt.:hp2.>:ehp2.
 :dd.Match end of word.
 :dt.:hp2.[ ]:ehp2.
 :dd.Specifies a class of characters ([abc123], [\]\x10], etc).
 :dt.:hp2.[ - ]:ehp2.
 :dd.Specified a range of characters ([0-9a-zA-Z_], [0-9], etc)
 :dt.:hp2.[^ ]:ehp2.
 :dd.Specifies complement class ([^a-z], [^\-], etc)
 :dt.:hp2.?:ehp2.
 :dd.Matches preceeding pattern optionally (a?bc, filename\.?, $?, etc)
 :dt.:hp2.|:ehp2.
 :dd.Matches preceeding or next pattern (a|b, c|d, abc|d). Only one character will be used as pattern unless grouped together using {} or ().
 :dt.:hp2.*:ehp2.
 :dd.Match zero or more occurances of preceeding pattern. Matching is greedy and will match as much as possible.
 :dt.:hp2.+:ehp2.
 :dd.Match one or more occurances of preceeding pattern. Match is greedy.
 :dt.:hp2.@:ehp2.
 :dd.Match zero or more occurances of preceeding pattern. Matching is non-greedy and will match as little as possible without causing the rest of the pattern match to fail.
 :dt.:hp2.#:ehp2.
 :dd.Match one or more occurances of preceeding pattern. Matching is non-greedy.
 :dt.:hp2.{ }:ehp2.
 :dd.Group patterns together to form complex pattern. ( {abc}, {abc}|{cde}, {abc}?, {word}?)
 :dt.:hp2.( ):ehp2.
 :dd.Group patterns together to form complex pattern. Also used to remember the matched substring which can be used for substitution operation. Up to 9 can be used.
:edl.
:p.
:hp2.Replace Operators&colon.:ehp2. 
:dl compact tsize=8 break=all.
 :dt.:hp2.\:ehp2.
 :dd.Causes the next character to lose it's special meaning.
 :dt.:hp2.\n:ehp2.
 :dd.Inserts a 0x0A (LF) character.
 :dt.:hp2.\r:ehp2.
 :dd.Inserts a 0x0D (CR) character.
 :dt.:hp2.\t:ehp2.
 :dd.Inserts a 0x09 (TAB) character.
 :dt.:hp2.\#:ehp2.
 :dd.Recalls stored substring from matched pattern ()'s. (\1, \2, \3, to \9)
 :dt.:hp2.\0:ehp2.
 :dd.Recalls entire matched pattern.
 :dt.:hp2.\u:ehp2.
 :dd.Convert next character to uppercase
 :dt.:hp2.\l:ehp2.
 :dd.Convert next character to lowercase
 :dt.:hp2.\U:ehp2.
 :dd.Convert to uppercase till \E or \e
 :dt.:hp2.\L:ehp2.
 :dd.Convert to lowercase till \E or \e
:edl.

.br
:h1.Search and Replace 
:i1 id=search.Search and Replace

:p.
:hp2.Search and Replace Commands&colon.:ehp2.
:p.
:dl compact tsize=8 break=all.
:dt.:hp2.Find:ehp2.:dd.Search for text w/options.
:dt.:hp2.FindReplace:ehp2.:dd.Search and replace text w/options. 
:dt.:hp2.FindRepeat:ehp2.:dd.Repeat last search/replace operation
:dt.:hp2.FindRepeatReverse:ehp2.:dd.Repeat last search/replace operation in opposite direction
:dt.:hp2.FindRepeatOnce:ehp2.:dd.Repeat last search/replace operation only once.
:dt.:hp2.MatchBracket:ehp2.:dd.Search for matching bracket
:dt.:hp2.IncrementalSearch:ehp2.:dd.Search incrementally for text.
:dt.:hp2.Search:ehp2.:dd.Search for text
:dt.:hp2.SearchB:ehp2.:dd.Search for text backwards
:dt.:hp2.SearchRx:ehp2.:dd.Search for regexp
:dt.:hp2.SearchReplaceRx:ehp2.:dd.Search and replace using regexp
:dt.:hp2.SearchAgain:ehp2.:dd.Search for text again
:dt.:hp2.SearchAgainB:ehp2.:dd.Search for text again backwards
:dt.:hp2.SearchReplace:ehp2.:dd.Search for text and replace
:dt.:hp2.SearchReplaceB:ehp2.:dd.Search and replace backwards
:edl.
:p.
If :hp2.WSStyleSearch:ehp2. is set to 1, search/replace string and options
are entered at separate prompts. Otherwise they must be separated by a '/' 
(slash) and any slash or backslash in search/replace string must be escaped 
by '\' (backslash), except when using regular expressions (double 
escaping is not necessary).
:p.
For example (when WSStyleSearch is off)&colon.
:xmp.
         foo/bar/agn    replace all foo with bar globally without prompting
:exmp.

:hp2.Search and Replace Options:ehp2.
:p.
:dl compact tsize=8 break=all.
:dt.:hp2.a:ehp2.:dd.Search for all occurances
:dt.:hp2.b:ehp2.:dd.Search in block only
:dt.:hp2.g:ehp2.:dd.Search through entire file/block (globally).
:dt.:hp2.i:ehp2.:dd.Ignore case
:dt.:hp2.r:ehp2.:dd.Reverse search
:dt.:hp2.x:ehp2.:dd.Use regular expression matching
:dt.:hp2.d:ehp2.:dd.Delete found line
:dt.:hp2.j:ehp2.:dd.Join found line
:dt.:hp2.n:ehp2.:dd.No prompting
:edl.
:p.
Commands affected by :hp2.DefFindOpt:ehp2. mode setting&colon.
:ul compact.
:li.:hp2.Find:ehp2.
:eul.
:p.
Commands affected by :hp2.DefFindReplaceOpt:ehp2. mode setting&colon.
:ul compact.
:li.:hp2.FindReplace:ehp2.
:eul.
:p.
Commands affected by :hp2.MatchCase:ehp2. mode setting&colon.
:ul compact.
:li.:hp2.IncrementalSearch:ehp2.
:li.:hp2.Search:ehp2.
:li.:hp2.SearchB:ehp2.
:li.:hp2.SearchRx:ehp2.
:li.:hp2.SearchReplaceRx:ehp2.
:li.:hp2.SearchReplace:ehp2.
:li.:hp2.SearchReplaceB:ehp2.
:eul.
:p.
Commands affected by :hp2.WSStyleSearch:ehp2. mode setting&colon.
:ul compact.
:li.:hp2.Find:ehp2.
:li.:hp2.FindReplace:ehp2.
:li.:hp2.FindRepeat:ehp2.
:li.:hp2.FindRepeatReverse:ehp2.
:li.:hp2.FindRepeatOnce:ehp2.
:eul.


.br
:h1.CMode Smart Indentation 
:i1 id=cindent.CMode Smart Indentation


:hp2.Settings for CMode smart indentation:ehp2.
:p.
:dl compact tsize=8 break=all.
:dt.:hp2.C_Indent:ehp2.:dd.Basic C indentation level
:dt.:hp2.C_BraceOfs:ehp2.:dd.Brace '{' offset
:dt.:hp2.C_CaseOfs:ehp2.:dd.Offset of case and default statements
:dt.:hp2.C_CaseDelta:ehp2.:dd.Offsets of statements following case/default.
:dt.:hp2.C_ClassOfs:ehp2.:dd.Offset of public, private and protected
:dt.:hp2.C_ClassDelta:ehp2.:dd.Offset of statements following public, private, protected
:dt.:hp2.C_ColonOfs:ehp2.:dd.Offset of labels
:dt.:hp2.C_CommentOfs:ehp2.:dd.Offset of comments
:dt.:hp2.C_CommentDelta:ehp2.:dd.Offset of second line of comments
:edl.
:p.
Example 1&colon.

:xmp.
class line {
public&colon.                   // C_ClassOfs = 0
    line();               // C_ClassDelta = 4
    ~line();
};

int main() {
    int x = 1;
    
    /*                    // C_CommentOfs = 0
     * check value        // C_CommentDelta = 1
     */
    
    puts("main");         // C_Indent = 4
    if (x)
    {                     // C_BraceOfs = 0
        switch (x) {
        case 1&colon.           // C_CaseOfs = 0
            puts("ok");   // C_CaseDelta = 4
            break;
        }
    }
end&colon.
    return 0;
}
:exmp.

:p.
Example 2&colon.

:xmp.
class line {
  public&colon.                     // C_ClassOfs = 2
    line();                   // C_ClassDelta = 2
    ~line();
};

int main() {
    int x = 1;
    
      /*                      // C_CommentOfs = 2
      ** check value          // C_CommentDelta = 0
      */
    
    puts("main");             // C_Indent = 4
    if (x)
    {                         // C_BraceOfs = 0
        switch (x) {
            case 1&colon.           // C_CaseOfs = 4
                puts("ok");   // C_CaseDelta = 4
                break;
        }
    }
end&colon.
    return 0;
}
:exmp.


.br
:h1.Performance Tips 

If you want to achieve top performance (necessary for 
some text editing tasks), here are some tips&colon.

:ul compact.
:li.Disable Tab Expansion
:li.Disable ShowMarkers
:li.Disable Undo
:li.Use PLAIN hilit mode
:eul.

:h1.History of Changes 
:i1 id=history.History of Changes

:ul compact.
 :li.0.34 
  :ul compact.
   :li.1995/10/15
    :ul compact.
     :li.Minor fixes &amp. docs updates...
    :eul.
  :eul.
 :li.0.33 
  :ul compact.
   :li.1995/10/01
    :ul compact.
     :li.SIGBREAK handler now works again.
     :li.Fixes in C/C++ smart indentation (if in switch, ...)
     :li.Pascal highlighting mode.
     :li.Printing.
     :li.Rewritten folding. Now supports nested folds, opening closing folds, and persistent folds.
     :li.New folding commands&colon. FoldCreate, FoldDestroy, FoldOpen, FoldClose, FoldPromote, FoldDemote, FoldCreateByRegexp, FoldOpenAll, FoldOpenNested, FoldCloseAll, FoldDestroyAll, FoldToggleOpenClose, MoveFoldPrev, MoveFoldNext.
     :li.New settings&colon. SaveFolds, CommentStart, CommentEnd.
     :li.Word characters can be configured using WordChars setting.
    :eul.
  :eul.
 :li.0.32 
  :ul compact.
   :li.1995/08/15
    :ul compact.
     :li.New search routines. (Find, FindReplace, FindRepeat, FindRepeatReverse, FindRepeatOnce, ...)
     :li.Block-local searches.
     :li.In buffer-list, most recently used files will now be listed first.
     :li.Main menu bar can now be hidden.
     :li.Performance improvements.
     :li.Bookmarks! New commands&colon. PlaceBookmark, GotoBookmark, RemoveBookmark
     :li.Files can now be saved and closed from window list.
     :li.Optimized CMode indentation. Also more configurable.
    :eul.
  :eul.
 :li.0.31
  :ul compact.
   :li.1995/07/31
    :ul compact.
     :li.Bug fixed in undo/redo when UndoLimit reached.
    :eul.
  :eul.
 :li.0.30
  :ul compact.
   :li.1995/07/30
    :ul compact.
     :li.Folding support.
     :li.New commands&colon. FoldLine, UnfoldLine, UnfoldNextLine, UnfoldAll, ClearFolds, FoldIndent, FoldRegexp, FoldBlock, UnfoldBlock, FoldBlockRegexp
     :li.BackSpace at eof when TrimLine is enabled will not abort.
     :li.Incremental search (IncrementalSearch).
     :li.PgUp/PgDn on a file prompt will show a list of files.
     :li.New command&colon. CompleteWord
    :eul.
  :eul.
 :li.0.29
  :ul compact.
   :li.1995/07/20
    :ul compact.
     :li.Regexps can now be case insensitive (\C,\c).
     :li.BlockRead/BlockReadColumn/BlockWrite commands.
     :li.Block marking can now be undone.
     :li.Commands that prompt for string/int values can now take string/int arguments.
     :li.Multiple compile-regex statements can be specified simultaneously
     :li.Minor bug-fixes in regexps ([\x00-\xFF] now works).
     :li.Filter for filename completion.
     :li.New commands&colon. SwitchTo ChangeKeys ChangeFlags ShowMenu 
     :li.New options&colon. CompletionFilter DefaultModeName
    :eul.
  :eul.
 :li.0.28
  :ul compact.
   :li.1995/07/08
    :ul compact.
     :li.- Needs to have documentation updated.
     :li.Mostly rewritten PERL highlighting. Works much better now.
     :li.Completely new config file syntax.
     :li.New commands&colon. ASCIITable, LoadFileInMode
     :li.CMode indentation should now work for Perl (close enough).
     :li.Highlighting for ADA and Email messages.
    :eul.
  :eul.
 :li.0.27
  :ul compact.
   :li.1995/06/19
    :ul compact.
     :li.Minor bug fixes.
    :eul.
  :eul.
 :li.0.26
  :ul compact.
   :li.1995/06/18
    :ul compact.
     :li.New commands&colon. {Char,Line,Block}Case{Up,Down,Toggle}
     :li.New setting&colon. LoadAfterQuit -- if set to 1, editor will prompt to load another file before exiting.
     :li.New setting&colon. ShowScrollBar {0,1}.
    :eul.
  :eul.
 :li.0.25
  :ul compact.
   :li.1995/06/12
    :ul compact.
     :li.Minor bug fix in REXX highlighting ("\"", ...)
     :li.Bug fixes in word wrap.
     :li.BlockCut now doesn't move the cursor to the block beginning.
     :li.New commands&colon. MoveLineTop, MoveLineCenter, MoveLineBottom.
     :li.Editor will now check if the file has changed before the first modification.
     :li.Found text is now highlighted.
     :li.New CMode setting&colon. C.BraceOfs and command&colon. ChangeCBraceOfs
     :li.New commands&colon. MovePrevPos, SavePos, MoveSavedPos, MoveSavedPosCol, MoveSavedPosRow
    :eul.
  :eul.
 :li.0.24
  :ul compact.
   :li.1995/06/06
    :ul compact.
     :li.When checking for file modification time of last change is now used instead of the time of last access.
     :li.Wildcard support for file loading.
    :eul.
  :eul.
 :li.0.23
  :ul compact.
   :li.1995/06/04
    :ul compact.
     :li.Ctrl+C and Ctrl+Break are now disabled.
     :li.Ctrl+S and Ctrl+C keys are now again recognised in Windowed mode.
     :li.Fixed problem when spawning a subprocess in Windowed mode.
     :li.New command&colon. ShowEntryScreen
     :li.ListRoutines in CMode only shows functions not their prototypes.
     :li.New setting&colon. SysClipboard - if set to 1, editor will automatically use system clipboard.
     :li.New command&colon. ToggleSysClipboard.
     :li.Minor bug fix in PM clipboard support.
     :li.New commands&colon. BlockPasteStream, BlockPasteColumn and BlockPasteLine. BlockPaste command will now always paste in current block mode, not in the last Copy/Cut mode.
     :li.More than 4 commands can be bound to a key (actually this worked since 0.18, but was not documented).
     :li.New command&colon. FileReload.
     :li.Editor will now check if file has changed on disk before saving it.
    :eul.
  :eul.
 :li.0.22
  :ul compact.
   :li.1995/05/28
    :ul compact.
     :li.But fix in regular expressions (nested +#*@).
     :li.Changes in regular expression syntax.
     :li.New function&colon. ListRoutines. Shows functions in current buffer.
     :li.New setting&colon. RoutineRx
    :eul.
  :eul.
 :li.0.21
  :ul compact.
   :li.1995/05/21
    :ul compact.
     :li.REXX mode smart indentation.
     :li.KillWord &amp. KillWordPrev commands now actually work.
     :li.Pressing Ctrl+Enter to begin Search will toggle case sensitivity of search.
     :li.New option 'Trim' and commands 'ToggleTrim', 'LineTrim'. Removes whitespace from end of lines.
     :li.New option 'ShowMarkers' and command 'ToggleShowMarkers'. Shows end of line and end of file markers.
     :li.Bug fix in PERL highlighting (caused lockups)
     :li.Bug fixes and improvements in regular expressions.
    :eul.
  :eul.
 :li.0.20
  :ul compact.
   :li.1995/05/18
    :ul compact.
     :li.Major bug fixes in word wrap.
     :li.New commands&colon. MovePrevTab, MoveNextTab.
     :li.Bug fixes in BlockIndent and BlockUnindent (stream/line mode)
    :eul.
  :eul.
 :li.0.19
  :ul compact.
   :li.1995/05/16
    :ul compact.
     :li.Function names in REXX are now highlighted.
     :li.WordWrap can be set to 0 - disabled, 1 - wrap line at right margin and 2 - wrap paragraph continously. Function ToggleAutoWrap renamed to ToggleWordWrap.
     :li.New way to set left/right margin (SetLeftMargin, SetLeftMargin)
     :li.Minor fix in PERL highlighting.
    :eul.
  :eul.
 :li.0.18
  :ul compact.
   :li.1995/05/13
    :ul compact.
     :li.PERL Syntax Higlighting.
     :li.Memory allocation problem in tab expansion.
     :li.Wordwrap now strips all spaces on beginning of line (except on the first line of the paragraph).
     :li.Tabs can be set to any number between 1 and 32.
     :li.Changed names of buffer flags (WrapOn -> AutoWrap, UndoRedo -> Undo, ShowTab -> ShowTabs)
     :li.New commands&colon. ToggleAutoIndent, ToggleExpandTabs, ToggleShowTabs, ToggleUndo, ToggleReadOnly, ToggleKeepBackups, ToggleMatchCase, ToggleBackSpKillTab,
         ToggleDeleteKillTab, ToggleSpaceTabs, ToggleIndentWithTabs, ToggleBackSpUnindents, ToggleAutoWrap.
     :li.New commands&colon. WinRefresh, ChangeTabSize, ChangeCIndent, ChangeLeftMargin, ChangeRightMargin.
     :eul.
  :eul.
 :li.0.17
  :ul compact.
   :li.1995/05/10
    :ul compact.
     :li.Minor fix in word-wrap.
     :li.Screen repaint problems when shelling out fixed.
     :li.Blinking disabled for full-screen, high-intensity background colors can now be used.
    :eul.
  :eul.
 :li.0.16
  :ul compact.
   :li.1995/05/06
   :ul compact.
    :li.Minor speedups in screen handling and highlighting.
    :li.Regular expressions can now match start and end of words using .
    :li.Regexp replace can paste entire matched string using &amp.
    :li.Regexp search/replace could match part of just replaced string.
    :li.New commands&colon. MoveLastNonWhite, MovePrevEqualIndent and MoveNextEqualIndent, LineDuplicate, InsPrevLineChar, InsPrevLineToEol.
    :li.New color config. 'C.Function' for functions in C highlighting mode.
    :li.Improved CMode hilit, preprocessor hiliting improved (strings, comments, numbers)
   :eul.
  :eul.
 :li.0.15
  :ul compact.
   :li.1995/04/29
    :ul compact.
     :li.Speed improvement in CMode auto indent.
     :li.Delete command can now delete full tabs instead of converting them to spaces.
     :li.When closing a modified file, editor prompts you to save it.
     :li.Automatic indentation can now use tabs.
     :li.Manual and automatic wordwrap.
    :eul.
   :li.1995/04/24
    :ul compact.
     :li.Backspace can now delete full tabs instead of converting them to spaces (See BackSpace and KillBackTab).
     :li.Backspace can unindent to previous indentation level.
    :eul.
   :li.1995/04/20
    :ul compact.
     :li.Basic mouse support.
    :eul.
   :li.1995/04/12
    :ul compact.
     :li.Configurable colors/keywords in C/REXX mode.
    :eul.
  :eul.
 :li.0.14
  :ul compact.
   :li.1995/04/07
    :ul compact.
     :li.Characters could not be entered using AltGr on international keyboards.
     :li.Immediatelly doing an undo on a newly loaded file deleted the first line.
     :li.Ascii characters >= 128 can be now entered without quote command (C-Q).
     :li.IPF Syntax highlighting.
    :eul.
  :eul.
 :li.0.13
  :ul compact.
   :li.1995/04/03
    :ul compact.
     :li.Bug fix in regular expressions.
     :li.Bug fixes in compiler support
     :li.Editor clipboard can now be copied to/from PM clipboard.
    :eul.
  :eul.
 :li.0.12
  :ul compact.
   :li.1995/03/30
    :ul compact.
     :li.Compiler support + error message parsing
    :eul.
   :li.1995/03/25
    :ul compact.
     :li.Paren matching (Command&colon. MatchBracket).
     :li.Bug fixes in CMode smart indentation.
    :eul.
  :eul.
 :li.0.11
  :ul compact.
   :li.1995/03/11
    :ul compact.
     :li.Unlimited undo now works again.
    :eul.
   :li.1995/03/18
    :ul compact.
     :li.Entire blocks of C code can now be reindented (BlockReIndent)
     :li.Search can now be case insensitive (SearchMatchCase - toggle). Option&colon. MatchCase, Command&colon. SearchMatchCase
     :li.Regular expression find/replace works (case sensitive only)
    :eul.
   :li.1995/03/19
    :ul compact.
     :li.Fixed a bug in redo (last command could not be undone)
     :li.New option&colon. KeepBackups -- if set to 0, backup files will be deleted after a succesful save.
    :eul.
  :eul.
 :li.0.10
  :ul compact.
   :li.1995/03/06
    :ul compact.
     :li.Fixed CMode indent when tabs are present in the file.
     :li.Prompts now retain previous text only if you try to edit it.
    :eul.
   :li.1995/03/04
    :ul compact.
     :li.4DOS/4OS2 style filename completion (FileOpen, ...).
    :eul.
   :li.1995/02/25
    :ul compact.
     :li.New load routine, much faster in some cases.
     :li.Undo/Redo can now be limited (if you hate to waste memory).
    :eul.
   :li.1995/02/19
    :ul compact.
     :li.C Mode indentation level can now be specified (C.Indent)
     :li.Bug fixes in screen redraw. 
     :li.Editor will now scroll text instead of always redisplaying the screen.
     :li.Regular expressions (Search only).
    :eul.
  :eul.
 :li.0.09 
  :ul compact.
   :li.1995/02/08   
    :ul compact.
     :li.First public release (Version 0.09b)
    :eul.
  :eul.
:eul.


.br
:h1.Things To Do 
:i1 id=todo.Things To Do

:lines align=center.
:hp2.Short term&colon.:ehp2.
:elines.

:ul compact.
 :li.:hp2.Improve documentation:ehp2.
 :li.DrawMode
 :li.Block sort/detab/entab, copy-w/append, cut-w/append
 :li.Piping block to program redirection of program output to buffer
 :li.HexMode
 :li.REXX macros support.
 :li.Menus should determine keybindings automatically.
:eul.
:lines align=center.
:hp2.Future&colon.:ehp2.
:elines.
:ul compact.
 :li.PM Version.
 :li.Script language (C like, also REXX support).
 :li.CVS/RCS support.
 :li.Save/Restore desktop.
 :li.Regexp optimizer &amp. improved regexps.
:eul.

:lines align=center.
:hp2.Comments and suggestions are appreciated.:ehp2.
:elines.


:euserdoc.