/*------------------------------------------------------------------------*\
|                                                                          |
|           TEST164.CMD  - Version 1.2 - Version Date 1995-08-04           |
|                 Copyright (C) 1995 by C F S Nevada, Inc.                 |
|                                                                          |
|                  by Dick Goran  - Voice    702-732-9616                  |
|                                 - FAX      702-732-3847                  |
|                                 - CIS      71154,2002                    |
|                                 - Internet dgoran@cfsrexx.com            |
|                                                                          |
| ------------------------------------------------------------------------ |
|  Optional: REXXLIB.DLL  - OS/2 REXX external function library            |
|                           (c) Copyright 1992-95 Quercus Systems          |
\*------------------------------------------------------------------------*/
/*

   The purpose of this program is to try to confirm a possible problem
   with either a Pentium CPU or its attached BIOS.

   It will read a copy of ?:\OS2\DLL\....DLL into storage for
   control use and then will concurrently reread the DLL file
   while, at the same time, copying the same DLL file to a
   floppy diskette in Drive A: in another session.

   This program creates TEST164X.CMD (or whatever name this
   program is filed as - providing the name is less than 8
   characters). The ...X.CMD file is launched to copy the named
   test file to drive A:. Both STDOUT and STDERR from the
   ...X.CMD file are written to the ...X.LOG file in the same
   directory where this program resides. The ...X.CMD file is
   not erased when this program terminates but is replaced every
   time this program is run.

   This programs requires REXXLIB.DLL for trap processing only and will
   function without it.

   95/04/04 - Select largest DLL installed rather than TUTORMRI.DLL
              in case tutorial was not installed.
   95/08/03 - Prevent Synstax error if REXXLIB not present in LibPath.

*/

GBL. = ''             /* initialize stem */
parse Arg             GBL.command_line
parse Version         GBL.REXX_version .
parse Source          GBL.operating_system,
                      GBL.calling_environment,
                      GBL.program_path_and_name
GBL.environment     = 'OS2ENVIRONMENT'
GBL.boot_drive      = LEFT( VALUE( 'RUNWORKPLACE',, GBL.environment ), 2 )
GBL.program_name    = FILESPEC( 'N', GBL.program_path_and_name )
GBL.program_path    = FILESPEC( 'D', GBL.program_path_and_name ) ||,
                      FILESPEC( 'P', GBL.program_path_and_name )
parse upper var GBL.program_name,
                      GBL.program_fn '.',
                      GBL.program_fe
GBL.program_version = 1.2           /* version / mod of this program */
call TIME 'E'                       /* set elapsed timer - sssss.uuuuu */

say 'Begin' TRANSLATE( GBL.program_name ) 'at' TIME('N')
call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
call SysLoadFuncs

SIGNAL ON SYNTAX name SYNTAX_01_TRAP
if GBL.REXX_version = 'REXX/Personal' then
   do
      module = 'qrexxlib'
   end
else
   do
      module = 'rexxlib'
   end
call RxFuncAdd 'RexxLibRegister', module, 'rexxlibregister'
call RexxLibRegister
signal SYNTAX_01_OFF

SYNTAX_01_TRAP:
call RxFuncDrop 'rexxlibregister'


/*------------------------*\
|  Enable trap processing  |
\*------------------------*/
SYNTAX_01_OFF:
   SIGNAL ON ERROR
   SIGNAL ON FAILURE
   SIGNAL ON HALT
   SIGNAL ON NOVALUE
   SIGNAL ON SYNTAX

/*---------------------------------------*\
|  Find largest DLL file available        |
|  to use as input data for this program  |
\*---------------------------------------*/
call SysFileTree GBL.boot_drive || '\OS2\DLL\*.*', 'dll_stem', 'F'
if dll_stem.0 = 0 then
   do
      say '   Unable to locate DLLs. Should not occur'
      call EOJ
   end
test_file_size = 0
do ds = 1 to dll_stem.0
   parse value dll_stem.ds with,
      dll_date,
      dll_time,
      dll_size,
      dll_attr,
      dll_path_and_name
   dll_path_and_name = STRIP( dll_path_and_name )
   if dll_size > test_file_size then
      do
         test_file_path_and_name = dll_path_and_name
         test_file_size          = dll_size
      end
end


if LENGTH( GBL.program_fn ) > 7 then
   do
      say '   This program''s name must not exceed 7 characters'
      call EOJ
   end
subordinate_cmd_file =,
   GBL.program_path ||,
   GBL.program_fn   || 'X.CMD'

log_file =,
   GBL.program_path ||,
   GBL.program_fn   || 'X.LOG'

/*-----------------------------*\
|  Read test file into storage  |
\*-----------------------------*/
test_file_area = CHARIN( test_file_path_and_name, 1, test_file_size )
call STREAM test_file_path_and_name, 'C', 'CLOSE'

/*---------------------------------*\
|  Create REXX data queue and make  |
|  it active for this session       |
\*---------------------------------*/
proposed_queue_name = GBL.program_fn || 'Q'
call RXQUEUE 'DELETE', proposed_queue_name

actual_queue_name = RXQUEUE( 'CREATE', proposed_queue_name )
if actual_queue_name <> proposed_queue_name then
   do
      say '   "' || actual_queue_name           ||,
          '" returned while trying to create "' ||,
          proposed_queue_name                   ||,
          '". Possible system error.'
   end
original_queue_name = RXQUEUE( 'SET', actual_queue_name )

/*------------------------------------------------*\
|  Build TEST164X.CMD file to copy file to floppy  |
\*------------------------------------------------*/
destination_drive = 'A:\'
c=0
c=c+1; cmd.c = '@echo off'
c=c+1; cmd.c = 'rem  This file was created by ' GBL.program_path_and_name
c=c+1; cmd.c = 'echo ͻ'
c=c+1; cmd.c = 'echo  Copy file to floppy while it is being read elsewhere '
c=c+1; cmd.c = 'echo ͼ'
c=c+1; cmd.c = 'echo Copying' test_file_path_and_name 'to' destination_drive
c=c+1; cmd.c = 'copy' test_file_path_and_name destination_drive,
                      '2>&1 >>' log_file
c=c+1; cmd.c = 'rem  Clearing the named queue tells the calling program we''re done'
c=c+1; cmd.c = 'rxqueue /clear' actual_queue_name
c=c+1; cmd.c = 'exit'
       cmd.0 = c

call SysFileDelete subordinate_cmd_file
do c = 1 to cmd.0
   call LINEOUT subordinate_cmd_file, cmd.c
end
call STREAM subordinate_cmd_file, 'C', 'CLOSE'


/*------------------------------------------------------------------------*\
|                                                                          |
|    Mainline - Read file on hard drive while copying file to diskette     |
|                                                                          |
\*------------------------------------------------------------------------*/
call SysFileDelete log_file

/*-----------------------------------*\
|  Inform user how to cancel program  |
\*-----------------------------------*/
l=0
l=l+1; line.l = ' '
l=l+1; line.l = 'ͻ'
l=l+1; line.l = ' This test may be ended at any time with <Ctrl-Break>; however, '
l=l+1; line.l = ' the disk copy will run to completion for the current copy.     '
l=l+1; line.l = 'ͼ'
l=l+1; line.l = 'The test file being used is ' || test_file_path_and_name ||,
                ' (' || EDIT( test_file_size ) || ' bytes)'
l=l+1; line.l = ' '
       line.0 = l
do l = 1 to line.0
   say COPIES( ' ', 3 ) || line.l
end

diskette_reference_count   = 0
halt_request_switch        = 0
hard_drive_reference_count = 0
mismatch_count             = 0
call ON HALT name HALT_REQUEST

do forever

   if halt_request_switch > 0 then leave

   /*-----------------------------------*\
   |  See if diskete copy is in process  |
   \*-----------------------------------*/
   if QUEUED() = 0 then
      do
         /* stuff something into queue as sentinel */
         queue DATE() TIME()
         /* start COPY in separate session */
         '@start' subordinate_cmd_file
         diskette_reference_count = diskette_reference_count + 1
         call SysSleep 1            /* give it a chance to start */
      end

   /*------------------------------------------------------*\
   |  Read hard copy file and compare with data being held  |
   \*------------------------------------------------------*/
   call STREAM test_file_path_and_name, 'C', 'OPEN READ'
   new_file_area = CHARIN( test_file_path_and_name, 1, test_file_size )
   call STREAM test_file_path_and_name, 'C', 'CLOSE'
   scan_ptr = COMPARE( test_file_area, new_file_area )

   do while scan_ptr > 0
      hex_displacement = RIGHT( D2X( scan_ptr - 1 ), 6, '0' )
      say '   Compare mismatch occurred at byte ' ||,
          EDIT( scan_ptr )                        ||,
          " - (displ = '" || hex_displacement || "'x)"
      scan_ptr = 0               /* just show 1 error for now */
      mismatch_count = mismatch_count + 1
   end

   hard_drive_reference_count = hard_drive_reference_count + 1

end

/*----------------------------*\
|  Reset external data queues  |
\*----------------------------*/
if QUEUED() > 0 then
   do
      if halt_request_switch > 1 then leave /* bail out */
      say '   Waiting for' subordinate_cmd_file 'to complete'
      do while QUEUED() > 0
         call SysSleep 1
         if halt_request_switch > 1 then leave /* bail out */
      end
   end

call RXQUEUE 'DELETE', actual_queue_name
call RXQUEUE 'SET',    original_queue_name

say ' '
say '   Floppy copy started      '                ||,
    RIGHT( EDIT( diskette_reference_count ), 10 ) ||,
    ' times.'
say '   Hard drive file compared '                  ||,
    RIGHT( EDIT( hard_drive_reference_count ), 10 ) ||,
    ' times.'
say '   There were '       ||,
    EDIT( mismatch_count ) ||,
    ' errors comparing the hard disk data to the control copy.'
say ' '

call EOJ 0


/*--------------------------------------*\
|  User pressed <Ctrl-Break to end test  |
\*--------------------------------------*/
HALT_REQUEST:
halt_request_switch = halt_request_switch + 1
if halt_request_switch = 1 then
   do
      say '   Halt request acknowledged, program will terminate after'
      say '      ' || subordinate_cmd_file || ' completes'
      say '   <Ctrl-Break> again will force program to halt'
   end
else
return

/*------------------------------------------------------------------------*\
|                                                                          |
|             Copy of Dick Goran's public domain EDIT function             |
|                                                                          |
\*------------------------------------------------------------------------*/
EDIT:
/* first time here, build translate tables */
signal OFF NOVALUE
if LEFT(e1, 1) <> '01'x then
   do
      e1 = XRANGE('01'x, '19'x)
      e2 = XRANGE('01'x, '03'x) || '19'x ||,
           XRANGE('04'x, '06'x) || '19'x ||,
           XRANGE('07'x, '09'x) || '19'x ||,
           XRANGE('0A'x, '0C'x) || '19'x ||,
           XRANGE('0D'x, '0F'x) || '19'x ||,
           XRANGE('10'x, '12'x) || '19'x ||,
           XRANGE('13'x, '15'x) || '19'x ||,
           XRANGE('16'x, '18'x)
      /* get punctuation characters from INI file  */
      decimal  = STRIP( SysIni( 'USER',,
                                'PM_National',,
                                'sDecimal' ), 'T', '00'x )
      thousand = STRIP( SysIni( 'USER',,
                                'PM_National',,
                                'sThousand' ), 'T', '00'x )
   end
signal ON NOVALUE

/* return BAD if non-numeric data */
if DATATYPE( ARG(1) ) <> 'NUM' then
   return 'BAD'

/* test and save sign value along with absolute numeric value */
if SIGN( ARG(1) ) <> '-1' then
   sign_character = ''
else
   sign_character = '-'
absolute_value = ABS( ARG(1) )

/* test for and save decimal value indicator */
decimal_position = POS( decimal, absolute_value )

if decimal_position = 0 then
   source = RIGHT( absolute_value, LENGTH(e1) - 1 ) || ' '
else
   source = RIGHT( LEFT( absolute_value, decimal_position - 1 ), LENGTH(e1) - 1 ) || ' '

if decimal_position = 0 then
   edited_number =,
      STRIP( TRANSLATE( TRANSLATE( e2, source, e1), ',', ' '), 'B', ',')
else
   edited_number =,
      STRIP( TRANSLATE( TRANSLATE( e2, source, e1), ',', ' '), 'B', ','),
                      || RIGHT( absolute_value,,
                                LENGTH(absolute_value) - decimal_position + 1)
return sign_character || edited_number


!tr!=VALUE('TRACE',,'OS2Environment'); if !tr!<>'' then do;TRACE(!tr!);nop;end
/*------------------------------------------------------------------------*\
|                                                                          |
|                                End of Job                                |
|                                                                          |
\*------------------------------------------------------------------------*/
EOJ:
   Procedure expose,
      GBL.

if ARG() = 0 then
   eoj_rc = 0
else
   eoj_rc = ARG(1)

elapsed_time = TIME('E')            /* get elapsed time - sssss.uuuuu */
parse value elapsed_time with seconds '.' micro_seconds
if LEFT( micro_seconds, 1, 1 ) >= 5 then
   seconds = seconds + 1
ss = FORMAT( seconds // 60, 2 )
minutes = ( seconds - ss ) / 60
mm = FORMAT( minutes // 60, 2 )
hh = FORMAT( ( minutes - mm ) / 60, 2 )
duration = hh':'mm':'ss

program_name = TRANSLATE( FILESPEC( 'N', GBL.program_path_and_name ) )
say 'EOJ  ' program_name 'at' TIME('N') ||,
    ', duration' TRANSLATE( duration, '0', ' ' )
exit eoj_rc

/*------------------------------------------------------------------------*\
|                                                                          |
|                              Trap Routines                               |
|                                                                          |
\*------------------------------------------------------------------------*/
ERROR:   call TRAP_PROCESSING SIGL, 'ERROR',   RC
FAILURE: call TRAP_PROCESSING SIGL, 'FAILURE', RC
HALT:    call TRAP_PROCESSING SIGL, 'HALT',    ''
NOVALUE: call TRAP_PROCESSING SIGL, 'NOVALUE', ''
SYNTAX:  call TRAP_PROCESSING SIGL, 'SYNTAX',  RC

/* Rev. 95/07/29 */
TRAP_PROCESSING:
   parse Source . . TRAP.path_and_program
   trap.line_nbr = ARG(1)
   if POS( ':', TRAP.path_and_program ) > 0 then
      /* get source line if it is available */
      do t = 1
         trap_source_line.t =  SOURCELINE( trap.line_nbr )
         trap_source_line.0 = t
         trap.line_nbr      = trap.line_nbr + 1
         if RIGHT( trap_source_line.t, 1 ) = ',' then
            do
               leave
            end
      end
   else
      /* program is running in macrospace */
      do
         TRAP.path_and_program = VALUE( 'TEMP',, 'OS2ENVIRONMENT' ) ||,
                                 '\' || TRAP.path_and_program
         trap_source_line.1 = 'Source line is not available.'
         trap_source_line.0 = 1
      end

   parse value FILESPEC( 'N', TRAP.path_and_program ) with,
      TRAP.fn '.' TRAP.fe
   trap_file_name = FILESPEC( 'D', TRAP.path_and_program ) ||,
                    FILESPEC( 'P', TRAP.path_and_program ) ||,
                    TRAP.fn || '.' || 'DMP'

   /*------------------------------------------*\
   |  check for reason not to create .DMP file  |
   \*------------------------------------------*/
   if ARG(2) = 'HALT' then
      do
         trap_file_name = ''
      end
   if RxFuncQuery( 'VARDUMP' ) <> 0 then
      do
         trap_file_name = ''
      end
   if POS( ':', trap_file_name ) = 0 then
      do
         trap_file_name = ''
      end

   /*------------------------*\
   |  Build trap message box  |
   \*------------------------*/
   dbl.h    = 'CD'x                 /*  double line - horizontal   */
   dbl.v    = 'BA'x                 /*  double line - vertical     */
   dbl.bl   = 'C8'x                 /*  double line - bottom left  */
   dbl.br   = 'BC'x                 /*  double line - bottom right */
   dbl.tl   = 'C9'x                 /*  double line - top left     */
   dbl.tr   = 'BB'x                 /*  double line - top right    */
   trap.red = '1B'x || '[1;37;41m'  /* bright white on red          */
   trap.dul = '1B'x || '[0m'        /* reset to normal              */

   say ' '
   trap_error_description =,
      'Error line = ' || ARG(1) ||,
      '; ' ||,
      ARG(2) ||,
      ' error.'
   if ARG(3) <> '' then
      trap_error_description = trap_error_description ||,
                               '  Return code = ' || ARG(3)
   trap.width = MAX( 74, LENGTH( trap_error_description ) )
   say trap.red || dbl.tl || COPIES( dbl.h,trap.width + 2 ) || dbl.tr || trap.dul
   say trap.red || dbl.v  || COPIES( ' ',  trap.width + 2 ) || dbl.v  || trap.dul
   say trap.red || dbl.v CENTER( TRAP.fn'.CMD',trap.width )    dbl.v  || trap.dul
   say trap.red || dbl.v CENTER( trap_error_description, trap.width ) dbl.v || trap.dul
   if trap_file_name <> '' then
      do
   say trap.red || dbl.v  || COPIES( ' ',  trap.width + 2 ) || dbl.v  || trap.dul
   say trap.red || dbl.v     CENTER( 'See: ' || trap_file_name,,
                                     trap.width )  dbl.v  || trap.dul
      end
   say trap.red || dbl.v  || COPIES( ' ',  trap.width + 2 ) || dbl.v  || trap.dul
   say trap.red || dbl.bl || COPIES( dbl.h,trap.width + 2 ) || dbl.br || trap.dul
   say trap.red || COPIES( ' ', trap.width + 4 ) || trap.dul
   say trap.red || LEFT( 'Source line(s) at time of trap:', trap.width + 4 ) || trap.dul
   do t = 1 to trap_source_line.0
      say trap.red || LEFT( '   ' || trap_source_line.t, trap.width + 4 ) || trap.dul
   end
   say trap.red || COPIES( ' ', trap.width + 4 ) || trap.dul

   /*---------------------------------*\
   |  Create .DMP file if appropriate  |
   \*---------------------------------*/
   if trap_file_name <> '' then
      do
         call SysFileDelete trap_file_name
         /* remove meaningless labels from dump for clarity */
         drop dbl. TRAP. RC RESULT SIGL !tr!
         call VARDUMP trap_file_name  /* write variables to program.DMP file */
      end
   exit 253
