/* Adds Post Road Mailer icon to desktop.      */
/* Should be in same directory as POSTROAD.EXE */
/* (c) 1995 InnoVal System Solutions, Inc.     */

 cmdname ='SETICON.CMD'
 progname = 'POSTROAD.EXE'

/* Register REXXUTIL if not already registered */
 If RxFuncQuery('SysLoadFuncs') <> 0 Then Do
   Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
   Call SysLoadFuncs
   End

/* Get path                                    */
 Parse Upper Source . . path
 path = Left(path,Lastpos('\',path))

/* Must be in same directory as POSTROAD.EXE   */
 program = path || progname
 If Stream( program, 'C', 'QUERY EXISTS') = '' then do
   Say ''
   Say cmdname 'must be in the same directory as' progname
   Say progname 'not found in' path
   Exit 1
   end

/* Set up Post Road Mailer object              */
 class = 'WPProgram'
 title = 'Post Road Mailer'
 location = '<WP_DESKTOP>'
 setup = 'ObjectID=<POSTROAD>;ExeName=' || program || ';ProgType=PM;'
 option = 'UPDATE'
 rc = SysCreateObject( class, title, location, setup, option)
 If rc = 0 then do
   Say ''
   Say 'Error.  Unable to create Post Road Mailer program object.'
   Exit 1
   end

 Say ''
 Say 'Post Road Mailer object has been placed (or updated) on your OS/2 Desktop.'
 Say ''
 Say 'Double-click on the icon to start the program.'

 Exit
