#define PIPENAME	"\\PIPE\\PAGED"
#define SEMNAME		"\\SEM32\\PIPE\\PAGED"

#define PH_PAGE_BY_NAME_ID		0
#define PH_PAGE_BY_NAME			1
#define PH_PAGE_BY_ID			2
#define PH_PAGE_LIST_LOG		3
#define PH_PAGE_SHOW_QUEUES		4
#define PH_PAGE_DELETE_AT_PAGE	5

#define PH_ACTION_PAGE_NOW		0
#define PH_ACTION_PAGE_AT		1
#define PH_ACTION_PAGE_DELAY	2
#define PH_MODIFIER_RETRY		1
#define PH_ECHO_HELLO			10          // Not used
#define PH_EXIT					999         // Not used

#define PH_ID_SIZE				32
#define PH_MESSAGE_SIZE			4096
#define PH_CLI_NAME_SIZE		32

// Page format for V1
struct page_format {
	struct page_header {
		short	MsgVersion ;	// Must be 1 - Version 1
		short	MsgType ;		// PH_PAGE_BY_NAME_ID - Page by name or by id if
								//                      name not found
								// PH_PAGE_BY_NAME - Page by name only
								// PH_PAGE_BY_ID - Page by id only
								// PH_PAGE_LIST_LOG - List log file, How much
								//                    is stored in Modifier
								// PH_PAGE_SHOW_QUEUES - Show pages in queues
								//                       Type is stored in Modifier
								// PH_PAGE_DELETE_AT_PAGE - Will delete a AT queued page
								//                          Use some of or all of date & time &
								//                          id to match page to delete.
								//                          Set args to 0 to match all.

		short	Action ;		// PH_ACTION_PAGE_NOW - Page now
								// PH_ACTION_PAGE_AT - Page at time in at struct
								// PH_ACTION_PAGE_DELAY - Page in xxx minines
								//                        seconds are in pgf.header.at.sec
		short	Modifier ;		// PH_MODIFIER_RETRY - Delay xxx second befor retrying
								//                     seconds are in pgf.header.ModArg
		unsigned long ModArg ;	// Argument for Modifier

		char	CliName[PH_CLI_NAME_SIZE] ;
		short	DataSize ;		// Size of message in bytes
		// These fields are used if MsgType = PH_PAGE_DELAY
		struct _at {
			unsigned char sec ;		// Only used if Action = PH_ACTION_PAGE_DELAY
			unsigned long min ;		// 0 - 59
			unsigned char hour ;   // 0 - 23
			unsigned char day ;     // 1 - 31
			unsigned char month ;   // 1 - 12
			unsigned short year ;   // 95 - ??
		} at ;
	} header ;
	char id[PH_ID_SIZE] ;
	char message[PH_MESSAGE_SIZE] ;
} ;
typedef struct page_format pgf ;

