#define INCL_DOSNMPIPES   		// Named-pipe values
#define INCL_DOSFILEMGR         // File Manager values
#define INCL_DOSPROCESS
#define INCL_DOSERRORS          // DOS Error values
#include <os2.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <mem.h>
#include "page.h"

char	*date_ptr ;
char	*time_ptr ;
char	*min_ptr ;
char	*day_ptr ;
char    *msg_ptr ;
char    *id_ptr ;
int		LogIndex ;
int		StatType ;
int		Option = 0 ;
int SendMessage( int MessageSize, char *message_ptr ) ;
int	CommandLine( int argc, char *argv[] ) ;

int main(int    argc, char  *argv[])
{
int 	count, status, year, month, day, hour, min ;
char    line[100] ;
pgf 	*pgf_ptr ;

	pgf_ptr = (pgf *) calloc( 1, sizeof(pgf) ) ;
	if( pgf_ptr == NULL ) {
		printf( "Calloc error\n" ) ;
		return 0 ;
	}

	status = CommandLine( argc, argv ) ;
	if( status ) {
		printf( "page [-nadils] args id Message\n" ) ;
		printf( "      n  Page now - Default\n" ) ;
		printf( "         page -n \"Bill\" \"My message\"\n" ) ;
		printf( "         page \"Bill\" \"My message\"\n" ) ;
		printf( "      a  Page at a date(MM-DD-YY) and time(HH:MM)\n" ) ;
		printf( "         page -a 08-12-95 15:55 \"Bill\" \"My message\"\n" ) ;
		printf( "      d  Delete a page at date(MM-DD-YY), time(HH:MM) and ID\n" ) ;
		printf( "         page -d 08-12-95 15:55 \"Bill\"\n" ) ;
		printf( "         page -d 00-00-00 00:00 \"\"     - Deletes all pages\n" ) ;
		printf( "      i  Page in xxx minutes \n" ) ;
		printf( "         page -i 10 \"Bill\" \"My message\"\n" ) ;
		printf( "      l  List page log file:     page -l index\n" ) ;
		printf( "            index:  0:  Show last 1K of log file - Default\n" ) ;
		printf( "                    1:  Show 1K of log file, starting at EOF-2K\n" ) ;
		printf( "                    2:  Show 1K of log file, starting at EOF-3K\n" ) ;
		printf( "                    3:  Show 1K of log file, starting at EOF-4K\n" ) ;
		printf( "                    4:  Show 1K of log file, starting at EOF-5K\n" ) ;
		printf( "      s  List # of pages in Now queue and # of pages in At queue\n" ) ;
		printf( "         page -s type\n" ) ;
		printf( "            type:   0:  Short list - Default\n" ) ;
		printf( "                    1:  Full list\n" ) ;
		printf( "      page \"Watson Smith\" \"Watson come here, Brent\"" ) ;
		return 0 ;
	}

	memset( pgf_ptr, 0, sizeof(pgf) ) ;
	pgf_ptr->header.MsgVersion = 1 ;			// Version 1 format
	strcpy( pgf_ptr->id, id_ptr ) ;
	strcpy( (char *)pgf_ptr->message, msg_ptr ) ;
	pgf_ptr->header.DataSize = strlen( msg_ptr ) ;
	switch( Option ) {
		case 'n':
			// page -n "Bill" "My message"
			pgf_ptr->header.MsgType = PH_PAGE_BY_NAME_ID ;
			pgf_ptr->header.Action = PH_ACTION_PAGE_NOW ;
			break ;
		case 'a':
			// page -a 08-12-95 15:55 "Bill" "My message"
			pgf_ptr->header.MsgType = PH_PAGE_BY_NAME_ID ;
			pgf_ptr->header.Action = PH_ACTION_PAGE_AT ;
			if( date_ptr[2] == '-' ) {
				sscanf( date_ptr, "%d-%d-%d", &month, &day, &year ) ;
			} else {
				sscanf( date_ptr, "%d/%d/%d", &month, &day, &year ) ;
			}
			pgf_ptr->header.at.month = month ;
			pgf_ptr->header.at.day = day ;
			pgf_ptr->header.at.year = year ;
			sscanf( time_ptr, "%d:%d", &hour, &min ) ;
			pgf_ptr->header.at.hour = hour ;
			pgf_ptr->header.at.min = min ;
			break ;
		case 'd':
			// Delete a page(s)
			// page -d 08-12-95 15:55 "Bill"
			pgf_ptr->header.MsgType = PH_PAGE_DELETE_AT_PAGE ;
			if( date_ptr[2] == '-' ) {
				sscanf( date_ptr, "%d-%d-%d", &month, &day, &year ) ;
			} else {
				sscanf( date_ptr, "%d/%d/%d", &month, &day, &year ) ;
			}
			pgf_ptr->header.at.month = month ;
			pgf_ptr->header.at.day = day ;
			pgf_ptr->header.at.year = year ;
			sscanf( time_ptr, "%d:%d", &hour, &min ) ;
			pgf_ptr->header.at.hour = hour ;
			pgf_ptr->header.at.min = min ;
			break ;
		case 'i':
			// page -i 10 "Bill" "My message"
			pgf_ptr->header.MsgType = PH_PAGE_BY_NAME_ID ;
			pgf_ptr->header.Action = PH_ACTION_PAGE_DELAY ;
			pgf_ptr->header.at.min = atol( min_ptr ) ;
			break ;
		case 'l':
			// page -l index
			pgf_ptr->header.MsgType = PH_PAGE_LIST_LOG ;
			pgf_ptr->header.Modifier = LogIndex ;
			pgf_ptr->header.DataSize = 0 ;
			break ;
		case 's':
			// page -s type\n" ) ;
			pgf_ptr->header.MsgType = PH_PAGE_SHOW_QUEUES ;
			pgf_ptr->header.Modifier = StatType ;
			pgf_ptr->header.DataSize = 0 ;
			break ;
	}
/*
	printf( "MsgType   = %d\n", pgf_ptr->header.MsgType ) ;
	printf( "Action    = %d\n", pgf_ptr->header.Action ) ;
	printf( "Modifier  = %d\n", pgf_ptr->header.Modifier ) ;
	printf( "DataSize  = %d\n", pgf_ptr->header.DataSize ) ;
	printf( "Date:     = %d/%d/%d\n", (int)pgf_ptr->header.at.month,
			pgf_ptr->header.at.day, pgf_ptr->header.at.year ) ;
	printf( "Time:     = %d:%d\n", pgf_ptr->header.at.hour, pgf_ptr->header.at.min ) ;
	printf( "sec       = %ld\n", pgf_ptr->header.at.sec ) ;
	printf( "id        = %s\n", pgf_ptr->id ) ;
	printf( "Message   = %s\n", pgf_ptr->message ) ;
*/
	SendMessage( sizeof(pgf_ptr->header) + PH_ID_SIZE + strlen(msg_ptr) + 1,
		(char *)pgf_ptr  ) ;

	return 0 ;
}


int	CommandLine( int argc, char *argv[] )
{
int	index ;


	if( argc > 1 ) {
		if( argv[1][0] == '-' ) {
			Option = tolower( argv[1][1] ) ;
			switch( Option ) {
				case 'n':
					// page -n "Bill" "My message"
					if( argc != 4 ) break ;
					id_ptr = argv[2] ;
					msg_ptr = argv[3] ;
					return( 0 ) ;
				case 'a':
					// page -a 08-12-95 15:55 "Bill" "My message"
					if( argc != 6 ) break ;
					date_ptr = argv[2] ;
					time_ptr = argv[3] ;
					id_ptr = argv[4] ;
					msg_ptr = argv[5] ;
					return( 0 ) ;
				case 'd':
					// Delete a page(s)
					// page -d 08-12-95 15:55 "Bill"
					if( argc != 5 ) break ;
					date_ptr = argv[2] ;
					time_ptr = argv[3] ;
					id_ptr = argv[4] ;
					msg_ptr = "" ;
					return( 0 ) ;
				case 'i':
					// page -i 10 "Bill" "My message"
					if( argc != 5 ) break ;
					min_ptr = argv[2] ;
					id_ptr = argv[3] ;
					msg_ptr = argv[4] ;
					return( 0 ) ;
				case 'l':
					// page -l index
					if( argc == 3 ) {
						LogIndex = atoi( argv[2] ) ;
						id_ptr = "" ;
						msg_ptr = "" ;
						return( 0 ) ;
					}
					if( argc == 2 ) {
						LogIndex = 0 ;
						id_ptr = "" ;
						msg_ptr = "" ;
						return( 0 ) ;
					}
					break ;
				case 's':
					// page -s type \n" ) ;
					if( argc == 3 ) {
						StatType = atoi( argv[2] ) ;
						id_ptr = "" ;
						msg_ptr = "" ;
						return( 0 ) ;
					}
					if( argc == 2 ) {
						StatType = 0 ;
						id_ptr = "" ;
						msg_ptr = "" ;
						return( 0 ) ;
					}
					break ;
			}
		}
		// page "ID" "Message"
		if( argc == 3 ) {
			Option = 'n' ;
			id_ptr = argv[1] ;
			msg_ptr = argv[2] ;
			return( 0 ) ;
		}
	}
	return( 1 ) ;		// Error

}



int SendMessage( int MessageSize, char *message_ptr )
{
int trys ;
UCHAR    OutBuffer[3000];	// Read-buffer address
ULONG    OutBufferLen;   	// Read-buffer length
ULONG    BytesOut;       	// Bytes read (returned)
ULONG    TimeOut;        	// Maximum wait time
APIRET   rc;             	// Return code



	OutBufferLen = 3000;	// Max data length for output
							// (return) buffer

	TimeOut = 10000 ;    	//Timeout of 10 seconds (units
							//   are milliseconds)

	OutBuffer[0] = 0 ;
	for( trys = 0 ; trys < 3 ; trys++ ) {
		rc = DosCallNPipe(PIPENAME, message_ptr, MessageSize, OutBuffer,
								OutBufferLen, &BytesOut, TimeOut);
						  // On successful return, variable
						  // BytesOut will contain the
						  // number of bytes written to
						  // the output buffer (OutBuffer)
		if (rc != 0) {
			continue ;
		} else {
		   break ;
		}
	}
	if( BytesOut )
		printf( "%*.*s ", (int)BytesOut, (int)BytesOut, OutBuffer ) ;
	if( BytesOut == 0 && trys == 3 ) {
		printf( "Error sending page\n" ) ;
	}
/*
	if( OutBuffer[0] == 'O' && OutBuffer[1] == 'K'  ) {
		printf( "Page sent\n" ) ;
	} else {
		printf( "Error sending page\n" ) ;
	}
*/
	return 0 ;
}



