/* This sample command converts a Gopher menu template to a 'real' */
/* Gopher menu, where each line is a canonical Gopher reference.   */
/*                                                                 */
/* Call as:  GOSMENU Sourcefilespec Targetfilespec                 */
/*                                                                 */
/* Sourcefilespec and Targetfilespec are any OS/2 file             */
/* specifications without embedded blanks.                         */
/*                                                                 */
/* The Targetfilespec may be omitted if the Sourcefilespec has an  */
/* extension; in this case the extension is changed to "70" for    */
/* the Targetfilespec.                                             */
/*                                                                 */
/* The first line of the menu template file is a comment/title,    */
/*   and is ignored.                                               */
/*                                                                 */
/* The second line of the menu template file has three words:      */
/*                                                                 */
/*   1. The character used in the rest of the file for TAB         */
/*   2. The default server address (if none given)                 */
/*   3. The default server port (if none given)                    */
/*                                                                 */
/* The first word must be present.  The second, if omitted, will   */
/* default to the response of the HOSTNAME command; the third will */
/* default to '70'.                                                */
/*                                                                 */
/*   Example:  "; fred.hursley.ibm.com 70"                         */
/*                                                                 */
/* Subsequent lines are Gopher menu lines, which must start with   */
/* the Gopher item type character (e.g., 0, 1, etc.).  Within      */
/* these lines, blanks next to tabs are removed, blanks after the  */
/* first (item type) character are removed, and the server address */
/* and port are added as needed.                                   */
/*                                                                 */
/* Lines whose first character is a blank are ignored; they may be */
/* used as spacers or for commentary.                              */
/*                                                                 */
/* The input and output file names may not have embedded blanks in */
/* this version.                                                   */

port=70                               /* default extension */
arg infile outfile .
if outfile='' & infile<>'' then do    /* attempt to default output */
  name=filespec('n',infile); dot=lastpos('.', name)
  if dot>0 then do
    qual=filespec('d',infile)filespec('p',infile)
    outfile=qual''left(name,dot)''port
    end
  end
if outfile='' then do
  say 'This command needs an input filename and an output filename'
  say 'e.g., GOSMENU sample.men sample.70'; exit 1; end
if infile=outfile then do  /* only partial check */
  say 'Input and output filenames are the same!'
  exit 2; end

tab='09'x
say 'Converting "'linein(infile)'" into file "'outfile'"...'
parse value linein(infile) with tabchar defaddr defport rest
if defport='' then defport=port
if defaddr='' then do
  '@hostname | rxqueue'; parse pull defaddr
  if rest<>'' then do
    say 'Host name could not be found by the HOSTNAME command'
    exit 3; end
  say "Using host name '"defaddr"'"
  end
if rest<>'' then do
  say 'Second line of "'infile'" has more than three words'
  exit 4; end
if length(tabchar)<>1 then do
  say 'Second line of "'infile'" does not have at least one valid word'
  exit 5; end

'@erase' outfile '2>nul' /* quietly erase any old output */
do while lines(infile)>0
  line=translate(linein(infile), tab, tabchar)
  parse var line type +1 descrip (tab) selector (tab),
                 addr . (tab) port . (tab) gplus
  if type=' ' then iterate    /* ignore comments/blank lines */
  descrip=strip(descrip); selector=strip(selector)
  if addr='' then addr=defaddr
  if port='' then port=defport
  if gplus<>'' then gplus=tab||gplus /* Optional Gopher+ information */
  canonical=type||descrip||tab||selector||tab||addr||tab||port||gplus
  call lineout outfile, canonical
  end
call lineout outfile; call lineout infile
say 'Menu file generated'
exit 0
