//
// $Header: D:/ext2-os2/RCS/pathutil.c,v 1.5 1995/07/19 23:34:35 Willm Exp Willm $
//

// Linux ext2 file system driver for OS/2 2.x and WARP - Allows OS/2 to     
// access your Linux ext2fs partitions as normal drive letters.
// OS/2 implementation : Copyright (C) 1995  Matthieu WILLM
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#define INCL_DOS
#define INCL_DOSERRORS
#include <os2.h>		// From the "Developer Connection Device Driver Kit" version 2.0

#include <os2/types.h>
#include <os2/os2proto.h>


pchar DecoupePath(pchar path, pchar component)
{
    pchar tmp1;
    pchar tmp2;
    pchar tmp3;


    tmp1 = path;
    while ((*tmp1 != '\\') && (*tmp1 != '/') && (*tmp1 != '\0')) tmp1++;
    if (*tmp1 == '\0') return 0;
    tmp1++;
    if (*tmp1 == '\0') return 0;
    tmp3 = tmp1;
    tmp2 = component;
    while ((*tmp1 != '\\') && (*tmp1 != '/') && (*tmp1 != '\0')) {
        *component = *tmp1;
        tmp1++;
        component ++;
    }
    *component = 0;
    return tmp3;
    
}

void ExtractPath(pchar Name, pchar Path)
{
    int i, j;

    i = 0;
    while (Name[i] != 0) i++;

    while ((Name[i] != '\\') && (Name[i] != '/') && i > 0) {
        i--;
    }
    for (j = 0; j < i; j++) Path[j] = Name[j];
    Path[i] = 0;

}

void ExtractName(pchar Name, pchar Nom)
{
    int i, j, k;

    i = 0;
    while (Name[i] != 0) i++;
    j = i;

    while ((Name[j] != '\\') && (Name[j] != '/') && j > 0) {
        j--;
    }
    for (k = 0; k < i - j; k++) Nom[k] = Name[j + k + 1];

}
