//
// $Header: D:/ext2-os2/include/linux/RCS/fs_proto.h,v 1.2 1995/08/08 21:17:31 Willm Exp Willm $
//

// Linux ext2 file system driver for OS/2 2.x and WARP - Allows OS/2 to     
// access your Linux ext2fs partitions as normal drive letters.
// OS/2 implementation : Copyright (C) 1995  Matthieu WILLM
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.




#ifndef _FS_PROTO_H
#define _FS_PROTO_H

//
// From vfs/buffer.c
//
extern struct buffer_head *bread(struct super_block *dev, blk_t block, loff_t size);
extern struct buffer_head *getblk(dev_t dev, blk_t block, blk_t size);
extern void brelse(struct buffer_head *pbuf);

extern int init_bufs(struct super_block *p_volume);
extern int free_filebuf(struct super_block *p_volume, pbuffer_head pbuf);
extern struct buffer_head *alloc_filebuf(struct super_block *pvolume);

extern int init_hfiles(struct super_block *p_volume);
extern int free_hfile(struct super_block *p_volume, struct file *p_file);
extern struct file *alloc_hfile(struct super_block *p_volume);


//
// From vfs/dcache.c
//
int dcache_lookup(struct inode * dir, const char * name, int len, unsigned long * ino);
void dcache_add(struct inode * dir, const char * name, int len, unsigned long ino);
unsigned long name_cache_init(unsigned long mem_start, unsigned long mem_end);

//
// From vfs/ll_rwblk.c
//
void ll_rw_block(int rw, int nr, struct buffer_head *bh[]);

//
// From vfs\rw.c
//
int VFS_readdir(struct file *file, struct dirent *dirent);
int VFS_read(struct file *file, char *buf, loff_t len, unsigned long *pLen);
int VFS_write(struct file *file, char *buf, loff_t len, unsigned long *pLen);

//
// From vfs/inode.c
//
// struct inode * iget(struct super_block * sb,ino_t nr);
struct inode * __iget(struct super_block * sb, ino_t nr, int crossmntp);
void iput(struct inode * inode);
void clear_inode(struct inode *inode);
struct inode *get_empty_inode(void);
void insert_inode_hash(struct inode *inode);
void sync_inodes(dev_t dev);
void invalidate_inodes(dev_t dev);

extern _inline struct inode * iget(struct super_block * sb,ino_t nr)
{
#ifdef FS_TRACE
	kernel_printf("iget(%lu)", nr);
#endif
	return __iget(sb,nr,1);
}

//
// From volume.c
//
int sync_volume(struct super_block *sb);	// Will be moved to vfs/super.c
int free_volume (struct super_block **psb);	// Will be moved to vfs/super.c




#endif
