//
// $Header: D:/ext2-os2/RCS/ifsdbg.c,v 1.5 1995/08/08 21:15:29 Willm Exp Willm $
//

// Linux ext2 file system driver for OS/2 2.x and WARP - Allows OS/2 to     
// access your Linux ext2fs partitions as normal drive letters.
// OS/2 implementation : Copyright (C) 1995  Matthieu WILLM
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.



#define INCL_DOS
#define INCL_DOSERRORS
#include <os2.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <os2/ifsdbg.h>
#include <os2/types.h>
#include <os2/errors.h>

char Buf[8192];
extern char Msg_0[];

int nomem = FALSE;

int main(int argc, char **argv)
{

APIRET rc;
ULONG  DataIO;
BOOL   Fin = FALSE;
int    i;
USHORT *Tmp;
int    lg;
char  *tmp;

    setbuf(stdout, NULL);
    setbuf(stderr, NULL);

    printf("%s", Msg_0);
    for (i = 0 ; i < argc ; i++) {
        if (strcmp(argv[i], "-mem") == 0) {
            nomem = FALSE;
        } else {
	    nomem = TRUE;
        }
    }
#ifdef FS_TRACE
    if ((rc = DosSetPriority(PRTYS_THREAD, PRTYC_TIMECRITICAL, 31, 0)) != NO_ERROR) {
        printf("DosSetPriority rc = %d\n", rc);
        exit(EXIT_FAILURE);
    } /* end if */
#endif

    if ((rc = DosFSCtl ( NULL,  0,
                         0,  NULL,  0,
                         0,  IFSDBG_OPEN,  "ext2",
                        -1,  FSCTL_FSDNAME)) != NO_ERROR) {
        printf("open rc = %d\n", rc);
        exit(EXIT_FAILURE);
    } /* end if */

    while (!Fin) {
        DataIO = 0;
        memset(Buf, 0, 8192);
        if ((rc = DosFSCtl ( Buf,  4096,
                            &DataIO,  NULL,  0,
                            0,  IFSDBG_READ,  "ext2",
                           -1,  FSCTL_FSDNAME)) != NO_ERROR) {
            printf("read rc = %d \n", rc);
            Fin = TRUE;
        } else {
            tmp = Buf;
            while ((tmp[0] != '\0') && (tmp[1] != '\0')){
            Tmp = (USHORT *)tmp;
            switch(Tmp[0]) {
#if 0 // No longer used
                case LOG_FS_EXIT :
                    {
                        printf(
                               "FS_EXIT uid = 0x%04X, pid = 0x%04X, pdb = 0x%04X\n",
                               Tmp[1],
                               Tmp[2],
                               Tmp[3]
                              );
                        tmp = (char *)&(Tmp[4]);
                    }
                    break;
                case LOG_GET_ID :
                    {
                        printf(
                               "======> uid = 0x%04X, pid = 0x%04X, pdb = 0x%04X\n",
                               Tmp[1],
                               Tmp[2],
                               Tmp[3]
                              );
                        tmp = (char *)&(Tmp[4]);
                    }
                    break;
                case LOG_L_malloc :
                    {
                        if (!nomem)
                        printf(
                               "L_malloc sz = 0x%04X, addr = %04X:%04X\n",
                               Tmp[1],
                               Tmp[2],
                               Tmp[3]
                              );
                        tmp = (char *)&(Tmp[4]);
                    }
                    break;

                case LOG_L_free :
                    {
                        if (!nomem)
                        printf(
                               "L_free   pid = 0x%04X, addr = %04X:%04X\n",
                               Tmp[1],
                               Tmp[2],
                               Tmp[3]
                              );
                        tmp = (char *)&(Tmp[4]);
                    }
                    break;
#endif
                case LOG_FS_ERR :
                    {
                        err_record *err_rec = (err_record *)Tmp;
                        printf(
                               "===> ERROR : %s() called from %s() (%s - line %d) - rc = 0x%04X\n",
                               func[err_rec->errfunction],
                               func[err_rec->infunction],
                               sourcefile[err_rec->sourcefile],
                               err_rec->sourceline,
                               err_rec->retcode
                              );
                        tmp += sizeof(err_record);
                    }
                    break;
                default :
                    printf("%s\n", tmp);
                    tmp = &tmp[strlen(tmp) + 1];
                    break;
            } /* end switch */
            fflush(stdout);
            } /* end while */
        } /* end if */
    } /* end while */

    if ((rc = DosFSCtl ( NULL,  0,
                        0,  NULL,  0,
                        0,  IFSDBG_CLOSE,  "ext2-os2",
                        -1,  FSCTL_FSDNAME))!= NO_ERROR) {
        printf("close rc = %d\n", rc);
        exit(EXIT_FAILURE);
    } /* end if */

    exit(EXIT_SUCCESS);
}


