//
// $Header: D:/ext2-os2/RCS/devhelp.c,v 1.5 1995/08/08 21:15:01 Willm Exp Willm $
//

// Linux ext2 file system driver for OS/2 2.x and WARP - Allows OS/2 to     
// access your Linux ext2fs partitions as normal drive letters.
// OS/2 implementation : Copyright (C) 1995  Matthieu WILLM
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#define INCL_DOS
#define INCL_DOSERRORS
#include <os2.h>
#include <dhcalls.h>

#include <os2/types.h>
#include <os2/os2misc.h>
#include <os2/os2proto.h>

//
//
psysinfoseg psys = 0;			// OS/2 global infoseg

extern unsigned long Device_Help;	// Device helper entry point

int FS_DevHelp_Beep(int Frequence, int Duree)
{
    int rc;

    __asm {
              mov bx, Frequence
              mov cx, Duree
              mov dl, 0x52
              call [Device_Help]
              mov rc, ax
          } /* __asm */
    return rc;
}

/*
int far pascal DevHelp_GetDOSVar(unsigned char index, char _FS_PTR _FS_PTR ppvalue)
{
    int rc;
    unsigned short segm;
    unsigned short ofs;

    segm = (unsigned short)((unsigned long)ppvalue >> 16);
    ofs = (unsigned short)((unsigned long)ppvalue & 0xFFFF);

    __asm {
          
               mov al, index
               mov dl, 0x24
               call [Device_Help]
               jc error
               push es
               mov dx, segm
               mov es, dx
               mov es:[ofs], bx
               mov es:[ofs + 2], ax
               xor ax, ax
               mov rc, ax
               pop es
               jmp end
error:
               mov rc, ax
end:

           }
    return rc;
}
*/

int gettime(unsigned long _FS_PTR ptime) {
    int rc;
    unsigned int _FS_PTR pvalue;
    
    if (psys == 0) {
        if ((rc = FS_DevHelp_GetDOSVar((unsigned char)DHGETDOSV_SYSINFOSEG, (char **) &pvalue)) != 0) {
            return rc;
        }
        psys = (psysinfoseg)(((unsigned long)pvalue) << 16);
    }

    *ptime = psys->time;
    return NO_ERROR;
}

