/* sys/newthrea.c (emx+gcc) -- Copyright (c) 1993 by Eberhard Mattes */

#if defined (__MT__)

#include <sys/emx.h>
#include <errno.h>
#define INCL_DOS
#include <os2emx.h>
#include "syscalls.h"

int __newthread (int tid)
{
  ULONG rc;
  void *data;

  if (tid >= MAX_THREADS)
    {
      errno = EAGAIN;
      return (-1);
    }
  rc = DosSubAllocMem (_sys_private_heap, &data, sizeof (thread_data));
  if (rc != 0)
    {
      _sys_set_errno (rc);
      return (-1);
    }
  _sys_thread_table[tid] = data;
  _sys_init_thread (data);
  return (0);
}

#endif
