//---------------------------------------------------------------------------------------------
// File EDITOR2.C
//---------------------------------------------------------------------------------------------
#define INCL_WIN
#define INCL_GPI

#define S_findMsg           "Find"
#define S_replaceMsg        "Replace"
#define S_strNotFoundMsg    "Search string not found."
#define S_allReplacedMsg    "All occurrences replaced."

#include <os2.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>             // min / max - etc..
#include "editor2.h"

//---------------------------------------------------------------------------------------------
// Prototypes
//---------------------------------------------------------------------------------------------
MRESULT EXPENTRY ClientWndProc ( HWND, ULONG, MPARAM, MPARAM ); // Window procedure
MRESULT EXPENTRY NewFrameProc  ( HWND, ULONG ,MPARAM, MPARAM ); // subclass framewindow
MRESULT EXPENTRY NewMLEProc    ( HWND, ULONG ,MPARAM, MPARAM ); // subclass MLEwindow

// find, replace..
MRESULT EXPENTRY FindDlgProc   ( HWND, ULONG, MPARAM, MPARAM );
MRESULT EXPENTRY ReplaceDlgProc( HWND, ULONG, MPARAM, MPARAM );
MRESULT EXPENTRY GoLnDlgProc   ( HWND, ULONG, MPARAM, MPARAM );

void CentreDlgBox(HWND, HWND);  // centre a dialog

void OpenFile      ( PSZ );
void OpenFileDlg   ( HWND );
void SaveFile      ( PSZ );
void SaveasFileDlg ( HWND );

// for the font styles
VOID SetFont(VOID);
VOID ConvertVectorFontSize(FIXED fxPointSize, PFATTRS pfattrs);

//---------------------------------------------------------------------------------------------
// Global variables
//---------------------------------------------------------------------------------------------
HAB   hab;
HWND  hwndFrame,        // Frame
      hwndClient,       // Main client
      hwndStatus,       // Statusbar
      hwndToolbar,      // Toolbar
      hwndMenu,         // MainMenu
      hwndMLE;          // MLE

PFNWP pfnwOldFrameProc; // Pointer to normal Frame routine in kernel for subclassing
PFNWP pfnwOldMLEProc;   // Pointer to normal MLE   routine in kernel for subclassing

APIRET rc;

BOOL         success;
static CHAR  szAppName[]     = "editor2";
static CHAR  szKeyNameFont[] = "font";
static ULONG ulSize;
FONTDLG fontDlg;                // global structure


static CHAR  szKeyNamePos[] = "position";
struct  DATEN                   // position of the window
        {
        ULONG   PosX;
        ULONG   PosY;
        ULONG   SizeX;
        ULONG   SizeY;
        }
        position;


// for find / replace
MLE_SEARCHDATA SearchData;      // used is MLM_SEARCH message 
char szFind[60];                // target string for search 
char szReplace[60];             // replacement for search/replace 
char szLine[20];                // line number to go to 
USHORT res;                     // response from dialog or message box 
BOOL first;                     // set to TRUE if replace dialog called for first time 
LONG goline, gochar;            // go to line specified by user 


//---------------------------------------------------------------------------------------------
// Main procedure  (parameters for drop on icon)
//---------------------------------------------------------------------------------------------
main(int argc, char *argv[])
     {
     HMQ   hmq;
     QMSG  qmsg;
     ULONG flFrameFlags = FCF_TITLEBAR |FCF_SYSMENU |FCF_SIZEBORDER |FCF_MINMAX |FCF_TASKLIST;
     CHAR  szClient[] = "CLIENT";

     hab = WinInitialize (0);
     hmq = WinCreateMsgQueue (hab, 0);

     WinRegisterClass (hab, szClient, ClientWndProc, CS_SIZEREDRAW, 0);

     // Create Frame window
     hwndFrame = WinCreateStdWindow (HWND_DESKTOP,
                                     WS_VISIBLE,
                                     &flFrameFlags,
                                     szClient,
                                     "Untitled",
                                     0,
                                     NULLHANDLE,
                                     MAINMENU,
                                     &hwndClient);

      // Create statusbar window
      hwndStatus= WinCreateWindow(hwndFrame,
                                  WC_STATIC,
                                  "StatusBar",
                                  SS_TEXT| DT_VCENTER | WS_VISIBLE
                                  ,0, 0, 0, 0,       // client window has no size or position at this point
                                  hwndFrame,         // Owner handle (Client area)
                                  HWND_TOP,          // Z-order ontop
                                  STATUSBAR,         // Window ID
                                  0,                 // Control
                                  0);                // Presentation Parameters

     // Create MLE window
     hwndMLE = WinCreateWindow(hwndClient,           // Parent handle (Client area)
                               WC_MLE,               // Window class (NLE)
                               NULL,                 // Window header text
                               WS_VISIBLE|
                               MLS_WORDWRAP|
                               MLS_BORDER|
                               MLS_VSCROLL|
                               MLS_HSCROLL,          //Style flags
                               0, 0, 0, 0,           // client window has no size or position at this point
                               hwndClient,           // Owner handle (Client area)
                               HWND_TOP,             // Z-order ontop
                               MAINMLE,              // Window ID (Main MLE resource ID)
                               0,                    // Control
                               0);                   // Presentation Parameters
     //---------------------------------------------------------------------------------------------
     // Subclassing normal window proc & MLE window proc
     //---------------------------------------------------------------------------------------------
     pfnwOldFrameProc = WinSubclassWindow(hwndFrame,NewFrameProc);  // subclass Framewin
     pfnwOldMLEProc   = WinSubclassWindow(hwndMLE,NewMLEProc);      // Subclass mainMLE (drag drop)
     WinSetWindowULong(hwndFrame,QWL_USER,(ULONG)pfnwOldFrameProc); // Pointer to oldwinproc in winword
     WinSetWindowULong(hwndMLE,QWL_USER,(ULONG)pfnwOldMLEProc);     //pointer to winproc MLE in winword
     //---------------------------------------------------------------------------------------------
     // Load menu and toolbar
     //---------------------------------------------------------------------------------------------
     hwndMenu    = WinLoadMenu(hwndFrame,NULLHANDLE,MAINMENU);      // Load normal window menu
     hwndToolbar = WinLoadMenu(hwndFrame,NULLHANDLE,TOOLBAR);       // Load Toolbar
     //---------------------------------------------------------------------------------------------
     // Set Main window (Frame) size and position
     //---------------------------------------------------------------------------------------------
     WinSetWindowPos(hwndFrame,                     NULLHANDLE,
                     10,10,600,400,
                     SWP_ACTIVATE|SWP_MOVE|
                     SWP_SIZE    |SWP_SHOW);

     WinStartTimer(hab, hwndClient, 1, 100); // Timer for linenr and char pos display in statusbar


     // look up the ini file for font entry
     ulSize = sizeof fontDlg;

     success= PrfQueryProfileData (HINI_USERPROFILE, szAppName, szKeyNameFont, &fontDlg, &ulSize);

     // ok, then set the font on the MLE   
     if(success)   
       WinSendMsg(hwndMLE, MLM_SETFONT, MPFROMP(&(fontDlg.fAttrs)), NULL);


     ulSize = sizeof position;
     success= PrfQueryProfileData (HINI_USERPROFILE, szAppName, szKeyNamePos, &position, &ulSize);

     // set the window when sucessfull
     if(success)   
      WinSetWindowPos ( hwndFrame, NULL,
        position.PosX,  position.PosY,
        position.SizeX, position.SizeY,
        SWP_MOVE | SWP_SIZE | SWP_ACTIVATE | SWP_SHOW) ;

     //-------------------------------------
     // Process drop on icon
     //-------------------------------------
     if (argc > 1)
          OpenFile (argv[1]);

     while (WinGetMsg (hab, &qmsg, 0, 0, 0))
           WinDispatchMsg (hab, &qmsg);

     WinDestroyWindow (hwndFrame);
     WinDestroyMsgQueue (hmq);
     WinTerminate (hab);
     return(0);
     }

//---------------------------------------------------------------------------------------------
// Client window procedure
//---------------------------------------------------------------------------------------------
MRESULT EXPENTRY ClientWndProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
 ULONG  ulPicture;
 SWP    WinPosition ;

     switch (msg)
          {
          case WM_CREATE:
            ulPicture=(ULONG) WinLoadPointer(HWND_DESKTOP, 0, WinQueryWindowUShort(hwndFrame, QWS_ID));

            WinSendMsg(hwndFrame, WM_SETICON, (MPARAM) ulPicture, (MPARAM) 0);
            WinSetFocus(HWND_DESKTOP, hwndMLE);

          break;

          case WM_SIZE:
               {
               SWP   swpclient;
               WinQueryWindowPos(hwnd, &swpclient);            // Get SWP Client Area.
               WinSetWindowPos(hwndMLE,                        // Place and size MLE
                               HWND_TOP,                       // ONTOP in Z-order
                               0,                              // x coord(precies in de rand!)
                               0,                              // y coord
                               swpclient.cx,                   //
                               swpclient.cy,                   // Size,Place (same as Client Area)
                               SWP_SIZE | SWP_SHOW | SWP_MOVE);// Change size|move en Show
               }
          break;

          case WM_COMMAND:
               {
               switch (SHORT1FROMMP(mp1))
                    {
                    case IDM_NEW:
                         WinSetWindowText(hwndMLE, "");
                         WinSetWindowText(hwndFrame, "Untitled");
                    break;

                    case IDM_OPEN:
                         WinSetWindowText(hwndMLE, "");
                         OpenFileDlg(hwnd);
                    break;

//                  case IDM_RETRIEVE:
//                       OpenFileDlg(hwnd);
//                  break;

                    case IDM_SAVE:
                         {
                         char szTitle[CCHMAXPATH];
                         WinQueryWindowText(hwndFrame, CCHMAXPATH, szTitle);
                         SaveFile(szTitle);
                         }
                    break;

                    case IDM_SAVEAS:
                         {
                         char szTitle[CCHMAXPATH];
                         WinQueryWindowText(hwndFrame, CCHMAXPATH, szTitle);
                         SaveasFileDlg(hwnd);
                         }
                    break;

                    case IDM_UNDO:
                         WinSendMsg(hwndMLE, MLM_UNDO, 0L, 0L);
                    break;

                    case IDM_CUT:
                         WinSendMsg(hwndMLE, MLM_CUT, 0L, 0L);
                    break;

                    case IDM_COPY:
                         WinSendMsg(hwndMLE, MLM_COPY, 0L, 0L);
                    break;

                    case IDM_PASTE:
                         WinSendMsg(hwndMLE, MLM_PASTE, 0L, 0L);
                    break;

                    case IDM_CLEAR:
                         WinSendMsg(hwndMLE, MLM_CLEAR, 0L, 0L);
                    break;

                    case IDM_FONT:
                         SetFont();
                    break;


            // the following code comes from EDIT32    
            case IDM_FIND:
               if (DID_OK == WinDlgBox (HWND_DESKTOP, hwnd, FindDlgProc,
                                0, IDD_FIND, NULL)) {
//                SetPtrWait();

                  SearchData.cb = sizeof (MLE_SEARCHDATA);
                  SearchData.pchFind = szFind;
                  SearchData.cchFind = strlen (szFind);
                  SearchData.iptStart = (-1L);
                  SearchData.iptStop = (-1L);
      
                  res = SHORT1FROMMR (WinSendMsg (hwndMLE, MLM_SEARCH,
                                      MPFROMLONG (MLFSEARCH_SELECTMATCH),
                                      MPFROMP (&SearchData)));
      
//                SetPtrArrow();
      
                  if (!res) {    /* Not found: */
                     WinMessageBox (HWND_DESKTOP, hwnd, 
                        S_strNotFoundMsg, S_findMsg, 0, 
                        MB_OK | MB_ICONASTERISK | MB_MOVEABLE);
                     // Disable menu-item "Search Again": (tkg) 
//                   WinSendMsg (hwndMenu, MM_SETITEMATTR,
//                               MPFROM2SHORT (IDM_FINDAGAIN, TRUE),
//                               MPFROM2SHORT (MIA_DISABLED, MIA_DISABLED));
                  }
//                else {
                     // Enable menu-item "Search Again": (tkg) 
//                   WinSendMsg (hwndMenu, MM_SETITEMATTR,
//                               MPFROM2SHORT (IDM_FINDAGAIN, TRUE),
//                               MPFROM2SHORT (MIA_DISABLED, 0));
//                };
               }
               break;   
               
            case IDM_FINDAGAIN:
//                SetPtrWait();

                  SearchData.cb = sizeof (MLE_SEARCHDATA);
                  SearchData.pchFind = szFind;
                  SearchData.cchFind = strlen (szFind);
                  SearchData.iptStart = (-1L);
                  SearchData.iptStop = (-1L);
      
                  res = SHORT1FROMMR (WinSendMsg (hwndMLE, MLM_SEARCH,
                                      MPFROMLONG (MLFSEARCH_SELECTMATCH),
                                      MPFROMP (&SearchData)));
//                SetPtrArrow();
                  if (!res) {    /* Not found: */
                     WinMessageBox (HWND_DESKTOP, hwnd, 
                        S_strNotFoundMsg, S_findMsg, 0, 
                        MB_OK | MB_ICONASTERISK | MB_MOVEABLE);

                     // Disable menu-item "Search Again": (tkg) 
//                   WinSendMsg (hwndMenu, MM_SETITEMATTR,
//                               MPFROM2SHORT (IDM_FINDAGAIN, TRUE),
//                               MPFROM2SHORT (MIA_DISABLED, MIA_DISABLED));
                  };
                break;

               case IDM_REPLACE:
                 first = TRUE;
                 res = WinDlgBox (HWND_DESKTOP, hwnd, ReplaceDlgProc,
                        0, IDD_REPLACE, (PVOID)(&first));
                 first = FALSE;

                 for (;;) {
                  if (res == DID_CANCEL)
                     break;
                  else if (res == DID_OK) {                                   

                     // Disable menu-item "Search Again": (tkg) 
//                   WinSendMsg (hwndMenu, MM_SETITEMATTR,
//                               MPFROM2SHORT (IDM_FINDAGAIN, TRUE),
//                               MPFROM2SHORT (MIA_DISABLED, MIA_DISABLED));
//
//                   SetPtrWait();
                        
                     SearchData.cb = sizeof (MLE_SEARCHDATA);
                     SearchData.pchFind = szFind;
                     SearchData.cchFind = strlen (szFind);
                     SearchData.iptStart = (-1L);
                     SearchData.iptStop = (-1L);
                     
                     res = SHORT1FROMMR (WinSendMsg (hwndMLE, MLM_SEARCH, 
                                            MPFROMLONG (MLFSEARCH_SELECTMATCH),
                                            MPFROMP (&SearchData)));
                                       
//                   SetPtrArrow();
                        
                     if (!res) {                  
                        WinMessageBox (HWND_DESKTOP, hwnd, 
                           S_strNotFoundMsg, S_replaceMsg, 0,
                           MB_OK | MB_ICONASTERISK | MB_MOVEABLE);
                        break;   // exit search/replace 
                     }
                  }
                  else if (res == DID_DOREPLACE)
                     WinSendMsg (hwndMLE, MLM_INSERT, 
                        MPFROMP (szReplace), (MPARAM) 0L);
                  else if (res == DID_REPLACEALL) {
//                   SetPtrWait();
                        
                     WinSendMsg (hwndMLE, MLM_INSERT, 
                        MPFROMP (szReplace), (MPARAM) 0L);
                                 
                     SearchData.cb = sizeof (MLE_SEARCHDATA);
                     SearchData.pchFind = szFind;
                     SearchData.cchFind = strlen (szFind);
                     SearchData.pchReplace = szReplace;
                     SearchData.cchReplace = strlen (szReplace);
                     SearchData.iptStart = (-1L);
                     SearchData.iptStop = (-1L);
                     WinSendMsg (hwndMLE, MLM_SEARCH, 
                        MPFROMLONG (MLFSEARCH_CHANGEALL), 
                        MPFROMP (&SearchData));
                                 
//                   SetPtrArrow();
                        
                     WinMessageBox (HWND_DESKTOP, hwnd, 
                        S_allReplacedMsg, S_replaceMsg, 0,
                        MB_OK | MB_ICONASTERISK | MB_MOVEABLE);
                     break;   // exit search/replace 
                  }
                  else
                     break;   // exit search/replace 
                     
                   res = WinDlgBox (HWND_DESKTOP, hwnd, ReplaceDlgProc,
                           0, IDD_REPLACE, (PVOID)(&first));
                   }
                   break;     


                    case IDM_EXIT:
                         WinSendMsg(hwnd, WM_CLOSE, 0L, 0L);
                    break;

                    case IDM_ABOUT:
                         WinSetWindowText (hwndStatus, "editor");
                    break;
                    }
               }
          break;

          // when we close the dialog, query the window size and write to ini file ... 
          case WM_CLOSE:
                WinQueryWindowPos ( hwndFrame, &WinPosition ) ;

                position.PosX  = (LONG)WinPosition.x ;
                position.PosY  = (LONG)WinPosition.y ;

                position.SizeX = (LONG)WinPosition.cx ;
                position.SizeY = (LONG)WinPosition.cy ;

                // write the size of the window to the ini file entry for the next time 
                ulSize = sizeof position;
                PrfWriteProfileData (HINI_USERPROFILE, szAppName, szKeyNamePos, &position, ulSize);
          break;

          case WM_TIMER:
               {
               CHAR      String[64];
               LONG      Line, Col, Position;
               static    LONG OldPosition;

               Position = LONGFROMMR(WinSendMsg(hwndMLE, MLM_QUERYSEL, (MPARAM)MLFQS_CURSORSEL,0L));
               if (Position != OldPosition)
                    {
                    OldPosition = Position;
                    Line = LONGFROMMR(WinSendMsg(hwndMLE, MLM_LINEFROMCHAR, (MPARAM)Position, 0L));
                    Col  = LONGFROMMR(WinSendMsg(hwndMLE, MLM_CHARFROMLINE, (MPARAM)Line, 0L));
                    Col  = Position - Col;
                    sprintf(String,"  Line: %-5d Col: %-5d",Line+1,Col+1);
                    WinSetWindowText(hwndStatus, String);
                    }
               }
          }
     return (WinDefWindowProc (hwnd,msg,mp1,mp2));
     }

//--------------------------------------------------------------------------------------------
//  OpenFileDlg
//
//
//--------------------------------------------------------------------------------------------
void OpenFileDlg(HWND hwndWnd)
{
     FILEDLG     FileDlg;

     memset(&FileDlg, 0, sizeof(FILEDLG));             // All values in OpenDlg set to 0
     FileDlg.cbSize = sizeof(FILEDLG);                 // Set OpenDlg.cbSize (Mandatory)
     FileDlg.fl     = FDS_OPEN_DIALOG;                 // Set OpenDlg.fl (flags) (Mandatory)
     WinFileDlg(HWND_DESKTOP, hwndWnd, &FileDlg);      // Start Openfiledialog
     if (FileDlg.lReturn == DID_OK)                    // User pressed OK ?
          OpenFile(FileDlg.szFullFile);
}



//---------------------------------------------------------------------------------------------
// OpenFile  (Function added in EDITOR2 version)
//
// Function fills the main MLE with values from buffer.
// The filename of the file wich contents are in Buffer is writen to the titlebar.
//
// An MLE can't read more than 64 Kb at a time. Thats why this strange do/while is inserted
//---------------------------------------------------------------------------------------------
void OpenFile (PSZ pszFilename)
     {
//     CHAR        *Buffer;                 // input buffer
// n.h.
     PVOID       Buffer ; 
     HFILE       hfFile ;                 // file handle
     ULONG       Action, BytesRead = 0;   // status control
     CHAR        String[64];              // char string for status message
     IPT         ipt = -1;                // Insertion point

     //---------------------------------------------------------------------
     // Open file
     //---------------------------------------------------------------------
     DosOpen (pszFilename,                // Open file met naam in InFile
              &hfFile,                    // filehandle
              &Action,                    // Action taken by DosOpen
              0,                          // Filesize (not significant, opening existing file)
              FILE_NORMAL,                // Fileattribute (only significant in file creation)
              FILE_OPEN,                  // OPEN ACTION
              OPEN_FLAGS_FAIL_ON_ERROR |  // OPEN MODE
              OPEN_SHARE_DENYWRITE,
              NULL);  				  // NO EA's

     //---------------------------------------------------------------------
     // Read file in MLE
     //---------------------------------------------------------------------
     if (hfFile)
          {
          // first delete the MLE 
          WinSendMsg (hwndMLE, MLM_DELETE, MPFROMLONG (NULL),
            MPFROMLONG (WinSendMsg (hwndMLE, MLM_QUERYTEXTLENGTH, NULL, NULL)));


#ifdef __BORLANDC__
          Buffer = new char[0x8FFF];        // Set up memory for buffer
#else
          rc = DosAllocMem (&Buffer, (ULONG) 0x8FFF, PAG_READ | PAG_WRITE | PAG_COMMIT);
#endif

          WinSendMsg(hwndMLE,               // Set up buffer for MLE
                     MLM_SETIMPORTEXPORT,
                     (MPARAM) Buffer,
                     (MPARAM) 0x8FFF);

          do   {
               DosRead(hfFile, Buffer, 0x8000, &BytesRead);                  // Read buffer
               WinSendMsg(hwndMLE,                                           // Buffer import in MLE
                          MLM_IMPORT,
                          (MPARAM) &ipt,
                          MPFROMLONG(BytesRead));

               sprintf(String," File: %s   Bytes read:%d", pszFilename,ipt); // Stringfill

               WinSetWindowText( hwndStatus, String);                        // Bytesread in statusbar
               }
          while (BytesRead == 0x8000);

          WinSetWindowText(hwndFrame, pszFilename); // Filename in titlebar
          DosClose(hfFile);                         // Close file

#ifdef __BORLANDC__
          delete Buffer;
#else
          DosFreeMem (Buffer);
#endif
          }
     }

//-------------------------------------------------------------------------------------------
//  SaveasFileDlg  (Function added in EDITOR2 version)
//
//  Saveas filedialog
//-------------------------------------------------------------------------------------------
void SaveasFileDlg(HWND hwndWnd)
     {
     FILEDLG     FileDlg;
     FILESTATUS3 Status;
//     APIRET      rc;

     memset(&FileDlg, 0, sizeof(FILEDLG));             // All values in SaveasDlg set to 0
     FileDlg.cbSize = sizeof(FILEDLG);                 // Set SaveasDlg.cbSize (Mandatory)
     FileDlg.fl = FDS_SAVEAS_DIALOG| FDS_ENABLEFILELB; // Set SaveasDlg.fl (flags) (Mandatory)
     WinQueryWindowText(hwndFrame,                     // Query filename from Titlebar
                        CCHMAXPATH,
                        FileDlg.szFullFile);

     WinFileDlg(HWND_DESKTOP, hwndWnd, &FileDlg);      // Start SaveasFiledialog
     if (FileDlg.lReturn == DID_OK)                    // User pressed OK ?
          {
          rc = DosQueryPathInfo(FileDlg.szFullFile,
                                FIL_STANDARD,
                                &Status,
                                sizeof(Status));

          switch (rc)
               {
               case 0:   // File SaveDlg.szFullFile exists
                    {
                    if (WinMessageBox(HWND_DESKTOP, hwndWnd,
                                      "FILE EXISTS! Overwrite ?",
                                      FileDlg.szFullFile,
                                      0, MB_YESNO|MB_QUERY|MB_MOVEABLE) == MBID_YES)
                         {
                         SaveFile(FileDlg.szFullFile);
                         }
                    }
               break;

               case 2:   // File SaveDlg.szFullFile does not exist
                    SaveFile(FileDlg.szFullFile);
               break;

               default:  // An Error occured (most likely 3, path unknown)
                    WinMessageBox(HWND_DESKTOP, hwndWnd,
                                  "Invalid drive,path or file",
                                  "Save as",
                                  0, MB_OK|MB_ICONEXCLAMATION|MB_MOVEABLE);
               break;
               }
          }
     }



//-------------------------------------------------------------------------------------------------
// SaveFile  (Function added in EDITOR2 version)
//
// Function reads the main MLE and fills the buffer.
//
// MLE can't write more than 64 Kb at a time. Thats why this strange do/while is inserted
//-------------------------------------------------------------------------------------------------

void SaveFile (PSZ pszFilename)
     {
     PVOID  Buffer;                            // Transfer buffer
     HFILE  hfFile;                            // File handle
     ULONG  Action, Wrote, amount, amountexp;  //
     IPT    FirstChar = 0;                     // IPT
     LONG   FileLength;                        //
     CHAR   String[64];
//     APIRET rc;

     FileLength = (LONG) WinSendMsg(hwndMLE,   // Fetch filelength
                                    MLM_QUERYTEXTLENGTH,
                                    0,
                                    (MPARAM)0xffffffff);
     if(FileLength > 0)                        // Any contents?
           {
           //---------------------------------------------------------------------
           // Open file
           //---------------------------------------------------------------------
           DosOpen(pszFilename,               // Open file met naam in InFile
                   &hfFile,                   // filehandle
                   &Action,                   // Action taken by DosOpen
                   FileLength,                // Filesize (Initial)
                   FILE_NORMAL,               // Fileattribute (only significant in file creation)
                   OPEN_ACTION_CREATE_IF_NEW |// Open Action
                   OPEN_ACTION_REPLACE_IF_EXISTS,
                   OPEN_FLAGS_FAIL_ON_ERROR | // OPEN MODE
                   OPEN_SHARE_DENYREADWRITE|
                   OPEN_ACCESS_READWRITE,
                   NULL);                     // NO EA's

           if (hfFile)
               {
               //---------------------------------------------------------------------
               // Write from MLE to File
               //---------------------------------------------------------------------

#ifdef __BORLANDC__
          Buffer = new char[0x8FFF];        // Set up memory for buffer
#else
          rc = DosAllocMem (&Buffer, (ULONG) 0x8FFF, PAG_READ | PAG_WRITE | PAG_COMMIT);
#endif

               WinSendMsg(hwndMLE,
                          MLM_SETIMPORTEXPORT,
                          Buffer,
                          MPFROMLONG(0x8F00));

               do   {
                    amount = 0x8F00;
                    amountexp = (ULONG) WinSendMsg(hwndMLE, MLM_EXPORT, &FirstChar, &amount);
                    DosWrite(hfFile, (PVOID)Buffer, amountexp, &Wrote);
                    sprintf(String," Bytes written: %-10d ", FileLength);
                    WinSetWindowText( hwndStatus, String);
                    }
               while(amountexp != 0);
               WinSetWindowText(hwndFrame, pszFilename);


#ifdef __BORLANDC__
               delete Buffer;
#else
               DosFreeMem (Buffer);
#endif

               DosClose (hfFile) ;
               }
          }
}



//-------------------------------------------------------------------------------------------------
// NewFrameProc
//
// this proc is coupled through subclassing to the original window proc of the framewindow.
// If the framewindow proc is called, for example if the framewindow is put on the screen,
// this proc is called first. At the end of this subclass the handle  is passed to the
// original proced.
//-------------------------------------------------------------------------------------------------
MRESULT EXPENTRY NewFrameProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
     {

     HPS hpsTemp;
     PFNWP   oldFrameProc ;
     FONTMETRICS fm;


     oldFrameProc = (PFNWP) WinQueryWindowULong( hwnd, QWL_USER );      // Pointer from windowword

     switch (msg)
          {
          case WM_QUERYFRAMECTLCOUNT:
               {
               USHORT   itemCount;
               itemCount = SHORT1FROMMR(oldFrameProc(hwnd,msg,mp1,mp2)); //get count of original frame controls
               return ( (MRESULT) (itemCount+2) );                       //add 2 for new controls
               }

           case WM_FORMATFRAME :
               {
               USHORT itemCount = SHORT1FROMMR( oldFrameProc( hwnd, msg, mp1, mp2 ));
               USHORT usClient  = 0,
                      usMinMax  = 0,
                      usToolbar = 0,
                      usMenu    = itemCount,
                      usStatus  = itemCount+1;

               PSWP pSWP = (PSWP)PVOIDFROMMP(mp1);

               while (pSWP[usClient].hwnd != WinWindowFromID(hwndFrame, FID_CLIENT))
                    ++usClient;
               while (pSWP[usToolbar].hwnd != hwndToolbar)
                    ++usToolbar;
               while (pSWP[usMinMax].hwnd != WinWindowFromID(hwndFrame, FID_MINMAX))
                    ++usMinMax;

               // Fill in values for the menu
               pSWP[usMenu].fl = pSWP[usToolbar].fl;     // SWP_SIZE style flag
               pSWP[usMenu].cy = pSWP[usClient].cy;      // Heigth
               pSWP[usMenu].cx = pSWP[usClient].cx ;     // width is menu width
               pSWP[usMenu].hwndInsertBehind = HWND_TOP ;// On which window (ONTOP)
               pSWP[usMenu].hwnd = hwndMenu;             // Window handle

               WinSendMsg(pSWP[usMenu].hwnd,             // let the menu code make the adjustments(cy)
                          WM_ADJUSTWINDOWPOS,            // Message WM_ADJUSTWINDOWPOS to hwndTool
                          MPFROMP(pSWP+usMenu),          // mp1 == SWP struct of hwndTool
                          (MPARAM) 0L );                 // mp2 == Leeg 

               pSWP[usMenu].x = pSWP[usToolbar].x ;                                        // XPOS in FRAME
               pSWP[usMenu].y = pSWP[usToolbar].y + pSWP[usToolbar].cy - pSWP[usMenu].cy ; // YPOS in FRAME

               pSWP[usToolbar].y = pSWP[usMenu].y - pSWP[usToolbar].cy;

               // adjust client window size for 2nd menu
               // If not, the client window will be placed over the statusbar

               pSWP[usClient].cy= pSWP[usClient].cy - pSWP[usMenu].cy ;

               // Fill in values for the statusbar
               pSWP[usStatus].fl = SWP_SIZE | SWP_MOVE;      // SWP_SIZE style flag

               // get a presentation space for our statusbar
               hpsTemp = WinGetPS(hwndStatus);

               GpiQueryFontMetrics(hpsTemp, sizeof(FONTMETRICS), &fm);
               WinReleasePS(hpsTemp);

               // use font metrics to adjust hight
               pSWP[usStatus].cy = fm.lMaxBaselineExt;

               //pSWP[usStatus].cy = pSWP[usMinMax].cy;        // Heigth menu hoogte
               pSWP[usStatus].cx = pSWP[usToolbar].cx ;      // width is menu width
               pSWP[usStatus].x = pSWP[usClient].x ;         // XPOS in FRAME
               pSWP[usStatus].y = pSWP[usClient].y ;         // YPOS in FRAME
               pSWP[usStatus].hwndInsertBehind = HWND_TOP ;  // On which window (ONTOP)
               pSWP[usStatus].hwnd = hwndStatus;             // Window handle
               // adjust client window size for 2nd control
               // If not, the client window will be placed over the statusbar
               pSWP[usClient].cy= pSWP[usClient].cy - pSWP[usStatus].cy ;
               pSWP[usClient].y = pSWP[usStatus].y  + pSWP[usStatus].cy ;
               // return total count of frame controls
               return( MRFROMSHORT(itemCount+2));
               }

          default:
               return oldFrameProc(hwnd,msg,mp1,mp2);
          }
}


//--------------------------------------------------------------------------------------------------
// Subclass for MLE (for drag drop)  (Function added in EDITOR2 version)
//
// It is neccesery to subclass the MLE window to install drag & drop for opening files.
//
// DM_RENDER isn't send to the source because owning a filename and a sourcedir is enough
// Confed itself will open the file. It's not nessecery to use filesystem rendering!
//--------------------------------------------------------------------------------------------------
MRESULT EXPENTRY NewMLEProc(HWND hwndDlg, ULONG msg, MPARAM mpParm1, MPARAM mpParm2)
{
 PFNWP     oldMLEProc;
 PDRAGINFO pDragInfo;
 PDRAGITEM pDragItem;

     oldMLEProc = (PFNWP) WinQueryWindowULong(hwndDlg, QWL_USER); // Get Winproc pointer from winword

     switch (msg)
          {
          case DM_DRAGOVER:
	          {
          	pDragInfo = (PDRAGINFO) mpParm1;
          	DrgAccessDraginfo( pDragInfo );
          	pDragItem = DrgQueryDragitemPtr( pDragInfo, 0 );
          	//---------------------------------------------------------------
          	// Don't accept multi select and non_text
          	//---------------------------------------------------------------
               if (pDragInfo->cditem > 1 || !DrgVerifyType(pDragItem, DRT_TEXT))
		          return ( MPFROM2SHORT (DOR_NEVERDROP, DO_UNKNOWN) );
          	else
          		return ( MPFROM2SHORT (DOR_DROP, DO_UNKNOWN) );
          	}

          case DM_DROP:
               {
               UCHAR dragname[CCHMAXPATH];
               char szTitle[CCHMAXPATH];


               pDragInfo = (PDRAGINFO)mpParm1;
               DrgAccessDraginfo(pDragInfo);
               pDragItem = DrgQueryDragitemPtr(pDragInfo, 0);

               DrgQueryStrName(pDragItem->hstrContainerName,100,dragname);
               DrgQueryStrName(pDragItem->hstrSourceName,100,dragname+strlen(dragname));

               // first save the old file  
               WinQueryWindowText(hwndFrame, CCHMAXPATH, szTitle);
               SaveFile(szTitle);

               OpenFile(dragname);
               }
          break;
          }
 return oldMLEProc(hwndDlg, msg, mpParm1, mpParm2);
}


//  Name: SetFont
//
//  Description : Allows the user to select a font for the text
//                displayed in the MLE.
//
//  Concepts : Routine is called each time the user selects the
//             Font menu item from the Options menu.  The
//             standard font dialog is called with the current
//             available fonts.  If the user selects one, then
//             the MLM_SETFONT message is sent to the MLE to
//             display its text to the font chosen.
//
//  API's : WinSendMsg
//          GpiCreateLogFont
//          GpiSetCharSet
//          GpiQueryFontMetrics
//          GpiDeleteSetId
//          WinGetPS
//          WinReleasePS
//          WinLoadString
//          WinFontDlg
//
//  Parameters :  None
//
//  Returns: None
//
VOID SetFont(void)
{
//   FONTDLG fontDlg;
   HWND hwndFontDlg;
   HPS hpsMLE;
   FONTMETRICS fontMetrics;
//   CHAR szTitle[256];
   CHAR szFamily[CCHMAXPATH];
   static fxPointSize = 0;            // keep track of this for vector fonts 

   memset(&fontDlg, 0, sizeof(fontDlg));            // initialize all fields 
   // Get the current font attributes
   hpsMLE = WinGetPS(hwndMLE);
   WinSendMsg(hwndMLE, MLM_QUERYFONT,
      MPFROMP((PFATTRS)&(fontDlg.fAttrs)), NULL);

   // create system default font 

   GpiCreateLogFont(
      hpsMLE,
      (PSTR8)fontDlg.fAttrs.szFacename,
      1,
      &(fontDlg.fAttrs));

   GpiSetCharSet(hpsMLE, 1);

   GpiQueryFontMetrics(hpsMLE, sizeof(FONTMETRICS), &fontMetrics);

   GpiSetCharSet(hpsMLE, LCID_DEFAULT);
   GpiDeleteSetId(hpsMLE, 1);
   WinReleasePS(hpsMLE);
/*
   if(!WinLoadString(hab, (HMODULE)0, IDS_FONTDLGTITLE, MESSAGELEN, szTitle))
   {
      MessageBox(hwndMain, IDMSG_CANNOTLOADSTRING, MB_OK | MB_ERROR, TRUE);
      return;
   }
*/



   // Initialize the FONTDLG structure with the current font
   fontDlg.cbSize     = sizeof(FONTDLG);                  // sizeof(FONTDLG)  
   fontDlg.hpsScreen  = WinGetScreenPS(HWND_DESKTOP);  // Screen presentation space  
   fontDlg.hpsPrinter = NULLHANDLE;            // Printer presentation space  
   fontDlg.pszTitle      = "font";              // szTitle;       // Application supplied title       
   fontDlg.pszPreview    = "abcABC";     //  NULL;          // String to print in preview wndw  
   fontDlg.pszPtSizeList = NULL;          // Application provided size list   
   fontDlg.pfnDlgProc    = NULL;          // Dialog subclass procedure        

   strcpy(szFamily, fontMetrics.szFamilyname); // Family name of font         

   fontDlg.pszFamilyname = szFamily;      // point to Family name of font     
   fontDlg.fxPointSize = fxPointSize;     // Point size the user selected     
   fontDlg.fl           = FNTS_CENTER |   // FNTS_* flags - dialog styles     
                          FNTS_INITFROMFATTRS;
   fontDlg.flFlags      = 0;              // FNTF_* state flags               
                                          // Font type option bits            
   fontDlg.flType       = (LONG) fontMetrics.fsType;
   fontDlg.flTypeMask   = 0;              // Mask of which font types to use  
   fontDlg.flStyle      = 0;              // The selected style bits          
   fontDlg.flStyleMask  = 0;              // Mask of which style bits to use  
   fontDlg.clrFore      = CLR_BLACK;    // lClrForeground; // Selected foreground color        
   fontDlg.clrBack      = CLR_WHITE; // lClrBackground; // Selected background color        
   fontDlg.ulUser       = 0;              // Blank field for application      
   fontDlg.lReturn      = 0;              // Return Value of the Dialog       
   fontDlg.lSRC;                          // System return code.              
   fontDlg.lEmHeight    = 0;              // Em height of the current font    
   fontDlg.lXHeight     = 0;              // X height of the current font     
   fontDlg.lExternalLeading = 0;          // External Leading of font         
   fontDlg.hMod;                          // Module to load custom template   
                                          // Nominal Point Size of font       
   fontDlg.sNominalPointSize = fontMetrics.sNominalPointSize;
   fontDlg.usWeight = fontMetrics.usWeightClass; // The boldness of the font  
   fontDlg.usWidth = fontMetrics.usWidthClass;  // The width of the font      
   fontDlg.x            = 0;              // X coordinate of the dialog       
   fontDlg.y            = 0;              // Y coordinate of the dialog       
   fontDlg.usDlgId      = IDD_FONT;       // ID of a custom dialog template   
   fontDlg.usFamilyBufLen = sizeof(szFamily); //Length of family name buffer  
   fontDlg.fAttrs;                        // Font attribute structure         

   //   Bring up the standard Font Dialog

   hwndFontDlg = WinFontDlg(HWND_DESKTOP, hwndMLE, &fontDlg); 

   CentreDlgBox (hwndFontDlg, hwndClient);  // center the dialog box

   if(fontDlg.lReturn != DID_OK)          // check reason for return          
   {
      WinReleasePS(fontDlg.hpsScreen);
      return;
   }
   fxPointSize = fontDlg.fxPointSize;     // save point size for next dialog  

   //   If outline font, calculate the maxbaselineext and
   //   avecharwidth for the point size selected

   if ( fontDlg.fAttrs.fsFontUse == FATTR_FONTUSE_OUTLINE )
   {
      ConvertVectorFontSize(fontDlg.fxPointSize, &fontDlg.fAttrs);
   }

   //   Query FONTMETRICS again to determine if font has been ISO9241
   //   tested and if it complies to the ISO9241 standard.

   hpsMLE = WinGetPS(hwndMLE);
   GpiQueryFontMetrics(hpsMLE, sizeof(FONTMETRICS), &fontMetrics);

/*
   if (fontMetrics.fsSelection & FM_SEL_ISO9241_TESTED)
   {
       //  Values of fbPassed/FailedISO field in the PANOSE structure below
       //  indicate if any displays with ISO support pass/fail compliance test.
       //  If desired, you could also determine the display type to narrow
       //  down which of the following bit tests are necessary.

      if ((fontMetrics.panose.fbFailedISO & FM_ISO_9515_640 ) &&
          (fontMetrics.panose.fbFailedISO & FM_ISO_9515_1024) &&
          (fontMetrics.panose.fbFailedISO & FM_ISO_9517_640 ) &&
          (fontMetrics.panose.fbFailedISO & FM_ISO_9517_1024) &&
          (fontMetrics.panose.fbFailedISO & FM_ISO_9518_640 ))
      {
          //  font selected fails ISO compliance test on all diplays
          ((  tested above.
         MessageBox(hwndMain, IDMSG_ISOFAILED, MB_OK | MB_WARNING, FALSE);
      }
   }
   else
   {  // font isn't tested for ISO compliance 
      MessageBox(hwndMain, IDMSG_ISONOTTESTED, MB_OK | MB_WARNING, FALSE);
   }
*/

   WinReleasePS(fontDlg.hpsScreen);
   WinReleasePS(hpsMLE);
   WinSendMsg(hwndMLE, MLM_SETFONT, MPFROMP(&(fontDlg.fAttrs)), NULL);

   // write the selection to the ini file entry for the next time 
   ulSize = sizeof fontDlg;
   PrfWriteProfileData (HINI_USERPROFILE, szAppName, szKeyNameFont, &fontDlg, ulSize);
}   // End of SetFont()                                                  





//   Convert vector font size using point size and fAttrs structure and
//   return it in that structure.
VOID ConvertVectorFontSize(FIXED fxPointSize, PFATTRS pfattrs)
{
  HPS   hps;
  HDC   hDC;
  LONG  lxFontResolution;
  LONG  lyFontResolution;
  SIZEF sizef;

  hps = WinGetScreenPS(HWND_DESKTOP);        // Screen presentation space  

  //   Query device context for the screen and then query
  //   the resolution of the device for the device context.

  hDC = GpiQueryDevice(hps);
  DevQueryCaps( hDC, CAPS_HORIZONTAL_FONT_RES, (LONG)1, &lxFontResolution);
  DevQueryCaps( hDC, CAPS_VERTICAL_FONT_RES, (LONG)1, &lyFontResolution);

  //   Calculate the size of the character box, based on the
  //   point size selected and the resolution of the device.
  //   The size parameters are of type FIXED, NOT int.
  //   NOTE: 1 point == 1/72 of an inch.

  sizef.cx = (FIXED)(((fxPointSize) / 72 ) * lxFontResolution );
  sizef.cy = (FIXED)(((fxPointSize) / 72 ) * lyFontResolution );

  pfattrs->lMaxBaselineExt = MAKELONG( HIUSHORT( sizef.cy ), 0 );
  pfattrs->lAveCharWidth   = MAKELONG( HIUSHORT( sizef.cx ), 0 );
  WinReleasePS(hps);

}   // end ConvertVectorPointSize()  


/* window procedure for find (text search) dialog box */
MRESULT EXPENTRY FindDlgProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
   switch (msg) {
      case WM_INITDLG:

      CentreDlgBox (hwnd, hwndClient);  // center the dialog box

        WinSendDlgItemMsg (hwnd, DID_FINDTEXT, EM_SETTEXTLIMIT,
           MPFROM2SHORT (50, 0), NULL);
         WinSetDlgItemText (hwnd, DID_FINDTEXT, szFind);
         WinSetFocus (HWND_DESKTOP, WinWindowFromID (hwnd, DID_FINDTEXT));
         return (MRESULT) TRUE;
         
      case WM_COMMAND:
         switch (SHORT1FROMMP (mp1)) {
            case DID_OK:
               if (WinQueryDlgItemText (hwnd, DID_FINDTEXT, 60, szFind))
                  WinDismissDlg (hwnd, DID_OK);
               else
                  WinDismissDlg (hwnd, DID_CANCEL);
               return 0;
               
            case DID_CANCEL:
               WinDismissDlg (hwnd, DID_CANCEL);
               return 0;
               
            default:
               break;
         }
   }
   return WinDefDlgProc (hwnd, msg, mp1, mp2);
}


/* window procedure for replace (text search and replace) dialog box */
MRESULT EXPENTRY ReplaceDlgProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
   BOOL FAR *pb;
   
   switch (msg) {
      case WM_INITDLG:

      CentreDlgBox (hwnd, hwndClient);  // center the dialog box


         WinSendDlgItemMsg (hwnd, DID_NEWTEXT, EM_SETTEXTLIMIT,
            MPFROM2SHORT (50, 0), NULL);
         WinSendDlgItemMsg (hwnd, DID_OLDTEXT, EM_SETTEXTLIMIT,
            MPFROM2SHORT (50, 0), NULL);
         WinSetDlgItemText (hwnd, DID_OLDTEXT, szFind);
         WinSetDlgItemText (hwnd, DID_NEWTEXT, szReplace);
         pb = (PVOID) mp2;   /* TRUE if first entry */
         if (*pb) {
            WinEnableWindow (WinWindowFromID (hwnd, DID_DOREPLACE), FALSE);
            WinEnableWindow (WinWindowFromID (hwnd, DID_REPLACEALL), FALSE);
            WinSetFocus (HWND_DESKTOP, WinWindowFromID (hwnd, DID_OLDTEXT));
         }
         else
            WinSetFocus (HWND_DESKTOP, WinWindowFromID (hwnd, DID_NEWTEXT));
         return (MRESULT) TRUE;
         
      case WM_COMMAND:
         switch (SHORT1FROMMP (mp1)) {
            case DID_OK:
               if (WinQueryDlgItemText (hwnd, DID_OLDTEXT, 60, szFind)) {
                  WinQueryDlgItemText (hwnd, DID_NEWTEXT, 60, szReplace);
                  WinDismissDlg (hwnd, DID_OK);
               }
               else
                  WinDismissDlg (hwnd, DID_CANCEL);
               return 0;
               
            case DID_DOREPLACE:
               if (WinQueryDlgItemText (hwnd, DID_NEWTEXT, 60, szReplace))
                  WinDismissDlg (hwnd, DID_DOREPLACE);
               else
                  WinDismissDlg (hwnd, DID_CANCEL);
               break;
               
            case DID_REPLACEALL:
               if (WinQueryDlgItemText (hwnd, DID_NEWTEXT, 60, szReplace))
                  WinDismissDlg (hwnd, DID_REPLACEALL);
               else
                  WinDismissDlg (hwnd, DID_CANCEL);
               break;
               
            case DID_CANCEL:
               WinDismissDlg (hwnd, DID_CANCEL);
               return 0;
               
            default:
               break;
         }
   }
   return WinDefDlgProc (hwnd, msg, mp1, mp2);
}




/* window procedure for find (text search) dialog box */
MRESULT EXPENTRY GoLnDlgProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
   switch (msg) {
      case WM_INITDLG:
         WinSetFocus (HWND_DESKTOP, WinWindowFromID (hwnd, DID_LINENBR));
         return (MRESULT) TRUE;
         
      case WM_COMMAND:
         switch (SHORT1FROMMP (mp1)) {
            case DID_OK:
               if (WinQueryDlgItemText (hwnd, DID_LINENBR, 20, szLine))
                  WinDismissDlg (hwnd, DID_OK);
               else
                  WinDismissDlg (hwnd, DID_CANCEL);
               return 0;
               
            case DID_CANCEL:
               WinDismissDlg (hwnd, DID_CANCEL);
               return 0;
               
            default:
               break;
         }
   }
   return WinDefDlgProc (hwnd, msg, mp1, mp2);
}


/*ͻ
  Name         : CentreDlgBox                                               
                                                                            
  Description  : centres a dialog box (hwnddlg)on a given parent(hwndparent)
                                                                            
                                                                            
  Return       : VOID                                                       
                                                                            
 ͼ*/
VOID CentreDlgBox(HWND hwndDlg, HWND hwndParent)
{
  LONG  ix, iy;                     // New position of the dialog box
  LONG  iwidth, idepth;             // Size of the display
  SWP   swp;                        // Window informations
  RECTL rect;                       // Size of the window

  // Get size of display
  iwidth = (SHORT)WinQuerySysValue (HWND_DESKTOP, SV_CXSCREEN );
  idepth = (SHORT)WinQuerySysValue (HWND_DESKTOP, SV_CYSCREEN );

  // Get size of window and norm it to screen
  WinQueryWindowRect (hwndParent, &rect);
  WinMapWindowPoints (hwndParent, HWND_DESKTOP, (PPOINTL)&rect, 2);

  // Get window informations of the dialog box
  WinQueryWindowPos (hwndDlg, (PSWP)&swp);

  // Calculate new position
  ix = ((rect.xRight - rect.xLeft   - swp.cx) / 2) + rect.xLeft;
  iy = ((rect.yTop   - rect.yBottom - swp.cy) / 2) + rect.yBottom;

  // Make shure, that the box is totally visible
  ix = max (ix, 0);
  ix = min (ix, (iwidth - swp.cx));

  iy = max (iy, 0);
  iy = min (iy, (idepth - swp.cy));

  // Set the new position
  WinSetWindowPos( hwndDlg, HWND_TOP, ix, iy, 0, 0, SWP_MOVE );
}
// End of CentreDlgBox()

