/*  */
/* Extract Summary from Downsort's ALLFileList    -    by Rob Hamerling  */
/*  */

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

parse arg all sum

if all <> '' then
  call SysFileTree all, 'file', 'FO'
if all = '' | sum = '' | file.0 = 0 then
  do
    call beep 800, 200
    say ''
    say 'Syntax:  SPLITSUM  <allfiles>  <summary>'
    say ''
    say ' <allfiles> and <summary> should specify input and output files'
    say ''
    if file.0 = 0 then
      say ' <allfiles>' all 'could not be found'
    exit 1
  end

say 'Extracting file area summary report of' file.1 'into' sum

linecount = 0
do while lines(file.1) > 0              /* copy header */
  l = linein(file.1)
  linecount = linecount + 1
  if substr(l, 1, 5) = '' & linecount < 100 then
    leave
  rx = lineout(sum, l)
end

do while lines(file.1) > 0              /* skip to summary */
  l = linein(file.1)
  if substr(l, 1, 1) = '' then
    leave
end

if lines(file.1) = 0 then               /* check if summary present */
  do
    say 'No summary found in' file.1
    exit 99
  end

do while lines(file.1) > 0              /* rest of file is summary */
  l = linein(file.1)
  rx = lineout(sum, l)
end

exit
