Unit MCIOS2;

(* use 8-bit alignment *)
{$Cdecl+,AlignRec-,OrgName+}

{L MDM.LIB}
{L MMIO.LIB}

{L MMPM.LIB}
{$L OS2ME.LIB}


interface

uses OS2DEF,Use32;

{$I MEERROR.INC} (*Error Constants*)

(***************)
(* definitions *)
(***************)
const
  BPS_4=4;
  BPS_8=8;
  BPS_16=16;

  CF_RMID=10;
  CF_RIFF=11;
  CF_WAVE=12;
  CF_AVI=13;

  CH_1=1;
  CH_2=2;
  CH_4=4;

  HZ_8000=8000;
  HZ_11025=11025;
  HZ_14700=14700;
  HZ_18900=18900;
  HZ_22050=22050;
  HZ_37800=37800;
  HZ_44100=44100;

  RT_RMID=100;
  RT_RIFF=101;
  RT_WAVE=102;
  RT_AVI=103;
  RT_AVS=104;




  MCI_TRUE=1;
  MCI_FALSE=0;

(************************)
(* multimedia filetypes *)
(************************)

  DATATYPE_NULL=$0000;
  DATATYPE_WAVEFORM=$0001;
  DATATYPE_DIGVIDEO=$0002;
  DATATYPE_RIFF_ALAW=$0006;
  DATATYPE_RIFF_MULAW=$0007;
  DATATYPE_MULAW=$0101;
  DATATYPE_ALAW=$0102;
  DATATYPE_ADPCM_AVC=$0103;
  DATATYPE_CT_ADPCM=$0200;
  DATATYPE_MIDI=$0201;
  DATATYPE_GENERIC=$0202;
  DATATYPE_SPV2=$0203;
  DATATYPE_CDXA_VIDEO=$0204;
  DATATYPE_CDXA_DATA=$0205;
  DATATYPE_CDXA_AUDIO=$0206;
  DATATYPE_CDXA_AUDIO_HD=$0207;
  DATATYPE_CDXA_HEADERS=$0208;
  DATATYPE_UNKNOWN=$FFFFFFFF;

  DATATYPE_DIGISPEECH=$0208;
  DIGISPEECH_NATIVE=$0001;
  SUBTYPE_NONE=$0000;

  WAVE_FORMAT_1M08=$0001;
  WAVE_FORMAT_1S08=$0002;
  WAVE_FORMAT_1M16=$0003;
  WAVE_FORMAT_1S16=$0004;
  WAVE_FORMAT_2M08=$0005;
  WAVE_FORMAT_2S08=$0006;
  WAVE_FORMAT_2M16=$0007;
  WAVE_FORMAT_2S16=$0008;
  WAVE_FORMAT_4M08=$0009;
  WAVE_FORMAT_4S08=$000a;
  WAVE_FORMAT_4M16=$000b;
  WAVE_FORMAT_4S16=$000c;
  WAVE_FORMAT_8M08=$000d;
  WAVE_FORMAT_8S08=$000e;
  WAVE_FORMAT_8M16=$000f;
  WAVE_FORMAT_8S16=$0010;

  DIGVIDEO_PHOTOM=$544F4850;
  DIGVIDEO_ULTIM=$49544c55;
  DIGVIDEO_AVI=$20495641;

  MULAW_8B8KS=$0001;
  MULAW_8B11KS=$0002;
  MULAW_8B22KS=$0003;
  MULAW_8B44KS=$0004;
  MULAW_8B8KM=$0005;
  MULAW_8B11KM=$0006;
  MULAW_8B22KM=$0007;
  MULAW_8B44KM=$0008;

  ALAW_8B8KS=$0001;
  ALAW_8B11KS=$0002;
  ALAW_8B22KS=$0003;
  ALAW_8B44KS=$0004;
  ALAW_8B8KM=$0005;
  ALAW_8B11KM=$0006;
  ALAW_8B22KM=$0007;
  ALAW_8B44KM=$0008;

  ADPCM_AVC_VOICE=$0001;
  ADPCM_AVC_MUSIC=$0002;
  ADPCM_AVC_STEREO=$0003;
  ADPCM_AVC_HQ=$0004;

  CT_ADPCM_16B8KS=$0001;
  CT_ADPCM_16B11KS=$0002;
  CT_ADPCM_16B22KS=$0003;
  CT_ADPCM_16B44KS=$0004;
  CT_ADPCM_16B8KM=$0005;
  CT_ADPCM_16B11KM=$0006;
  CT_ADPCM_16B22KM=$0007;
  CT_ADPCM_16B44KM=$0008;

  SPV2_BPCM=$0001;
  SPV2_PCM=$0002;
  SPV2_NONE=$0003;

  CDXA_LEVELB=$0000;
  CDXA_LEVELC=$0001;
  CDXA_LEVELB_MONO=$0002;
  CDXA_LEVELC_MONO=$0003;


(**********)
(* limits *)
(**********)

  MAX_DEVICE_NAME=20;
  MAX_ALIAS_NAME=20;
  MAX_PRODINFO=40;
  MAX_EXTENSION_NAME=4;
  MAX_DEV_PARAMS=128;
  MAX_VERSION_NUMBER=6;
  MAX_PDD_NAME=9;
  MAX_DLL_NAME=260;
  MAX_CLASSES=10;
  MAX_CONNECTORS=10;
  MAX_EXTENSIONS=25;
  MAX_TYPEBUFFER=256;


(************************)
(* MCI command messages *)
(************************)

  MCI_OPEN=1;
  MCI_CLOSE=2;
  MCI_ESCAPE=3;
  MCI_PLAY=4;
  MCI_SEEK=5;
  MCI_STOP=6;
  MCI_PAUSE=7;
  MCI_INFO=8;
  MCI_GETDEVCAPS=9;
  MCI_STATUS=10;
  MCI_SPIN=11;
  MCI_SET=12;
  MCI_STEP=13;
  MCI_RECORD=14;
  MCI_SYSINFO=15;
  MCI_SAVE=16;
  MCI_CUE=17;
  MCI_UPDATE=18;
  MCI_SET_CUEPOINT=19;
  MCI_SET_POSITION_ADVISE=20;
  MCI_SET_SYNC_OFFSET=21;
  MCI_LOAD=22;
  MCI_ACQUIREDEVICE=23;
  MCI_RELEASEDEVICE=24;
  MCI_MASTERAUDIO=25;
  MCI_GETTOC=26;
  MCI_DEVICESETTINGS=27;
  MCI_CONNECTOR=28;
  MCI_RESUME=29;
  MCI_CONNECTORINFO=31;
  MCI_DEFAULT_CONNECTION=32;
  MCI_CONNECTION=33;
  MCI_GROUP=34;
  MCI_CAPTURE=40;
  MCI_FREEZE=41;
  MCI_GETIMAGEBUFFER=42;
  MCI_GETIMAGEPALETTE=43;
  MCI_PUT=44;
  MCI_REALIZE=45;
  MCI_REWIND=46;
  MCI_RESTORE=47;
  MCI_SETIMAGEBUFFER=48;
  MCI_SETIMAGEPALETTE=49;
  MCI_UNFREEZE=50;
  MCI_WHERE=51;
  MCI_WINDOW=52;
  MCI_DELETE=53;
  MCI_CUT=54;
  MCI_PASTE=55;
  MCI_COPY=56;
  MCI_REDO=57;
  MCI_UNDO=58;
  MCI_MAX_COMMAND=58;
  MCI_USER_MESSAGES=2000;


(****************)
(* device stuff *)
(****************)

  MCI_ALL_DEVICE_ID=$FFFF;

  MCI_DEVTYPE_VIDEOTAPE=1;
  MCI_DEVTYPE_VIDEODISC=2;
  MCI_DEVTYPE_CD_AUDIO=3;
  MCI_DEVTYPE_DAT=4;
  MCI_DEVTYPE_AUDIO_TAPE=5;
  MCI_DEVTYPE_OTHER=6;
  MCI_DEVTYPE_WAVEFORM_AUDIO=7;
  MCI_DEVTYPE_SEQUENCER=8;
  MCI_DEVTYPE_AUDIO_AMPMIX=9;
  MCI_DEVTYPE_OVERLAY=10;
  MCI_DEVTYPE_ANIMATION=11;
  MCI_DEVTYPE_DIGITAL_VIDEO=12;
  MCI_DEVTYPE_SPEAKER=13;
  MCI_DEVTYPE_HEADPHONE=14;
  MCI_DEVTYPE_MICROPHONE=15;
  MCI_DEVTYPE_MONITOR=16;
  MCI_DEVTYPE_CDXA=17;

  MCI_MAX_SYSTEM_DEVICE_NAMES=17;

  MCI_DEVTYPE_VIDEOTAPE_NAME='Videotape';
  MCI_DEVTYPE_VIDEODISC_NAME='Videodisc';
  MCI_DEVTYPE_CD_AUDIO_NAME='CDaudio';
  MCI_DEVTYPE_DAT_NAME='DAT';
  MCI_DEVTYPE_AUDIO_TAPE_NAME='Audiotape';
  MCI_DEVTYPE_OTHER_NAME='Other';
  MCI_DEVTYPE_WAVEFORM_AUDIO_NAME='Waveaudio';
  MCI_DEVTYPE_SEQUENCER_NAME='Sequencer';
  MCI_DEVTYPE_AUDIO_AMPMIX_NAME='Ampmix';
  MCI_DEVTYPE_OVERLAY_NAME='Overlay';
  MCI_DEVTYPE_ANIMATION_NAME='Animation';
  MCI_DEVTYPE_DIGITAL_VIDEO_NAME='Digitalvideo';
  MCI_DEVTYPE_SPEAKER_NAME='Speaker';
  MCI_DEVTYPE_HEADPHONE_NAME='Headphone';
  MCI_DEVTYPE_MICROPHONE_NAME='Microphone';
  MCI_DEVTYPE_MONITOR_NAME='Monitor';
  MCI_DEVTYPE_CDXA_NAME='CDXA';


(********************)
(* item base values *)
(********************)

  MCI_AMP_ITEM_BASE=$1000;
  MCI_CD_ITEM_BASE=$2000;
  MCI_CDXA_ITEM_BASE=$3000;
  MCI_VD_ITEM_BASE=$4000;
  MCI_SEQ_ITEM_BASE=$5000;
  MCI_WAVE_ITEM_BASE=$6000;
  MCI_VID_ITEM_BASE=$7000;
  MCI_DGV_ITEM_BASE=$8000;
  MCI_OVLY_ITEM_BASE=$9000;


(*********)
(* items *)
(*********)

  MCI_AMP_STATUS_PITCH=MCI_AMP_ITEM_BASE;
  MCI_AMP_STATUS_TREBLE=(MCI_AMP_ITEM_BASE+1);
  MCI_AMP_STATUS_BASS=(MCI_AMP_ITEM_BASE+2);
  MCI_AMP_STATUS_BALANCE=(MCI_AMP_ITEM_BASE+3);
  MCI_AMP_STATUS_GAIN=(MCI_AMP_ITEM_BASE+4);
  MCI_AMP_STATUS_MONITOR=(MCI_AMP_ITEM_BASE+5);

  MCI_CD_STATUS_TRACK_TYPE=MCI_CD_ITEM_BASE;
  MCI_CD_STATUS_TRACK_COPYPERMITTED=(MCI_CD_ITEM_BASE+1);
  MCI_CD_STATUS_TRACK_CHANNELS=(MCI_CD_ITEM_BASE+2);
  MCI_CD_STATUS_TRACK_PREEMPHASIS=(MCI_CD_ITEM_BASE+3);

  MCI_CDXA_STATUS_CHANNEL=MCI_CDXA_ITEM_BASE;

  MCI_VD_STATUS_SPEED=MCI_VD_ITEM_BASE;
  MCI_VD_STATUS_FORWARD=(MCI_VD_ITEM_BASE+1);
  MCI_VD_MEDIA_TYPE=(MCI_VD_ITEM_BASE+2);
  MCI_VD_STATUS_SIDE=(MCI_VD_ITEM_BASE+3);
  MCI_VD_STATUS_DISC_SIZE=(MCI_VD_ITEM_BASE+4);

  MCI_SEQ_STATUS_TEMPO=MCI_SEQ_ITEM_BASE;
  MCI_SEQ_STATUS_OFFSET=(MCI_SEQ_ITEM_BASE+1);
  MCI_SEQ_STATUS_DIVTYPE=(MCI_SEQ_ITEM_BASE+2);
  MCI_SEQ_STATUS_MASTER=(MCI_SEQ_ITEM_BASE+3);
  MCI_SEQ_STATUS_PORT=(MCI_SEQ_ITEM_BASE+4);
  MCI_SEQ_STATUS_SLAVE=(MCI_SEQ_ITEM_BASE+5);

  MCI_WAVE_STATUS_LEVEL=MCI_WAVE_ITEM_BASE;
  MCI_WAVE_STATUS_SAMPLESPERSEC=(MCI_WAVE_ITEM_BASE+1);
  MCI_WAVE_STATUS_AVGBYTESPERSEC=(MCI_WAVE_ITEM_BASE+2);
  MCI_WAVE_STATUS_BLOCKALIGN=(MCI_WAVE_ITEM_BASE+3);
  MCI_WAVE_STATUS_FORMATTAG=(MCI_WAVE_ITEM_BASE+4);
  MCI_WAVE_STATUS_CHANNELS=(MCI_WAVE_ITEM_BASE+5);
  MCI_WAVE_STATUS_BITSPERSAMPLE=(MCI_WAVE_ITEM_BASE+6);

  MCI_VID_SET_VIDEO_COMPRESSION=MCI_VID_ITEM_BASE;
  MCI_VID_SET_IMAGE_COMPRESSION=(MCI_VID_ITEM_BASE+1);
  MCI_VID_SET_IMAGE_BITSPERPEL=(MCI_VID_ITEM_BASE+2);
  MCI_VID_SET_IMAGE_PELFORMAT=(MCI_VID_ITEM_BASE+3);
  MCI_VID_SET_BRIGHTNESS=(MCI_VID_ITEM_BASE+4);
  MCI_VID_SET_CONTRAST=(MCI_VID_ITEM_BASE+5);
  MCI_VID_SET_HUE=(MCI_VID_ITEM_BASE+6);
  MCI_VID_SET_SATURATION=(MCI_VID_ITEM_BASE+7);
  MCI_VID_SET_SHARPNESS=(MCI_VID_ITEM_BASE+8);
  MCI_VID_SET_GREYSCALE=(MCI_VID_ITEM_BASE+9);
  MCI_VID_SET_IMAGE_QUALITY=(MCI_VID_ITEM_BASE+10);
  MCI_VID_SET_VIDEO_QUALITY=(MCI_VID_ITEM_BASE+11);
  MCI_VID_SET_IMAGE_COMPRESSION_METHOD=(MCI_VID_ITEM_BASE+12);
  MCI_VID_SET_MINIMUM_VIDEO_REFRESH_RATE=(MCI_VID_ITEM_BASE+13);
  MCI_VID_SET_IMAGE_FILE_FORMAT=(MCI_VID_ITEM_BASE+14);
  MCI_VID_SET_REF_INTERVAL=(MCI_VID_ITEM_BASE+15);
  MCI_VID_SET_MAXDATARATE=(MCI_VID_ITEM_BASE+16);
  MCI_VID_SET_VIDEO_FILE_FORMAT=(MCI_VID_ITEM_BASE+17);

  MCI_VID_STATUS_HWND=MCI_VID_ITEM_BASE;
  MCI_VID_STATUS_AUDIO_COMPRESSION=(MCI_VID_ITEM_BASE+1);
  MCI_VID_STATUS_VIDEO_COMPRESSION=(MCI_VID_ITEM_BASE+2);
  MCI_VID_STATUS_IMAGE_COMPRESSION=(MCI_VID_ITEM_BASE+3);
  MCI_VID_STATUS_AUDIO_QUALITY=(MCI_VID_ITEM_BASE+4);
  MCI_VID_STATUS_VIDEO_QUALITY=(MCI_VID_ITEM_BASE+5);
  MCI_VID_STATUS_IMAGE_QUALITY=(MCI_VID_ITEM_BASE+6);
  MCI_VID_STATUS_IMAGE_BITSPERPEL=(MCI_VID_ITEM_BASE+7);
  MCI_VID_STATUS_IMAGE_PELFORMAT=(MCI_VID_ITEM_BASE+8);
  MCI_VID_STATUS_FORWARD=(MCI_VID_ITEM_BASE+9);
  MCI_VID_STATUS_NORMAL_RATE=(MCI_VID_ITEM_BASE+10);
  MCI_VID_STATUS_VIDEO_X_EXTENT=(MCI_VID_ITEM_BASE+11);
  MCI_VID_STATUS_VIDEO_Y_EXTENT=(MCI_VID_ITEM_BASE+12);
  MCI_VID_STATUS_IMAGE_X_EXTENT=(MCI_VID_ITEM_BASE+13);
  MCI_VID_STATUS_IMAGE_Y_EXTENT=(MCI_VID_ITEM_BASE+14);
  MCI_VID_STATUS_BRIGHTNESS=(MCI_VID_ITEM_BASE+15);
  MCI_VID_STATUS_CONTRAST=(MCI_VID_ITEM_BASE+16);
  MCI_VID_STATUS_HUE=(MCI_VID_ITEM_BASE+17);
  MCI_VID_STATUS_SATURATION=(MCI_VID_ITEM_BASE+18);
  MCI_VID_STATUS_GREYSCALE=(MCI_VID_ITEM_BASE+19);
  MCI_VID_STATUS_SHARPNESS=(MCI_VID_ITEM_BASE+20);
  MCI_VID_STATUS_SPEED=(MCI_VID_ITEM_BASE+21);
  MCI_VID_STATUS_IMAGE_FILE_FORMAT=(MCI_VID_ITEM_BASE+22);
  MCI_VID_STATUS_TRANSPARENT_TYPE=(MCI_VID_ITEM_BASE+23);
  MCI_VID_STATUS_REF_INTERVAL=(MCI_VID_ITEM_BASE+24);
  MCI_VID_STATUS_MAXDATARATE=(MCI_VID_ITEM_BASE+25);
  MCI_VID_STATUS_VIDEO_FILE_FORMAT=(MCI_VID_ITEM_BASE+26);
  MCI_VID_STATUS_TRANSPARENT_COLOR=(MCI_VID_ITEM_BASE+24);

  MCI_DGV_SET_AUDIO_COMPRESSION=MCI_DGV_ITEM_BASE;
  MCI_DGV_SET_AUDIO_QUALITY=(MCI_DGV_ITEM_BASE+1);


(**************)
(* operations *)
(**************)

  MCI_NOTIFY=$00000001;
  MCI_WAIT=$00000002;
  MCI_FROM=$00000004;
  MCI_TO=$00000008;
  MCI_MILLISECONDS=$00000010;
  MCI_TRACK=$00000020;
  MCI_OVER=$00000040;
  MCI_TEST=$00000080;
  MCI_TO_BUFFER=$00000100;
  MCI_FROM_BUFFER=$00000200;
  MCI_CONVERT_FORMAT=$00000400;


(*********************)
(* other definitions *)
(*********************)

  MCI_ACQUIRE_QUEUE=$00000400;
  MCI_AUD_COMP_ADPCM4=$00000001;
  MCI_AUD_COMP_PCM8=$00000002;
  MCI_AUD_QUALITY_HIGH=$00000001;
  MCI_AUD_QUALITY_MED=$00000002;
  MCI_AUD_QUALITY_LOW=$00000003;

  MCI_CAPTURE_RECT=$00000100;
  MCI_CONVERT=$00001000;
  MCI_CUE_INPUT=$00000100;
  MCI_CUE_OUTPUT=$00000200;

  MCI_ESCAPE_STRING=$00000100;
  MCI_EXCLUSIVE=$00000100;
  MCI_EXCLUSIVE_INSTANCE=$00000200;

  MCI_FIND_BEST_REGISTERED=$00000100;
  MCI_FORMAT_MILLISECONDS=$00000001;
  MCI_FORMAT_MMTIME=$00000002;
  MCI_FORMAT_MSF=$00000005;
  MCI_FORMAT_TMSF=$00000006;
  MCI_FORMAT_CHAPTERS=$00000007;
  MCI_FORMAT_FRAMES=$00000008;
  MCI_FORMAT_HMS=$00000009;
  MCI_FORMAT_TRACKS=$0000000A;
  MCI_FORMAT_BYTES=$0000000B;
  MCI_FORMAT_SAMPLES=$0000000C;
  MCI_FORMAT_HMSF=$0000000D;
  MCI_FORMAT_SET_SMPTE_24=$0000000E;
  MCI_FORMAT_SET_SMPTE_25=$0000000F;
  MCI_FORMAT_SET_SMPTE_30=$00000010;
  MCI_FORMAT_SET_SMPTE_30DROP=$00000011;
  MCI_FORMAT_SET_SONGPTR=$00000012;
  MCI_FORMAT_PERCENTAGE=$00000003;
  MCI_FORMAT_FPS=$00000004;

  MCI_GAINING_USE=$00000002;
  MCI_GET_HW_BUFFER_PTR=$00000800;
  MCI_GROUP_MAKE=$00000400;
  MCI_GROUP_DELETE=$00000800;
  MCI_GROUP_ALIAS=$00001000;
  MCI_GROUP_MASTER=$00002000;

  MCI_HEADPHONES=$00000400;

  MCI_IMG_COMP_NONE=$00000201;
  MCI_IMG_COMP_PIC9_1_0=$00000202;
  MCI_IMG_COMP_PIC16_1_0=$00000203;
  MCI_IMG_COMP_JPEG9=$00000204;
  MCI_IMG_COMP_JPEG9_1_0=MCI_IMG_COMP_JPEG9;
  MCI_IMG_COMP_BMP_RLE4=$00000205;
  MCI_IMG_COMP_BMP_RLE8=$00000206;
  MCI_IMG_COMP_JPEGN=$00000207;

  MCI_VID_PALETTE=$00000001;
  MCI_VID_COMP_RTV_2_0=$00000101;
  MCI_VID_COMP_RTV_2_1=$00000102;
  MCI_VID_COMP_ULTI=$49544C55;
  MCI_VID_COMP_RT21=$31325452;
  MCI_VID_FILE_FORMAT_AVI=$20495641;
  MCI_VID_OPEN_PARENT=$01000000;
  MCI_VID_PUT_RECT=$00000100;
  MCI_VID_PUT_DESTINATION=$00000200;
  MCI_VID_PUT_SOURCE=$00000400;
  MCI_VID_PUT_WINDOW_MOVE=$00000800;
  MCI_VID_PUT_WINDOW_SIZE=$00001000;
  MCI_VID_QUALITY_HIGH=$00000101;
  MCI_VID_QUALITY_MED=$00000102;
  MCI_VID_QUALITY_LOW=$00000103;
  MCI_VID_QUALITY_BEST=MCI_VID_QUALITY_HIGH;
  MCI_VID_QUALITY_CDROM=MCI_VID_QUALITY_MED;
  MCI_VID_QUALITY_COMPACT=MCI_VID_QUALITY_LOW;
  MCI_VID_QUALITY_BETTER=MCI_VID_QUALITY_MED;
  MCI_VID_QUALITY_GOOD=MCI_VID_QUALITY_LOW;
  MCI_VID_RGB=$00000002;
  MCI_VID_WHERE_DESTINATION=$00000100;
  MCI_VID_WHERE_SOURCE=$00000200;
  MCI_VID_WHERE_WINDOW=$00000400;
  MCI_VID_WINDOW_HWND=$00000100;
  MCI_VID_WINDOW_STATE=$00000200;
  MCI_VID_WINDOW_TEXT=$00000400;
  MCI_VID_WINDOW_DEFAULT=$00000800;
  MCI_VID_YUV=$00000003;


  MCI_IMG_PALETTE=MCI_VID_PALETTE;
  MCI_IMG_RGB=MCI_VID_RGB;
  MCI_IMG_YUV=MCI_VID_YUV;
  MCI_IMG_QUALITY_HIGH=$00000201;
  MCI_IMG_QUALITY_MED=$00000202;
  MCI_IMG_QUALITY_LOW=$00000203;
  MCI_INFO_FILE=$00000200;
  MCI_INFO_PRODUCT=$00000100;

  MCI_LOSING_USE=$00000001;

  MCI_MASTERVOL=$00001000;
  MCI_MODE_NOT_READY=$00000001;
  MCI_MODE_PAUSE=$00000002;
  MCI_MODE_PLAY=$00000003;
  MCI_MODE_STOP=$00000004;
  MCI_MODE_RECORD=$00000005;
  MCI_MODE_SEEK=$00000006;

  MCI_NOPIECEMEAL=$00000200;
  MCI_NOTIFY_SUCCESSFUL=$0000;
  MCI_NOTIFY_SUPERSEDED=$0001;
  MCI_NOTIFY_ABORTED=$0002;
  MCI_NOTIFY_ERROR=$0003;

  MCI_ON=$00000100;
  MCI_OFF=$00000200;
  MCI_OPEN_ELEMENT=$00000100;
  MCI_OPEN_ALIAS=$00000200;
  MCI_OPEN_ELEMENT_ID=$00000400;
  MCI_OPEN_PLAYLIST=$00000800;
  MCI_OPEN_TYPE_ID=$00001000;
  MCI_OPEN_SHAREABLE=$00002000;
  MCI_OPEN_MMIO=$00004000;

  MCI_PREROLL_NOTIFIED=$00000001;
  MCI_PREROLL_DETERMINISTIC=$00000002;
  MCI_PREROLL_NONE=$00000003;

  MCI_QUERYSAVEDSETTING=$00004000;
  MCI_QUERYCURRENTSETTING=$00008000;
  MCI_QUERY_REGISTERED_MAP=$00000200;
  MCI_QUERY_REGISTERED_MAP_SIZE=$00000400;

  MCI_READONLY=$00008000;
  MCI_RECORD_INSERT=$00000100;
  MCI_RECORD_OVERWRITE=$00000200;
  MCI_RESTORE_SRC_RECT=$00000100;
  MCI_RESTORE_DEST_RECT=$00000200;
  MCI_RETURN_RESOURCE=$00000100;

  MCI_SAVESETTING=$00002000;
  MCI_SAVE_FILE=$00000100;
  MCI_SET_ITEM=$00000100;
  MCI_SET_ON=$00000200;
  MCI_SET_OFF=$00000400;
  MCI_SET_VIDEO=$00000800;
  MCI_SET_AUDIO=$00001000;
  MCI_SET_DOOR_OPEN=$00002000;
  MCI_SET_DOOR_CLOSED=$00004000;
  MCI_SET_SPEED_FORMAT=$00008000;
  MCI_SET_TIME_FORMAT=$00010000;
  MCI_SET_DOOR_LOCK=$00020000;
  MCI_SET_DOOR_UNLOCK=$00040000;
  MCI_SET_VOLUME=$00080000;
  MCI_SET_ITEM_FOURCC=$00100000;
  MCI_SET_AUDIO_ALL=$00000000;
  MCI_SET_AUDIO_LEFT=$00000001;
  MCI_SET_AUDIO_RIGHT=$00000002;
  MCI_SET_MONITOR=$00000001;
  MCI_SET_MONITOR_AUDIO=$00000002;
  MCI_SET_MONITOR_VIDEO=$00000003;
  MCI_SET_RECORD=$00000004;
  MCI_SET_NONE=$10000000;
  MCI_SET_POSITION_ADVISE_ON=$00000100;
  MCI_SET_POSITION_ADVISE_OFF=$00000200;
  MCI_SET_CUEPOINT_ON=$00000100;
  MCI_SET_CUEPOINT_OFF=$00000200;
  MCI_SET_REGISTERED=$00000100;
  MCI_SPEAKERS=$00000800;
  MCI_SPIN_UP=$00000100;
  MCI_SPIN_DOWN=$00000200;
  MCI_STATUS_ITEM=$00000100;
  MCI_STATUS_START=$00000200;
  MCI_STATUS_CURRENT_TRACK=$00000001;
  MCI_STATUS_LENGTH=$00000002;
  MCI_STATUS_MODE=$00000003;
  MCI_STATUS_NUMBER_OF_TRACKS=$00000004;
  MCI_STATUS_POSITION=$00000005;
  MCI_STATUS_POSITION_IN_TRACK=$00000006;
  MCI_STATUS_MEDIA_PRESENT=$00000007;
  MCI_STATUS_VOLUME=$00000008;
  MCI_STATUS_READY=$00000009;
  MCI_STATUS_TIME_FORMAT=$0000000A;
  MCI_STATUS_SPEED_FORMAT=$0000000B;
  MCI_STATUS_MONITOR=$0000000C;
  MCI_STATUS_AUDIO=$0000000D;
  MCI_STATUS_VIDEO=$0000000E;
  MCI_STATUS_CLIPBOARD=$0000000F;
  MCI_STATUS_AUDIO_ALL=$00000000;
  MCI_STATUS_AUDIO_LEFT=$00000001;
  MCI_STATUS_AUDIO_RIGHT=$00000002;
  MCI_STEP_FRAMES=$00000100;
  MCI_STEP_REVERSE=$00000200;
  MCI_SYNCHRONIZE=$00000100;
  MCI_SYSINFO_QUANTITY=$00000100;
  MCI_SYSINFO_OPEN=$00000200;
  MCI_SYSINFO_NAME=$00000400;
  MCI_SYSINFO_INSTALLNAME=$00000800;
  MCI_SYSINFO_ITEM=$00001000;
  MCI_SYSINFO_INI_LOCK=$00002000;
  MCI_SYSINFO_DEV_CONTROLLABLE=$00000001;
  MCI_SYSINFO_DEV_NONCONTROLLABLE=$00000002;
  MCI_SYSINFO_DEVICESETTINGS=$00000004;
  MCI_SYSINFO_INSTALL_DRIVER=$00000001;
  MCI_SYSINFO_QUERY_DRIVER=$00000002;
  MCI_SYSINFO_DELETE_DRIVER=$00000004;
  MCI_SYSINFO_SET_PARAMS=$00000008;
  MCI_SYSINFO_QUERY_PARAMS=$00000010;
  MCI_SYSINFO_SET_CONNECTORS=$00000020;
  MCI_SYSINFO_QUERY_CONNECTORS=$00000040;
  MCI_SYSINFO_SET_EXTENSIONS=$00000080;
  MCI_SYSINFO_QUERY_EXTENSIONS=$00000100;
  MCI_SYSINFO_SET_ALIAS=$00000200;
  MCI_SYSINFO_QUERY_NAMES=$00000400;
  MCI_SYSINFO_SET_DEFAULT=$00000800;
  MCI_SYSINFO_QUERY_DEFAULT=$00001000;
  MCI_SYSINFO_SET_TYPES=$00002000;
  MCI_SYSINFO_QUERY_TYPES=$00004000;

  MCI_TO_START=$00000100;
  MCI_TO_END=$00000200;

  MCI_USE_HW_BUFFER=$00000400;


(****************)
(* device stuff *)
(****************)

  MCI_AMP_SET_BALANCE=$00100000;
  MCI_AMP_SET_PITCH=$00200000;
  MCI_AMP_SET_TREBLE=$00400000;
  MCI_AMP_SET_BASS=$00800000;
  MCI_AMP_SET_GAIN=$01000000;
  MCI_AMP_SET_MONITOR=MCI_SET_MONITOR_AUDIO;

  MCI_CD_INFO_ID=$00010000;
  MCI_CD_INFO_UPC=$00020000;
  MCI_CD_TRACK_AUDIO=$00000001;
  MCI_CD_TRACK_DATA=$00000002;
  MCI_CD_TRACK_OTHER=$00000003;

  MCI_CDXA_NONE=$00000000;
  MCI_CDXA_SET_CHANNEL=$01000000;
  MCI_CDXA_AUDIO_DEVICE=$10000000;
  MCI_CDXA_AUDIO_BUFFER=$02000000;
  MCI_CDXA_VIDEO_BUFFER=$04000000;
  MCI_CDXA_DATA_BUFFER=$08000000;

  MCI_VD_INFO_LABEL=$00001000;
  MCI_VD_MEDIA_CLV=$00000001;
  MCI_VD_MEDIA_CAV=$00000002;
  MCI_VD_MEDIA_OTHER=$00000003;
  MCI_VD_PLAY_REVERSE=$00001000;
  MCI_VD_PLAY_FAST=$00002000;
  MCI_VD_PLAY_SPEED=$00004000;
  MCI_VD_PLAY_SCAN=$00008000;
  MCI_VD_PLAY_SLOW=$00010000;
  MCI_VD_SEEK_REVERSE=$00001000;
  MCI_VD_SET_CHANNEL=$00100000;
  MCI_VD_SET_DISPLAY=$00200000;
  MCI_VD_SET_ON=MCI_SET_ON;
  MCI_VD_SET_OFF=MCI_SET_OFF;
  MCI_VD_SET_VIDEO=MCI_SET_VIDEO;
  MCI_VD_SPEED_NORMAL=$00000000;
  MCI_VD_SPEED_FAST=$00000001;
  MCI_VD_SPEED_SLOW=$00000002;

  MCI_SEQ_SET_TEMPO=$00100000;
  MCI_SEQ_SET_PORT=$00200000;
  MCI_SEQ_ENABLE_PORT_MAPPER=$00400000;
  MCI_SEQ_DISABLE_PORT_MAPPER=$00800000;
  MCI_SEQ_SET_OFFSET=$01000000;
  MCI_SEQ_SET_MASTER=$02000000;
  MCI_SEQ_SET_SLAVE=$04000000;
  MCI_SEQ_SET_SMPTE_24=$00000100;
  MCI_SEQ_SET_SMPTE_25=$00000200;
  MCI_SEQ_SET_SMPTE_30=$00000300;
  MCI_SEQ_SET_SMPTE_30DROP=$00000400;
  MCI_SEQ_SET_SONGPTR=$00000500;
  MCI_SEQ_MIDI=$00000001;
  MCI_SEQ_SMPTE=$00000002;
  MCI_SEQ_FILE=$00000003;
  MCI_SEQ_NONE=$00000004;
  MCI_SEQ_DIV_PPQN=$00000001;
  MCI_SEQ_DIV_SMPTE_24=$00000002;
  MCI_SEQ_DIV_SMPTE_25=$00000003;
  MCI_SEQ_DIV_SMPTE_30DROP=$00000004;
  MCI_SEQ_DIV_SMPTE_30=$00000005;

  MCI_WAVE_INPUT=$00001000;
  MCI_WAVE_OUTPUT=$00002000;
  MCI_WAVE_SET_SAMPLESPERSEC=$01000000;
  MCI_WAVE_SET_AVGBYTESPERSEC=$02000000;
  MCI_WAVE_SET_BLOCKALIGN=$04000000;
  MCI_WAVE_SET_FORMATTAG=$08000000;
  MCI_WAVE_SET_CHANNELS=$10000000;
  MCI_WAVE_SET_BITSPERSAMPLE=$80000000;
  MCI_WAVE_FORMAT_PCM=DATATYPE_WAVEFORM;
  MCI_WAVE_FORMAT_ADPCM=$0002;
  MCI_WAVE_FORMAT_IBM_CVSD=$0005;
  MCI_WAVE_FORMAT_ALAW=DATATYPE_RIFF_ALAW;
  MCI_WAVE_FORMAT_MULAW=DATATYPE_RIFF_MULAW;
  MCI_WAVE_FORMAT_OKI_ADPCM=$0010;
  MCI_WAVE_FORMAT_DVI_ADPCM=$0011;
  MCI_WAVE_FORMAT_DIGISTD=$0015;
  MCI_WAVE_FORMAT_DIGIFIX=$0016;
  MCI_WAVE_FORMAT_AVC_ADPCM=DATATYPE_ADPCM_AVC;
  MCI_WAVE_FORMAT_IBM_ADPCM=DATATYPE_ADPCM_AVC;
  MCI_WAVE_FORMAT_IBM_MULAW=DATATYPE_MULAW;
  MCI_WAVE_FORMAT_IBM_ALAW=DATATYPE_ALAW;
  MCI_WAVE_FORMAT_CT_ADPCM=DATATYPE_CT_ADPCM;


  MCI_DGV_INFO_VIDEO_FILE=$00001000;
  MCI_DGV_INFO_IMAGE_FILE=$00002000;
  MCI_DGV_INFO_TEXT=$00010000;
  MCI_DGV_OPEN_PARENT=MCI_VID_OPEN_PARENT;
  MCI_DGV_PLAY_REVERSE=$00001000;
  MCI_DGV_PLAY_FAST=$00002000;
  MCI_DGV_PLAY_SPEED=$00004000;
  MCI_DGV_PLAY_SCAN=$00008000;
  MCI_DGV_PLAY_SLOW=$00010000;
  MCI_DGV_PLAY_REPEAT=$00020000;
  MCI_DGV_PUT_RECT=MCI_VID_PUT_RECT;
  MCI_DGV_PUT_DESTINATION=MCI_VID_PUT_DESTINATION;
  MCI_DGV_PUT_SOURCE=MCI_VID_PUT_SOURCE;
  MCI_DGV_PUT_WINDOW_MOVE=MCI_VID_PUT_WINDOW_MOVE;
  MCI_DGV_PUT_WINDOW_SIZE=MCI_VID_PUT_WINDOW_SIZE;
  MCI_DGV_RECORD_RECT=$00000400;
  MCI_DGV_SAVE_VIDEO_FILE=$00001000;
  MCI_DGV_SAVE_IMAGE_FILE=$00002000;
  MCI_DGV_SEEK_TO_NEAREST_IFRAME=$00100000;
  MCI_DGV_SET_VIDEO_COMPRESSION=MCI_VID_SET_VIDEO_COMPRESSION;
  MCI_DGV_SET_IMAGE_COMPRESSION=MCI_VID_SET_IMAGE_COMPRESSION;
  MCI_DGV_SET_IMAGE_BITSPERPEL=MCI_VID_SET_IMAGE_BITSPERPEL;
  MCI_DGV_SET_IMAGE_PELFORMAT=MCI_VID_SET_IMAGE_PELFORMAT;
  MCI_DGV_SET_BRIGHTNESS=MCI_VID_SET_BRIGHTNESS;
  MCI_DGV_SET_CONTRAST=MCI_VID_SET_CONTRAST;
  MCI_DGV_SET_HUE=MCI_VID_SET_HUE;
  MCI_DGV_SET_SATURATION=MCI_VID_SET_SATURATION;
  MCI_DGV_SET_SHARPNESS=MCI_VID_SET_SHARPNESS;
  MCI_DGV_SET_GREYSCALE=MCI_VID_SET_GREYSCALE;
  MCI_DGV_SET_IMAGE_QUALITY=MCI_VID_SET_IMAGE_QUALITY;
  MCI_DGV_SET_VIDEO_QUALITY=MCI_VID_SET_VIDEO_QUALITY;
  MCI_DGV_SET_IMAGE_COMPRESSION_METHOD=MCI_VID_SET_IMAGE_COMPRESSION_METHOD;
  MCI_DGV_SET_MONITOR=MCI_SET_MONITOR;
  MCI_DGV_SET_MINIMUM_VIDEO_REFRESH_RATE=MCI_VID_SET_MINIMUM_VIDEO_REFRESH_RATE;
  MCI_DGV_SET_IMAGE_FILE_FORMAT=MCI_VID_SET_IMAGE_FILE_FORMAT;
  MCI_DGV_SET_REF_INTERVAL=MCI_VID_SET_REF_INTERVAL;
  MCI_DGV_SET_MAXDATARATE=MCI_VID_SET_MAXDATARATE;
  MCI_DGV_SET_VIDEO_FILE_FORMAT=MCI_VID_SET_VIDEO_FILE_FORMAT;
  MCI_DGV_STATUS_HWND=MCI_VID_STATUS_HWND;
  MCI_DGV_STATUS_AUDIO_COMPRESSION=MCI_VID_STATUS_AUDIO_COMPRESSION;
  MCI_DGV_STATUS_VIDEO_COMPRESSION=MCI_VID_STATUS_VIDEO_COMPRESSION;
  MCI_DGV_STATUS_IMAGE_COMPRESSION=MCI_VID_STATUS_IMAGE_COMPRESSION;
  MCI_DGV_STATUS_AUDIO_QUALITY=MCI_VID_STATUS_AUDIO_QUALITY;
  MCI_DGV_STATUS_VIDEO_QUALITY=MCI_VID_STATUS_VIDEO_QUALITY;
  MCI_DGV_STATUS_IMAGE_QUALITY=MCI_VID_STATUS_IMAGE_QUALITY;
  MCI_DGV_STATUS_IMAGE_BITSPERPEL=MCI_VID_STATUS_IMAGE_BITSPERPEL;
  MCI_DGV_STATUS_IMAGE_PELFORMAT=MCI_VID_STATUS_IMAGE_PELFORMAT;
  MCI_DGV_STATUS_FORWARD=MCI_VID_STATUS_FORWARD;
  MCI_DGV_STATUS_NORMAL_RATE=MCI_VID_STATUS_NORMAL_RATE;
  MCI_DGV_STATUS_VIDEO_X_EXTENT=MCI_VID_STATUS_VIDEO_X_EXTENT;
  MCI_DGV_STATUS_VIDEO_Y_EXTENT=MCI_VID_STATUS_VIDEO_Y_EXTENT;
  MCI_DGV_STATUS_IMAGE_X_EXTENT=MCI_VID_STATUS_IMAGE_X_EXTENT;
  MCI_DGV_STATUS_IMAGE_Y_EXTENT=MCI_VID_STATUS_IMAGE_Y_EXTENT;
  MCI_DGV_STATUS_BRIGHTNESS=MCI_VID_STATUS_BRIGHTNESS;
  MCI_DGV_STATUS_CONTRAST=MCI_VID_STATUS_CONTRAST;
  MCI_DGV_STATUS_HUE=MCI_VID_STATUS_HUE;
  MCI_DGV_STATUS_SATURATION=MCI_VID_STATUS_SATURATION;
  MCI_DGV_STATUS_SPEED=MCI_VID_STATUS_SPEED;
  MCI_DGV_STATUS_SHARPNESS=MCI_VID_STATUS_SHARPNESS;
  MCI_DGV_STATUS_REF_INTERVAL=MCI_VID_STATUS_REF_INTERVAL;
  MCI_DGV_STATUS_MAXDATARATE=MCI_VID_STATUS_MAXDATARATE;
  MCI_DGV_STATUS_VIDEO_FILE_FORMAT=MCI_VID_STATUS_VIDEO_FILE_FORMAT;
  MCI_DGV_WHERE_DESTINATION=MCI_VID_WHERE_DESTINATION;
  MCI_DGV_WHERE_SOURCE=MCI_VID_WHERE_SOURCE;
  MCI_DGV_WHERE_WINDOW=MCI_VID_WHERE_WINDOW;
  MCI_DGV_WINDOW_HWND=MCI_VID_WINDOW_HWND;
  MCI_DGV_WINDOW_STATE=MCI_VID_WINDOW_STATE;
  MCI_DGV_WINDOW_TEXT=MCI_VID_WINDOW_TEXT;
  MCI_DGV_WINDOW_DEFAULT=MCI_VID_WINDOW_DEFAULT;

  MCI_OVLY_FREEZE_RECT=$00000100;
  MCI_OVLY_FREEZE_RECT_OUTSIDE=$00000200;
  MCI_OVLY_UNFREEZE_RECT=$00000100;
  MCI_OVLY_UNFREEZE_RECT_OUTSIDE=$00000200;
  MCI_OVLY_INFO_TEXT=$00010000;
  MCI_OVLY_OPEN_PARENT=MCI_VID_OPEN_PARENT;
  MCI_OVLY_PUT_RECT=MCI_VID_PUT_RECT;
  MCI_OVLY_PUT_DESTINATION=MCI_VID_PUT_DESTINATION;
  MCI_OVLY_PUT_SOURCE=MCI_VID_PUT_SOURCE;
  MCI_OVLY_PUT_WINDOW_MOVE=MCI_VID_PUT_WINDOW_MOVE;
  MCI_OVLY_PUT_WINDOW_SIZE=MCI_VID_PUT_WINDOW_SIZE;
  MCI_OVLY_SET_IMAGE_COMPRESSION=MCI_VID_SET_IMAGE_COMPRESSION;
  MCI_OVLY_SET_IMAGE_BITSPERPEL=MCI_VID_SET_IMAGE_BITSPERPEL;
  MCI_OVLY_SET_IMAGE_PELFORMAT=MCI_VID_SET_IMAGE_PELFORMAT;
  MCI_OVLY_SET_BRIGHTNESS=MCI_VID_SET_BRIGHTNESS;
  MCI_OVLY_SET_CONTRAST=MCI_VID_SET_CONTRAST;
  MCI_OVLY_SET_HUE=MCI_VID_SET_HUE;
  MCI_OVLY_SET_SATURATION=MCI_VID_SET_SATURATION;
  MCI_OVLY_SET_SHARPNESS=MCI_VID_SET_SHARPNESS;
  MCI_OVLY_SET_GREYSCALE=MCI_VID_SET_GREYSCALE;
  MCI_OVLY_SET_IMAGE_QUALITY=MCI_VID_SET_IMAGE_QUALITY;
  MCI_OVLY_SET_IMAGE_COMPRESSION_METHOD=MCI_VID_SET_IMAGE_COMPRESSION_METHOD;
  MCI_OVLY_SET_MINIMUM_VIDEO_REFRESH_RATE=MCI_VID_SET_MINIMUM_VIDEO_REFRESH_RATE;
  MCI_OVLY_SET_IMAGE_FILE_FORMAT=MCI_VID_SET_IMAGE_FILE_FORMAT;
  MCI_OVLY_STATUS_HWND=MCI_VID_STATUS_HWND;
  MCI_OVLY_STATUS_IMAGE_COMPRESSION=MCI_VID_STATUS_IMAGE_COMPRESSION;
  MCI_OVLY_STATUS_IMAGE_BITSPERPEL=MCI_VID_STATUS_IMAGE_BITSPERPEL;
  MCI_OVLY_STATUS_IMAGE_PELFORMAT=MCI_VID_STATUS_IMAGE_PELFORMAT;
  MCI_OVLY_STATUS_IMAGE_X_EXTENT=MCI_VID_STATUS_IMAGE_X_EXTENT;
  MCI_OVLY_STATUS_IMAGE_Y_EXTENT=MCI_VID_STATUS_IMAGE_Y_EXTENT;
  MCI_OVLY_STATUS_BRIGHTNESS=MCI_VID_STATUS_BRIGHTNESS;
  MCI_OVLY_STATUS_CONTRAST=MCI_VID_STATUS_CONTRAST;
  MCI_OVLY_STATUS_HUE=MCI_VID_STATUS_HUE;
  MCI_OVLY_STATUS_SATURATION=MCI_VID_STATUS_SATURATION;
  MCI_OVLY_STATUS_GREYSCALE=MCI_VID_STATUS_GREYSCALE;
  MCI_OVLY_STATUS_IMAGE_QUALITY=MCI_VID_STATUS_IMAGE_QUALITY;
  MCI_OVLY_STATUS_SHARPNESS=MCI_VID_STATUS_SHARPNESS;
  MCI_OVLY_STATUS_IMAGE_FILE_FORMAT=MCI_VID_STATUS_IMAGE_FILE_FORMAT;
  MCI_OVLY_STATUS_TRANSPARENT_TYPE=MCI_VID_STATUS_TRANSPARENT_TYPE;
  MCI_OVLY_STATUS_TRANSPARENT_COLOR=MCI_VID_STATUS_TRANSPARENT_COLOR;
  MCI_OVLY_WHERE_DESTINATION=MCI_VID_WHERE_DESTINATION;
  MCI_OVLY_WHERE_SOURCE=MCI_VID_WHERE_SOURCE;
  MCI_OVLY_WHERE_WINDOW=MCI_VID_WHERE_WINDOW;
  MCI_OVLY_WINDOW_HWND=MCI_VID_WINDOW_HWND;
  MCI_OVLY_WINDOW_STATE=MCI_VID_WINDOW_STATE;
  MCI_OVLY_WINDOW_TEXT=MCI_VID_WINDOW_TEXT;
  MCI_OVLY_WINDOW_DEFAULT=MCI_VID_WINDOW_DEFAULT;


(**************************)
(* get device capabilites *)
(**************************)

  MCI_GETDEVCAPS_MESSAGE=$00000100;
  MCI_GETDEVCAPS_ITEM=$00000200;
  MCI_GETDEVCAPS_EXTENDED=$00000400;

  MCI_GETDEVCAPS_CAN_EJECT=$00000001;
  MCI_GETDEVCAPS_CAN_LOCKEJECT=$00000002;
  MCI_GETDEVCAPS_CAN_PLAY=$00000003;
  MCI_GETDEVCAPS_CAN_PROCESS_INTERNAL=$00000004;
  MCI_GETDEVCAPS_CAN_RECORD=$00000005;
  MCI_GETDEVCAPS_CAN_RECORD_INSERT=$00000006;
  MCI_GETDEVCAPS_CAN_SAVE=$00000007;
  MCI_GETDEVCAPS_CAN_SETVOLUME=$00000008;
  MCI_GETDEVCAPS_CAN_STREAM=$00000009;
  MCI_GETDEVCAPS_DEVICE_TYPE=$0000000A;
  MCI_GETDEVCAPS_HAS_AUDIO=$0000000B;
  MCI_GETDEVCAPS_HAS_VIDEO=$0000000C;
  MCI_GETDEVCAPS_PREROLL_TIME=$0000000D;
  MCI_GETDEVCAPS_PREROLL_TYPE=$0000000E;
  MCI_GETDEVCAPS_USES_FILES=$0000000F;
  MCI_GETDEVCAPS_HAS_IMAGE=$00000010;
  MCI_GETDEVCAPS_WAVE_FORMAT=$00000011;

  MCI_VID_GETDEVCAPS_CAN_STRETCH=MCI_VID_ITEM_BASE;
  MCI_VID_GETDEVCAPS_CAN_DISTORT=(MCI_VID_ITEM_BASE+1);
  MCI_VID_GETDEVCAPS_VIDEO_X_EXTENT=(MCI_VID_ITEM_BASE+2);
  MCI_VID_GETDEVCAPS_VIDEO_Y_EXTENT=(MCI_VID_ITEM_BASE+3);
  MCI_VID_GETDEVCAPS_IMAGE_X_EXTENT=(MCI_VID_ITEM_BASE+4);
  MCI_VID_GETDEVCAPS_IMAGE_Y_EXTENT=(MCI_VID_ITEM_BASE+5);
  MCI_VID_GETDEVCAPS_MAX_WINDOWS=(MCI_VID_ITEM_BASE+6);
  MCI_VID_GETDEVCAPS_CAN_FREEZE=(MCI_VID_ITEM_BASE+7);
  MCI_VID_GETDEVCAPS_OVERLAY_GRAPHICS=(MCI_VID_ITEM_BASE+8);
  MCI_VID_GETDEVCAPS_CAN_REVERSE=(MCI_VID_ITEM_BASE+9);
  MCI_VID_GETDEVCAPS_FAST_RATE=(MCI_VID_ITEM_BASE+10);
  MCI_VID_GETDEVCAPS_SLOW_RATE=(MCI_VID_ITEM_BASE+11);
  MCI_VID_GETDEVCAPS_NORMAL_RATE=(MCI_VID_ITEM_BASE+12);
  MCI_VID_GETDEVCAPS_MINIMUM_RATE=(MCI_VID_ITEM_BASE+13);
  MCI_VID_GETDEVCAPS_MAXIMUM_RATE=(MCI_VID_ITEM_BASE+14);

  MCI_VD_GETDEVCAPS_CLV=$00000400;
  MCI_VD_GETDEVCAPS_CAV=$00000800;
  MCI_VD_GETDEVCAPS_CAN_REVERSE=MCI_VID_GETDEVCAPS_CAN_REVERSE;
  MCI_VD_GETDEVCAPS_FAST_RATE=MCI_VID_GETDEVCAPS_FAST_RATE;
  MCI_VD_GETDEVCAPS_SLOW_RATE=MCI_VID_GETDEVCAPS_SLOW_RATE;
  MCI_VD_GETDEVCAPS_NORMAL_RATE=MCI_VID_GETDEVCAPS_NORMAL_RATE;
  MCI_VD_GETDEVCAPS_MINIMUM_RATE=MCI_VID_GETDEVCAPS_MINIMUM_RATE;
  MCI_VD_GETDEVCAPS_MAXIMUM_RATE=MCI_VID_GETDEVCAPS_MAXIMUM_RATE;

  MCI_DGV_GETDEVCAPS_CAN_STRETCH=MCI_VID_GETDEVCAPS_CAN_STRETCH;
  MCI_DGV_GETDEVCAPS_CAN_DISTORT=MCI_VID_GETDEVCAPS_CAN_DISTORT;
  MCI_DGV_GETDEVCAPS_VIDEO_X_EXTENT=MCI_VID_GETDEVCAPS_VIDEO_X_EXTENT;
  MCI_DGV_GETDEVCAPS_VIDEO_Y_EXTENT=MCI_VID_GETDEVCAPS_VIDEO_Y_EXTENT;
  MCI_DGV_GETDEVCAPS_IMAGE_X_EXTENT=MCI_VID_GETDEVCAPS_IMAGE_X_EXTENT;
  MCI_DGV_GETDEVCAPS_IMAGE_Y_EXTENT=MCI_VID_GETDEVCAPS_IMAGE_Y_EXTENT;
  MCI_DGV_GETDEVCAPS_MAX_WINDOWS=MCI_VID_GETDEVCAPS_MAX_WINDOWS;
  MCI_DGV_GETDEVCAPS_OVERLAY_GRAPHICS=MCI_VID_GETDEVCAPS_OVERLAY_GRAPHICS;
  MCI_DGV_GETDEVCAPS_CAN_REVERSE=MCI_VID_GETDEVCAPS_CAN_REVERSE;
  MCI_DGV_GETDEVCAPS_FAST_RATE=MCI_VID_GETDEVCAPS_FAST_RATE;
  MCI_DGV_GETDEVCAPS_SLOW_RATE=MCI_VID_GETDEVCAPS_SLOW_RATE;
  MCI_DGV_GETDEVCAPS_NORMAL_RATE=MCI_VID_GETDEVCAPS_NORMAL_RATE;
  MCI_DGV_GETDEVCAPS_MINIMUM_RATE=MCI_VID_GETDEVCAPS_MINIMUM_RATE;
  MCI_DGV_GETDEVCAPS_MAXIMUM_RATE=MCI_VID_GETDEVCAPS_MAXIMUM_RATE;

  MCI_OVLY_GETDEVCAPS_CAN_STRETCH=MCI_VID_GETDEVCAPS_CAN_STRETCH;
  MCI_OVLY_GETDEVCAPS_CAN_DISTORT=MCI_VID_GETDEVCAPS_CAN_DISTORT;
  MCI_OVLY_GETDEVCAPS_VIDEO_X_EXTENT=MCI_VID_GETDEVCAPS_VIDEO_X_EXTENT;
  MCI_OVLY_GETDEVCAPS_VIDEO_Y_EXTENT=MCI_VID_GETDEVCAPS_VIDEO_Y_EXTENT;
  MCI_OVLY_GETDEVCAPS_IMAGE_X_EXTENT=MCI_VID_GETDEVCAPS_IMAGE_X_EXTENT;
  MCI_OVLY_GETDEVCAPS_IMAGE_Y_EXTENT=MCI_VID_GETDEVCAPS_IMAGE_Y_EXTENT;
  MCI_OVLY_GETDEVCAPS_MAX_WINDOWS=MCI_VID_GETDEVCAPS_MAX_WINDOWS;
  MCI_OVLY_GETDEVCAPS_CAN_FREEZE=MCI_VID_GETDEVCAPS_CAN_FREEZE;
  MCI_OVLY_GETDEVCAPS_OVERLAY_GRAPHICS=MCI_VID_GETDEVCAPS_OVERLAY_GRAPHICS;


(*******************)
(* connector stuff *)
(*******************)

  MCI_MIDI_STREAM_CONNECTOR=$00000001;
  MCI_CD_STREAM_CONNECTOR=$00000002;
  MCI_WAVE_STREAM_CONNECTOR=$00000003;
  MCI_AMP_STREAM_CONNECTOR=$00000004;
  MCI_XA_STREAM_CONNECTOR=$00000005;
  MCI_HEADPHONES_CONNECTOR=$00000006;
  MCI_SPEAKERS_CONNECTOR=$00000007;
  MCI_MICROPHONE_CONNECTOR=$00000008;
  MCI_LINE_IN_CONNECTOR=$00000009;
  MCI_LINE_OUT_CONNECTOR=$0000000a;
  MCI_VIDEO_IN_CONNECTOR=$0000000b;
  MCI_VIDEO_OUT_CONNECTOR=$0000000c;
  MCI_PHONE_SET_CONNECTOR=$0000000d;
  MCI_PHONE_LINE_CONNECTOR=$0000000e;
  MCI_AUDIO_IN_CONNECTOR=$0000000f;
  MCI_AUDIO_OUT_CONNECTOR=$00000010;
  MCI_UNIVERSAL_CONNECTOR=$00000011;

  MCI_ENABLE_CONNECTOR=$00000100;
  MCI_DISABLE_CONNECTOR=$00000200;
  MCI_QUERY_CONNECTOR_STATUS=$00000400;
  MCI_CONNECTOR_TYPE=$00000800;
  MCI_CONNECTOR_INDEX=$00001000;
  MCI_TO_CONNECTOR_INDEX=$00002000;
  MCI_TO_CONNECTOR_TYPE=$00004000;
  MCI_QUERY_CONNECTION=$00008000;
  MCI_MAKE_CONNECTION=$00010000;
  MCI_BREAK_CONNECTION=$00020000;
  MCI_ENUMERATE_CONNECTORS=$00040000;
  MCI_QUERY_CONNECTOR_TYPE=$00080000;
  MCI_QUERY_VALID_CONNECTION=$00100000;
  MCI_CONNECTOR_ALIAS=$00200000;


(********)
(* misc *)
(********)

  MIDI_MAPPER=$20000000;
  MCI_MIDI_MAPPER=MIDI_MAPPER;

  MM_MCINOTIFY=$0500;
  MM_MCIPASSDEVICE=$0501;
  MM_MCIPOSITIONCHANGE=$0502;
  MM_MCICUEPOINT=$0503;
  MM_MCIPLAYLISTMESSAGE=$0504;
  MM_MCIEVENT=$0505;
  MM_MCISYNCH=$0506;

  MSV_CLOSEDCAPTION=0;
  MSV_MASTERVOLUME=1;
  MSV_HEADPHONES=2;
  MSV_SPEAKERS=3;
  MSV_WORKPATH=4;
  MSV_SYSQOSVALUE=5;
  MSV_SYSQOSERRORFLAG=6;
  MSV_MAX=7;

type
  HDCT=ULONG;
  RECT=ULONG;


(************************)
(* playlist definitions *)
(************************)

const
  DATA_OPERATION=0;
  BRANCH_OPERATION=1;
  LOOP_OPERATION=2;
  CALL_OPERATION=3;
  RETURN_OPERATION=4;
  EXIT_OPERATION=5;
  NOP_OPERATION=6;
  MESSAGE_OPERATION=7;
  CUEPOINT_OPERATION=8;


(************)
(* typedefs *)
(************)
type
(*OS2ME*)
 SZ=Char;
 PSZ=PChar;
 PVOID=POINTER;

 VERSION=SmallWord;
 PW=^SmallWord;
 PAW=^Smallword;
 LPSTR=pointer;
 LPTR=pointer;
 LPRECT=pointer;

 FNMCI= Function (var x1:ULONG; x2:SmallWord;x3:ULONG;
                  x4:ULONG;x5:SmallWord):ULONG;
 PFNMCI=FNMCI;

 HANDLE=HWND;

 MMTIME=ULONG;
 PMMTIME=^MMTIME;

 HMMIO=ULONG;
 PHMMIO=^ULONG;


 SPCBKEY = record
   ulDataType:ULONG;
   ulDataSubType:ULONG;
   ulIntKey:ULONG;
 end;

  PSPCBKEY=^SPCBKEY;

 MMTRACKINFO = record
   ulTrackID:ULONG;
   ulMediaType:ULONG;
   ulCountry:ULONG;
   ulCodePage:ULONG;
   ulReserved1:ULONG;
   ulReserved2:ULONG;
 end;

  PMMTRACKINFO=^MMTRACKINFO;




(***************)
  CONNECT=record
    usConnectType:USHORT;
    szToInstallName: array [0..MAX_DEVICE_NAME-1] of CHAR;
    usToConnectIndex:USHORT;
  end;

  MCI_AMP_OPEN_PARMS=record
    hwndCallback:HWND;
    usDeviceID:USHORT;
    usReserved0:USHORT;
    pszDeviceType:PSZ;
    pszElementName:PSZ;
    pszAlias:PSZ;
    pDevDataPtr:PVOID;
  end;

  MCI_CAPTURE_PARMS=record
    hwndCallback:HWND;
    rect:RECTL;
  end;

  MCI_CDXA_SET_PARMS=record
    hwndCallback:HWND;
    ulTimeFormat:ULONG;
    ulSpeedFormat:ULONG;
    ulAudio:ULONG;
    ulLevel:ULONG;
    ulOver:ULONG;
    ulItem:ULONG;
    ulValue:ULONG;
    ulChannel:ULONG;
    pPlayList:PVOID;
    ulPlayListSize:ULONG;
  end;

  MCI_CDXA_STATUS_PARMS=record
    hwndCallback:HWND;
    ulReturn:ULONG;
    ulItem:ULONG;
    ulValue:ULONG;
    ulChannel:ULONG;
  end;

  MCI_CONNECTION_PARMS=record
    hwndCallback:HWND;
    ulConnectorType:ULONG;
    ulConnectorIndex:ULONG;
    pszAlias:PSZ;
    usToDeviceID:USHORT;
    usReserved0:USHORT;
    ulReserved1:ULONG;
    ulReserved2:ULONG;
  end;

  MCI_CONNECTORINFO_PARMS=record
    hwndCallback:HWND;
    ulReturn:ULONG;
    ulDeviceTypeID:ULONG;
    ulConnectorType:ULONG;
    ulConnectorIndex:ULONG;
    ulToConnectorType:ULONG;
  end;

  MCI_CONNECTOR_PARMS=record
    hwndCallback:HWND;
    ulReturn:ULONG;
    ulConnectorType:ULONG;
    ulConnectorIndex:ULONG;
  end;

  MCI_CUEPOINT_PARMS=record
    hwndCallback:HWND;
    ulCuepoint:ULONG;
    usUserParm:USHORT;
    usReserved0:USHORT;
  end;

  MCI_DEFAULT_CONNECTION_PARMS=record
    hwndCallback:HWND;
    pszDevice:PSZ;
    ulConnectorType:ULONG;
    ulConnectorIndex:ULONG;
    pszToDevice:PSZ;
    ulToConnectorType:ULONG;
    ulToConnectorIndex:ULONG;
  end;

  MCI_DEVICESETTINGS_PARMS=record
    hwndCallback:HWND;
    hwndNotebook:HWND;
    usDeviceType:USHORT;
    pszDeviceName:PSZ;
  end;

  MCI_DGV_PLAY_PARMS=record
    hwndCallback:HWND;
    ulFrom:ULONG;
    ulTo:ULONG;
    ulSpeed:ULONG;
  end;

  MCI_EDIT_PARMS=record
    hwndCallback:HWND;
    ulStructLen:ULONG;
    ulFrom:ULONG;
    ulTo:ULONG;
    pBuff:PVOID;
    ulBufLen:ULONG;
    pHeader:PVOID;
  end;

  MCI_ESCAPE_PARMS=record
    hwndCallback:HWND;
    pszCommand:PSZ;
  end;

  MCI_GENERIC_PARMS=record
    hwndCallback:HWND;
  end;

  MCI_GETDEVCAPS_PARMS=record
    hwndCallback:HWND;
    ulReturn:ULONG;
    ulItem:ULONG;
    usMessage:USHORT;
    usReserved0:USHORT;
  end;

  MCI_GROUP_PARMS=record
    hwndCallback:HWND;
    usGroupID:USHORT;
    usReserved0:USHORT;
    ulStructLength:ULONG;
    usMasterID:USHORT;
    usReserved1:USHORT;
    pszGroupAlias:PSZ;
    ulNumDevices:ULONG;
    paulDeviceID:PULONG;
  end;

  MCI_IMAGE_PARMS=record
    hwndCallback:HWND;
    ulPelFormat:ULONG;
    usBitCount:USHORT;
    usReserved0:USHORT;
    ulImageCompression:ULONG;
    rect:RECTL;
    pPelBuffer:PVOID;
    ulPelBufferHeight:ULONG;
    ulPelBufferWidth:ULONG;
    ulBufLen:ULONG;
  end;

  MCI_INFO_PARMS=record
    hwndCallback:HWND;
    pszReturn:PSZ;
    ulRetSize:ULONG;
  end;

  MCI_LOAD_PARMS=record
    hwndCallback:HWND;
    pszElementName:PSZ;
  end;

  MCI_MASTERAUDIO_PARMS=record
    hwndDummyCallback:HWND;
    ulReturn:ULONG;
    ulMasterVolume:ULONG;
  end;

  MCI_OPEN_PARMS=record
    hwndCallback:HWND;
    usDeviceID:USHORT;
    usReserved0:USHORT;
    pszDeviceType:PSZ;
    pszElementName:PSZ;
    pszAlias:PSZ;
  end;

  MCI_PALETTE_PARMS=record
    hwndCallback:HWND;
    usRegisteredMap:USHORT;
    usReserved0:USHORT;
    ulPalEntries:ULONG;
    pPalette:PVOID;
  end;

  MCI_PLAY_PARMS=record
    hwndCallback:HWND;
    ulFrom:ULONG;
    ulTo:ULONG;
  end;

  MCI_POSITION_PARMS=record
    hwndCallback:HWND;
    ulUnits:ULONG;
    usUserParm:USHORT;
    Reserved0:USHORT;
    Reserved1:ULONG;
  end;

  MCI_RECORD_PARMS=record
    hwndCallback:HWND;
    ulFrom:ULONG;
    ulTo:ULONG;
  end;

  MCI_RESTORE_PARMS=record
    hwndCallback:HWND;
    SrcRect:RECTL;
    DestRect:RECTL;
  end;

  MCI_SAVE_PARMS=record
    hwndCallback:HWND;
    pszFileName:PSZ;
  end;

  MCI_SEEK_PARMS=record
    hwndCallback:HWND;
    ulTo:ULONG;        (* SEEK_SET, SEEK_CUR, SEEK_END are defined in os2.h! *)
  end;

  MCI_SET_PARMS=record
    hwndCallback:HWND;
    ulTimeFormat:ULONG;
    ulSpeedFormat:ULONG;
    ulAudio:ULONG;
    ulLevel:ULONG;
    ulOver:ULONG;
    ulItem:ULONG;
    ulValue:ULONG;
  end;

  MCI_SEQ_SET_PARMS=record
    hwndCallback:HWND;
    ulTimeFormat:ULONG;
    ulSpeedFormat:ULONG;
    ulAudio:ULONG;
    ulLevel:ULONG;
    ulOver:ULONG;
    ulItem:ULONG;
    ulValue:ULONG;
    ulTempo:ULONG;
    ulPort:ULONG;
    ulSlave:ULONG;
    ulMaster:ULONG;
    ulOffset:ULONG;
  end;

  MCI_STATUS_PARMS=record
    hwndCallback:HWND;
    ulReturn:ULONG;
    ulItem:ULONG;
    ulValue:ULONG;
  end;

  MCI_STEP_PARMS=record
    hwndCallback:HWND;
    ulStep:ULONG;
  end;

  MCI_SYNC_OFFSET_PARMS=record
    hwndCallback:HWND;
    ulOffset:ULONG;
  end;

  MCI_SYSINFO_ALIAS=record
    szInstallName: array [0..MAX_DEVICE_NAME-1] of CHAR;
    szAliasName:array [0..MAX_ALIAS_NAME-1] of CHAR;
  end;

  MCI_SYSINFO_CONPARAMS=record
    szInstallName:array [0..MAX_DEVICE_NAME-1] of CHAR;
    usNumConnectors:USHORT;
    ConnectorList:array [0..MAX_CONNECTORS-1] of CONNECT;
  end;

  MCI_SYSINFO_DEFAULTDEVICE=record
    szInstallName:array[0..MAX_DEVICE_NAME-1] of CHAR;
    usDeviceType:USHORT;
  end;

  MCI_SYSINFO_DEVPARAMS=record
    szInstallName:array [0..MAX_DEVICE_NAME-1] of CHAR;
    szDevParams: array [0..MAX_DEV_PARAMS-1] of CHAR;
  end;

  MCI_SYSINFO_EXTENSION=record
    szInstallName: array [0..MAX_DEVICE_NAME] of CHAR;
    usNumExtensions:USHORT;
    szExtension: array [0..MAX_EXTENSIONS-1,0..MAX_EXTENSION_NAME-1] of CHAR;
  end;

  MCI_SYSINFO_LOGDEVICE=record
    szInstallName: array [0..MAX_DEVICE_NAME-1] of CHAR;
    usDeviceType:USHORT;
    ulDeviceFlag:ULONG;
    szVersionNumber: array [0..MAX_VERSION_NUMBER-1] of CHAR;
    szProductInfo: array [0..MAX_PRODINFO-1] of CHAR;
    szMCDDriver: array [0..MAX_DEVICE_NAME-1] of CHAR;
    szVSDDriver: array [0..MAX_DEVICE_NAME-1] of CHAR;
    szPDDName: array [0..MAX_PDD_NAME-1] of CHAR;
    szMCDTable: array [0..MAX_DEVICE_NAME-1] of CHAR;
    szVSDTable: array [0..MAX_DEVICE_NAME-1] of CHAR;
    usShareType:USHORT;
    szResourceName: array [0..MAX_DEVICE_NAME-1] of CHAR;
    usResourceUnits:USHORT;
    usResourceClasses:USHORT;
    ausClassArray: array [0..MAX_CLASSES-1] of USHORT;
    ausValidClassArray: array [0..MAX_CLASSES-1,0..MAX_CLASSES-1] of USHORT;
  end;

  MCI_SYSINFO_PARMS=record
    hwndDummyCallback:HWND;
    pszReturn:PSZ;
    ulRetSize:ULONG;
    ulNumber:ULONG;
    usDeviceType:USHORT;
    usReserved0:USHORT;
    ulItem:ULONG;
    pSysInfoParm:PVOID;
  end;

  MCI_SYSINFO_QUERY_NAME=record
    szInstallName: array [0..MAX_DEVICE_NAME-1] of CHAR;
    szLogicalName: array [0..MAX_DEVICE_NAME-1] of CHAR;
    szAliasName: array [0..MAX_ALIAS_NAME-1] of CHAR;
    usDeviceType:USHORT;
    usDeviceOrd:USHORT;
  end;

  MCI_SYSINFO_TYPES=record
    szInstallName: array [0..MAX_DEVICE_NAME-1] of CHAR;
    szTypes: array [0..MAX_TYPEBUFFER] of CHAR;
  end;

  MCI_TOC_REC=record
    TrackNum:BYTE;
    ulStartAddr:ULONG;
    ulEndAddr:ULONG;
    Control:BYTE;
    usCountry:USHORT;
    ulOwner:ULONG;
    ulSerialNum:ULONG;
  end;

  PTOCREC=^MCI_TOC_REC;

  MCI_TOC_PARMS=record
    hwndCallback:HWND;
    pBuf:PTOCREC;
    ulBufSize:ULONG;
  end;


  MCI_VD_PLAY_PARMS=record
    hwndCallback:HWND;
    ulFrom:ULONG;
    ulTo:ULONG;
    ulFactor:ULONG;
  end;

  MCI_VD_SET_PARMS=record
    hwndCallback:HWND;
    ulTimeFormat:ULONG;
    ulSpeedFormat:ULONG;
    ulAudio:ULONG;
    ulLevel:ULONG;
    ulOver:ULONG;
    ulItem:ULONG;
    ulValue:ULONG;
    ulChannel:ULONG;
  end;

  MCI_VID_OPEN_PARMS=record
    hwndCallback:HWND;
    usDeviceID:USHORT;
    usReserved0:USHORT;
    pszDeviceType:PSZ;
    pszElementName:PSZ;
    pszAlias:PSZ;
    hwndParent:HWND;
  end;

  MCI_VID_RECT_PARMS=record
    hwndCallback:HWND;
    rc:RECTL;
  end;

  MCI_VID_WINDOW_PARMS=record
    hwndCallback:HWND;
    hwndDest:HWND;
    usCmdShow:USHORT;
    usReserved1:USHORT;
    pszText:PSZ;
    pszAlias:PSZ;
  end;

  MCI_WAVE_GETDEVCAPS_PARMS=record
    hwndCallback:HWND;
    ulReturn:ULONG;
    ulItem:ULONG;
    usMessage:USHORT;
    usReserved0:USHORT;
    ulLength:ULONG;
    ulBitsPerSample:ULONG;
    ulFormatTag:ULONG;
    ulSamplesPerSec:ULONG;
    ulChannels:ULONG;
    ulFormatMode:ULONG;
  end;

  MCI_WAVE_SET_PARMS=record
    hwndCallback:HWND;
    ulTimeFormat:ULONG;
    ulSpeedFormat:ULONG;
    ulAudio:ULONG;
    ulLevel:ULONG;
    ulOver:ULONG;
    ulItem:ULONG;
    ulValue:ULONG;
    usInput:USHORT;
    usReserved0:USHORT;
    usOutput:USHORT;
    usReserved1:USHORT;
    usFormatTag:USHORT;
    usReserved2:USHORT;
    usChannels:USHORT;
    usReserved3:USHORT;
    ulSamplesPerSec:ULONG;
    ulAvgBytesPerSec:ULONG;
    usBlockAlign:USHORT;
    usReserved4:USHORT;
    usBitsPerSample:USHORT;
    usReserved5:USHORT;
  end;

  PCONNECT=^CONNECT;

  MCI_AMP_SET_PARMS=MCI_SET_PARMS;
  MCI_DGV_OPEN_PARMS=MCI_VID_OPEN_PARMS;
  MCI_DGV_RECT_PARMS=MCI_VID_RECT_PARMS;
  MCI_DGV_SET_PARMS=MCI_SET_PARMS;
  MCI_DGV_WINDOW_PARMS=MCI_VID_WINDOW_PARMS;
  MCI_OVLY_OPEN_PARMS=MCI_VID_OPEN_PARMS;
  MCI_OVLY_RECT_PARMS=MCI_VID_RECT_PARMS;
  MCI_OVLY_SET_PARMS=MCI_SET_PARMS;
  MCI_OVLY_WINDOW_PARMS=MCI_VID_WINDOW_PARMS;

  PMCI_AMP_OPEN_PARMS=^MCI_AMP_OPEN_PARMS;
  PMCI_AMP_SET_PARMS=^MCI_AMP_SET_PARMS;
  PMCI_CAPTURE_PARMS=^MCI_CAPTURE_PARMS;
  PMCI_CDXA_SET_PARMS=^MCI_CDXA_SET_PARMS;
  PMCI_CDXA_STATUS_PARMS=^MCI_CDXA_STATUS_PARMS;
  PMCI_CONNECTION_PARMS=^MCI_CONNECTION_PARMS;
  PMCI_CONNECTORINFO_PARMS=^MCI_CONNECTORINFO_PARMS;
  PMCI_CONNECTOR_PARMS=^MCI_CONNECTOR_PARMS;
  PMCI_CUEPOINT_PARMS=^MCI_CUEPOINT_PARMS;
  PMCI_DEFAULT_CONNECTION_PARMS=^MCI_DEFAULT_CONNECTION_PARMS;
  PMCI_DEVICESETTINGS_PARMS=^MCI_DEVICESETTINGS_PARMS;
  PMCI_DGV_OPEN_PARMS=^MCI_DGV_OPEN_PARMS;
  PMCI_DGV_PLAY_PARMS=^MCI_DGV_PLAY_PARMS;
  PMCI_DGV_RECT_PARMS=^MCI_DGV_RECT_PARMS;
  PMCI_DGV_SET_PARMS=^MCI_DGV_SET_PARMS;
  PMCI_DGV_WINDOW_PARMS=^MCI_DGV_WINDOW_PARMS;
  PMCI_EDIT_PARMS=^MCI_EDIT_PARMS;
  PMCI_ESCAPE_PARMS=^MCI_ESCAPE_PARMS;
  PMCI_GENERIC_PARMS=^MCI_GENERIC_PARMS;
  PMCI_GETDEVCAPS_PARMS=^MCI_GETDEVCAPS_PARMS;
  PMCI_GROUP_PARMS=^MCI_GROUP_PARMS;
  PMCI_IMAGE_PARMS=^MCI_IMAGE_PARMS;
  PMCI_INFO_PARMS=^MCI_INFO_PARMS;
  PMCI_LOAD_PARMS=^MCI_LOAD_PARMS;
  PMCI_MASTERAUDIO_PARMS=^MCI_MASTERAUDIO_PARMS;
  PMCI_OPEN_PARMS=^MCI_OPEN_PARMS;
  PMCI_OVLY_OPEN_PARMS=^MCI_OVLY_OPEN_PARMS;
  PMCI_OVLY_RECT_PARMS=^MCI_OVLY_RECT_PARMS;
  PMCI_OVLY_SET_PARMS=^MCI_OVLY_SET_PARMS;
  PMCI_OVLY_WINDOW_PARMS=^MCI_OVLY_WINDOW_PARMS;
  PMCI_PALETTE_PARMS=^MCI_PALETTE_PARMS;
  PMCI_PLAY_PARMS=^MCI_PLAY_PARMS;
  PMCI_POSITION_PARMS=^MCI_POSITION_PARMS;
  PMCI_RECORD_PARMS=^MCI_RECORD_PARMS;
  PMCI_RESTORE_PARMS=^MCI_RESTORE_PARMS;
  PMCI_SAVE_PARMS=^MCI_SAVE_PARMS;
  PMCI_SEEK_PARMS=^MCI_SEEK_PARMS;
  PMCI_SET_PARMS=^MCI_SET_PARMS;
  PMCI_SEQ_SET_PARMS=^MCI_SEQ_SET_PARMS;
  PMCI_STATUS_PARMS=^MCI_STATUS_PARMS;
  PMCI_STEP_PARMS=^MCI_STEP_PARMS;
  PMCI_SYNC_OFFSET_PARMS=^MCI_SYNC_OFFSET_PARMS;
  PMCI_SYSINFO_ALIAS=^MCI_SYSINFO_ALIAS;
  PMCI_SYSINFO_CONPARAMS=^MCI_SYSINFO_CONPARAMS;
  PMCI_SYSINFO_DEFAULTDEVICE=^MCI_SYSINFO_DEFAULTDEVICE;
  PMCI_SYSINFO_DEVPARAMS=^MCI_SYSINFO_DEVPARAMS;
  PMCI_SYSINFO_EXTENSION=^MCI_SYSINFO_EXTENSION;
  PMCI_SYSINFO_LOGDEVICE=^MCI_SYSINFO_LOGDEVICE;
  PMCI_SYSINFO_PARMS=^MCI_SYSINFO_PARMS;
  PMCI_SYSINFO_QUERY_NAME=^MCI_SYSINFO_QUERY_NAME;
  PMCI_SYSINFO_TYPES=^MCI_SYSINFO_TYPES;
  PMCI_TOC_PARMS=^MCI_TOC_PARMS;
  PMCI_VD_PLAY_PARMS=^MCI_VD_PLAY_PARMS;
  PMCI_VD_SET_PARMS=^MCI_VD_SET_PARMS;
  PMCI_WAVE_GETDEVCAPS_PARMS=^MCI_WAVE_GETDEVCAPS_PARMS;
  PMCI_WAVE_SET_PARMS=^MCI_WAVE_SET_PARMS;


(**********************)
(* BYTE--DWORD macros *)
(**********************)
{
#define ULONG_LWLB(ul)  (*(BYTE *)((ULONG *)(&ul)))
#define ULONG_LWHB(ul)  (*((BYTE *)((ULONG *)(&ul))+1))
#define ULONG_HWLB(ul)  (*((BYTE *)((ULONG *)(&ul))+2))
#define ULONG_HWHB(ul)  (*((BYTE *)((ULONG *)(&ul))+3))
#define ULONG_LOWD(ul)  (*(USHORT *)((ULONG *)(&ul)))
#define ULONG_HIWD(ul)  (*((USHORT *)((ULONG *)(&ul))+1))

}
(**********************************)
(* time conversion macros (yuck!) *)
(**********************************)
{
#define FPS24TOMM(value)  ((((value) & 0x000000FF) * 60 * 60 * 3000) + \
                           (((value) & 0x0000FF00) / 0x0000100 * 60 * 3000) + \
                           (((value) & 0x00FF0000) / 0x0010000 * 3000) + \
                           (((value) & 0xFF000000) / 0x1000000 * 3000/24))

#define FPS24FROMMM(value)  ((((value)+63) >= 0x100*60*60*3000) ? 0L : \
                         (((((((value)+63) % 3000)/(3000/24)) << 24) & 0xFF000000) | \
                          ((((((value)+63) / 3000) % 60) << 16) & 0x00FF0000)      | \
                         (((((((value)+63) / 3000) / 60) % 60) << 8) & 0x0000FF00) | \
                          ((((((value)+63) / 3000) / 60) / 60)  & 0x000000FF)))

#define FPS25TOMM(value)  ((((value) & 0x000000FF) * 60 * 60 * 3000) + \
                           (((value) & 0x0000FF00) / 0x0000100 * 60 * 3000) + \
                           (((value) & 0x00FF0000) / 0x0010000 * 3000) + \
                           (((value) & 0xFF000000) / 0x1000000 * 3000/25))

#define FPS25FROMMM(value)  ((((value)+60) >= 0x100*60*60*3000) ? 0L : \
                         (((((((value)+60) % 3000)/(3000/25)) << 24) & 0xFF000000) | \
                          ((((((value)+60) / 3000) % 60) << 16) & 0x00FF0000)      | \
                         (((((((value)+60) / 3000) / 60) % 60) << 8) & 0x0000FF00) | \
                          ((((((value)+60) / 3000) / 60) / 60)  & 0x000000FF)))

#define FPS30TOMM(value)  ((((value) & 0x000000FF) * 60 * 60 * 3000) + \
                           (((value) & 0x0000FF00) / 0x0000100 * 60 * 3000) + \
                           (((value) & 0x00FF0000) / 0x0010000 * 3000) + \
                           (((value) & 0xFF000000) / 0x1000000 * 3000/30))

#define FPS30FROMMM(value)  ((((value)+50) >= 0x100*60*60*3000) ? 0L : \
                         (((((((value)+50) % 3000)/(3000/30)) << 24) & 0xFF000000) | \
                          ((((((value)+50) / 3000) % 60) << 16) & 0x00FF0000)      | \
                         (((((((value)+50) / 3000) / 60) % 60) << 8) & 0x0000FF00) | \
                          ((((((value)+50) / 3000) / 60) / 60)  & 0x000000FF)))

#define HMSTOMM(value)  ((((value) & 0x000000FF) * 60 * 60 * 3000) + \
                         (((value) & 0x0000FF00) / 0x00100 * 60 * 3000) + \
                         (((value) & 0x00FF0000) / 0x10000 * 3000))

#define HMSFROMMM(value)  ((((value)+50) >= 0x100*60*60*3000) ? 0L : \
                       (((((((value)+50) / 3000) % 60) << 16) & 0x00FF0000)      | \
                       (((((((value)+50) / 3000) / 60) % 60) << 8) & 0x0000FF00) | \
                        ((((((value)+50) / 3000) / 60) / 60)  & 0x000000FF)))

#define MSECTOMM(value)  (((value) > (0xFFFFFFFF /3)) ? 0L : \
                          ((value) * 3))

#define MSECFROMMM(value)  (((value)+1) / 3)

#define REDBOOKTOMM(value)  ((((value) & 0x000000FF) * 60 * 3000) + \
                             (((value) & 0x0000FF00) / 0x00100 * 3000) + \
                             (((value) & 0x00FF0000) / 0x10000 * 3000/75))

#define REDBOOKFROMMM(value)  ((((value)+20) >= 0x100*60*3000) ? 0L : \
                               ((((value)+20) / (60*3000)) + \
                               (((value)+20) % (60*3000) / 3000 << 8) + \
                               (((value)+20) / (3000/75) % 75 << 16)))

#define MSF_FRAME(time)    (*((BYTE *)(&(time))+2))
#define MSF_MINUTE(time)   (*(BYTE *)(&(time)))
#define MSF_SECOND(time)   (*((BYTE *)(&(time))+1))

#define TMSF_FRAME(time)   (*((BYTE *)(&(time))+3))
#define TMSF_MINUTE(time)  (*((BYTE *)(&(time))+1))
#define TMSF_SECOND(time)  (*((BYTE *)(&(time))+2))
#define TMSF_TRACK(time)   (*(BYTE *)(&(time)))

}
(*************)
(* MCI API's *)
(*************)

Function mciSendCommand(usDeviceID:USHORT; usMessage:USHORT; ulParam1:ULONG;
               var Param2; usUserParm:USHORT):Ulong;

Function mciSendString(pszCommandBuf:PSZ; pszReturnString:PSZ;
              wReturnLength:USHORT; hwndCallBack:HWND;
              usUserParm:USHORT):Ulong;

Function mciGetErrorString(ulError:ULONG; pszBuffer:PSZ; usLength:USHORT):Ulong;

Function mciMakeGroup(var usDeviceGroupID:USHORT; usDeviceCount:USHORT;
             var ausDeviceList:USHORT; ulFlags:ULONG; ulMMTime:ULONG):Ulong;

Function mciDeleteGroup(usGroupID:USHORT):Ulong;

Function mciSetSysValue(iSysValue:USHORT; var Value):BOOL;

Function mciQuerySysValue(iSysValue:USHORT;var Value):BOOL;

Function mciGetDeviceID(pszName:PSZ):ULONG;


(*Some needed Snippets of MMIOOS2*)

{$AlignRec+}
const
  FOURCC_RIFF   =ord('R')+(ord('I') shl 8)+(ord('F') shl 16)+(ord('F' ) shl 24);
  FOURCC_LIST   =ord('L')+(ord('I') shl 8)+(ord('S') shl 16)+(ord('T' ) shl 24);
  FOURCC_MEM    =ord('M')+(ord('E') shl 8)+(ord('M') shl 16)+(ord(' ' ) shl 24);
  FOURCC_DOS    =ord('D')+(ord('O') shl 8)+(ord('S') shl 16)+(ord(' ' ) shl 24);
  FOURCC_BND    =ord('B')+(ord('N') shl 8)+(ord('D') shl 16)+(ord(' ' ) shl 24);
  FOURCC_FREE   =ord('F')+(ord('R') shl 8)+(ord('E') shl 16)+(ord('E' ) shl 24);
  FOURCC_DEL    =ord('D')+(ord('E') shl 8)+(ord('L') shl 16)+(ord(' ' ) shl 24);
  FOURCC_CTOC   =ord('C')+(ord('T') shl 8)+(ord('O') shl 16)+(ord('C' ) shl 24);
  FOURCC_CGRP   =ord('C')+(ord('G') shl 8)+(ord('R') shl 16)+(ord('P' ) shl 24);
  FOURCC_CF     =ord('C')+(ord('F') shl 8)+(ord(' ') shl 16)+(ord(' ' ) shl 24);

  MMIO_SUCCESS=0;
  MMIO_WARNING=2;
  MMIO_ERROR=-1;
  MMIOERR_UNSUPPORTED_MESSAGE=-2;

  MMIO_CF_SUCCESS=0;
  MMIO_CF_FAILURE=1;
                                        (* Open *)
  MMIO_CREATE=$00000001;
  MMIO_CTOCFIRST=$00000002;
  MMIO_READ=$00000004;
  MMIO_WRITE=$00000008;
  MMIO_READWRITE=$00000010;
  MMIO_COMPAT=$00000020;
  MMIO_EXCLUSIVE=$00000040;
  MMIO_DENYWRITE=$00000080;
  MMIO_DENYREAD=$00000100;
  MMIO_DENYNONE=$00000200;
  MMIO_ALLOCBUF=$00000400;
  MMIO_DELETE=$00000800;
                                         (* Open/Close/Save *)
  MMIO_USE_TEMP=$00001000;
                                         (* Insert *)
  MMIO_INSERTON=$00000001;
  MMIO_INSERTOFF=$00000002;
                                         (* Open *)
  MMIO_RWMODE=$00001000;
  MMIO_SHAREMODE=$00002000;
                                         (* Write *)
  MMIO_DIRTY=$00004000;
                                         (* Open *)
  MMIO_VERTBAR=$00008000;
  MMIO_BUFSHARED=$00010000;
  MMIO_APPEND=$00020000;
  MMIO_NOIDENTIFY=$00040000;


type
(* HMMIO=ULONG;*)
 FOURCC=ULONG;

 MMIOPROC=Function (var mmioinfo;
                    usMsg:SmallWord;
                    lParam1:ULONG;
                    lParam2:ULONG):ULONG;
 PMMIOPROC=MMIOPROC;

  MMIOINFO=record
    ulFlags:ULONG;
    fccIOProc:FOURCC;
    pIOProc:PMMIOPROC;
    ulErrorRet:ULONG;
    cchBuffer:LONG;
    pchBuffer:PCHAR;
    pchNext:PCHAR;
    pchEndRead:PCHAR;
    pchEndWrite:PCHAR;
    lBufOffset:LONG;
    lDiskOffset:LONG;
    aulInfo:array [0..3] of ULONG;
    lLogicalFilePos:LONG;
    ulTranslate:ULONG;
    fccChildIOProc:FOURCC;
    pExtraInfoStruct:PVOID;
    hmmio:HMMIO;
  end;

  PMMIOINFO=^MMIOINFO;

  WAVE_HEADER=record
    usFormatTag:USHORT;
    usChannels:USHORT;
    ulSamplesPerSec:ULONG;
    ulAvgBytesPerSec:ULONG;
    usBlockAlign:USHORT;
    usBitsPerSample:USHORT;
  end;


  XWAV_HEADERINFO=record
    ulAudioLengthInMS:ULONG;
    ulAudioLengthInBytes:ULONG;
    ulReserved:ULONG;
  end;


  MMXWAV_HEADER=record
    WAVEHeader:WAVE_HEADER;
    XWAVHeaderInfo:XWAV_HEADERINFO;
  end;


  MMAUDIOHEADER=record
    ulHeaderLength:ULONG;
    ulContentType:ULONG;
    ulMediaType:ULONG;
    mmXWAVHeader:MMXWAV_HEADER;
  end;

{$Cdecl+,AlignRec+,OrgName+}


Function mmioOpen( pszFileName:PSZ;
           pmmioinfo:PMMIOINFO;
           ulOpenFlags:ULONG):HMMIO;

Function mmioRead( hmmio:HMMIO;
          var chBuffer:CHAR;
          cBytes:LONG):ULONG;

Function mmioGetHeader( hmmio:HMMIO;
                var Header;
                lHeaderLength:LONG;
                var lBytesRead:LONG;
                ulReserved:ULONG;
                ulFlags:ULONG):ULONG;


Function mmioClose( hmmio:HMMIO;
                         usFlags:USHORT):SmallWord;


implementation

Function mciSendCommand;external;
Function mciSendString;external;
Function mciGetErrorString;external;
Function mciMakeGroup;external;
Function mciDeleteGroup;external;
Function mciSetSysValue;external;
Function mciQuerySysValue;external;
Function mciGetDeviceID;external;

Function mmioOpen;external;
Function mmioRead;external;
Function mmioGetHeader;external;
Function mmioClose;external;
(*Function mmioGetLastError;external;*)


end.



