/*
 *
 * blt2demo.c -  9-Sep-95 Cornel Huth
 * This module calls blt2cx0?.c
 * Bullet 2 Demonstration Program
 *
 */

#define PRG_DATE "[9-Sep-95]"

#include "platform.h"           // defines platform (OS/2 or DOSX or ...)

#ifdef ON_OS2
   #define INCL_DOSPROCESS      // for OS/2 threads
   #define INCL_DOSMISC         // for DosError()
   #include <os2.h>
   #define HANDLES_WANTED  1030 // can do 1024 Bullet files (3 for OS, ...)
#else
   #define HANDLES_WANTED   255 // can do 250 Bullet files (5 for OS)
#endif

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>

#ifdef ON_OS2
   #include "bullet2.h"
#else
   #include <dos.h>             // for _harderr()
   #include "bulletx.h"
#endif

int cx01();
int cx02();
int cx03();
int cx04();
int cx05();
int cx06();
int cx07();
int cx08();
int cx09();


// For the DOS-Extender version only:
//
// Memory is taken from the compiler/extender facility to ensure flatitude.
// malloc() and free() are used (available in C or C++), but these can be
// replaced if you are not using a C or C++ compiler.  The routines are
// standard C functions, with the single, dword-sized parameter on the stack.
// The parameter is also directly available in the EAX register (use either).  
//
// _BULLETMALLOC() receives the bytes requested, and is to return a pointer 
// (FLAT) to the base of the allocation (the return is always in EAX -- this
// is automatically done by all compilers).  If bytes== -1, then the amount
// of memory available should be returned.  This value is currently used only
// by MEMORY_XB, and is for informational use only.  A dummy value may be
// returned, such as 65536 (or 524288, etc.).
//
// _BULLETFREE() receives the same pointer when the memory is no longer needed, 
// and is to release the allocation.  Nothing need be returned, but if anything
// must, return 0 (in EAX).
//
// _BULLETGETENV() is to return a pointer to 'TMP=' in the environment.  This
// is for the temporary file created during REINDEX_XB.  If the current dir
// is to be used instead, return NULL. 
//
// The three routines must be externally available.

#ifndef ON_OS2

   // Bullet/X requires memory to be gotten from the run-time library 
   // (for flatitude).
   // Names must be _BULLETMALLOC, _BULLETFREE, and _BULLETGETENV.

   // WATCOM reg-based parameter passing uses FuncName_ as naming convention, 
   // so if WATCOM, and reg-based parms, use the following #pragma, which may
   // be 'undone' after these two are defined:

   #pragma aux BULLETMALLOC "_*";
   #pragma aux BULLETFREE "_*";
   #pragma aux BULLETGETENV "_*";

   ULONG BULLETMALLOC(ULONG bytes) {
      if (bytes != 0xFFFFFFFF)
         return((ULONG) malloc(bytes));
         // cast and be happy
      else
         return(512*1024); 
         // this return value is informational only, used only by MEMORY_XB
   }

   ULONG BULLETFREE(VOID *ptr) {
      free(ptr);
      return(0);
   }

   PVOID BULLETGETENV(void) {
      return(getenv("TMP"));
   }


   // Also for DOS extenders, the critical error handler must be setup by your
   // compiler, since, depending on it, and the extender, different methods are
   // used to make it work.  This makes use of no Bullet routine, but it does
   // access an global Bullet variable called _BULLETINT24.  This variable is
   // set to 0xFFFF0000 at the start of a Bullet disk I/O access and set to 0
   // after the access.  Therefore, you can tell if a critical error originates
   // from a Bullet call.  The critical error handler is to set the low word of
   // _BULLETINT24 with the error (actually, error + 19) and is to return an 
   // 'ignore' flag back to the caller (ignore=0).  The INT24HANDLER() below 
   // should make it obvious what needs to be done.
   // This is for the DOSX32 version only.

   extern ULONG BULLETINT24;       // known as _BULLETINT24 to Bullet

   int __far INT24HANDLER(unsigned deverr,unsigned errcode,unsigned far *devhdr) {

      if ((!(deverr & 0x8000)) & ((BULLETINT24 & 0xFFFF0000) == 0xFFFF0000)) {

         // Bit15=0 is disk error, and:
         // if disk error, and if high-word of BULLETINT24 is FFFF, then
         // this critical error occured while processing a Bullet initiated
         // disk access -- any other case then it is not from Bullet (such
         // as file I/O you perform other than through Bullet).  Generally,
         // DOS attempts/retries the operation 3 times (and enters this handler
         // on each), and only after the third does it return back to Bullet.
         // BULLETINT24's high word must be cleared on return.

         BULLETINT24 = errcode + 0x13;  // +19 to get standard DOS error code
         return(0);                     // 0=_HARDERR_IGNORE
      }

      // you may prefer to abort, rather than ignore, if not a Bullet error
      // see your compiler for details

      // #include <conio.h>           // for cprintf()
      // cprintf( "Critical error other than from Bullet: " ); 
      // cprintf( "deverr=%4.4X errcode=%d\r\n",deverr, errcode ); 
      // cprintf( "devhdr = %Fp\r\n", devhdr ); 

      return(0);
   }

#endif

// Also for DOS-Extender version only (details in BULLETX.H)
// (since some extenders may not support INT21/6501 and 6506...)

#ifdef INT2165xxNS
                                // table is global data, for code page 437
   CHAR ctable[] = {
0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F,
0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,
0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2A,0x2B,0x2C,0x2D,0x2E,0x2F,
0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,
0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,
0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5A,0x5B,0x5C,0x5D,0x5E,0x5F,
0x60,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,
0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5A,0x7B,0x7C,0x7D,0x7E,0x7F,
0x43,0x55,0x45,0x41,0x41,0x41,0x41,0x43,0x45,0x45,0x45,0x49,0x49,0x49,0x41,0x41,
0x45,0x41,0x41,0x4F,0x4F,0x4F,0x55,0x55,0x59,0x4F,0x55,0x24,0x24,0x24,0x24,0x24,
0x41,0x49,0x4F,0x55,0x4E,0x4E,0xA6,0xA7,0x3F,0xA9,0xAA,0xAB,0xAC,0x21,0x22,0x22,
0xB0,0xB1,0xB2,0xB3,0xB4,0xB5,0xB6,0xB7,0xB8,0xB9,0xBA,0xBB,0xBC,0xBD,0xBE,0xBF,
0xC0,0xC1,0xC2,0xC3,0xC4,0xC5,0xC6,0xC7,0xC8,0xC9,0xCA,0xCB,0xCC,0xCD,0xCE,0xCF,
0xD0,0xD1,0xD2,0xD3,0xD4,0xD5,0xD6,0xD7,0xD8,0xD9,0xDA,0xDB,0xDC,0xDD,0xDE,0xDF,
0xE0,0x53,0xE2,0xE3,0xE4,0xE5,0xE6,0xE7,0xE8,0xE9,0xEA,0xEB,0xEC,0xED,0xEE,0xEF,
0xF0,0xF1,0xF2,0xF3,0xF4,0xF5,0xF6,0xF7,0xF8,0xF9,0xFA,0xFB,0xFC,0xFD,0xFE,0xFF
};

   CHAR *collateTable = &ctable;

#else

   CHAR *collateTable = NULL;

#endif



// Main program start ////////////////////////////////////////////////////////

int main(void) {

#pragma pack(1)

   EXITPACK EP;
   INITPACK IP;

#pragma pack()

int rez;

CHAR tmpStr[1024];
CHAR aPRGDATE[] = PRG_DATE;
CHAR op1[] = "Import/Add/REINDEX, with import data generated on-the-fly to DBF.";
CHAR op2[] = "Key I/O on non-Bullet data file (only index file is maintained).";
CHAR op3[] = "Atomic INSERT (transaction-list of up to 512 files).";
CHAR op4[] = "Atomic UPDATE (transaction-list of up to 512 files).";
CHAR op5[] = "Two-table joined view of EMPLOYEE and DEPARTMENT tables.";
CHAR op6[] = "Memo support for text/BLOB data to DBT.";
CHAR op7[] = "Files blowout -- many files opened simultaneously.";
CHAR op8[] = "Lock file, region, & record; exclusive/shared relock.";
CHAR op9[] = "Import/Add/REINDEX (as #1) using Custom sortFunction (float key).";

#ifdef USE_ANSI
   CHAR aCLS[] = "\x1B[2J";
   CHAR aGRN[] = "\x1B[1;32m";
   CHAR aWHT[] = "\x1B[0;37m";
#else
   CHAR aCLS[] = "";
   CHAR aGRN[] = "";
   CHAR aWHT[] = "";
#endif

setbuf(stdout,NULL);



IP.func = INIT_XB;
IP.JFTsize = HANDLES_WANTED;
rez = BULLET(&IP);
if (rez) {
   printf("Failed Bullet initialization.  Err: %li\n",rez);
   goto ExitNow;
}

#ifndef ON_OS2

   // register EXIT_XB with the startup code's shutdown list so that Bullet
   // is exited with files closed, etc.

   rez = atexit(IP.exitPtr);
   if (rez)
      printf("\a\n<*> Could not register EXIT_XB with atexit().  Continuing...\n");

   // DOS extenders do not have a standard method of doing the critical error 
   // handler.  Only your compiler knows (or you, the programmer) how the
   // extender expects things to be set up.  Therefore, this is done at the
   // program level, and is to set a Bullet variable (_BULLETINT24:DWORD) to
   // the error code.  The low-word (16 bits) is all that is used.  This 
   // handler comes into play when, for example, you attempt to open a file 
   // on a floppy with no disk in, etc.).

   _harderr(INT24HANDLER);

#else

   // Instead of using _hard() as is done for DOSX, in OS/2 all one needs to
   // do to prevent pop-ups is to call DosError(FERR_DISABLEHARDERR) (or 0).
   // You may prefer to place it around Bullet sections only (use
   // FERR_ENABLEHARDERR, or 1, to restore pop-ups).  This does not disable 
   // numeric or other exceptions, which would be FERR_DISABLEEXCEPTION, or 2.

   DosError(FERR_DISABLEHARDERR);

#endif


while (1) {

   printf("%s%sBullet 2 Demo.%s  NLS IX3/DBF/DBT/external %s\n\n",aCLS,aGRN,aWHT,aPRGDATE);
   printf("Take your pick (each has selectable run options):\n");
   printf("\n 0. Exit demo\n");
   printf(" 1. %s\n",op1);
   printf(" 2. %s\n",op2);
   printf(" 3. %s\n",op3);
   printf(" 4. %s\n",op4);
   printf(" 5. %s\n",op5);
   printf(" 6. %s\n",op6);
   printf(" 7. %s\n",op7);
   printf(" 8. %s\n",op8);
   printf(" 9. %s\n",op9);
   printf("\nSelection: ");

   gets(tmpStr);
   switch(*tmpStr) {
   case '1':
      printf("\n%s%s%s\n",aGRN,op1,aWHT);
      rez = cx01();
      break;
   case '2':
      printf("\n%s%s%s\n",aGRN,op2,aWHT);
      rez = cx02();
      break;
   case '3':
      printf("\n%s%s%s\n",aGRN,op3,aWHT);
      rez = cx03();
      break;
   case '4':
      printf("\n%s%s%s\n",aGRN,op4,aWHT);
      rez = cx04();
      break;
   case '5':
      printf("\n%s%s%s\n",aGRN,op5,aWHT);
      rez = cx05();
      break;
   case '6':
      printf("\n%s%s%s\n",aGRN,op6,aWHT);
      rez = cx06();
      break;
   case '7':
      printf("\n%s%s%s\n",aGRN,op7,aWHT);
      rez = cx07();
      break;
   case '8':
      printf("\n%s%s%s\n",aGRN,op8,aWHT);
      rez = cx08();
      break;
   case '9':
      printf("\n%s%s%s\n",aGRN,op9,aWHT);
      rez = cx09();
      break;
   case '0':
      break;
   }
   if ((*tmpStr=='0') | (rez))
      break;

   printf("\nPress ENTER for select menu...");
   getchar();
}
EP.func = EXIT_XB;
rez = BULLET(&EP);

ExitNow:
return(rez);
}

