/*====================================================================
This file is part of the Blackout screen saver.       v0.94 1995-10-01
Copyright (C) 1995 by Staffan Ulfberg.    See README file for details.
====================================================================*/
#define INCL_WIN
#include <os2.h>
#include <time.h>
#include "blackout.h"

HWND hwndFrameShared;
int MouseMovesShared;

BOOL EXPENTRY InputHook(HAB hab, PQMSG pQmsg, ULONG fs) {
  static time_t LastTimePosted = 0, LastTimeMoved = 0;
  time_t temptime;

  if (pQmsg->msg == WM_CHAR || pQmsg->msg == WM_BUTTON1DOWN ||
      pQmsg->msg == WM_BUTTON2DOWN || pQmsg->msg == WM_BUTTON3DOWN ||
      pQmsg->msg == WM_MOUSEMOVE && MouseMovesShared) {

    if ((time(&temptime) - LastTimeMoved < 30 || pQmsg->msg != WM_MOUSEMOVE)
	&& temptime - LastTimePosted > 3) {
      WinPostMsg(hwndFrameShared, WM_USER, 0, 0);
      LastTimePosted = temptime;
    }
    LastTimeMoved = temptime;
  }
  return 0;
}

/*
BOOL EXPENTRY InputHook(HAB hab, PQMSG pQmsg, ULONG fs) {
  if (pQmsg->msg == WM_MOUSEMOVE)
    DosBeep(100, 100);
  return 0;
}
*/




