/*********************************************************************
AUTOBMP installation
*********************************************************************/
trace 'O'
address CMD

'@ECHO OFF'
'cls'
say "AUTOBMP Installation"
say "----------------------"

/*********************************************************************
Initialization
*********************************************************************/
call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
call sysloadfuncs

instdrive = ''
instpath = ''
bootdrive = Substr(Translate(Value('PATH',,'OS2ENVIRONMENT')),Pos('\OS2\SYSTEM',Translate(Value('PATH',,'OS2ENVIRONMENT')))-2,2)

/*********************************************************************
Get the installation drive and path
*********************************************************************/
say ""
say "Please enter the drive to install upon: (ie. C:)"
parse Upper Pull instdrive
if instdrive == '' then do
  instdrive=bootdrive
end
if right(instdrive, 1)<>':' then do
  instdrive=instdrive||':'
end 


say ""
say "AUTO BMP creates a subdirectory called AUTOBMP for it's files."
say "Please enter the directory where AUTOBMP should be placed: (blank for root)"
parse Upper Pull intpath
if intpath <> '' then do
  if left(intpath, 1) <> '\' then do
    intpath='\'||intpath
  end
end
intpath=instdrive||intpath
instpath=intpath||"\AUTOBMP"

say "AUTOBMP will be installed in: " instpath
say "Is this correct? (Y/N)"
parse Upper Pull response
if response <> 'Y' then do
  say "AUTO BMP installation aborted.  Nothing installed."
  exit 1
end

'md ' intpath  ' 1>nul 2>nul'
'md ' instpath ' 1>nul 2>nul'
say "Installing AUTOBMP files..."
'copy * ' instpath ' 1>nul'
if rc <> 0 then do
  say "Problem copying files to " instpath
  exit 1
end

/*********************************************************************
Define and Create the Folder
*********************************************************************/
say "Creating WorkPlace objects..."

foldobj='<AUTO_BMP>'
foldtitle='AUTOBMP'
foldicon='AUTOBMP.ico'

call SysCreateObject 'WPFolder', foldtitle,'<WP_DESKTOP>','OBJECTID='||foldobj||';ICONFILE='||instpath||'\'||foldicon||';','R'

/*********************************************************************
Create Reference Program ICONs in the Folder
*********************************************************************/
 progobj='AUTOBMP'
progname='AUTOBMP.exe'
progtitle='AUTOBMP'
progpath=instpath
progtype='PM'
progparm=''
call CreateProgram

progobj='AUTO_ NEW'
progname='e.exe' 
progtitle='Whats New'
progpath=bootdrive||'\os2' 
progtype='PM' 
progparm='whatsnew.txt' 
call CreateProgram

progobj='AUTO_ ORDER'
progname='e.exe' 
progtitle='Ordering Infomation'
progpath=bootdrive||'\os2' 
progtype='PM' 
progparm='order.txt' 
call CreateProgram

progobj='AUTO_ ORDERFORM'
progname='e.exe' 
progtitle='Order Form'
progpath=bootdrive||'\os2' 
progtype='PM' 
progparm='ordform.txt' 
call CreateProgram
/*********************************************************************
let em know everything worked
*********************************************************************/
say "AUTOBMP was sucessfully installed."
pause
exit 0

/*********************************************************************
create a program object in a folder
*********************************************************************/
CreateProgram:
  call SysCreateObject 'WPProgram',progtitle,foldobj,'OBJECTID='||progobj||';EXENAME='||progpath||'\'||progname||';PROGTYPE='||progtype||';PARAMETERS='||progparm||';STARTUPDIR='||instpath||';','R'
  return
