#!/usr/bin/X11/wish -f
# Program: Install
# Tcl version: 7.3 (Tcl/Tk/XF)
# Tk version: 3.6
# XF version: $__lastrelease$
#

# module inclusion
global env
global xfLoadPath
if {[info exists env(XF_LOAD_PATH)]} {
  if {[string first $env(XF_LOAD_PATH) /usr/local/lib/] == -1} {
    set xfLoadPath $env(XF_LOAD_PATH):/usr/local/lib/
  } {
    set xfLoadPath /usr/local/lib/
  }
} {
  set xfLoadPath /usr/local/lib/
}

global argc
global argv
global tkVersion
global xfLoadInfo
global xfLoadPath
set xfLoadInfo 0
set tmpArgv ""
for {set counter 0} {$counter < $argc} {incr counter 1} {
  case [string tolower [lindex $argv $counter]] in {
    {-xfloadpath} {
      incr counter 1
      set xfLoadPath "[lindex $argv $counter]:$xfLoadPath"
    }
    {-xfstartup} {
      incr counter 1
      source [lindex $argv $counter]
    }
    {-xfbindfile} {
      incr counter 1
      set env(XF_BIND_FILE) "[lindex $argv $counter]"
    }
    {-xfcolorfile} {
      incr counter 1
      set env(XF_COLOR_FILE) "[lindex $argv $counter]"
    }
    {-xfcursorfile} {
      incr counter 1
      set env(XF_CURSOR_FILE) "[lindex $argv $counter]"
    }
    {-xffontfile} {
      incr counter 1
      set env(XF_FONT_FILE) "[lindex $argv $counter]"
    }
    {-xfmodelmono} {
      if {$tkVersion >= 3.0} {
        tk colormodel . monochrome
      }
    }
    {-xfmodelcolor} {
      if {$tkVersion >= 3.0} {
        tk colormodel . color
      }
    }
    {-xfloading} {
      set xfLoadInfo 1
    }
    {-xfnoloading} {
      set xfLoadInfo 0
    }
    {default} {
      lappend tmpArgv [lindex $argv $counter]
    }
  }
}
set argv $tmpArgv
set argc [llength $tmpArgv]
unset counter
unset tmpArgv


# procedure to show window .
proc ShowWindow. {args} {# xf ignore me 7

  # Window manager configurations
  global tkVersion
  wm positionfrom . user
  wm sizefrom . ""
  wm maxsize . 1024 768
  wm title . {Install.tcl}


  # build widget .frame1
  frame .frame1 \
    -borderwidth {2}

  # build widget .frame1.entry7
  entry .frame1.entry7 \
    -relief {sunken}
  # bindings
  bind .frame1.entry7 <Key-Return> {focus [SN ExecutablePath]}
  bind .frame1.entry7 <Key-Tab> {focus [SN ExecutablePath]}

  # build widget .frame1.label6
  label .frame1.label6 \
    -text {Script Path:}

  # pack widget .frame1
  pack append .frame1 \
    .frame1.label6 {left frame center} \
    .frame1.entry7 {top frame center expand fillx} 

  # build widget .frame2
  frame .frame2 \
    -borderwidth {2}

  # build widget .frame2.entry19
  entry .frame2.entry19 \
    -relief {sunken}
  # bindings
  bind .frame2.entry19 <Key-Return> {focus [SN BinPath]}
  bind .frame2.entry19 <Key-Tab> {focus [SN BinPath]}

  # build widget .frame2.label8
  label .frame2.label8 \
    -text {Executable Path:}

  # pack widget .frame2
  pack append .frame2 \
    .frame2.label8 {left frame center} \
    .frame2.entry19 {left frame center expand fillx} 

  # build widget .frame3
  frame .frame3 \
    -borderwidth {2}

  # build widget .frame3.entry13
  entry .frame3.entry13 \
    -relief {sunken}
  # bindings
  bind .frame3.entry13 <Key-Return> {focus [SN InfoPath]}
  bind .frame3.entry13 <Key-Tab> {focus [SN InfoPath]}

  # build widget .frame3.label12
  label .frame3.label12 \
    -text {Bin Path:}

  # pack widget .frame3
  pack append .frame3 \
    .frame3.label12 {left frame center} \
    .frame3.entry13 {left frame center expand fillx} 

  # build widget .frame4
  frame .frame4 \
    -borderwidth {2}

  # build widget .frame4.entry15
  entry .frame4.entry15 \
    -relief {sunken}
  # bindings
  bind .frame4.entry15 <Key-Return> {[SN InstallButton] invoke}

  # build widget .frame4.label14
  label .frame4.label14 \
    -text {Info Path:}

  # pack widget .frame4
  pack append .frame4 \
    .frame4.label14 {left frame center} \
    .frame4.entry15 {left frame center expand fillx} 

  # build widget .frame5
  frame .frame5 \
    -borderwidth {2}

  # build widget .frame5.button16
  button .frame5.button16 \
    -command {DoInstall}\
    -text {Install It!}

  # build widget .frame5.button17
  button .frame5.button17 \
    -command {exit}\
    -text {Don't Install}

  # build widget .frame5.button18
  button .frame5.button18 \
    -command {GiveHelp}\
    -text {Help}

  # pack widget .frame5
  pack append .frame5 \
    .frame5.button16 {left frame center expand} \
    .frame5.button17 {left frame center expand} \
    .frame5.button18 {left frame center expand} 

  # build widget .label0
  label .label0 \
    -font {-Adobe-Helvetica-Bold-R-Normal--*-240-*}\
    -text {Role Playing DataBase System Installation}

  # pack widget .
  pack append . \
    .label0 {top frame center fillx} \
    .frame1 {top frame center fillx} \
    .frame2 {top frame center fillx} \
    .frame3 {top frame center fillx} \
    .frame4 {top frame center fillx} \
    .frame5 {top frame center fillx} 

  if {"[info procs XFEdit]" != ""} {
    XFEditSetShowWindows
    XFMiscBindWidgetTree .xfInfoWidgetTree
  }

  .frame1.entry7 insert end {/usr/local/lib/RPG/scripts}
  .frame2.entry19 insert end {/usr/local/lib/RPG/RPGwish}
  .frame3.entry13 insert end {/usr/local/bin/RolePlayingDB}
  .frame4.entry15 insert end {/usr/local/lib/RPG/Info}


}


# User defined procedures


# Procedure: DoInstall
proc DoInstall {} {
  set scriptPath [[SN ScriptPath] get]
  set executablePath [[SN ExecutablePath] get]
  set binPath [[SN BinPath] get]
  set infoPath [[SN InfoPath] get]
  if {![IsADir $scriptPath]} {
    if {[catch "exec mkdir -p $scriptPath" error]} {
       tkerror "Could not create script directory: $scriptPath\n$error"
       return
    }
  }
  if {[catch "exec cp [glob scripts/*] $scriptPath" error]} {
     tkerror "Could not copy scripts to $scriptPath\n$error"
     return  
  }
  set exeDir [file dirname $executablePath]
  if {![IsADir $exeDir]} {
    if {[catch "exec mkdir -p $exeDir" error]} {
      tkerror "Could not create exe directory: $exeDir\n$error"
      return
    }
  }
  if {[catch "exec cp bin/RPGwish $executablePath" error]} {
    tkerror "Cound not copy executable to $executablePath\n$error"
    return
  }
  set binDir [file dirname $binPath]
  if {![IsADir $binDir]} {
    if {[catch "exec mkdir -p $binDir" error]} {
       tkerror "Could not create bin directory: $binDir\n$error"
       return
    }
  }
  set binFile {}
  if {[catch "open $binPath w" binFile]} {
    tkerror "Could not open $binPath: $binFile"
    return
  }
  puts $binFile "#!/bin/sh"
  puts $binFile "$executablePath -f $scriptPath/RolePlayingDB"
  close $binFile
  catch "exec chmod +x $binPath"
  if {![IsADir $infoPath]} {
    if {[catch "exec mkdir -p $infoPath" error]} {
       tkerror "Could not create Info directory: $infoPath\n$error"
       return
    }
  }
  if {[catch "exec cp [glob Info/*] $infoPath" error]} {
    tkerror "Could not copy Info files to $infoPath\n$error"
    return
  }
  catch "exec ln -s $infoPath $scriptPath/Info"
  exit
}


# Procedure: GiveHelp
proc GiveHelp {} {
  TextBox {Role Playing DataBase System Installation Help

The Role Playing DataBase System needs four paths:

  1) The name of te directory the scripts are to be installed
     in.
  2) The installed filename for the customized RPG wish.
  3) The name of the /bin/sh script to start up the 
     Role Playing DataBase System.
  4) The directory where the Info file (on-line help).

Enter the four paths and then select the Install It! button.
If the installation was successfull, the Install program will
go away.  Otherwise an error message will popup.
} {} {500x225}
}


# Procedure: IsADir
proc IsADir { pathName} {
# xf ignore me 5
##########
# Procedure: IsADir
# Description: check if name is a directory (including symbolic links)
# Arguments: pathName - the path to check
# Returns: 1 if its a directory, otherwise 0
# Sideeffects: none
##########

  if {[file isdirectory $pathName]} {
    return 1
  } {
    catch "file type $pathName" fileType
    if {"$fileType" == "link"} {
      if {[catch "file readlink $pathName" linkName]} {
        return 0
      }
      catch "file type $linkName" fileType
      while {"$fileType" == "link"} {
        if {[catch "file readlink $linkName" linkName]} {
          return 0
        }
        catch "file type $linkName" fileType
      }
      return [file isdirectory $linkName]
    }
  }
  return 0
}


# Procedure: IsAFile
proc IsAFile { fileName} {
# xf ignore me 5
##########
# Procedure: IsAFile
# Description: check if filename is a file (including symbolic links)
# Arguments: fileName - the filename to check
# Returns: 1 if its a file, otherwise 0
# Sideeffects: none
##########

  if {[file isfile $fileName]} {
    return 1
  } {
    catch "file type $fileName" fileType
    if {"$fileType" == "link"} {
      if {[catch "file readlink $fileName" linkName]} {
        return 0
      }
      catch "file type $linkName" fileType
      while {"$fileType" == "link"} {
        if {[catch "file readlink $linkName" linkName]} {
          return 0
        }
        catch "file type $linkName" fileType
      }
      return [file isfile $linkName]
    }
  }
  return 0
}


# Procedure: TextBox
proc TextBox { {textBoxMessage "Text message"} {textBoxCommand ""} {textBoxGeometry "350x150"} {textBoxTitle "Text box"} args} {
# xf ignore me 5
##########
# Procedure: TextBox
# Description: show text box
# Arguments: {textBoxMessage} - the text to display
#            {textBoxCommand} - the command to call after ok
#            {textBoxGeometry} - the geometry for the window
#            {textBoxTitle} - the title for the window
#            {args} - labels of buttons
# Returns: The number of the selected button, or nothing
# Sideeffects: none
# Notes: there exist also functions called:
#          TextBoxFile - to open and read a file automatically
#          TextBoxFd - to read from an already opened filedescriptor
##########
#
# global textBox(activeBackground) - active background color
# global textBox(activeForeground) - active foreground color
# global textBox(background) - background color
# global textBox(font) - text font
# global textBox(foreground) - foreground color
# global textBox(scrollActiveForeground) - scrollbar active background color
# global textBox(scrollBackground) - scrollbar background color
# global textBox(scrollForeground) - scrollbar foreground color
# global textBox(scrollSide) - side where scrollbar is located

  global textBox

  # show text box
  if {[llength $args] > 0} {
    eval TextBoxInternal "\{$textBoxMessage\}" "\{$textBoxCommand\}" "\{$textBoxGeometry\}" "\{$textBoxTitle\}" $args
  } {
    TextBoxInternal $textBoxMessage $textBoxCommand $textBoxGeometry $textBoxTitle
  }

  if {[llength $args] > 0} {
    # wait for the box to be destroyed
    update idletask
    grab $textBox(toplevelName)
    tkwait window $textBox(toplevelName)

    return $textBox(button)
  }
}


# Procedure: TextBoxFd
proc TextBoxFd { {textBoxInFile ""} {textBoxCommand ""} {textBoxGeometry "350x150"} {textBoxTitle "Text box"} args} {
# xf ignore me 5
##########
# Procedure: TextBoxFd
# Description: show text box containing a filedescriptor
# Arguments: {textBoxInFile} - a filedescriptor to read. The descriptor
#                              is closed after reading
#            {textBoxCommand} - the command to call after ok
#            {textBoxGeometry} - the geometry for the window
#            {textBoxTitle} - the title for the window
#            {args} - labels of buttons
# Returns: The number of the selected button, ot nothing
# Sideeffects: none
# Notes: there exist also functions called:
#          TextBox - to display a passed string
#          TextBoxFile - to open and read a file automatically
##########
#
# global textBox(activeBackground) - active background color
# global textBox(activeForeground) - active foreground color
# global textBox(background) - background color
# global textBox(font) - text font
# global textBox(foreground) - foreground color
# global textBox(scrollActiveForeground) - scrollbar active background color
# global textBox(scrollBackground) - scrollbar background color
# global textBox(scrollForeground) - scrollbar foreground color
# global textBox(scrollSide) - side where scrollbar is located

  global textBox

  # check file existance
  if {"$textBoxInFile" == ""} {
    puts stderr "No filedescriptor specified"
    return
  }

  set textBoxMessage [read $textBoxInFile]
  close $textBoxInFile

  # show text box
  if {[llength $args] > 0} {
    eval TextBoxInternal "\{$textBoxMessage\}" "\{$textBoxCommand\}" "\{$textBoxGeometry\}" "\{$textBoxTitle\}" $args
  } {
    TextBoxInternal $textBoxMessage $textBoxCommand $textBoxGeometry $textBoxTitle
  }

  if {[llength $args] > 0} {
    # wait for the box to be destroyed
    update idletask
    grab $textBox(toplevelName)
    tkwait window $textBox(toplevelName)

    return $textBox(button)
  }
}


# Procedure: TextBoxFile
proc TextBoxFile { {textBoxFile ""} {textBoxCommand ""} {textBoxGeometry "350x150"} {textBoxTitle "Text box"} args} {
# xf ignore me 5
##########
# Procedure: TextBoxFile
# Description: show text box containing a file
# Arguments: {textBoxFile} - filename to read
#            {textBoxCommand} - the command to call after ok
#            {textBoxGeometry} - the geometry for the window
#            {textBoxTitle} - the title for the window
#            {args} - labels of buttons
# Returns: The number of the selected button, ot nothing
# Sideeffects: none
# Notes: there exist also functions called:
#          TextBox - to display a passed string
#          TextBoxFd - to read from an already opened filedescriptor
##########
#
# global textBox(activeBackground) - active background color
# global textBox(activeForeground) - active foreground color
# global textBox(background) - background color
# global textBox(font) - text font
# global textBox(foreground) - foreground color
# global textBox(scrollActiveForeground) - scrollbar active background color
# global textBox(scrollBackground) - scrollbar background color
# global textBox(scrollForeground) - scrollbar foreground color
# global textBox(scrollSide) - side where scrollbar is located

  global textBox

  # check file existance
  if {"$textBoxFile" == ""} {
    puts stderr "No filename specified"
    return
  }

  if {[catch "open $textBoxFile r" textBoxInFile]} {
    puts stderr "$textBoxInFile"
    return
  }

  set textBoxMessage [read $textBoxInFile]
  close $textBoxInFile

  # show text box
  if {[llength $args] > 0} {
    eval TextBoxInternal "\{$textBoxMessage\}" "\{$textBoxCommand\}" "\{$textBoxGeometry\}" "\{$textBoxTitle\}" $args
  } {
    TextBoxInternal $textBoxMessage $textBoxCommand $textBoxGeometry $textBoxTitle
  }

  if {[llength $args] > 0} {
    # wait for the box to be destroyed
    update idletask
    grab $textBox(toplevelName)
    tkwait window $textBox(toplevelName)

    return $textBox(button)
  }
}


# Procedure: TextBoxInternal
proc TextBoxInternal { textBoxMessage textBoxCommand textBoxGeometry textBoxTitle args} {
# xf ignore me 6
  global textBox

  set tmpButtonOpt ""
  set tmpFrameOpt ""
  set tmpMessageOpt ""
  set tmpScrollOpt ""
  if {"$textBox(activeBackground)" != ""} {
    append tmpButtonOpt "-activebackground \"$textBox(activeBackground)\" "
  }
  if {"$textBox(activeForeground)" != ""} {
    append tmpButtonOpt "-activeforeground \"$textBox(activeForeground)\" "
  }
  if {"$textBox(background)" != ""} {
    append tmpButtonOpt "-background \"$textBox(background)\" "
    append tmpFrameOpt "-background \"$textBox(background)\" "
    append tmpMessageOpt "-background \"$textBox(background)\" "
  }
  if {"$textBox(font)" != ""} {
    append tmpButtonOpt "-font \"$textBox(font)\" "
    append tmpMessageOpt "-font \"$textBox(font)\" "
  }
  if {"$textBox(foreground)" != ""} {
    append tmpButtonOpt "-foreground \"$textBox(foreground)\" "
    append tmpMessageOpt "-foreground \"$textBox(foreground)\" "
  }
  if {"$textBox(scrollActiveForeground)" != ""} {
    append tmpScrollOpt "-activeforeground \"$textBox(scrollActiveForeground)\" "
  }
  if {"$textBox(scrollBackground)" != ""} {
    append tmpScrollOpt "-background \"$textBox(scrollBackground)\" "
  }
  if {"$textBox(scrollForeground)" != ""} {
    append tmpScrollOpt "-foreground \"$textBox(scrollForeground)\" "
  }

  # start build of toplevel
  if {"[info commands XFDestroy]" != ""} {
    catch {XFDestroy $textBox(toplevelName)}
  } {
    catch {destroy $textBox(toplevelName)}
  }
  toplevel $textBox(toplevelName)  -borderwidth 0
  catch "$textBox(toplevelName) config $tmpFrameOpt"
  if {[catch "wm geometry $textBox(toplevelName) $textBoxGeometry"]} {
    wm geometry $textBox(toplevelName) 350x150
  }
  wm title $textBox(toplevelName) $textBoxTitle
  wm maxsize $textBox(toplevelName) 1000 1000
  wm minsize $textBox(toplevelName) 100 100
  # end build of toplevel

  frame $textBox(toplevelName).frame0  -borderwidth 0  -relief raised
  catch "$textBox(toplevelName).frame0 config $tmpFrameOpt"

  text $textBox(toplevelName).frame0.text1  -relief raised  -wrap none  -borderwidth 2  -yscrollcommand "$textBox(toplevelName).frame0.vscroll set"
  catch "$textBox(toplevelName).frame0.text1 config $tmpMessageOpt"

  scrollbar $textBox(toplevelName).frame0.vscroll  -relief raised  -command "$textBox(toplevelName).frame0.text1 yview"
  catch "$textBox(toplevelName).frame0.vscroll config $tmpScrollOpt"

  frame $textBox(toplevelName).frame1  -borderwidth 0  -relief raised
  catch "$textBox(toplevelName).frame1 config $tmpFrameOpt"

  set textBoxCounter 0
  set buttonNum [llength $args]

  if {$buttonNum > 0} {
    while {$textBoxCounter < $buttonNum} {
      button $textBox(toplevelName).frame1.button$textBoxCounter  -text "[lindex $args $textBoxCounter]"  -command "
          global textBox
          set textBox(button) $textBoxCounter
          set textBox(contents) \[$textBox(toplevelName).frame0.text1 get 1.0 end\]
          if {\"\[info commands XFDestroy\]\" != \"\"} {
            catch {XFDestroy $textBox(toplevelName)}
          } {
            catch {destroy $textBox(toplevelName)}
          }"
      catch "$textBox(toplevelName).frame1.button$textBoxCounter config $tmpButtonOpt"

      pack append $textBox(toplevelName).frame1  $textBox(toplevelName).frame1.button$textBoxCounter {left fillx expand}

      incr textBoxCounter
    }
  } {
    button $textBox(toplevelName).frame1.button0  -text "OK"  -command "
        global textBox
        set textBox(button) 0
        set textBox(contents) \[$textBox(toplevelName).frame0.text1 get 1.0 end\]
        if {\"\[info commands XFDestroy\]\" != \"\"} {
          catch {XFDestroy $textBox(toplevelName)}
        } {
          catch {destroy $textBox(toplevelName)}
        }
        $textBoxCommand"
    catch "$textBox(toplevelName).frame1.button0 config $tmpButtonOpt"

    pack append $textBox(toplevelName).frame1  $textBox(toplevelName).frame1.button0 {left fillx expand}
  }

  $textBox(toplevelName).frame0.text1 insert end "$textBoxMessage"

  $textBox(toplevelName).frame0.text1 config  -state $textBox(state)

  # packing
  pack append $textBox(toplevelName).frame0  $textBox(toplevelName).frame0.vscroll "$textBox(scrollSide) filly"  $textBox(toplevelName).frame0.text1 {left fill expand}
  pack append $textBox(toplevelName)  $textBox(toplevelName).frame1 {bottom fill}  $textBox(toplevelName).frame0 {top fill expand}
}


# Internal procedures


# Procedure: Alias
proc Alias { args} {
# xf ignore me 7
##########
# Procedure: Alias
# Description: establish an alias for a procedure
# Arguments: args - no argument means that a list of all aliases
#                   is returned. Otherwise the first parameter is
#                   the alias name, and the second parameter is
#                   the procedure that is aliased.
# Returns: nothing, the command that is bound to the alias or a
#          list of all aliases - command pairs. 
# Sideeffects: internalAliasList is updated, and the alias
#              proc is inserted
##########
  global internalAliasList

  if {[llength $args] == 0} {
    return $internalAliasList
  } {
    if {[llength $args] == 1} {
      set xfTmpIndex [lsearch $internalAliasList "[lindex $args 0] *"]
      if {$xfTmpIndex != -1} {
        return [lindex [lindex $internalAliasList $xfTmpIndex] 1]
      }
    } {
      if {[llength $args] == 2} {
        eval "proc [lindex $args 0] {args} {#xf ignore me 4
return \[eval \"[lindex $args 1] \$args\"\]}"
        set xfTmpIndex [lsearch $internalAliasList "[lindex $args 0] *"]
        if {$xfTmpIndex != -1} {
          set internalAliasList [lreplace $internalAliasList $xfTmpIndex $xfTmpIndex "[lindex $args 0] [lindex $args 1]"]
        } {
          lappend internalAliasList "[lindex $args 0] [lindex $args 1]"
        }
      } {
        error "Alias: wrong number or args: $args"
      }
    }
  }
}


# Procedure: GetSelection
if {"[info procs GetSelection]" == ""} {
proc GetSelection {} {
# xf ignore me 7
##########
# Procedure: GetSelection
# Description: get current selection
# Arguments: none
# Returns: none
# Sideeffects: none
##########

  # the save way
  set xfSelection ""
  catch "selection get" xfSelection
  if {"$xfSelection" == "selection doesn't exist or form \"STRING\" not defined"} {
    return ""
  } {
    return $xfSelection
  }
}
}


# Procedure: MenuPopupAdd
if {"[info procs MenuPopupAdd]" == ""} {
proc MenuPopupAdd { xfW xfButton xfMenu {xfModifier ""} {xfCanvasTag ""}} {
# xf ignore me 7
# the popup menu handling is from (I already gave up with popup handling :-):
#
# Copyright 1991,1992 by James Noble.
# Everyone is granted permission to copy, modify and redistribute.
# This notice must be preserved on all copies or derivates.
#
##########
# Procedure: MenuPopupAdd
# Description: attach a popup menu to widget
# Arguments: xfW - the widget
#            xfButton - the button we use
#            xfMenu - the menu to attach
#            {xfModifier} - a optional modifier
#            {xfCanvasTag} - a canvas tagOrId
# Returns: none
# Sideeffects: none
##########

  if {"$xfModifier" != ""} {
    set xfPressModifier "$xfModifier-"
    set xfMoveModifier "$xfModifier-"
    set xfReleaseModifier "Any-"
  } {
    set xfPressModifier ""
    set xfMoveModifier ""
    set xfReleaseModifier ""
  }

  if {"$xfCanvasTag" == ""} {
    if {[catch "bind $xfW \"<${xfPressModifier}ButtonPress-$xfButton>\"  \"$xfMenu post %X %Y\"" xfResult]} {
      if {"[info commands XFProcError]" != ""} {
        XFProcError "$xfResult"
      } {
        puts stdout "$xfResult"
      }
      return
    }
    if {[catch "bind $xfW \"<${xfMoveModifier}B$xfButton-Motion>\"  \"MenuPopupHandle $xfMenu %W %X %Y\"" xfResult]} {
      if {"[info commands XFProcError]" != ""} {
        XFProcError "$xfResult"
      } {
        puts stdout "$xfResult"
      }
      return
    }
    # we need these to counteract the effects of passive grabs :-(
    if {[catch "bind $xfW \"<${xfReleaseModifier}ButtonRelease-$xfButton>\"  \"$xfMenu invoke active; $xfMenu unpost\"" xfResult]} {
      if {"[info commands XFProcError]" != ""} {
        XFProcError "$xfResult"
      } {
        puts stdout "$xfResult"
      }
      return
    }
  } {
    if {[catch "$xfW bind $xfCanvasTag \"<${xfPressModifier}ButtonPress-$xfButton>\"  \"$xfMenu post %X %Y\"" xfResult]} {
      if {"[info commands XFProcError]" != ""} {
        XFProcError "$xfResult"
      } {
        puts stdout "$xfResult"
      }
      return
    }
    if {[catch "$xfW bind $xfCanvasTag \"<${xfMoveModifier}B$xfButton-Motion>\"  \"MenuPopupHandle $xfMenu %W %X %Y\"" xfResult]} {
      if {"[info commands XFProcError]" != ""} {
        XFProcError "$xfResult"
      } {
        puts stdout "$xfResult"
      }
      return
    }
    # we need these to counteract the effects of passive grabs :-(
    if {[catch "$xfW bind $xfCanvasTag \"<${xfReleaseModifier}ButtonRelease-$xfButton>\"  \"$xfMenu invoke active; $xfMenu unpost\"" xfResult]} {
      if {"[info commands XFProcError]" != ""} {
        XFProcError "$xfResult"
      } {
        puts stdout "$xfResult"
      }
      return
    }
  }
}
}


# Procedure: MenuPopupHandle
if {"[info procs MenuPopupHandle]" == ""} {
proc MenuPopupHandle { xfMenu xfW xfX xfY} {
# xf ignore me 7
##########
# Procedure: MenuPopupHandle
# Description: handle the popup menus
# Arguments: xfMenu - the menu to attach
#            xfW - the widget
#            xfX - the root x coordinate
#            xfY - the root x coordinate
# Returns: none
# Sideeffects: none
##########

  if {"[info commands $xfMenu]" != "" && [winfo ismapped $xfMenu]} {
    set xfPopMinX [winfo rootx $xfMenu]
    set xfPopMaxX [expr $xfPopMinX+[winfo width $xfMenu]]
    if {($xfX >= $xfPopMinX) &&  ($xfX <= $xfPopMaxX)} {
      $xfMenu activate @[expr $xfY-[winfo rooty $xfMenu]]
    } {
      $xfMenu activate none
    }
  }
}
}


# Procedure: NoFunction
if {"[info procs NoFunction]" == ""} {
proc NoFunction { args} {
# xf ignore me 7
##########
# Procedure: NoFunction
# Description: do nothing (especially with scales and scrollbars)
# Arguments: args - a number of ignored parameters
# Returns: none
# Sideeffects: none
##########
}
}


# Procedure: SN
if {"[info procs SN]" == ""} {
proc SN { {xfName ""}} {
# xf ignore me 7
##########
# Procedure: SN
# Description: map a symbolic name to the widget path
# Arguments: xfName
# Returns: the symbolic name
# Sideeffects: none
##########

  SymbolicName $xfName
}
}


# Procedure: SymbolicName
if {"[info procs SymbolicName]" == ""} {
proc SymbolicName { {xfName ""}} {
# xf ignore me 7
##########
# Procedure: SymbolicName
# Description: map a symbolic name to the widget path
# Arguments: xfName
# Returns: the symbolic name
# Sideeffects: none
##########

  global symbolicName

  if {"$xfName" != ""} {
    set xfArrayName ""
    append xfArrayName symbolicName ( $xfName )
    if {![catch "set \"$xfArrayName\"" xfValue]} {
      return $xfValue
    } {
      if {"[info commands XFProcError]" != ""} {
        XFProcError "Unknown symbolic name:\n$xfName"
      } {
        puts stderr "XF error: unknown symbolic name:\n$xfName"
      }
    }
  }
  return ""
}
}


# Procedure: Unalias
proc Unalias { aliasName} {
# xf ignore me 7
##########
# Procedure: Unalias
# Description: remove an alias for a procedure
# Arguments: aliasName - the alias name to remove
# Returns: none
# Sideeffects: internalAliasList is updated, and the alias
#              proc is removed
##########
  global internalAliasList

  set xfIndex [lsearch $internalAliasList "$aliasName *"]
  if {$xfIndex != -1} {
    rename $aliasName ""
    set internalAliasList [lreplace $internalAliasList $xfIndex $xfIndex]
  }
}



# application parsing procedure
proc XFLocalParseAppDefs {xfAppDefFile} {
  global xfAppDefaults

  # basically from: Michael Moore
  if {[file exists $xfAppDefFile] &&
      [file readable $xfAppDefFile] &&
      "[file type $xfAppDefFile]" == "link"} {
    catch "file type $xfAppDefFile" xfType
    while {"$xfType" == "link"} {
      if {[catch "file readlink $xfAppDefFile" xfAppDefFile]} {
        return
      }
      catch "file type $xfAppDefFile" xfType
    }
  }
  if {!("$xfAppDefFile" != "" &&
        [file exists $xfAppDefFile] &&
        [file readable $xfAppDefFile] &&
        "[file type $xfAppDefFile]" == "file")} {
    return
  }
  if {![catch "open $xfAppDefFile r" xfResult]} {
    set xfAppFileContents [read $xfResult]
    close $xfResult
    foreach line [split $xfAppFileContents "\n"] {
      # backup indicates how far to backup.  It applies to the
      # situation where a resource name ends in . and when it
      # ends in *.  In the second case you want to keep the *
      # in the widget name for pattern matching, but you want
      # to get rid of the . if it is the end of the name. 
      set backup -2  
      set line [string trim $line]
      if {[string index $line 0] == "#" || "$line" == ""} {
        # skip comments and empty lines
        continue
      }
      set list [split $line ":"]
      set resource [string trim [lindex $list 0]]
      set i [string last "." $resource]
      set j [string last "*" $resource]
      if {$j > $i} { 
        set i $j
        set backup -1
      }
      incr i
      set name [string range $resource $i end]
      incr i $backup
      set widname [string range $resource 0 $i]
      set value [string trim [lindex $list 1]]
      if {"$widname" != "" && "$widname" != "*"} {
        # insert the widget and resourcename to the application
        # defaults list.
        set xfAppDefaults($widname:[string tolower $name]) $value
      }
    }
  }
}

# application loading procedure
proc XFLocalLoadAppDefs {xfClasses {xfPriority "startupFile"} {xfAppDefFile ""}} {
  global env

  if {"$xfAppDefFile" == ""} {
    set xfFileList ""
    if {[info exists env(XUSERFILESEARCHPATH)]} {
      append xfFileList [split $env(XUSERFILESEARCHPATH) :]
    }
    if {[info exists env(XAPPLRESDIR)]} {
      append xfFileList [split $env(XAPPLRESDIR) :]
    }
    if {[info exists env(XFILESEARCHPATH)]} {
      append xfFileList [split $env(XFILESEARCHPATH) :]
    }
    append xfFileList " /usr/lib/X11/app-defaults"
    append xfFileList " /usr/X11/lib/X11/app-defaults"

    foreach xfCounter1 $xfClasses {
      foreach xfCounter2 $xfFileList {
        set xfPathName $xfCounter2
        if {[regsub -all "%N" "$xfPathName" "$xfCounter1" xfResult]} {
          set xfPathName $xfResult
        }
        if {[regsub -all "%T" "$xfPathName" "app-defaults" xfResult]} {
          set xfPathName $xfResult
        }
        if {[regsub -all "%S" "$xfPathName" "" xfResult]} {
          set xfPathName $xfResult
        }
        if {[regsub -all "%C" "$xfPathName" "" xfResult]} {
          set xfPathName $xfResult
        }
        if {[file exists $xfPathName] &&
            [file readable $xfPathName] &&
            ("[file type $xfPathName]" == "file" ||
             "[file type $xfPathName]" == "link")} {
          catch "option readfile $xfPathName $xfPriority"
          if {"[info commands XFParseAppDefs]" != ""} {
            XFParseAppDefs $xfPathName
          } {
            if {"[info commands XFLocalParseAppDefs]" != ""} {
              XFLocalParseAppDefs $xfPathName
            }
          }
        } {
          if {[file exists $xfCounter2/$xfCounter1] &&
              [file readable $xfCounter2/$xfCounter1] &&
              ("[file type $xfCounter2/$xfCounter1]" == "file" ||
               "[file type $xfCounter2/$xfCounter1]" == "link")} {
            catch "option readfile $xfCounter2/$xfCounter1 $xfPriority"
            if {"[info commands XFParseAppDefs]" != ""} {
              XFParseAppDefs $xfCounter2/$xfCounter1
            } {
              if {"[info commands XFLocalParseAppDefs]" != ""} {
                XFLocalParseAppDefs $xfCounter2/$xfCounter1
              }
            }
          }
        }
      }
    }
  } {
    # load a specific application defaults file
    if {[file exists $xfAppDefFile] &&
        [file readable $xfAppDefFile] &&
        ("[file type $xfAppDefFile]" == "file" ||
         "[file type $xfAppDefFile]" == "link")} {
      catch "option readfile $xfAppDefFile $xfPriority"
      if {"[info commands XFParseAppDefs]" != ""} {
        XFParseAppDefs $xfAppDefFile
      } {
        if {"[info commands XFLocalParseAppDefs]" != ""} {
          XFLocalParseAppDefs $xfAppDefFile
        }
      }
    }
  }
}

# application setting procedure
proc XFLocalSetAppDefs {{xfWidgetPath "."}} {
  global xfAppDefaults

  if {![info exists xfAppDefaults]} {
    return
  }
  foreach xfCounter [array names xfAppDefaults] {
    if {[string match "${xfWidgetPath}*" $xfCounter]} {
      set widname [string range $xfCounter 0 [expr [string first : $xfCounter]-1]]
      set name [string range $xfCounter [expr [string first : $xfCounter]+1] end]
      # Now lets see how many tcl commands match the name
      # pattern specified.
      set widlist [info command $widname]
      if {"$widlist" != ""} {
        foreach widget $widlist {
          # make sure this command is a widget.
          if {![catch "winfo id $widget"]} {
            catch "$widget configure -[string tolower $name] $xfAppDefaults($xfCounter)" 
          }
        }
      }
    }
  }
}


# prepare auto loading
global auto_path
global tk_library
global xfLoadPath
set auto_path "[split $xfLoadPath :] $tk_library [info library]"

# initialize global variables
proc InitGlobals {} {
  global {textBox}
  set {textBox(activeBackground)} {}
  set {textBox(activeForeground)} {}
  set {textBox(background)} {}
  set {textBox(button)} {0}
  set {textBox(contents)} {Role Playing DataBase System Installation Help

The Role Playing DataBase System needs four paths:

  1) The name of te directory the scripts are to be installed
     in.
  2) The installed filename for the customized RPG wish.
  3) The name of the /bin/sh script to start up the 
     Role Playing DataBase System.
  4) The directory where the Info file (on-line help).

Enter the four paths and then select the Install It! button.
If the installation was successfull, the Install program will
go away.  Otherwise an error message will popup.
}
  set {textBox(font)} {}
  set {textBox(foreground)} {}
  set {textBox(scrollActiveForeground)} {}
  set {textBox(scrollBackground)} {}
  set {textBox(scrollForeground)} {}
  set {textBox(scrollSide)} {left}
  set {textBox(state)} {disabled}
  set {textBox(toplevelName)} {.textBox}

  # please don't modify the following
  # variables. They are needed by xf.
  global {autoLoadList}
  set {autoLoadList(Install.tcl)} {0}
  set {autoLoadList(main.tcl)} {0}
  global {internalAliasList}
  set {internalAliasList} {}
  global {moduleList}
  set {moduleList(Install.tcl)} {}
  global {preloadList}
  set {preloadList(xfInternal)} {}
  global {symbolicName}
  set {symbolicName(BinPath)} {.frame3.entry13}
  set {symbolicName(ExecutablePath)} {.frame2.entry19}
  set {symbolicName(InfoPath)} {.frame4.entry15}
  set {symbolicName(InstallButton)} {.frame5.button16}
  set {symbolicName(ScriptPath)} {.frame1.entry7}
  set {symbolicName(root)} {.}
  global {xfWmSetPosition}
  set {xfWmSetPosition} {}
  global {xfWmSetSize}
  set {xfWmSetSize} {}
  global {xfAppDefToplevels}
  set {xfAppDefToplevels} {}
}

# initialize global variables
InitGlobals

# display/remove toplevel windows.
ShowWindow.

# load default bindings.
if {[info exists env(XF_BIND_FILE)] &&
    "[info procs XFShowHelp]" == ""} {
  source $env(XF_BIND_FILE)
}

# parse and apply application defaults.
XFLocalLoadAppDefs Install
XFLocalSetAppDefs

# eof
#

