unit Main;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls,Testrep,md_rep, ExtCtrls,printers, DBCtrls, DB,
  DBTables;

type
  TTQuickReportDemo = class(TForm)
    PreviewBtn: TButton;
    PrintBtn: TButton;
    PrintDialogChk: TCheckBox;
    Bevel1: TBevel;
    DemoLabel: TLabel;
    Label1: TLabel;
    ExitBtn: TButton;
    GroupBox1: TGroupBox;
    Portrait: TRadioButton;
    Landscape: TRadioButton;
    ReportCombo: TComboBox;
    procedure PreviewBtnClick(Sender: TObject);
    procedure PrintDialogChkClick(Sender: TObject);
    procedure PrintBtnClick(Sender: TObject);
    procedure ExitBtnClick(Sender: TObject);
    procedure PortraitClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  TQuickReportDemo: TTQuickReportDemo;

implementation

{$R *.DFM}

procedure TTQuickReportDemo.PreviewBtnClick(Sender: TObject);
begin
   case ReportCombo.ItemIndex of
      0 : TestReport.DemoReport.Preview;
      1 : MasterDetailReport.Report.Preview;
   end;
end;

procedure TTQuickReportDemo.PrintDialogChkClick(Sender: TObject);
begin
   if PrintDialogChk.Checked then
      Testreport.DemoReport.DisplayPrintDialog:=True
   else
      TestReport.DemoReport.DisplayPrintDialog:=False;
end;

procedure TTQuickReportDemo.PrintBtnClick(Sender: TObject);
begin
   Cursor:=crHourGlass;
   case ReportCombo.ItemIndex of
      0 : TestReport.DemoReport.Print;
      1 : MasterDetailReport.Report.Print;
   end;
   Cursor:=crDefault;
end;

procedure TTQuickReportDemo.ExitBtnClick(Sender: TObject);
begin
   Close;
end;

procedure TTQuickReportDemo.PortraitClick(Sender: TObject);
begin
   if Portrait.Checked then
      TestReport.DemoReport.Orientation:=poPortrait
   else
      TestReport.DemoReport.Orientation:=poLandscape;
   MasterDetailReport.Report.Orientation:=TestReport.DemoReport.Orientation;
end;

procedure TTQuickReportDemo.FormCreate(Sender: TObject);
begin
   ReportCombo.ItemIndex:=0;
end;

end.
