/*
 * PB-Lib C/C++ Library Version 0.021
 *
 * Copyright (C) 1995 by Branislav L. Slantchev
 * A product of Silicon Creations, Inc.
 *
 * See the file "copying.pbl" for licensing information.
*/

#ifndef __SYSUTIL_H
#define __SYSUTIL_H

#ifndef __PBLIB_H
#include <pblib.h>
#endif

/*
 * return values of DetectOS
*/
#define __DOS  1  /* MS-DOS or compatible is running */
#define __OS2  2  /* OS/2 DOS box detected           */
#define __WIN  3  /* Windows is detected             */
#define __DV   4  /* DESQview running                */

enum{
	dtError,			/* invalid drive, letter not assigned         */
	dtFixed,			/* fixed (hard disk) drive                    */
	dtRemovable,		/* removable (floppy disk) drive              */
	dtRemote,			/* remote (network) drive                     */
	dtCDROM,			/* MSCDEX 2.00+ drive CD-ROM drive            */
	dtSubst,			/* SUBST'ed drive                             */
	dtRAM,				/* RAM drive                                  */
	dtDblSpace,			/* DoubleSpace compressed drive               */
#if 0 /* support for these detections has been removed: can't test it */
	dtStack4,			/* Stacker 4 compressed drive                 */
	dtSStor,			/* SuperStor compressed drive                 */
	dtDblDisk			/* Vertisoft DoubleDisk 2.6 compressed drive  */
	dtDiskreet,			/* Norton Diskreet drive                      */
	dtBernoully,		/* IOmega Bernoully drive                     */
#endif
	dtReadOK,			/* drive ready for reading (removable only)   */
	dtWriteOK,			/* drive ready for writing (implies reading)  */
	dtNotReady			/* drive is valid, but not ready              */
};

#ifdef __cplusplus
	extern "C" {
#endif

int  _dos_share_loaded( void );
int  _dos_detect_os( void );
void _dos_idle( void );
int  _dos_drvnum( void );
int  _dos_drvtype( int drive );
int  _dos_drvready( int drive );
int  _dos_version( void );

#ifdef __cplusplus
	}
#endif
#endif
