/*
 * PB-Lib C/C++ Library Version 0.021
 *
 * Copyright (C) 1995 by Branislav L. Slantchev
 * A product of Silicon Creations, Inc.
 *
 * See the file "copying.pbl" for licensing information.
*/

#ifndef __ASSERT_H
#define __ASSERT_H

#ifndef PB_SDK
#error "If you're not using PEX mode, then #include <assert.h>, not this!"
#endif

#ifdef __cplusplus
	extern "C" {
#endif

void __assertfail( char *msg, char *cond, char *file, int line );

#ifdef  __cplusplus
}
#endif

#undef assert

#ifdef NDEBUG
#define assert(p)   ((void)0)
#else
#define assert(p) ((p) ? (void)0 : (void) __assertfail( \
	"Assertion failed: %s, file %s, line %d\n", #p, __FILE__, __LINE__ ) )
#endif
#endif
