/*
 * PB-Lib C/C++ Library Version 0.021
 *
 * Copyright (C) 1995 by Branislav L. Slantchev
 * A product of Silicon Creations, Inc.
 *
 * See the file "copying.pbl" for licensing information.
*/

#ifndef __PBSTDC_H
#define __PBSTDC_H

#ifndef PB_SDK
#error This module cannot compile unless in PEX mode! #define PB_SDK.
#endif

#ifndef __MACDEF_H
#include <macdef.h>
#endif

#ifndef __LARGE__
#error ProBoard's SDK *requires* the large memory model!
#endif

#define EOF              -1
#define EXIT_FAILURE
#define EXIT_SUCCESS
#define BUFSIZ          512

#include <sys/__stdarg.h>

#ifdef __cplusplus
	extern "C" {
#endif

#define FAR far
#define TRUE (1)
#define FALSE (0)

#if !defined( _SIZE_T_DEFINED_ ) && !defined( _SIZE_T )
	#define _SIZE_T_DEFINED_
	#define _SIZE_T
	typedef unsigned      size_t;
#endif
typedef int           FILE;
typedef long          clock_t;
typedef long          time_t;

struct find_t              /* used by dos_findfirst() & dos_findnext() */
  {
   char     reserved[21];      /* reserved by DOS                      */
   char     attrib;            /* attribute found (FA_XXXX)            */
   unsigned time,date;         /* file's last write                    */
   unsigned long size;         /* file's size                          */
   char     name[13];          /* filename followed by 0 byte          */
  };

/* Used in dos_findfirst & dos_findnext  */
#define FA_NORMAL   0x00
#define FA_RDONLY	0x01
#define FA_HIDDEN	0x02
#define FA_SYSTEM	0x04
#define FA_LABEL	0x08
#define FA_DIREC	0x10
#define FA_ARCH		0x20

#define FP_SEG(fp)	((unsigned)((unsigned long)(fp) >> 16))
#define FP_OFF(fp)  ((unsigned)((unsigned long)(fp)))

#define MK_FP(seg,offset) ((void FAR *)(((unsigned long)(seg)<<16) | (unsigned)(offset)))

struct WREGS
   {
    unsigned ax,bx,cx,dx,si,di,cflag,flags;
   };

struct BREGS
   {
    unsigned char al,ah,bl,bh,cl,ch,dl,dh;
   };

union REGS
   {
    struct WREGS x;
    struct BREGS h;
   };

struct SREGS
   {
    unsigned es,cs,ss,ds;
   };

extern int errno;

#define ENOENT  2
#define ENOTDIR	3
#define EMFILE	4
#define EACCES	5
#define EBADF	6
#define ENOMEM	8
#define EINVAL	22
#define EEXIST	80

#define E2BIG	1000
#define ENOEXEC	1001
#define EDOM	1002
#define	ERANGE	1003

#define O_RDONLY  0
#define O_WRONLY	1
#define O_RDWR		2

#define O_NOINHERIT 0x80
#define O_DENYALL   0x10
#define O_DENYWRITE 0x20
#define O_DENYREAD  0x30
#define O_DENYNONE  0x40

#define S_IREAD  0x0100
#define S_IWRITE 0x0080

#define O_BINARY        0

#define _IOFBF  0
#define _IOLBF  1
#define _IONBF  2

#define F_OK    0       /* does file exist?     */
#define X_OK	1	/* execute permission?	*/
#define W_OK	2	/* write permission?	*/
#define R_OK	4	/* read permission?	*/

#define SEEK_SET	0	/* seek from start of file	*/
#define SEEK_CUR	1	/* relative to current position	*/
#define SEEK_END	2	/* relative to end of file	*/

struct tm
  {
   int tm_sec,         /* seconds 0..59                        */
       tm_min,         /* minutes 0..59                        */
       tm_hour,        /* hour of day 0..23                    */
       tm_mday,        /* day of month 1..31                   */
       tm_mon,         /* month 0..11                          */
       tm_year,        /* years since 1900                     */
       tm_wday,        /* day of week, 0..6 (Sunday..Saturday) */
       tm_yday,        /* day of year, 0..365                  */
       tm_isdst;       /* >0 if daylight savings time          */
                       /* ==0 if not DST                       */
                       /* <0 if don't know                     */
  };

FILE *  fopen(const char *,const char *);
FILE *  freopen(const char *,const char *,FILE *);
int     fseek(FILE *,long,int);
long    ftell(FILE *);
char *  fgets(char *,int,FILE *);
int     fgetc(FILE *);
int     fflush(FILE *);
int     fclose(FILE *);
int     fputs(const char *,FILE *);
int     getc(FILE *);
int     getchar(void);
char *  gets(char *);
int     fputc(int,FILE *);
int     putc(int,FILE *);
int     putchar(int);
int     puts(const char *);
size_t  fread(void *,size_t,size_t,FILE *);
size_t  fwrite(const void *,size_t,size_t,FILE *);
int     printf(const char *,...);
int     fprintf(FILE *,const char *,...);
int     vfprintf(FILE *,const char *,va_list);
int     vprintf(const char *,va_list);
int     sprintf(char *,const char *,...);
int     vsprintf(char *,const char *,va_list);
void    setbuf(FILE *,char *);
int     setvbuf(FILE *,char *,int,size_t);
int     remove(const char *);
int     rename(const char *,const char *);
void    rewind(FILE *);
void    clearerr(FILE *);
int     feof(FILE *);

int     isalnum(int);
int     isalpha(int);
int     iscntrl(int);
int     isdigit(int);
int     isgraph(int);
int     islower(int);
int     isprint(int);
int     ispunct(int);
int     isspace(int);
int     isupper(int);
int     isxdigit(int);
int     toupper(int);
int     tolower(int);

int     int86(int,union REGS *,union REGS *);
int     int86x(int,union REGS *,union REGS *,struct SREGS *);
int     intdos(union REGS *,union REGS *);
int     intdosx(union REGS *,union REGS *,struct SREGS *);
int     dos_findfirst(const char *, unsigned, struct find_t *);
int     dos_findnext(struct find_t *);

int     read(int,void *,unsigned);
int     write(int,const void *,unsigned);
int     open(const char *,int);
int     creat(const char *,int);
int     close(int);
int     unlink(const char *);
int     chsize(int, long);
int     dup(int);
int     dup2(int, int);
long    lseek(int,long,int);
int     access(const char *,int);
long    filelength(int);
int     isatty(int);

int     atoi(const char *);
long    atol(const char *);
long    strtol(const char *,char **,int);
int     rand(void);
void    srand(unsigned);
void *  calloc(size_t,size_t);
void    free(void *);
void *  malloc(size_t);
void *  realloc(void *,size_t);
char *  getenv(const char *);
int     putenv(const char *);
int     abs(int);
long    labs(long);

void *  memcpy(void *,const void *,size_t);
void *  memmove(void *,const void *,size_t);
char *  strcpy(char *,const char *);
char *  strncpy(char *,const char *,size_t);
char *  strcat(char *,const char *);
char *  strncat(char *,const char *,size_t);
int     memcmp(const void *,const void *,size_t);
int     strcmp(const char *,const char *);
int     strncmp(const char *,const char *,size_t);
void *  memchr(const void *,int,size_t);
char *  strchr(const char *,int);
size_t  strcspn(const char *,const char *);
char *  strpbrk(const char *,const char *);
char *  strrchr(const char *,int);
size_t  strspn(const char *,const char *);
char *  strstr(const char *,const char *);
char *  strtok(char *,const char *);
void *  memset(void *,int,size_t);
size_t  strlen(const char *);

int     memicmp(const void *,const void *,size_t);
char *  stpcpy(char *,const char *);
int     strcmpl(const char *,const char *);
int     strnicmp(const char *,const char *, size_t);
char *  strdup(const char *);
char *  strlwr(char *);
char *  strupr(char *);
char *  strnset(char *,int,size_t);
char *  strrev(char *);
char *  strset(char *,int);

#ifdef __TURBOC__
void    swab(char *,char*,int);
#else
void    swab(char *,char *,size_t);
#endif

#define strncmpl(a,b,c) strnicmp((a),(b),(c))
#define stricmp(a,b)    strcmpl((a),(b))
#define delay(a)        msleep(a)

clock_t clock(void);
time_t  time(time_t *);
time_t  mktime(struct tm *);
char *  asctime(const struct tm *);
char *  ctime(time_t *);
struct tm * localtime(const time_t *);
struct tm * gmtime(const time_t *);
size_t  strftime(char *,size_t,const char *,struct tm *);

#define difftime(t1,t2)   (((time_t)(t1) - (time_t)(t2)))

void sleep(time_t);
void usleep(unsigned long);
void msleep(unsigned long);

#ifdef __cplusplus
 }

inline void * operator new   (unsigned size)    { return malloc(size); }
inline void   operator delete(void *p)          { free(p); }

#endif
#endif
