/*
 * PB-Lib C/C++ Library Version 0.021
 *
 * Copyright (C) 1995 by Branislav L. Slantchev
 * A product of Silicon Creations, Inc.
 *
 * See the file "copying.pbl" for licensing information.
*/

#ifndef __PBSDK_H
#define __PBSDK_H

#ifndef PB_SDK
#error This module will not compile in non-PEX mode. #define PB_SDK
#endif

#define PBSDK_VERSION 202

#ifndef __PBDEFS_H
#include <sys\_pbdefs.h>
#endif
#ifndef __PBSTDC_H
#include <sys\_pbstdc.h>
#endif

#ifdef __cplusplus
 extern "C" {
#endif

/***** Long math substitution functions *****/

long l_mul(long val1,long val2);
long l_div(long val1,long val2);
long l_mod(long val1,long val2);
long l_shl(long val,unsigned s);
long l_shr(long val,unsigned s);

dword ul_div(dword val1,dword val2);
dword ul_mod(dword val1,dword val2);
dword ul_shl(dword val,word s);
dword ul_shr(dword val,word s);

#ifdef __cplusplus

	inline bool
GetFlag( dword flags, int flag )
{
	return ((flags & ul_shl(1,32-flag)) ? TRUE:FALSE );
}

	inline void
SetFlag( dword &flags, int flag )
{
	flags |= ul_shl(1,32-flag);
}

	inline void
ClearFlag( dword &flags, int flag )
{
	flags &= ~ul_shl(1,32-flag);
}

	inline void
InitMessage( MESSAGE *msg )
{
	memset( msg,0,sizeof(MESSAGE) );
}

#else /* not C++, normal #defines */

#define GetFlag(flags,flag)   (((flags) &   ul_shl(1,32-(flag)))?TRUE:FALSE)
#define SetFlag(flags,flag)   { (flags) |=  ul_shl(1,32-(flag)); }
#define ClearFlag(flags,flag) { (flags) &= ~ul_shl(1,32-(flag)); }

#endif /* if C++ */

/*
 
  Global ProBoard variables.
 
*/
extern USER_REC     * const CurUser;      /* Current user online        (R/W) */
extern int            const UserRecNr;    /* Record # of current user   (R/O) */
extern int            const NumLimits;    /* # limits in limits[] array (R/O) */
extern LIMIT  const * const Limits;       /* Limits per level           (R/O) */
extern char         * const LoginDate;    /* Login date of user         (R/W) */
extern char         * const LoginTime;    /* Login time of user         (R/W) */
extern bool           const NetEntered;   /* Netmail entered            (R/O) */
extern bool           const EchoEntered;  /* Echomail entered           (R/O) */
extern int            const NumUsers;     /* # users in userfile        (R/O) */
extern int            const NodeNumber;   /* Current node number        (R/O) */
extern char   const * const CurMenu;      /* Current menu name          (R/O) */
extern char   const * const UserFirstName;/* First name of current user (R/O) */
extern char   const * const PrevUser;     /* Name of previous user      (R/O) */
extern char   const * const StartupPath;  /* Startup path               (R/O) */
extern char   const * const SysPath;      /* ProBoard system path       (R/O) */
extern CONFIG const * const Config;       /* ProBoard config-record     (R/O) */
extern word           const PBVersion;    /* Version number of ProBoard (R/O) */
extern long           const BaudRate;     /* Baud rate (0=local)        (R/O) */
extern word           const Beta;         /* Beta nr (0xFFFF=release)   (R/O) */
extern char         * const PageReason;   /* Reason for sysop paging    (R/W) */
extern word         * const PageCount;    /* Number of sysop pages      (R/W) */

char *form(char *, ...);                         /* From old C++ streams lib */

/*
 
  Message-handling functions
 
*/
void MsgEd(void);
int  PostMessage(const char *from,const char *to,const char *subject,int area,bool pvt);
int  PostNetmail(const char *from,const char *to,const char *subject,int area,const FIDO_NODE *address,bool attach,bool crash,bool kill);
bool ReadMsgArea(int area,MSGAREA *ma);
int  NumMsgAreas(void);
long GetLastRead(int areanum , long user_recno);
void SetLastRead(int areanum , long user_recno , long msgid);
long NumMsgs(int areanum);
long HighMsg(int areanum);
long MsgNum(int areanum , long id);
long MsgId (int areanum , long num);
bool ReadMessage(MESSAGE *msg,long msgid,int areanum);
void WriteMSGTMP(const char *text);
void AppendMSGTMP(const char *text);
void ShowMessage(const MESSAGE *msg);
void CreateMessageText(const MESSAGE *msg);
void CreateMessageTextString(const MESSAGE *msg,char *text,int maxsize);
bool FirstMessage(MESSAGE *msg,int area,int order,long first);
bool NextMessage(MESSAGE *msg,int area,int order);
void DeleteMessage(MESSAGE *msg);
void MarkMessage(int area,long msgid);
void ReadMarkedMessages(void);
void ListMarkedMessages(void);
void UnMarkAllMessages(void);

/*
 
  Time-handling functions.
 
*/
void AddTime(int plusminus);
int  TimeLeft(void);
int  TimeOnline(void);
void SuspendTimer(void);
void RestartTimer(void);
void AdjustTime(void);
int  TimeUntilEvent(void);

/*
 
  Low-level undocumented functions.
 
*/
bool IO_SendByte(byte);                   /* TRUE = byte sent, FALSE = buffer full */
int  IO_ReadByte(void);                   /* Returns -1 if no byte available       */
bool IO_Carrier(void);                    /* TRUE = carrier available              */
bool IO_ByteReady(void);                  /* TRUE = byte available in input buffer */
bool IO_BufEmpty(void);                   /* TRUE = output buffer is empty         */
void IO_StartBreak(void);                 /* Start sending a break                 */
void IO_StopBreak(void);                  /* Stop sending a break                  */
void IO_DTR(bool);                        /* Set/lower DTR line (TRUE = set)       */
word IO_SendBlock(byte *buf,word size);   /* Send block of bytes, returns # bytes actually sent */
word IO_ReadBlock(byte *buf,word size);   /* Read block of bytes, returns # bytes actually read */

/*
 
  I/O functions (keyboard, screen)
 
*/
char WaitKey(void);
char WaitKeys(const char *);
KEY  ScanKey(void);
void Input(char *buf,int len,int readmode);
bool Ask(bool def);
char PeekChar(void);
void SetColor(char color);
void SetFullColor(byte color);
void GotoXY(int x,int y);
void ClrEol(void);
void EnableStop(void);
void DisableStop(void);
bool Stopped(void);
bool ExternalInput(void);
char ShowHotkeyFile(const char *fname,const char *hotkeys);
char ShowHotkeyANSIFile(const char *fname,const char *hotkeys);
bool ShowRIPscrip(char *fn);
void InitLineCounter(void);
bool LineCounter(void);
void ResetInactivity(void);
bool LocalDisplay( bool );
bool RemoteDisplay( bool );
bool RIP(void);

/*
 
  Userbase support functions.
 
*/
int  ReadUser(USER_REC *rec,long recnr);
void WriteUser(const USER_REC *rec);
bool SetUser(long recnr);

/*
 
  Filebase support functions.
 
*/
int  GetTaggedFiles(TAGGED_FILE *array,int max);
bool PutTaggedFiles(TAGGED_FILE *array,int n);
bool AddTaggedFile(TAGGED_FILE *tag);
bool RemoveTaggedFile(TAGGED_FILE *tag);
void ClearTaggedFiles();
bool IsTagged(TAGGED_FILE *tag);
int  ReadFileArea(int area,FILEAREA *ma);
int  NumFileAreas(void);

/*
 
  General functions.
 
*/
int  FuzzySearch(char *text,char *search,int degree);
char PlayMusic(const char *fname,const char *hotkeys);
void PostInfo(const char *fname);
long MemAvail(void);
void MenuFunction(int,const char *);
void Log(int loglevel,const char *fmtstring,...);
void HangUp(void);
bool CheckAccess(word level,accessflags flags);
void exit(void);
void ExitTSR(void);
int  ErrorLevel(void);
bool GetIniVar(char *fname,char *varname,char *value,int max);
bool SetIniVar(char *fname,char *varname,char *value);
int  _InstallHandler(int handler,int (*func)(void),unsigned ds);
void _RemoveHandler(int handler,int (*func)(void),unsigned ds);

#define InstallHandler(handler,func) _InstallHandler(handler,(int (*)(void))(func),FP_SEG(&NetEntered));
#define RemoveHandler(handler,func)  _RemoveHandler(handler,(int (*)(void))(func),FP_SEG(&NetEntered));

/*
 
  Undocumented functions.
 
*/
void ParseStringVars(char *input,char *result,int max_len);
int  ReadHandler(int handler, HANDLER *hnd);

#ifdef __cplusplus
 }
#endif
#endif
