/*
 * PB-Lib C/C++ Library Version 0.021
 *
 * Copyright (C) 1995 by Branislav L. Slantchev
 * A product of Silicon Creations, Inc.
 *
 * See the file "copying.pbl" for licensing information.
*/

#ifndef __PBLDEFS_H
#define __PBLDEFS_H

/*
 
             Language string numbers with symbolic constants
 
*/

/*
 
  Strings dealing with message-handling
 
*/
#define MSGINF_ABORT       0x0043  /* mesg aborted                        */
#define MSGINF_ALL         0x004F  /* all                                 */
#define MSGINF_AREAHDR     0x0107  /* select mesg area header             */
#define MSGINF_AREANO      0x0108  /* unknown mesg area                   */
#define MSGINF_END         0x0064  /* end of mesg                         */
#define MSGINF_ENTER       0x00CE  /* enter msg, space for empty line     */
#define MSGINF_ERROR       0x0042  /* error, inform sysop                 */
#define MSGINF_FOR         0x004D  /* forward                             */
#define MSGINF_FORWARD     0x0120  /* forwarding message                  */
#define MSGINF_GRPHDR      0x015E  /* select mesg group header            */
#define MSGINF_HDR         0x0069  /* mesg header info                    */
#define MSGINF_INDIV       0x0053  /* individual                          */
#define MSGINF_MARK        0x0054  /* marked                              */
#define MSGINF_MARKED      0x0060  /* mesg marked                         */
#define MSGINF_MOVE        0x011C  /* moving mesg                         */
#define MSGINF_NEW         0x0050  /* new                                 */
#define MSGINF_NEWSCAN     0x0057  /* searching for new messages          */
#define MSGINF_NOEXIST     0x005E  /* this message not found              */
#define MSGINF_NOFOUND     0x005A  /* no messages found                   */
#define MSGINF_NONE        0x004B  /* no messages in this area            */
#define MSGINF_NONEW       0x0058  /* no new mesg found                   */
#define MSGINF_NOPREV      0x0062  /* there is no previous mesg           */
#define MSGINF_NOREPLY     0x0063  /* no access to this reply             */
#define MSGINF_NOWRITE     0x002D  /* no access to this area              */
#define MSGINF_NUM         0x004A  /* there are num meas in this area     */
#define MSGINF_NUMNEW      0x0059  /* num new mesg found                  */
#define MSGINF_QSHDR       0x0066  /* quick scan list header              */
#define MSGINF_QSLINE      0x0067  /* quick scan mesg info                */
#define MSGINF_QUOTE       0x0114  /* quoting mesg                        */
#define MSGINF_REV         0x004E  /* reverese                            */
#define MSGINF_SAVE        0x0041  /* saving message                      */
#define MSGINF_SP          0x005C  /* press 'S' to stop, 'P' to pause     */
#define MSGINF_SUB         0x003E  /* mesg subject line                   */
#define MSGINF_SUBALL      0x0031  /* write 'All'if this is for everyone  */
#define MSGINF_UNMARK      0x00C8  /* unmarked all mesg                   */
#define MSGINF_WRITE       0x002C  /* write a message                     */

/*
 
  Message reader strings
 
*/
#define MSGRD_HDR             356  /* netmail message header              */
#define MSGRD_PRIVATE         357  /* private message string              */
#define MSGRD_CRASH           358  /* crash message string header         */
#define MSGRD_KILL            359  /* kill after send string              */
#define MSGRD_FILE            360  /* file attach string                  */
#define MSGRD_SENT            361  /* sent message string                 */
#define MSGRD_POSTED          362  /* message from, posted:               */
#define MSGRD_TO              363  /* message to                          */
#define MSGRD_RECV            364  /* message received                    */
#define MSGRD_RECVSTAT        365  /* message received statistic          */
#define MSGRD_SUBJLINE        366  /* message reader subject line         */
#define MSGRD_FILELINE        367  /* file line                           */
#define MSGRD_NEXT            368  /* next                                */
#define MSGRD_PREV            369  /* previous                            */
#define MSGRD_AGAIN           370  /* re-read message again               */
#define MSGRD_STOP            371  /* stop reading messages               */
#define MSGRD_MARK            372  /* mark current message                */
#define MSGRD_ANSW            373  /* reply to current message            */
#define MSGRD_UNREAD          374  /* unread current message              */
#define MSGRD_DEL             375  /* delete current message              */
#define MSGRD_ORIG            376  /* origin of thread                    */
#define MSGRD_MULTI           377  /* multi-letter prompt in reader       */

/*
 
  Message reader help
 
*/
#define MSGRH_TEXT            378  /* header of help screen               */
#define MSGRH_NEXT            379
#define MSGRH_PREV            380
#define MSGRH_AGAIN           381
#define MSGRH_STOP            382
#define MSGRH_MARK            383
#define MSGRH_REPLY           384
#define MSGRH_DELETE          385
#define MSGRH_UNREAD          386
#define MSGRH_PLUS            387
#define MSGRH_MINUS           388
#define MSGRH_ORIGINAL        389
#define MSGRH_FORWARD         390
#define MSGRH_PRIVATE         391
#define MSGRH_MOVE            392
#define MSGRH_EXPORT          393
#define MSGRH_NA              394

/*
 
  Various message prompts
 
*/
#define MSGPMT_2SYS        0x0013  /* leave message to Sysop?             */
#define MSGPMT_AREANUM     0x0105  /* enter mesg area number              */
#define MSGPMT_CHSUB       0x0113  /* change the subject?                 */
#define MSGPMT_DEL         0x005F  /* delete mesg?                        */
#define MSGPMT_DIR         0x0055  /* forward or reverse                  */
#define MSGPMT_ENTERALIAS  0x0030  /* enter alias to use                  */
#define MSGPMT_FILE        0x0061  /* export message to file              */
#define MSGPMT_FORNAME     0x011F  /* forward message to username         */
#define MSGPMT_FORSAME     0x011D  /* forward mesg in same area           */
#define MSGPMT_FORSEL      0x011E  /* select mesg area to forward mesg to */
#define MSGPMT_MNS         0x006A  /* mesg: mark, next, stop              */
#define MSGPMT_NEWAREA     0x011B  /* select mesg area to move mesg to    */
#define MSGPMT_NUMREAD     0x005D  /* read mesg num                       */
#define MSGPMT_PVT         0x0040  /* private message                     */
#define MSGPMT_QUICK       0x0065  /* quick scan mesg                     */
#define MSGPMT_READ        0x004C  /* read messages                       */
#define MSGPMT_REPALIAS    0x0111  /* reply to mesg using your alias      */
#define MSGPMT_REPALIASANY 0x0112  /* reply to mesg using any alias       */
#define MSGPMT_SCAN        0x0068  /* scan mesg                           */
#define MSGPMT_SEARCH      0x0052  /* search for text                     */
#define MSGPMT_SELECT      0x0051  /* selected                            */
#define MSGPMT_START       0x0056  /* start at mesg number                */
#define MSGPMT_SUB         0x003F  /* enter mesg subject                  */
#define MSGPMT_USEALIAS    0x002E  /* write message with personal alias   */
#define MSGPMT_USEANYALIAS 0x002F  /* write a message using any alias     */
#define MSGPMT_WAIT        0x005B  /* wait after each mesg                */
#define MSGPMT_WRITETO     0x0032  /* write to                            */
#define MSGPMT_WRITEUSR    0x0033  /* write mesg to user                  */

/*
 
  Strings dealing with the line message editor
 
*/
#define MSGED_CONT         0x00D3  /* continue                            */
#define MSGED_DELLINE      0x00D5  /* delete lines                        */
#define MSGED_LIST         0x00D0  /* list                                */
#define MSGED_NEWLINE      0x00DE  /* line now reads                      */
#define MSGED_NUMDEL       0x00D8  /* number of lines deleted             */
#define MSGED_SAVE         0x00D1  /* save                                */
#define MSGED_TXTNONE      0x00DC  /* text not found                      */
#define MSGED_ABORT        0x00D2  /* abort mesg                          */
#define MSGED_ACTION       0x00CF  /* save,abort,cont,replace text        */
#define MSGED_DELEND       0x00D7  /* end deleting with line              */
#define MSGED_DELSTART     0x00D6  /* start deleting from line            */
#define MSGED_INS          0x00D9  /* insert text before line             */
#define MSGED_LINE         0x00D4  /* edit line                           */
#define MSGED_REPLACE      0x00DA  /* replace text in line                */
#define MSGED_REPLBY       0x00DD  /* replacement text                    */
#define MSGED_REPLTXT      0x00DB  /* text to replace                     */

/*
 
  Strings dealing with file handling messages
 
*/
#define FILE_AREAHDR       0x010A  /* select file area header             */
#define FILE_AREANO        0x010B  /* unknown file area                   */
#define FILE_BYE           0x0080  /* goodbye                             */
#define FILE_COPY          0x0082  /* copying file to local drive         */
#define FILE_DESC          0x00C3  /* description for uploads header      */
#define FILE_DL            0x0078  /* download                            */
#define FILE_DLDELAY       0x006D  /* can't download yet due to delay     */
#define FILE_DLHDR         0x006C  /* download files header               */
#define FILE_DLLIST        0x006F  /* enter files to D/L                  */
#define FILE_DLNO          0x006E  /* no downloading at this time         */
#define FILE_DUPE          0x00C0  /* duplicate                           */
#define FILE_DUPEDEL       0x00BF  /* duplicate: deleted                  */
#define FILE_END           0x008B  /* end of listing                      */
#define FILE_EOS           0x008E  /* end of search                       */
#define FILE_ERROR         0x0083  /* error                               */
#define FILE_EXCEED        0x0075  /* exceeds limit                       */
#define FILE_FREE          0x0079  /* free file                           */
#define FILE_GRPHDR        0x015D  /* select file group header            */
#define FILE_HDR           0x0073  /* file/size/area list header          */
#define FILE_KEYSRCH       0x008D  /* searching for keyword               */
#define FILE_LINE          0x0074  /* file/size/area info line            */
#define FILE_NAMESRCH      0x0092  /* searching for file name             */
#define FILE_NEWDATE       0x0090  /* searching for new files since       */
#define FILE_NONE          0x007C  /* no files found                      */
#define FILE_NOPVT         0x0072  /* no private files found              */
#define FILE_NORECV        0x00C2  /* no files received                   */
#define FILE_NOSPACE       0x00B7  /* not enough space on upload drive    */
#define FILE_NOTIME        0x007E  /* no time left to complete D/L        */
#define FILE_NOUP          0x00B8  /* due to event, you can't upload      */
#define FILE_NOXFER        0x0085  /* num files not transferred           */
#define FILE_PROTO         0x0081  /* activating protocol                 */
#define FILE_PVTCHECK      0x00FF  /* checking for personal files         */
#define FILE_PVTFROM       0x0101  /* from user                           */
#define FILE_PVTWAIT       0x0100  /* there are personal files waiting    */
#define FILE_QUIT          0x007B  /* quit                                */
#define FILE_RECV          0x00BE  /* file received                       */
#define FILE_RECVSUM       0x00C1  /* num files received                  */
#define FILE_SEARCH        0x0071  /* searching file database             */
#define FILE_SKIP          0x007A  /* skipped                             */
#define FILE_SP            0x008A  /* listing hdr, s to stop, p to pause  */
#define FILE_SUM           0x007D  /* num files selected, D/L time est.   */
#define FILE_TAGCLEAR      0x00F8  /* all tags clreared                   */
#define FILE_TAGLIST       0x00F6  /* files tagged                        */
#define FILE_UP            0x00B6  /* upload files                        */
#define FILE_UPCHECK       0x00BD  /* checking files                      */
#define FILE_UPNONE        0x00BC  /* no files received                   */
#define FILE_UPREADY       0x00BB  /* ready to receive files              */
#define FILE_UPREQ         0x0076  /* upload required                     */
#define FILE_XFERSUM       0x0084  /* num files transferred successfully  */
#define FILE_SCAN          0x0162  /* scanning uploads                    */
#define FILE_REJECT        0x0163  /* files rejected by the upload scan   */

/*
 
  File handling prompts.
 
*/
#define FILPMT_AREANUM     0x0109  /* enter file area number              */
#define FILPMT_DESC        0x00C5  /* enter description for file          */
#define FILPMT_DESC2       0x00C6  /* next line of description            */
#define FILPMT_DLNAME      0x0070  /* file name to D/L?                   */
#define FILPMT_DSQ         0x0077  /* file d/l, skip, quit?               */
#define FILPMT_EOSCTE      0x015C  /* end of list, cont, tag, edit        */
#define FILPMT_HANG        0x0086  /* press 'C' to cont, 'H' to hangup    */
#define FILPMT_KEYSRCH     0x008C  /* keyword search                      */
#define FILPMT_MORE        0x0087  /* more? yes, no, cont, tag, edit      */
#define FILPMT_NAMESRCH    0x0091  /* enter filename to search for        */
#define FILPMT_NEWDATE     0x008F  /* listing new files, enter date       */
#define FILPMT_TAG         0x0089  /* num files tagged, press enter       */
#define FILPMT_TAGCHAR     0x0088  /* enter tag characters                */
#define FILPMT_TAGEDIT     0x00F7  /* tag,untag,quit edit taglist         */
#define FILPMT_UNTAG       0x00F9  /* enter file num to untag             */
#define FILPMT_UPNAME      0x00B9  /* file name to upload                 */
#define FILPMT_UPSTART     0x00BA  /* start upload or abort               */
#define FILPMT_USR         0x00C4  /* enter username for file             */
#define FILPMT_XFER        0x007F  /* xfer start, goodbye, abort          */
#define FILPMT_DOWNLOAD    0x0161  /* download now?                       */

/*
 
  Strings dealing with protocols
 
*/
#define PROTO_AVAIL        0x0102  /* available protocols                 */
#define PROTO_NOSEL        0x0103  /* don't select a protocol             */
#define PROTO_SEL          0x0104  /* choose a protocol                   */

/*
 
  Strings dealing with mail
 
*/
#define MAIL_ALLOFF        0x00F5  /* all areas disabled                  */
#define MAIL_ALLON         0x00F4  /* all areas enabled                   */
#define MAIL_CHECKING      0x00FC  /* checking the mailbox                */
#define MAIL_MARK          0x00FE  /* mesg were marked                    */
#define MAIL_NONE          0x00FD  /* mailbox is empty                    */
#define MAIL_QWK           0x00F1  /* select combined/QWK areas           */
#define MAIL_SEL           0x00F0  /* select areas to include in mailscan */
#define MAIL_WAIT          0x00FA  /* following mail is waiting for you   */
#define MAIL_ACTION        0x00FB  /* read,list,cont                      */
#define MAIL_ALL           0x00F3  /* enable/disable all areas            */
#define MAIL_CHECK         0x000A  /* check for mail?                     */
#define MAIL_TOGGLE        0x00F2  /* select area numbers to toggle       */

/*
 
  Strings dealing with Top Statistics
 
*/
#define TOPS_CALL          0x012F  /* top callers header                  */
#define TOPS_CALLNUM       0x0130  /* top callers num calls               */
#define TOPS_DLKB          0x0131  /* top downloaders KB                  */
#define TOPS_DLKBNUM       0x0132  /* top downloaders num KB              */
#define TOPS_DLFILE        0x0133  /* top downloaders file                */
#define TOPS_DLFILENUM     0x0134  /* top downloaders num files           */
#define TOPS_UPKB          0x0135  /* top uploaders KB                    */
#define TOPS_UPKBNUM       0x0136  /* top uploaders num KB                */
#define TOPS_UPFILE        0x0137  /* top uploaders files                 */
#define TOPS_UPFILENUM     0x0138  /* top uploaders num files             */
#define TOPS_MSG           0x0139  /* top message writers                 */
#define TOPS_MSGNUM        0x013A  /* top message writers, num mesg       */
#define TOPS_TOTAL         0x013B  /* top total time online               */
#define TOPS_TOTALNUM      0x013C  /* top total time online num           */

/*
 
  Strings dealing with netmail
 
*/
#define NET_ADDRHDR        0x0037  /* enter net address info header       */
#define NET_NET            0x010D  /* net, name, location, cost           */
#define NET_NOCREDIT       0x003A  /* not enough netmail credit left      */
#define NET_NODE           0x010E  /* node, name, location, cost          */
#define NET_NONODE         0x010F  /* node number not found               */
#define NET_ZONE           0x010C  /* zone, name, location, cost          */
#define NET_ADDR           0x0038  /* enter net destination address       */
#define NET_ATTACH         0x003C  /* attach a file to this mesg          */
#define NET_CRASH          0x003B  /* send mesg with crash priority       */
#define NET_FILE           0x003D  /* name of file to attach              */
#define NET_CREDITS        0x0039  /* node x (n credits) Ok?              */

/*
 
  Strings dealing with chatting
 
*/
#define CHAT_CALL          0x00EC  /* calling other node                  */
#define CHAT_END           0x0046  /* chat ended                          */
#define CHAT_ENDMODE       0x014A  /* end of chat mode                    */
#define CHAT_GONE          0x00EF  /* other person disappeared            */
#define CHAT_HDR           0x00EA  /* multiline chat header               */
#define CHAT_HELLO         0x0149  /* hello, here's your sysop            */
#define CHAT_NONODE        0x00ED  /* requested node not available        */
#define CHAT_STARTML       0x0045  /* multiline chat started              */
#define CHAT_START         0x00EE  /* chat started                        */
#define CHAT_PAGELEN       0x00CC  /* you must enter at least num chars   */
#define CHAT_PAGEMANY      0x00C9  /* you paged too many times            */
#define CHAT_PAGENO        0x00CD  /* sysop is not responding             */
#define CHAT_PAGENOSYS     0x00CA  /* sysop is not available              */
#define CHAT_NODEREQ       0x00EB  /* enter node number to chat with      */
#define CHAT_REQ           0x0044  /* user at node requests chat, chat?   */
#define CHAT_PAGEREASON    0x00CB  /* reason for page                     */

/*
 
  Strings dealing with changing settings
 
*/
#define SET_ANSIOFF        0x009A  /* ansi now disabled                   */
#define SET_ANSION         0x0099  /* ansi now enabled                    */
#define SET_AVT0OFF        0x009E  /* avatar/0+ now disabled              */
#define SET_AVT0ON         0x009D  /* avatar/0+ now enabled               */
#define SET_AVTOFF         0x009C  /* avatar disabled                     */
#define SET_AVTON          0x009B  /* avatar now enabled                  */
#define SET_CHDATE         0x0156  /* change date format                  */
#define SET_CHPWD          0x00B1  /* change password header              */
#define SET_CHPWDOK        0x00B3  /* password changed successfully       */
#define SET_CLSOFF         0x00A2  /* clear screen disabled               */
#define SET_CLSON          0x00A1  /* clear screen enabled                */
#define SET_DATEAVAIL      0x0152  /* available date formats              */
#define SET_DATESEL        0x0153  /* select date format                  */
#define SET_FSEDOFF        0x00A0  /* line-editor enabled                 */
#define SET_FSEDON         0x009F  /* full-screen editor enabled          */
#define SET_HOTKEYOFF      0x00A8  /* hotkeys disabled                    */
#define SET_HOTKEYON       0x00A7  /* hotkeys enabled                     */
#define SET_IBMOFF         0x00A6  /* extended ASCII disabled             */
#define SET_IBMON          0x00A5  /* extended ASCII enabled              */
#define SET_INVALID        0x014E  /* invalid input                       */
#define SET_LANGAVAIL      0x014B  /* available languages                 */
#define SET_LANGRLOAD      0x014D  /* loading language file               */
#define SET_LARGEFONT      0x00AF  /* large RIP font selected             */
#define SET_MOREOFF        0x00A4  /* more disabled                       */
#define SET_MOREON         0x00A3  /* more enabled                        */
#define SET_RIPOFF         0x00AA  /* RIP disabled                        */
#define SET_RIPON          0x00A9  /* RIP enabled                         */
#define SET_SEXFEMALE      0x0158  /* female                              */
#define SET_SEXMALE        0x0157  /* male                                */
#define SET_SEXUNKNOWN     0x0159  /* unknown                             */
#define SET_SMALLFONT      0x00B0  /* small RIP font selected             */

#define CNG_ALIAS          0x0097  /* change alias                        */
#define CNG_CITY           0x0093  /* change city                         */
#define CNG_COUNTRY        0x015B  /* change country                      */
#define CNG_DATA           0x0095  /* change data phone number            */
#define CNG_FAX            0x0154  /* change fax number                   */
#define CNG_MAILADDRESS    0x0155  /* change mailing address              */
#define CNG_PWD            0x00B2  /* enter new password                  */
#define CNG_SCRLEN         0x0098  /* change screen length                */
#define CNG_STATE          0x0096  /* change state                        */
#define CNG_VOICE          0x0094  /* change voice phone number           */

#define PMT_COUNTRY        0x015A  /* enter country                       */
#define PMT_FAXNUM         0x014F  /* enter FAX phone number              */
#define PMT_LANGSEL        0x014C  /* select a language                   */
#define PMT_MAILADDRESS    0x0150  /* enter mailing address               */
#define PMT_SEX            0x0151  /* enter sex                           */
#define PMT_USEHOTKEYS     0x00AB  /* use hotkeys                         */
#define PMT_USEIBM         0x00AC  /* use extended ASCII                  */
#define PMT_USELARGEFONT   0x00AE  /* use large RIP font                  */
#define PMT_USERIP         0x00AD  /* use RIP                             */

/*
 
  Login sequence and new user prompt
 
*/
#define LOGIN_BADNAME      0x000F  /* illegal name                        */
#define LOGIN_DUPEALIAS    0x0027  /* this alias is already taken         */
#define LOGIN_EVENT        0x0008  /* event has to run                    */
#define LOGIN_FIRSTLAST    0x0010  /* must enter first and last name      */
#define LOGIN_LEVELEXP     0x0015  /* level has expired                   */
#define LOGIN_LEVELWARN    0x0016  /* level will expire in num days       */
#define LOGIN_LOCKED       0x0017  /* locked out of the system            */
#define LOGIN_NODEACCESS   0x0012  /* no access to this node              */
#define LOGIN_NONEW        0x0019  /* node not available to new users     */
#define LOGIN_PVTSYS       0x0018  /* private system                      */
#define LOGIN_SCAN         0x0002  /* scanning userbase                   */
#define LOGIN_TIMEADJUST   0x0009  /* due to event, time adjusted         */
#define LOGIN_WRONGPWD     0x000E  /* wrong password                      */
#define LOGIN_ALIAS        0x0026  /* enter alias to use                  */

#define NEW_ALLCORRECT     0x002B  /* answer everything correctly         */
#define NEW_ANSI           0x001A  /* ansi emulation?                     */
#define NEW_AVATAR         0x001B  /* avatar emulation                    */
#define NEW_AVATAR0        0x001C  /* avatar/0+ support                   */
#define NEW_BADPWD         0x0029  /* illegal name                        */
#define NEW_CALLCITY       0x0021  /* city calling from                   */
#define NEW_CALLSTATE      0x0022  /* state calling from                  */
#define NEW_CLEAR          0x001E  /* send CLS codes                      */
#define NEW_DATANUM        0x0024  /* data phone number                   */
#define NEW_DOB            0x0025  /* date of birth?                      */
#define NEW_FSED           0x001D  /* use full-screen editor              */
#define NEW_NAME           0x0001  /* enter name                          */
#define NEW_NEWPWD         0x0028  /* enter password to use               */
#define NEW_NEWUSER        0x0011  /* name not found, new user?           */
#define NEW_NUMLINES       0x0020  /* number of lines per screen          */
#define NEW_PWD            0x0003  /* enter password                      */
#define NEW_SYSPWD         0x000D  /* enter system password               */
#define NEW_VERPWD         0x002A  /* enter password again (verify)       */
#define NEW_VOICENUM       0x0023  /* voice phone number                  */
#define NEW_WAIT           0x001F  /* wait at end of screen               */

/*
 
  Strings dealing with statistics
 
*/
#define STAT_HDR           0x0121  /* statistics header                   */
#define STAT_ONLINETM      0x0122  /* time online                         */
#define STAT_LEFTTM        0x0123  /* time left                           */
#define STAT_FREETM        0x0124  /* free time received this call        */
#define STAT_USEDTM        0x0125  /* time already used today             */
#define STAT_LIMITTM       0x0126  /* daily time limit                    */
#define STAT_LIMITDL       0x0127  /* daily download limit                */
#define STAT_LEFTDL        0x0128  /* downloads left today                */
#define STAT_KBDL          0x0129  /* kbytes D/L to date                  */
#define STAT_KBUP          0x012A  /* kbytes U/L to date                  */
#define STAT_NEEDKB        0x012B  /* kbytes upload needed                */
#define STAT_FREEDL        0x012C  /* free D/L without U/L                */
#define STAT_LAST          0x012D  /* last time called                    */
#define STAT_TOTAL         0x012E  /* total calls                         */

/*
 
  Strings dealing with user online status
 
*/
#define USERON_STATUS      0x013D  /* user online: node,name,city,status  */
#define USERON_BROWSE      0x013E  /* user online: browsing               */
#define USERON_CHAT        0x013F  /* user online: chatting               */
#define USERON_OFF         0x0140  /* user online: offline                */
#define USERON_SHELL       0x0141  /* user online: in shell               */
#define USERON_BUSY        0x0142  /* user online: busy                   */
#define USERON_NONE        0x0143  /* user online: none                   */

/*
 
  Strings dealing with user listing
 
*/
#define LIST_HEADER        0x0034  /* name, location, country/state       */
#define LIST_FOOTER        0x0035 /* a straight line */
#define LIST_NOTFOUND      0x0036  /* user not located on system          */
#define LIST_TXTSRCH       0x00B4  /* text to search in userlist          */
#define LIST_END           0x00B5  /* end of user list                    */
#define LIST_CALLSUM       0x00C7  /* user, calling/num calls, id         */

/*
 
  Strings dealing with viewing archives
 
*/
#define ARC_PROMPT         0x00DF  /* name of archive to view             */
#define ARC_NOTFOUND       0x00E0  /* this file could not be found        */
#define ARC_NAME           0x00E1  /* file name                           */
#define ARC_DATE           0x00E2  /* file date                           */
#define ARC_TIME           0x00E3  /* file time                           */
#define ARC_ORIGSZ         0x00E4  /* file original size                  */
#define ARC_CMPSZ          0x00E5  /* file compressed size                */

/*
 
  Strings dealing with viewing GIF files
 
*/
#define GIF_PROMPT         0x0115  /* show GIF file info                  */
#define GIF_NAME           0x0116  /* file name of GIF                    */
#define GIF_RES            0x0117  /* file resolution                     */
#define GIF_COLORS         0x0118  /* number of colors                    */

/*
 
  Strings with various message and default prompts
 
*/
#define DEF_FATAL          0x0047  /* fatal error, inform Sysop           */
#define DEF_HANGUP         0x0014  /* hanging up                          */
#define DEF_LOCKAREA       0x0049  /* area locked by another node         */
#define DEF_NO             0x0006  /* No                                  */
#define DEF_NOACCESS       0x0048  /* access denied                       */
#define DEF_TIMEINACTIVE   0x00E8  /* inactive, logging off               */
#define DEF_TIMELEFT       0x00E7  /* only num min remaining              */
#define DEF_TIMEUP         0x00E6  /* time limit exceeded                 */
#define DEF_TIMEWARN       0x00E9  /* inactivity warning                  */
#define DEF_WAITEND        0x0148  /* sysop is back                       */
#define DEF_WAITLOAD       0x0146  /* please wait, loading                */
#define DEF_WAITMOMENT     0x0145  /* one moment, please                  */
#define DEF_WAITSHELL      0x0147  /* sysop is shelling                   */
#define DEF_YES            0x0005  /* Yes                                 */
#define DEF_DIRSHOW        0x0144  /* directory to show                   */
#define DEF_ENTER          0x0007  /* press enter                         */
#define DEF_ENTERLIST      0x0106  /* enter = list                        */
#define DEF_MORE           0x0004  /* more? yes,no, etc.                  */
#define DEF_NOYES          0x000C  /* No, yes?                            */
#define DEF_YESNO          0x000B  /* Yes, no?                            */

/*
 
  Miscellaneous strings.
 
*/
#define MISC_GROUPNO       0x0160  /* unknown group                       */
#define MISC_BULLETIN      0x0119  /* enter bulletin number               */
#define MISC_BULNOTFOUND   0x011A  /* bulletin not found                  */
#define MISC_FILESHOW      0x0110  /* enter filename to display           */
#define MISC_GROUPNUM      0x015F  /* enter group num                     */
#define MISC_MNUPWD        0x006B  /* enter menu password                 */

#endif
