/*
 * PB-Lib C/C++ Library Version 0.021
 *
 * Copyright (C) 1995 by Branislav L. Slantchev
 * A product of Silicon Creations, Inc.
 *
 * See the file "copying.pbl" for licensing information.
*/

#ifndef __PBDEFS_H
#define __PBDEFS_H

#ifndef __TYPEDEF_H
#include <typedef.h>
#endif

/*
 
  ProBoard native types
 
*/
typedef byte     DateType[3];
typedef byte     TimeType[3];
typedef byte     TimeFrame[7][6];
typedef byte     combinedboards[125];
typedef word     KEY;
typedef dword    accessflags;
typedef DateType Date;
typedef TimeType Time;

/*
 
  Modes for Input()
 
*/
#define INPUT_ALL       0
#define INPUT_UPFIRST   1
#define INPUT_UPALL     2
#define INPUT_DIGITS    3
#define INPUT_PWD      64   /* OR */
#define INPUT_NOFIELD 128   /* OR */

/*
 
  Parameters for SetColor()
 
*/
#if 0 /* skip it: we use COLORS defined in <sys/__conio.h> instead */
/* note that the mapping is somewhat different and not compatible  */
#ifdef PB_SDK
#define BLACK   0x00
#define RED     0x01
#define GREEN   0x02
#define YELLOW  0x03
#define MAGENTA 0x04
#define BLUE    0x05
#define CYAN    0x06
#define WHITE   0x07
#define BLINK   0x10   /* OR together for flashing colors      */
#endif
#endif

/*
 
  Parameters for MenuFunction()
 
*/
#define MENU_GOTOMENU            1
#define MENU_GOSUBMENU           2
#define MENU_PREVMENU            3
#define MENU_GOTOMENUCLEAR       4
#define MENU_SHOWANSASC          5
#define MENU_COUNTRY_CHANGE      6
#define MENU_SHELL               7
#define MENU_VERSION_INFO        8
#define MENU_LOGOFF              9
#define MENU_USAGE_GRAPH        10
#define MENU_PAGESYSOP          11
#define MENU_QUESTIONNAIRE      12
#define MENU_USER_LIST          13
#define MENU_TIME_STAT          14
#define MENU_VIEW_ANS_WAIT      15
#define MENU_CITY_CHANGE        16
#define MENU_PASSWORD_CHANGE    17
#define MENU_LINES_CHANGE       18
#define MENU_CLS_TOGGLE         19
#define MENU_PAUSE_TOGGLE       20
#define MENU_ANSI_TOGGLE        21
#define MENU_MAILCHECK          22
#define MENU_READMSG            23
#define MENU_SCAN_MSG           24
#define MENU_QSCAN_MSG          25
#define MENU_DAYS_GRAPH         26
#define MENU_WRITEMSG           27
#define MENU_COMBINED_SELECT    28
#define MENU_WEEKS_GRAPH        29
#define MENU_RAW_DIR            30
#define MENU_LIST_FILES         31
#define MENU_DOWNLOAD           32
#define MENU_UPLOAD             33
#define MENU_LIST_ARCHIVE       34
#define MENU_KEYWORD_SEARCH     35
#define MENU_FILENAME_SEARCH    36
#define MENU_NEW_FILES          37
#define MENU_VIEW_FILE          38
#define MENU_VIEW_NAMED_FILE    39
#define MENU_FSED_TOGGLE        41
#define MENU_HOTKEY_TOGGLE      42
#define MENU_CLEARMARKED        43
#define MENU_COMBINED_CLEAR     44
#define MENU_VIEW_FILE_WAIT     45
#define MENU_CHANGE_ACCESS      46
#define MENU_LOGENTRY           47
#define MENU_TOPS               48
#define MENU_SET_MSGAREA        49
#define MENU_SHOW_USERS_ONLINE  50
#define MENU_LASTCALLERS        51
#define MENU_USEREDITOR         52
#define MENU_MULTICHAT          53
#define MENU_SET_FILEAREA       54
#define MENU_VIEW_GIF           55
#define MENU_IBM_TOGGLE         56
#define MENU_PHONE_CHANGE       57
#define MENU_DATAPHONE_CHANGE   58
#define MENU_HANDLE_CHANGE      59
#define MENU_RUN_SDKFILE        60
#define MENU_SHOW_BULLETIN      61
#define MENU_AVT0               62
#define MENU_AVT1               63
#define MENU_SHOW_GRAPH         64
#define MENU_RIP_FONT           66
#define MENU_RIP_GRAPHICS       67
#define MENU_EDIT_TAGGED            68
#define MENU_SELECT_LANGUAGE        69
#define MENU_CHANGE_DATE_FORMAT     70
#define MENU_CHANGE_MAILING_ADDRESS 71
#define MENU_CHANGE_FAX_NUMBER      72
#define MENU_CHANGE_COUNTRY         73

/*
 
  Keyboard handler modes and return values
 
*/
#define HANDLER_SYSOPKEY  6
#define HANDLER_HANGUP    7
#define HANDLED           1
#define NOT_HANDLED       0

/*
 
  Modes for Log()
 
*/
#define LOG_FRIEND     0
#define LOG_NORMAL     1
#define LOG_SUSPICIOUS 2
#define LOG_DANGEROUS  3

/*
 
  Codes for ScanKey()
 
*/
#define KEY_F1   0x3B00U
#define KEY_F2   0x3C00U
#define KEY_F3   0x3D00U
#define KEY_F4   0x3E00U
#define KEY_F5   0x3F00U
#define KEY_F6   0x4000U
#define KEY_F7   0x4100U
#define KEY_F8   0x4200U
#define KEY_F9   0x4300U
#define KEY_F10  0x4400U

#define KEY_SF1   0x5400U
#define KEY_SF2   0x5500U
#define KEY_SF3   0x5600U
#define KEY_SF4   0x5700U
#define KEY_SF5   0x5800U
#define KEY_SF6   0x5900U
#define KEY_SF7   0x5A00U
#define KEY_SF8   0x5B00U
#define KEY_SF9   0x5C00U
#define KEY_SF10  0x5D00U

#define KEY_CF1   0x5E00U
#define KEY_CF2   0x5F00U
#define KEY_CF3   0x6000U
#define KEY_CF4   0x6100U
#define KEY_CF5   0x6200U
#define KEY_CF6   0x6300U
#define KEY_CF7   0x6400U
#define KEY_CF8   0x6500U
#define KEY_CF9   0x6600U
#define KEY_CF10  0x6700U

#define KEY_AF1   0x6800U
#define KEY_AF2   0x6900U
#define KEY_AF3   0x6A00U
#define KEY_AF4   0x6B00U
#define KEY_AF5   0x6C00U
#define KEY_AF6   0x6D00U
#define KEY_AF7   0x6E00U
#define KEY_AF8   0x6F00U
#define KEY_AF9   0x7000U
#define KEY_AF10  0x7100U

#define KEY_ALT1 0x7800U
#define KEY_ALT2 0x7900U
#define KEY_ALT3 0x7A00U
#define KEY_ALT4 0x7B00U
#define KEY_ALT5 0x7C00U
#define KEY_ALT6 0x7D00U
#define KEY_ALT7 0x7E00U
#define KEY_ALT8 0x7F00U
#define KEY_ALT9 0x8000U
#define KEY_ALT0 0x8100U

#define KEY_ALTA 0x1E00U
#define KEY_ALTB 0x3000U
#define KEY_ALTC 0x2E00U
#define KEY_ALTD 0x2000U
#define KEY_ALTE 0x1200U
#define KEY_ALTF 0x2100U
#define KEY_ALTG 0x2200U
#define KEY_ALTH 0x2300U
#define KEY_ALTI 0x1700U
#define KEY_ALTJ 0x2400U
#define KEY_ALTK 0x2500U
#define KEY_ALTL 0x2600U
#define KEY_ALTM 0x3200U
#define KEY_ALTN 0x3100U
#define KEY_ALTO 0x1800U
#define KEY_ALTP 0x1900U
#define KEY_ALTQ 0x1000U
#define KEY_ALTR 0x1300U
#define KEY_ALTS 0x1F00U
#define KEY_ALTT 0x1400U
#define KEY_ALTU 0x1600U
#define KEY_ALTV 0x2F00U
#define KEY_ALTW 0x1100U
#define KEY_ALTX 0x2D00U
#define KEY_ALTY 0x1500U
#define KEY_ALTZ 0x2C00U

#define KEY_CTLA 0x0001U
#define KEY_CTLB 0x0002U
#define KEY_CTLC 0x0003U
#define KEY_CTLD 0x0004U
#define KEY_CTLE 0x0005U
#define KEY_CTLF 0x0006U
#define KEY_CTLG 0x0007U
#define KEY_CTLH 0x0008U
#define KEY_CTLI 0x0009U
#define KEY_CTLJ 0x000AU
#define KEY_CTLK 0x000BU
#define KEY_CTLL 0x000CU
#define KEY_CTLM 0x000DU
#define KEY_CTLN 0x000EU
#define KEY_CTLO 0x000FU
#define KEY_CTLP 0x0010U
#define KEY_CTLQ 0x0011U
#define KEY_CTLR 0x0012U
#define KEY_CTLS 0x0013U
#define KEY_CTLT 0x0014U
#define KEY_CTLU 0x0015U
#define KEY_CTLV 0x0016U
#define KEY_CTLW 0x0017U
#define KEY_CTLX 0x0018U
#define KEY_CTLY 0x0019U
#define KEY_CTLZ 0x001AU

#define KEY_DEL  0x5300U
#define KEY_INS  0x5200U
#define KEY_HOME 0x4700U
#define KEY_END  0x4F00U

#define KEY_PGUP 0x4900U
#define KEY_PGDN 0x5100U
#define KEY_UP   0x4800U
#define KEY_DN   0x5000U
#define KEY_LT   0x4B00U
#define KEY_RT   0x4D00U

#define KEY_ESC  0x001BU
#define KEY_ENT  0x000DU
#define KEY_RET  0x000DU
#define KEY_TAB  0x0009U
#define KEY_STAB 0x0F00U
#define KEY_CPGUP 0x8400U
#define KEY_CPGDN 0x7600U

/*
 
  Flags for GetFlag(), SetFlag and ClearFlag()
 
*/
#define FLAG_A 1
#define FLAG_B 2
#define FLAG_C 3
#define FLAG_D 4
#define FLAG_E 5
#define FLAG_F 6
#define FLAG_G 7
#define FLAG_H 8
#define FLAG_I 9
#define FLAG_J 10
#define FLAG_K 11
#define FLAG_L 12
#define FLAG_M 13
#define FLAG_N 14
#define FLAG_O 15
#define FLAG_P 16
#define FLAG_Q 17
#define FLAG_R 18
#define FLAG_S 19
#define FLAG_T 20
#define FLAG_U 21
#define FLAG_V 22
#define FLAG_W 23
#define FLAG_X 24
#define FLAG_Y 25
#define FLAG_Z 26
#define FLAG_1 27
#define FLAG_2 28
#define FLAG_3 29
#define FLAG_4 30
#define FLAG_5 31
#define FLAG_6 32


/*
 
  USER_REC
 
*/
#define UFLAG_DELETED    (0x00000001L) /*  0 User deleted                */
#define UFLAG_ANSI       (0x00000002L) /*  1 ANSI mode ON                */
#define UFLAG_PAUSE      (0x00000004L) /*  2 Pause mode ON               */
#define UFLAG_CLEAR      (0x00000008L) /*  3 Screenclear mode ON         */
#define UFLAG_HOTKEYS    (0x00000010L) /*  4 Hotkeys?                    */
#define UFLAG_NOIBM      (0x00000020L) /*  5 User has no IBM-graphics    */
#define UFLAG_FSED       (0x00000040L) /*  6 Fullscreen editor used      */
#define UFLAG_NOKILL     (0x00000080L) /*  7 Do not kill user            */
#define UFLAG_IGNORE     (0x00000100L) /*  8 Ignore DL-hours             */
#define UFLAG_ATTEN      (0x00000200L) /*  9 Attention flag              */
#define UFLAG_NOTOPS     (0x00000400L) /* 10 Don't appear in tops        */
#define UFLAG_HIDDEN     (0x00000800L) /* 11 Hide from lists             */
#define UFLAG_QUIET      (0x00001000L) /* 12 Quiet??                     */
#define UFLAG_AVATAR     (0x00002000L) /* 13 AVT/0 codes                 */
#define UFLAG_AVTPLUS    (0x00004000L) /* 14 AVT/0+ codes                */
#define UFLAG_GUEST      (0x00008000L) /* 15 Guest account               */
#define UFLAG_PAGEPRI    (0x00010000L) /* 16 Page priority               */
#define UFLAG_LOCALONLY  (0x00020000L) /* 17 Local login only            */
#define UFLAG_MULTILOGIN (0x00040000L) /* 18 Allow multiple login        */
#define UFLAG_FREECHAT   (0x00080000L) /* 19 Freeze timer in chat        */
#define UFLAG_NORIP      (0x00100000L) /* 20 Disable RIP                 */

typedef struct{
	long         record;                /* Record number in USERS.BBS           */
	char         name[36];              /* User name                            */
	char         alias[36];             /* Alias/Handle                         */
	char         passWord[16];          /* Password                             */
	dword        passWordCRC;
	word         level;                 /* Security level                       */
	char         country[26];           /* Country                              */
	char         state[26];             /* State                                */
	char         city[26];              /* City                                 */
	char         company[51];           /* Company                              */
	char         address1[51];          /* Address line 1                       */
	char         address2[51];          /* Address line 2                       */
	char         address3[51];          /* Address line 3                       */
	char         comment[81];           /* Comment                              */
	char         forwardTo[36];         /* Forward mail to                      */
	DateType     birthDate;             /* Birthday                             */
	char         voicePhone[16];        /* Voice phone #                        */
	char         dataPhone [16];        /* Data phone #                         */
	char         faxPhone  [16];        /* Fax phone #                          */
	byte         sex;                   /* 0 = Unknown, 1 = Male, 2 = Female    */
	byte         dateFormat;            /* Date Format                          */
	byte         defaultProtocol;       /* Default protocol hotkey              */
	char         language[9];           /* Language                             */
	word         screenWidth;           /* Screen Width                         */
	word         screenLength;          /* # of lines                           */
	long         timeUsed;              /* time used today                      */
	dword        timesCalled;           /* # times called                       */
	dword        numDownloads;          /* # downloads                          */
	dword        kbDownloaded;          /* K downloaded                         */
	dword        numUploads;            /* # downloads                          */
	dword        kbUploaded;            /* K downloaded                         */
	dword        msgsPosted;            /* # messages posted                    */
	DateType     lastDate;              /* Date last called                     */
	DateType     lastTime;              /* Time last called                     */
	DateType     lastPwdChange;         /* Date of last password change         */
	DateType     lastNewFilesCheck;     /* Date of last check for new files     */
	accessflags  aFlags;                /* Access flags       (A-Z,1-6)         */
	dword        uFlags;                /* Flags (DELETED/ANSI/PAUSE/...)       */
	word         logLevel;              /* Log level of user                    */
	byte         mailCheckBoards[125];  /* Msg areas to check for mail          */
	byte         combinedBoards[125];   /* Areas to be used in combined mode    */
	dword        totalTimeUsed;         /* Total time used (minutes)            */
	DateType     expDate;               /* Expiration date                      */
	word         expLevel;              /* Fallback level after expiration      */
	accessflags  expFlagsOn;            /* Flags to be enabled after expiration */
	accessflags  expFlagsOff;           /* Flags to be disabled after expiration*/
	DateType     firstDate;             /* Date of first login                  */
	long         kbToday;               /* K downloaded today                   */
	long         credit;                /* Netmail credit                       */
	long         pending;               /* Netmail credit pending               */
	word         fileArea;              /* Last file area accessed              */
	word         msgArea;               /* Last msg area accessed               */
	int          tbTimeBalance;         /* Time balance           (Time Bank)   */
	int          tbKbBalance;           /* Kbyte balance          (Time Bank)   */
	int          tbTimeWithdrawn;       /* Time withdrawn today   (Time Bank)   */
	int          tbKbWithdrawn;         /* Kbytes withdrawn today (Time Bank)   */
	word         tbTimeDeposited;
	word         tbKbDeposited;
	word         tbTimeLoaned;
	word         tbKbLoaned;
	DateType     tbLastUsed;            /* Date last used         (Time Bank)   */
	byte         checkMail;             /* Check for mail at logon              */
	byte         checkNewFiles;         /* Check for new files at logon         */
	dword        highMsgRead;
	word         qwkMaxMsgsPerArea;
	word         qwkMaxMsgs;
	byte         qwkArchiver;
	byte         ripFont;
	DateType     tbTimePayback;
	DateType     tbKbPayback;
	word         fileGroup;
	word         msgGroup;
	byte         extra[390];
} USER_REC;


/*
 
  LIMITS.PRO
 
*/
typedef struct{
   word     level;            /* User Level                            */
   int      timelimit;        /* Time Limit                            */
   int      daily_klimit;     /* Daily download limit                  */
   int      pre_download;     /* Pre-download time limit               */
   char     id[6];            /* Usergroup ID                          */
   unsigned free;             /* Free upload in Kb.                    */
   byte     factor;           /* Percentage upload required            */
   unsigned max_download;     /* Max download for this level           */
   word     fallto;           /* Fall to level x when max. reached     */
   int      msgfactor;        /* # Kbytes granted per message written  */
   char extra[5];
} LIMIT;

/*
 
  FILECFG.PRO
 
*/
typedef struct{
	  char        name[80];             /* Name of file area                           */
	  char        listpath[80];         /* Path for file-list                          */
	  char        filepath[80];         /* Path for files                              */
	  word        level;                /* Level needed to access file area            */
	  accessflags flags;                /* Flags needed to access file area            */
	  bool        copyLocal;            /* TRUE = CDROM File listing type              */
	  int         maxfiles;             /* Max files per day in this area downloadable */
	  int         maxkb;                /* Max Kbytes per day in this area             */
	  bool        notops;               /* Set to TRUE if not to appear in TOPFILES.A* */
	  bool        free;                 /* If TRUE, this area is free                  */
	  byte        groups[4];            /* Groups belonging to                         */
	  bool        allGroups;            /* Belongs to all groups                       */
	  byte        minAge;               /* Minimum age                                 */
	  long        flagsNot;             /* Access flags                                */
	  char        extra[3];
} FILEAREA;
typedef FILEAREA FILECFG;

/*
 
  MESSAGE
 
*/
#define MSGATTR_PRIVATE     (0x00000001L)
#define MSGATTR_RECEIVED    (0x00000002L)
#define MSGATTR_DELETED     (0x00000004L)
#define MSGATTR_NETMAIL     (0x00000008L)
#define MSGATTR_UNSENT_ECHO (0x00000010L)
#define MSGATTR_UNSENT_NET  (0x00000020L)
#define MSGATTR_LOCAL       (0x00000040L)
#define MSGATTR_KILL        (0x00000080L)
#define MSGATTR_CRASH       (0x00000100L)
#define MSGATTR_SENT        (0x00000200L)
#define MSGATTR_FILE        (0x00000400L)
#define MSGATTR_REQ         (0x00000800L)
#define MSGATTR_AUDIT       (0x00001000L)
#define MSGATTR_RET         (0x00002000L)

typedef struct{
	long        num;
	long        id;
	char        from[36];
	char        to  [36];
	char        subj[66];
	dword       attr;
	DateType    postDate;
	TimeType    postTime;
	DateType    recvDate;
	TimeType    recvTime;
	long        next;
	long        prev;
	int         origZone,
				origNet,
				origNode,
				origPoint;
	int         destZone,
				destNet,
				destNode,
				destPoint;
	int   cost;
	int   area;
	int   reserved2;
} MESSAGE;


/*
 
  FIDO_NODE
 
*/
typedef struct{
	short zone;
	short net;
	short node;
	short point;
} FIDO_NODE;
typedef FIDO_NODE AKA;


/*
 
  BINLOG.PB
 
*/
typedef struct{
	DateType date;
	TimeType timeIn;
	TimeType timeOut;
	char     name[36];
	char     city[26];
	char     country[26];
	long     baud;
	word     node;
	long     kbDown;
	long     kbUp;
	word     yells;
	word     level;
	dword    uflags;
	char     alias[36];
	byte     extra[45];
} BINLOG;

/*
 
  HANDLER
 
*/
typedef struct{
	void *func;
	word data;
} HANDLER;

/*
 
  TAGGED_FILE
 
*/
typedef struct{
	char name[13];
	word area;
} TAGGED_FILE;


/*
 
  USERSPB.BBS
 
   This file is tied to the files USERS.BBS and USERSXI.BBS. The records are
   stored in the same order as the records in USERS.BBS. The name of the
   user is duplicated in this file, so it is possible to fix the userfile
   after using a third-party userfile packer/sorter, which does not know
   about USERSPB.BBS.

   PBUF_xxx are aditional flags for the uFlags element (RA_UFLAG_xxx are
   simply aliases for those who have code that relies on those names).
*/
#define PBUF_NOIBM            0x00000001L
#define PBUF_NOTOPS           0x00000002L
#define PBUF_AVTPLUS          0x00000004L
#define PBUF_ATTEN            0x00000008L
#define PBUF_NORIP            0x00000010L
#define PBUF_MULTILOGIN       0x00000020L
#define PBUF_FREECHAT         0x00000040L
#define PBUF_LOCALONLY        0x00000080L

#define RA_UFLAG_NOIBM        PBUF_NOIBM
#define RA_UFLAG_NOTOPS       PBUF_NOTOPS
#define RA_UFLAG_AVTPLUS      PBUF_AVTPLUS
#define RA_UFLAG_ATTEN        PBUF_ATTEN
#define RA_UFLAG_NORIP        PBUF_NORIP
#define RA_UFLAG_MULTILOGIN   PBUF_MULTILOGIN
#define RA_UFLAG_FREECHAT     PBUF_FREECHAT
#define RA_UFLAG_LOCALONLY    PBUF_LOCALONLY


typedef struct{
	char           name[36];
	char           country[26];
	char           state[26];
	char           faxPhone[16];
	char           passWord[16];
	char           language[9];
	Date           lastPwdChange;
	Date           lastNewFilesCheck;
	short          logLevel;
	short          tbTimeBalance;
	short          tbKbBalance;
	short          tbTimeWithdrawn;
	short          tbKbWithdrawn;
	word           tbTimeDeposited;
	word           tbKbDeposited;
	word           tbTimeLoaned;
	word           tbKbLoaned;
	Date           tbTimePayback;
	Date           tbKbPayback;
	Date           tbLastUsed;
	word           expLevel;
	accessflags    expFlagsOn;
	accessflags    expFlagsOff;
	dword          uFlags;
	combinedboards mailCheckBoards;
	dword          totalTimeUsed;
	word           qwkMaxMsgsPerArea;
	word           qwkMaxMsgs;
	byte           qwkArchiver;
	byte           ripFont;
	byte           checkMail;
	byte           checkNewFiles;
	byte           extra[398];
} USERSPB;


/*
 
  CONFIG.PRO and CurUser->Config
 
*/
typedef struct{
	char        shellmsg[81];         /* Message to show when shelling                */
	char        sysopname[36];        /* Name of sysop                                */
	char        txtpath[61];          /* Path for textfiles                           */
	char        mnupath[61];          /* Path for menu-files                          */
	char        msgpath[61];          /* Path for message base                        */
	char        uploadpath[61];       /* Uploadpath                                   */
	char        editorname[61];       /* Name of external editor                      */
	word        newuserlevel;         /* Level for new user                           */
	short       newuserloglevel;      /* Loglevel for new user                        */
	accessflags newuserflags;         /* New user flags                               */
	short       max_passinput;        /* Maximum attempts for password entry          */
	short       min_passlength;       /* Minimum password length                      */
	short       inactivity_time;      /* Inactivity time-out limit                    */
	short       max_sysop_pages;      /* Maximum times sysop can be paged             */
	short       pagebell_length;      /* Length of page-bell (secs)                   */
	short       mailcheck;            /* Check for mail at logon?                     */
	short       europe;               /* European date format?                        */
	short       numnodes;             /* # nodes                                      */
	bool        allowansi;            /* Allow ANSI?                                  */
	bool        allowavatar;          /* Allow AVATAR?                                */
	short       discrete;             /* Hide sysop activity?                         */
	short       askphone;             /* Ask for phone number?                        */
	short       allowoneword;         /* Allow one-word names                         */
	unsigned    crashlevel;           /* Level needed for crashmail                   */
	accessflags crashflags;           /* Flags needed for crashmail                   */
	word        attachlevel;          /* Level needed for file attach                 */
	accessflags attachflags;          /* Flags needed for file attach                 */
	short       allowmsgupload;       /* Allow message uploads                        */
	short       allowstacking;        /* Allow command stacking                       */
	Time        page_start;           /* Paging hours start                           */
	Time        page_end;             /* Paging hours end                             */
	short       handshaking;          /* I/O Handshaking                              */
	short       allowalias;           /* Allow alias for login                        */
	short       loglocal;             /* Log local calls                              */
	short       doswap;               /* Allow swapping                               */
	char        originline[61];       /* Origin line                                  */
	char        nodelistdir[61];      /* Nodelist directory                           */
	char        sysopkeys[10][60];    /* Sysop hotkeys                                */
	Time        dl_start;             /* Download hours start                         */
	Time        dl_end;               /* Download hours end                           */
	short       uploadspace;          /* Space needed for uploads                     */
	char        pvtuploadpath[61];    /* Directory for files uploads                  */
	char        quotestring[6];       /* String used for quoting                      */
	bool        fastmode;             /* Use fast mode                                */
	bool        extra_bool_1;
	bool        killsent;             /* Kill netmail after sent                      */
	bool        multiline;            /* Use message base sharing?                    */
	bool        egamode;              /* Use 43/50 line mode                          */
	bool        showuserinfo;         /* Show user info while in EGA mode?            */
	char        pexpath[61];          /* Directory for PEX files                      */
	bool        allowquicklogin;      /* Allow quick sysop login?                     */
	bool        suspendmsgtime;       /* Suspend time when writing msgs               */
	short       securityboard;        /* MsgBoard for security messages               */
	bool        pwdmessages;          /* Write security-messages?                     */
	bool        extra_bool_2;
	char        bbsname[36];          /* Name of the BBS                              */
	char        pwdchar;              /* Password character                           */
	short       tb_maxtimedeposit;    /* Max time deposit per day (TimeBank)          */
	short       tb_maxkbdeposit;      /* Max Kbytes deposit per day (TimeBank)        */
	short       tb_maxtimewithdrawal; /* Max time withdrawal per day (TimeBank)       */
	short       tb_maxkbwithdrawal;   /* Max Kbytes withdrawal per day (TimeBank)     */
	short       usage_days;           /* Days to keep usage graphs                    */
	char        systempwd[16];        /* System password                              */
	bool        usesystempwd;         /* Use system password?                         */
	bool        askbirthdate;         /* Ask Birth Date?                              */
	short       binlogdays;           /* # days to log in BINLOG.PB                   */
	bool        binloglocal;          /* Log local calls to BINLOG.PB yes/no          */
	short       pageArea;             /* Area number for page messages                */
	bool        indexfiles;           /* Use file indexing                            */
	bool        checkdupes;           /* Check for dupes                              */
	bool        killdupes;            /* Kill duplocate files                         */
	bool        ignore_ext;           /* Ignore file extensions for dupe checking     */
	char        RIPpath[61];          /* Path for RIP scripts                         */
	char        iconspath[61];        /* Path for RIP icons                           */
	char        location[36];         /* BBS Location (city)                          */
	char        phone[26];            /* BBS Phone #                                  */
	char        QWKid[9];             /* BBS QWK id                                   */
	word        IObuffersize;         /* I/O buffer size in bytes                     */
	TimeFrame   pagingHours;          /* Paging hours                                 */
	char        defaultLanguage[9];   /* Default language                             */
	bool        addUploaderName;      /* Add uploader's name to FILES.BBS             */
	TimeFrame   downloadHours;        /* Download hours                               */
	bool        askdataphone;         /* Ask data phone #                             */
	bool        askfaxphone;          /* Ask fax phone #                              */
	bool        askaddress;           /* Ask mailing address                          */
	bool        asksex;               /* Ask sex                                      */
	bool        askdateformat;        /* Ask date format                              */
	bool        askstate;             /* Ask state                                    */
	bool        askcountry;           /* Ask country                                  */
	short       fuzzyRate;            /* Fuzzy search percentage for user editor      */
	bool        hidePassword;         /* Hide password in user editor                 */
	bool        valConfirm;           /* Confirm user validation                      */
	char        extra_char_1[17];
	char        extChat[81];          /* External chat program                        */
	char        virScanCommand[61];   /* External upload scan command                 */
	byte        virScanType;          /* External upload scan command (type)          */
	char        virScanSemaphore[13]; /* External upload scan command (semaphore)     */
	byte        listColorTag;         /* File list color (tag char)                   */
	byte        listColorFileName;    /* File list color (file name)                  */
	byte        listColorSize;        /* File list color (file size)                  */
	byte        listColorDate;        /* File list color (file date)                  */
	byte        listColorCounter;     /* File list color (file counter)               */
	byte        listColorDesc;        /* File list color (description)                */
	byte        listColorSeperator;   /* File list color (description seperator)      */
	byte        listColorMissing;     /* File list color (missing indicator)          */
	bool        hideFileCounter;      /* File list setup - hide file counter          */
	bool        disableRIP;           /* TRUE = disable RIP completely                */
	char        extra_char_2[81];
	byte        virScanFailedAction;  /* External upload scan command (action)        */
	word        virScanFailedArea;    /* External upload scan command (failed area)   */
	char        extra[5];
} CONFIG;


/*
 
  TIMELOG.PRO
 
*/
typedef struct{
	short       numdays;              /* Number of days active                        */
	Date        lastdate;             /* Last update                                  */
	long        hours[24];            /* # minutes per hour usage (obsolete)          */
	long        days[7];              /* # minutes per day usage  (obsolete)          */
	long        weeks[53];            /* # minutes per week usage (obsolete)          */
	long        totalcalls;           /* Total calls to system                        */
} TIMELOG;


/*
 
  MESSAGES.PB
 
*/
#define MSGKIND_LOCAL    0 /* Local          */
#define MSGKIND_NET      1 /* NetMail        */
#define MSGKIND_ECHO     2 /* EchoMail       */
#define MSGKIND_PVTECHO  3 /* Pvt EchoMail   */
#define MSGTYPE_BOTH     0 /* Private/Public */
#define MSGTYPE_PVT      1 /* Private Only   */
#define MSGTYPE_PUBLIC   2 /* Public Only    */
#define MSGTYPE_TOALL    3 /* To All         */

#define MSG_LOCAL        MSGKIND_LOCAL
#define MSG_NET          MSGKIND_NET
#define MSG_ECHO         MSGKIND_ECHO
#define MSG_PVTECHO      MSGKIND_PVTECHO
#define MSG_BOTH         MSGTYPE_BOTH
#define MSG_PVT          MSGTYPE_PVT
#define MSG_PUB          MSGTYPE_PUB
#define MSG_TOALL        MSGTYPE_TOALL

#define MSGBASE_HUDSON   0 /* Hudson         */
#define MSGBASE_SQUISH   1 /* Squish         */
#define MSGBASE_SDM      2 /* Fido *.MSG     */
#define MSGBASE_JAM      3 /* JAM            */

typedef struct{
	word        areaNum;              /* # of message area (1-10000)                  */
	word        hudsonBase;           /* Number of Hudson message base                */
	char        name[81];             /* Name of message area                         */
	byte        msgType;              /* Kind of message area (Net/Echo/Local)        */
	byte        msgKind;              /* Type of message (Private only/Public only/.) */
	byte        msgBaseType;          /* Type of message base                         */
	char        path[81];             /* Path to Squish or *.MSG                      */
	byte        flags;                /* Alias allowed/forced/prohibited              */
	word        readLevel;            /* Minimum level needed to read msgs            */
	accessflags readFlags;            /* flags needed to read msgs                    */
	accessflags readFlagsNot;         /* flags non-grata to read msgs                 */
	word        writeLevel;           /* Minimum level needed to write msgs           */
	accessflags writeFlags;           /* flags needed to write msgs                   */
	accessflags writeFlagsNot;        /* flags non-grata to read msgs                 */
	word        sysopLevel;           /* Minimum level needed to change msgs          */
	accessflags sysopFlags;           /* flags needed to change msgs                  */
	accessflags sysopFlagsNot;        /* flags non-grata to read msgs                 */
	char        origin[62];           /* Origin line                                  */
	short       aka;                  /* AKA                                          */
	word        rcvKillDays;          /* Kill received after xx days                  */
	word        msgKillDays;          /* Kill after xx days                           */
	word        maxMsgs;              /* Max # msgs                                   */
	char        sysop[36];            /* Area Sysop                                   */
	short       replyBoard;           /* Area number where replies should go          */
	char        echoTag[61];          /* Echomail Tag Name                            */
	char        qwkTag[13];           /* QWK Area Name                                */
	byte        groups[4];            /* Groups belonging to                          */
	bool        allGroups;            /* Belongs to all groups                        */
	byte        minAge;               /* Minimum age for this area                    */
	byte        extra[112];
} MESSAGES;
typedef MESSAGES MSGAREA;

/*
 
  ONLINE.PRO
 
*/

typedef struct{
	char        name[36];             /* Name of user online                          */
	char        city[16];             /* City of user online                          */
	word        baud;                 /* Baud rate of user                            */
	short       status;               /* 0 -> online , <0 -> not online or unavailable*/
	char        extra[8];
} ONLINE;

/*
 
  TOPS.PB
 
   NOTE: The file name has changed from TOPS.PRO (2.0x) to TOPS.PB (2.10)

   NOTE: the TOPS.PB file contains BEST 20 Users Statistics. It has
		 7 sections, each of which has 20 entries in the same format
		 as this structure. Here's the list with the sections:

			  1. Callers by total number of calls (stats = # of calls)
			  2. Downloaders by KBytes (stats = # of KBytes)
			  3. Downloaders by # of files (stats = # of files)
			  4. Uploaders by KBytes (stats = # of KBytes)
			  5. Uploaders by # of files (stats = # of files)
			  6. Message writers (stats = # messages written)
			  7. Callers by time online (stats = minutes online)
*/

typedef struct{
	char    name[36];             /* Name of user online                                 */
	dword   n;                    /* Data (# kb/minutes/files/etc...)                    */
} TOPS;

/*
 
  PROTOCOL.PRO
 
*/
#define PROT_BATCH   1    /* Batch protocol        */
#define PROT_ENABLED 2    /* Enabled               */
#define PROT_BOTH    4    /* Full-duplex protocol  */
#define PROT_BIM     8    /* Bimodem-type ctl-file */
#define PROT_LOCAL  16    /* Local only            */

typedef struct{
	char        name[50];             /* Name of protocol                             */
	char        key;                  /* Hotkey for Protocol                          */
	char        flags;                /* Protocol behavior                            */
	char        logfile[60];          /* Logfile from protocol                        */
	char        ctlfile[60];          /* Control file (redirection file)              */
	char        dlcom[128];           /* Download command line                        */
	char        ulcom[128];           /* Upload command line                          */
	char        dlstring[80];         /* String to place in download control file     */
	char        ulstring[80];         /* String to place in upload control file       */
	char        dlkeyword[40];        /* Download keyword to search for in logfile    */
	char        ulkeyword[40];        /* Upload keyword to search for in logfile      */
	short       wordnr;               /* File name word nr after keyword (1-..)       */
} PROTOCOL;

/*
 
  MODEM.PB
 
*/
#define MODEM_LOCKED        (0x00000001L)
#define MODEM_MANUAL_ANSWER (0x00000002L)

typedef struct{
	long        maxBps;               /* Maximum Baud Rate                         */
	long        lockedBps;            /* Locked Baud Rate  (not used)              */
	dword       flags;                /* Attributes (see below)                    */
	short       port;                 /* COM port (1-8)                            */
	short       commandDelay;         /* Delay in 1/10s between characters sent    */
	short       answerDelay;          /* Delay in 1/10s before answer string sent  */
	short       blankTime;            /* Time in seconds for screen blanker        */
	char        msgCon300     [80];   /* Connect 300 string                        */
	char        msgCon1200    [80];   /* Connect 1200 string                       */
	char        msgCon1275    [80];   /* Connect 1275 string                       */
	char        msgCon2400    [80];   /* Connect 2400 string                       */
	char        msgCon4800    [80];   /* Connect 4800 string                       */
	char        msgCon7200    [80];   /* Connect 7200 string                       */
	char        msgCon9600    [80];   /* Connect 9600 string                       */
	char        msgCon12000   [80];   /* Connect 12000 string                      */
	char        msgCon14400   [80];   /* Connect 14400 string                      */
	char        msgCon16800   [80];   /* Connect 16800 string                      */
	char        msgCon19200   [80];   /* Connect 19200 string                      */
	char        msgCon21600   [80];   /* Connect 21600 string                      */
	char        msgCon24000   [80];   /* Connect 24000 string                      */
	char        msgCon26400   [80];   /* Connect 26400 string                      */
	char        msgCon28800   [80];   /* Connect 28800 string                      */
	char        msgCon38400   [80];   /* Connect 38400 string                      */
	char        msgCon57600   [80];   /* Connect 57600 string                      */
	char        msgCon64000   [80];   /* Connect 64000 string                      */
	char        msgCon115200  [80];   /* Connect 115200 string                     */
	char        msgConExternal[80];   /* External/Fax connect string               */
	char        msgRing       [80];   /* Ring string                               */
	char        msgOk         [80];   /* "OK" string                               */
	char        cmdInit1      [80];   /* Init command string 1                     */
	char        cmdInit2      [80];   /* Init command string 2                     */
	char        cmdInit3      [80];   /* Init command string 3                     */
	char        cmdAnswer     [80];   /* Answer commnad string                     */
	char        cmdOffHook    [80];   /* Off Hook command string                   */
	char        cmdDown       [80];   /* BBS Down command string                   */
	char        cmdAttention  [80];   /* Attention command string (usually "AT|")  */
	short       externalErrorLevel;   /* Errorlevel for external/fax connect       */
	char        msgCon31200   [80];   /* Connect 31200 string                      */
	char        msgCon33600   [80];   /* Connect 33600 string                      */
	char        msgCon36000   [80];   /* Connect 36000 string                      */
	char        msgConUser1   [80];   /* User connect string #1                    */
	long        userConBps1;          /* User connect bps #1                       */
	char        msgConUser2   [80];   /* User connect string #2                    */
	long        userConBps2;          /* User connect bps #2                       */
	char        msgConUser3   [80];   /* User connect string #3                    */
	long        userConBps3;          /* User connect bps #3                       */
	char        msgConUser4   [80];   /* User connect string #4                    */
	long        userConBps4;          /* User connect bps #4                       */
	char        msgConUser5   [80];   /* User connect string #5                    */
	long        userConBps5;          /* User connect bps #5                       */
	char        msgConUser6   [80];   /* User connect string #6                    */
	long        userConBps6;          /* User connect bps #6                       */
	byte        extra[920];
} MODEM;

/*
 
  FILESIDX.PB
 
*/
typedef struct{
	char        filename[13];         /* Name of the file, with extension             */
	word        area;                 /* File area number where file is located       */
} FILESIDX;


/*
 
  FGROUPS.PB / MGROUPS.PB
 
*/

typedef struct{
	char        name[80];
	word        level;
	long        flags;
	long        flagsNot;
	byte        extra[10];
} FILEGROUP;

typedef FILEGROUP MSGROUP;


/*
 
  PVTFILES.PB
 
*/
#define PVTFILE_KEEP (0x00000001L)

typedef struct{
	Date        date;
	char        fname  [80];
	char        to     [36];
	char        from   [36];
	char        desc   [80];
	dword       attr;
	byte        extra  [61];
} PVTFILE;


/*
 
  FLAGDESC.PB
 
*/
typedef struct{
	char name[40];                /* Description of this flag           */
} FLAGDESC;

/*
 
  TEMPLATE.PB
 
*/
typedef struct{
	char  name[61];               /* Name of this template              */
	char  comment[81];            /* Comment to place in user record    */
	char  valMsgFile[9];          /* Validation message filename        */
	word  newLevel;               /* Assign this as the new user level  */
	word  subDays;                /* Days the new level will last       */
	word  expLevel;               /* Assign this level when it expires  */
	word  tbTime;                 /* Bank: deposit time to user account */
	word  tbKBytes;               /* Bank: deposit KB to user account   */
	word  netCredit;              /* Netmail credit user can use        */
	int   logLevel;               /* Log: 0=Fnd,1=Nml,2=Sus,3=Ext,4=Ign */
	byte  hidden;                 /* Set HIDDEN (0=No, 1=Yes, 2=Ignore) */
	byte  noTops;                 /* Set the NOTOPS flag in user record */
	byte  attention;              /* Set ATTENTION flag in user record  */
	byte  noKill;                 /* Set NOKILL flag in user's record   */
	byte  ignoreDL;               /* Set IGNOREDL flag in user record   */
	bool  deleted;                /* Template marked for deletion       */
	char  extra[99];
	dword newFlagsOn;             /* Flags to turn on when validated    */
	dword newFlagsOff;            /* Flags to turn off when validated   */
	dword expFlagsOn;             /* Flags to turn on when expired      */
	dword expFlagsOff;            /* Flags to turn off when expired     */
} TEMPLATE;

/*
 
   EVENTS.PRO
 
   The EVT_xxx masks are used for the daysEnabled variable. To see if a
   day is enabled, use EventVar.daysEnabled & EVT_xxx.
*/
#define EVT_MONDAY     0x01
#define EVT_TUESDAY    0x02
#define EVT_WEDNESDAY  0x04
#define EVT_THURSDAY   0x08
#define EVT_FRIDAY     0x10
#define EVT_SATURDAY   0x20
#define EVT_SUNDAY     0x40

typedef struct{
	int      type;                /* Event type: 0=Errorlevel,1=Command */
	int      errorLevel;          /* Errorlevel for type 0 events       */
	char     command[80];         /* Command string for type 1 events   */
	TimeType startTime;           /* Start time for the event           */
	int      duration;            /* Duration of the event (in minutes) */
	word     daysEnabled;         /* Days event is enabled, see EVT_??? */
	char     nodeNum;             /* Node number this event is for <128 */
	bool     enabled;             /* True if event is enabled,false=not */
} EVENT;

/*
 
  *.PBM menu files
 
  Each file has a header of type MENUHDR and an undefined number of MENUREC
  entries. Both structures are fixed length, the header being 315 bytes and
  the definition of each entry in the menu - 514 bytes.

  The menuFlags variable of the header can be chacked with the MNUHDF_xxx
  contants, the recFlags variable in the record, with MNUF_xxx constants.
  The sex variable can be chacked with the MNUSEX_xxx contants.
*/
#define MNUHDF_RIPFILE  0x00000001L   /* if this the prompt has RIP file */

typedef struct{
	long menuFlags;                /* flags for the menu, see MNUHDF_xxx  */
	char prompt[200];			   /* prompt string                       */
	byte color;					   /* normal color attribute              */
	byte highColor;                /* highlight color attribute           */
	char ripName[9];               /* filename of the RIP prompt file     */
	char extra[100];
} MENUHDR;

#define MNU_SHOWREMOTE    0x00000001L    /* rip show remote               */
#define MNU_NOLOCAL       0x00000002L	 /* rip suppress local display    */
#define MNU_NORESET       0x00000004L    /* rip don't reset               */
#define MNUSEX_DONTCARE	  0              /* don't care about sex          */
#define MNUSEX_MALE       1              /* only male users can access it */
#define MNUSEX_FEMALE     2              /* only female users can access  */

typedef struct{
	dword menuFlags;               /* see the MNU_xxx constants           */
	char text[160];                /* menu line text                      */
	char data[160];                /* data for function                   */
	byte color;                    /* color for the line                  */
	byte hotKey;                   /* hotkey to activate this function    */
	word function;                 /* PB function number                  */
	char password[16];
	word minLevel;                 /* minimum level needed to access line */
	word maxLevel;                 /* maximum level needed to access line */
	accessflags aFlags;            /* access flags the user needs         */
	accessflags flagsNot;          /* flags the user must not have        */
	byte minAge;                   /* minimum age needed to access line   */
	byte maxAge;                   /* maximum age needed to access line   */
	byte sex;                      /* sex user must have, see MNUSEX_xxx  */
	word timeLeft;				   /* time user must have left            */
	word timeOnline;               /* time the user must have spent on    */
	TimeFrame enabled;             /* day/hour frame line is enabled      */
	byte terminals;                /* 0xff = don't care                   */
	dword minSpeed;                /* minimum connect speed to get access */
	dword maxSpeed;                /* maximum connect speed to get access */
	byte extra[100];
} MENUREC;

/*
 
  *.PBL language files
 
  All language files consist of a header of type LANGHDR which is followed
  by a number of records of type LANGREC. The total number of those records
  is determined by the numRecs variable in the header. The strings in the
  header are regular NUL-terminated C strings.

  This header is followed by stringLen bytes for the string(s), which is
  followed by numHotkeys bytes for the hotkeys. Neither the string, nor the
  hotkeys are NUL-terminated, and the 8 different strings are separated by
  0x0A only. The maximum length of each string is 200 chars, the maxkeys
  can be no more than 80.
*/
typedef struct{
	char        name[41];         /* Title of the language file         */
	bool        avail;            /* TRUE if available, FALSE otherwise */
	word        level;            /* Security level needed to use it    */
	accessflags aFlags;           /* Flags needed to use it             */
	char        menuPath[61];     /* Directory for the language menus   */
	char        textPath[61];     /* Directory for the textfiles        */
	char        questPath[61];    /* Directory for the questionnaires   */
	char        copyright[81];    /* Copyright string for the file      */
	byte        attrib;           /* not used                           */
	byte        extra[500];
} LANGHDR;

#define PBL_HASPROMPT 0x0001
#define PBL_NOCOLOR   0x0002

typedef struct{
	int  len;                     /* Length of string, see NOTE         */
	int  numHotKeys;              /* Number of defined hotkeys          */
	byte normCol;                 /* Color attribute for the strings    */
	byte highCol;                 /* Highlight color attribute          */
	byte promptCol;               /* Foreground prompt color            */
	byte flags;                   /* PBL_??? constants                  */
} LANGREC;

/*
 
  NODE_IDX.PRO
 
  Originally contributed by: Peter Szymczyk via the PROBOARD FidoNet echo.
  Modified by Branislav L. Slantchev: changed type to union, removed fillin
  entry and added field to process filenames easily (Aug 6, 1995).

  After each record is read, it needs to be XOR'ed with the values in the
  xor array. When 'type' is > 10, the record is a nodelist filename, 12
  characters plus the terminating NUL. The first record is always a nodelist
  filename.

  Xor bytes: 234, 123, 76, 245, 87, 12, 43, 56, 23, 12, 98, 55, 34
*/
#define NODEIDX_ZONE   1            /* Record 'type' Zone                 */
#define NODEIDX_REGION 2            /* Record 'type' Region               */
#define NODEIDX_HOST   3            /* Record 'type' Host                 */
#define NODEIDX_HUB    4            /* Record 'type' Hub                  */
#define NODEIDX_PVT    5            /* Record 'type' Private              */
#define NODEIDX_DOWN   6            /* Record 'type' Down                 */
#define NODEIDX_HOLD   7            /* Record 'type' Hold                 */
#define NODEIDX_NODE   8            /* Record 'type' Node                 */

typedef union{
	struct{
		char type;                  /* record type, see NODEIDX_xxx       */
		long offset;                /* offset of record in the nodelist   */
		union{
			int zone;               /* if record is a zone, this is it    */
			int net;                /* if record is a node, this is it    */
		}fido;
		int  cost;                  /* netmail credits for this record    */
	}    data;
	char name[13];                  /* if record is name, list filename   */
} NODEIDX;

/*
 
  TAGLIST.PB
 
  Each entry is defined as the header TAGLIST structure, followed by
  'numTagged' entries of TAGGED_FILE structure.
*/
typedef struct{
	char name[36];
	int  numTagged;
} TAGLIST;

#endif /* _pbdefs.h */
