/*
 * PB-Lib C/C++ Library Version 0.021
 *
 * Copyright (C) 1995 by Branislav L. Slantchev
 * A product of Silicon Creations, Inc.
 *
 * See the file "copying.pbl" for licensing information.
*/

/* membdg.h (originally mem.h)

   Copyright (C) 1989-1995 by Walter Bright.

   This file has been modified by Branislav L. Slantchev for the inclusion
   in PBLib. The original source code is available in the FidoNet C Echo
   Snippets Collection, courtesy of Bob Stout. Note that comments have been
   removed as well as multiplatform support. The target are MS-DOS ANSI C
   compilers, like Zortech, Borland and Microsoft.

   To enable the debugging package, #define MEM_DEBUG 1. The default
   is no extended debugging (for shipping code, very little overhead).

   Always call mem_init() at startup and mem_term() at close. The behavior
   of out-of-memory conditions can be controlled via mem_setexception().
*/

#ifndef __MEMDBG_H
#define __MEMDBG_H

#ifndef __PBLIB_H
#include <pblib.h>
#endif

/*
 * This will be != 0 if the memdbg package is initialized. Test this
 * if you have other packages that depend of memdbg being initialized.
*/
extern int mem_inited;

/*
 * possible values for the first parameter for mem_setexception()
*/
enum MEM_E{
	MEM_ABORTMSG, MEM_ABORT, MEM_RETNULL,
	MEM_CALLFP, MEM_RETRY
};

#ifdef __cplusplus
	extern "C" {
#endif

void  mem_setexception( enum MEM_E, int (*)(void) );
char *mem_strdup( const char * );
void  mem_freefp( void *p );
void  mem_check( void );
void  mem_checkptr( void *ptr );
void *mem_malloc( unsigned );
void *mem_calloc( unsigned );
void *mem_realloc( void *,unsigned );
void  mem_free( void * );
void  mem_init( void );
void  mem_term( void );

/*
 * function mapping for the debugging version
*/
#ifdef MEM_DEBUG
	#define mem_strdup(p)       mem_strdup_debug((p),__FILE__,__LINE__)
	#define mem_malloc(u)       mem_malloc_debug((u),__FILE__,__LINE__)
	#define mem_calloc(u)       mem_calloc_debug((u),__FILE__,__LINE__)
	#define mem_realloc(p,u)    mem_realloc_debug((p),(u),__FILE__,__LINE__)
	#define mem_free(p)	        mem_free_debug((p),__FILE__,__LINE__)
	#define mem_scalloc         mem_calloc
	#define mem_sfree(ptr,size) mem_free(ptr)
	char *mem_strdup_debug( const char *,char *,int );
	void *mem_calloc_debug( unsigned,char *,int );
	void *mem_malloc_debug( unsigned,char *,int );
	void *mem_realloc_debug( void *,unsigned,char *,int );
	void  mem_free_debug( void *,char *,int );
	void  mem_freefp( void * );
	void  mem_setnewfileline( void *,char *,int );
#else
	#define mem_freefp	     mem_free
	#define mem_check()
	#define mem_checkptr(p)
	void *mem_scalloc( size_t numbytes );
	void mem_sfree( void *ptr, size_t numbytes );
#endif

#ifdef __cplusplus
	}
#endif
#endif
