/*
 * PB-Lib C/C++ Library Version 0.021
 *
 * Copyright (C) 1995 by Branislav L. Slantchev
 * A product of Silicon Creations, Inc.
 *
 * See the file "copying.pbl" for licensing information.
*/

#ifndef __FSYS_H
#define __FSYS_H

/*
 ***************************************************************************
                  Drive, directory and file manipulation
 ***************************************************************************
*/

#ifndef __PBLIB_H
#include <pblib.h>
#endif

#ifndef PB_SDK
	#include <stdio.h>
#endif

#ifdef __cplusplus
	extern "C" {
#endif

int   cpfile( const char *dest, const char *src );
int   rmfile( const char *spec );
char *chext( char *dest, const char *src, const char *ext );
char *tempname( void );
char *tmpname( char *path );
char *basename( char *path );
char *basedir( const char *path );
word  fgetw( FILE *fp );
dword fgetdw( FILE *fp );
int   mkDirTree( char *path );
int   rmDirTree( char *path );
char *searchPath( char *path, const char *filename );

/*
 * only in SDK we provide alt functions, C libs have those
*/
#ifdef PB_SDK
	int   chmod( const char *path, int amode );
	int   chdir( const char *path );
	int   mkdir( const char *path );
	int   rmdir( const char *path );
	long  tell( int handle );
	char *getcwd( char *path, int buflen );
#else /* standard C library functions include */
	#include <direct.h>
	#include <io.h>

	#if defined( __ZTC__ ) && !defined( __SC__ )
		long tell( int handle );
	#endif
#endif /* only SDK mode prototypes */

#ifdef __cplusplus
	}
#endif
#endif
