
TSLICE			PB-Lib C/C++ Library Programmer's Manual		TSLICE


NAME
	_dos_detect_os - detect the current operating environment
	_dos_idle - release time slice to multitaskers

SYNOPSIS
	#include <sysutil.h>

	int _dos_detect_os(void);
	void _dos_idle(void);

DESCRIPTION
	This function combo provides limited support for multitaskers by
	enabling the calling program to release time slices when it is idle.
	The supported operating systems are DESQview, Windows and OS/2.

	_dos_detect_os() should be called at the beginning os the program.
	This function will setup an internal variable that is needed by the
	_dos_idle() routine.  Failure to initialize it will cause
	unpredictable results.

	_dos_idle() should be called when the application is idle.  It simply
	releases a time slice and returns (if the program is running under a
	multitasker) or does nothing special under MS-DOS.

RETURN VALUE
	_dos_detect_os() returns one of the following constants:

		__DOS - if plain vanilla MS-DOS is running
		__DV  - if DESQview has been detected
		__WIN - if Windows is running
		__OS2 - if OS/2 is running

	_dos_idle() does not return a value.

EXAMPLE
	#include <sysutil.h>

	void main(void)
	{
		_dos_detect_os();

		while( !kbhit() ){
			_dos_idle();
		}
	}

