
DRIVES			PB-Lib C/C++ Library Programmer's Manual		DRIVES


NAME
	_dos_drvready - returns status of removable media drive (floppy)
	_dos_drvnum - returns number of valid drives in the system
	_dos_drvtype - returns the type of drive

SYNOPSIS
	#include <sysutil.h>

	int _dos_drvready(int drive);
	int _dos_drvnum(void);
	int _dos_drvtype(int drive);

DESCRIPTION
	The _dos_drv??? functions deal with drives.  The most important one
	here is _dos_drvtype() because all others are built around its return
	values.  This function expects an integer representing the drive to
	identify, with 'A' == 1, 'B' == 2, etc.  The test is benign (i.e. if
	the drive letter is invalid or if the drive cannot be identified, the
	failure will not result in an ugly message on the screen).

	_dos_drvready() should be used on media that has been identified as
	removable by _dos_drvtype().  This function tests is there's a floppy
	in the drive and if that floppy is ready for reading, writing or both.
	This test will not trigger the critical error handler either.

	_dos_drvnum() simply returns the number of drives that have been
	recognized by _dos_drvtype() in the whole system.

RECOGNIZED DRIVES
		- dtFixed, meaning that the drive is a hard disk
		- dtRemovable, meaning that the drive is a floppy
		- dtRemote, meaning that the drive is a network drive
		- dtCDROM, CD-ROM drive, driven by MSCDEX
		- dtSubst, drive created by SUBST
		- dtRAM, drive is a RAM disk (RAMDRIVE.SYS, VDISK.SYS)
		- dtDblSpace, drive is DoubleSpace compressed
		- dtReadOK, drive is ready for reading
		- dtWriteOK, drive is ready for writing (implies reading too)
		- dtNotReady, drive is not ready (or no floppy)

RETURN VALUE
	On error, _dos_drvtype() returns the dtError constant; on success, any
	of the dt??? constants above 9except dtReadOK, dtWriteOK, dtNotReady).

	_dos_drvready() returns either dtReadOK, dtWriteOK or dtNotReady.

	_dos_drvnum returns the number of recognized drives.

EXAMPLE
	#include <stdio.h>
	#include <sysutil.h>

	int main( void )
	{
		int i;

		for( i = 'A'; i <= 'Z'; ++i ){
			printf( "\ndrive %c: ", i );
			switch( _dos_drvtype(i - '@') ){
				case dtError: printf( "invalid or unknown type" ); break;
				case dtFixed: printf( "fixed media" ); break;
				case dtRemovable:
					printf( "removable media ... " );
					switch( _dos_drvready(i - '@') ){
						case dtError:
							printf( "controller error" ); break;
						case dtNotReady:
							printf( "not ready" ); break;
						case dtReadOK:
							printf( "ready for reading" ); break;
						case dtWriteOK:
							printf( "ready for read/write" ); break;
						default: printf( "unknown error" );
					}
				break;
				case dtRemote: printf( "network drive" ); break;
				case dtRAM: printf( "RAM drive" ); break;
				case dtCDROM: printf( "MSCDEX 2.00+ CD-ROM" ); break;
				case dtSubst: printf( "SUBST'ed drive" ); break;
				case dtDblSpace: printf( "DoubleSpace compressed" ); break;
				default:
					printf( "unknown error" );
			}
		}
		return 0;
	}

