
DOSVER			PB-Lib C/C++ Library Programmer's Manual		DOSVER

NAME
	_dos_version - returns MS-DOS version number

SYNOPSIS
	#include <sysutil.h>

	int _dos_version(void);

DESCRIPTION
	_dos_version() uses an undocumented function call to retrieve the
	MS-DOS version number.  Unlike the regular call, this one will not be
	fooled by programs such as SETVER and will always return the correct
	number.  In case the function is not supported, _dos_version() will
	fall back to the documented call.

RETURN VALUE
	MS-DOS version number with the major version in the low byte of the
	returned integer and the minor revision - in the high byte.

EXAMPLE
	#include <stdio.h>
	#include <sysutil.h>

	void main(void)
	{
		int ver = _dos_version();

		printf( "MS-DOS Version %d.%d\n", ver & 0x0F, ver >> 8 );
	}

