
STRVCAT			PB-Lib C/C++ Library Programmer's Manual		STRVCAT


NAME
	strvcat - concatenates multiple strings.

SYNOPSIS
	#include <strlib.h>

	char *strvcat(char *s, ...);

DESCRIPTION
	strvcat() concatenates a NULL-terminated list of strings into a new
	string that is allocated by the function. Failure to specify NULL
	as the last entry in the list will certainly crash the system as
	the function will go into an infinte loop. Don't forget that this
	is a concatenation function	and if you give it a non-initialized
	buffer, the results are unpredictable. It is acceptable, however,
	to pass NULL as the s parameter, then it will simply be ignored.
	Freeing of the resulting buffer is the responsibility of the caller.

RETURN VALUE
	On success, strvcat() returns a pointer to the new string. On error,
	strvcat() returns NULL.

EXAMPLE
	#include <stdio.h>
	#include <strlib.h>

	int
	main(int argc, char *argv[])
	{
		char *ptr;

		ptr = strvcat( "Hello", ",", " w", "orld", "!", (char *)0 );
		if( ptr ){
			printf( "%s\n", ptr );
			free( ptr );
		}
	}

BUGS
	Be very careful with that function as you _must_ pass it the last
	NULL pointer or it won't be able to find the end of the list.


