
STRLIB			PB-Lib C/C++ Library Programmer's Manual		STRLIB


NAME
	strtopas - convert a C-style string to Pascal format

SYNOPSIS
	#include <strlib.h>

	char *strtopas(char *dest, const char *src);

DESCRIPTION
	strtopas() converts a C-style NUL-terminated string into a Pascal
	style string. In Pascal, strings are limited to 255 characters, with
	the first character of the string == its length. There's no such
	thing as NUL-terminators. The destination buffer must be big
	enough to accomodate the resulting string, but it does not need to
	be bigger than 256 characters. If strlen(s) > 255, it will be
	truncated. strtopas() returns dest.

EXAMPLE
	#include <stdio.h>
	#include <strlib.h>

	int
	main(int argc, char *argv[])
	{
		char pas[256], *text = "Hello, world!";

		strtopas(pas, text);
		fwrite( pas, sizeof(char), (int)pas[0], stdout );
		return 0;
	}

SEE ALSO
	strfmpas

