
STRSREP			PB-Lib C/C++ Library Programmer's Manual		STRSREP


NAME
	strsrep - replaces all occurences of a substring in a string

SYNOPSIS
	#include <strlib.h>

	char *strsrep(char *s1, const char *s2, const char *s3);

DESCRIPTION
	strsrep() replaces all occurences of string s2 in s1 with s3. If
	strlen(s3) > strlen(s2), the resulting string s1 will be longer
	and the allocated buffer should be large enough to accomodate the
	result. This function returns s1.

EXAMPLE
	#include <stdio.h>
	#include <strlib.h>

	int
	main(int argc, char *argv[])
	{
		char *s1 = "This is just another string, isn't it. It is";
		char s2[80] = "Ok, we'll try to do some replacing here too.";

		printf( "Orig1: %s\n", s1 );
		printf( "Mod1 : %s\n", strsrep(s1,"is","IS") );
		printf( "Orig2: %s\n", s2 );
		printf( "Mod2 : %s\n", strsrep(s2, "o", "uh-oh") );
		return 0;
	}

SEE ALSO
	strcrep, strcdel, strcrm, strsrm, strdel

