STREQU			PB-Lib C/C++ Library Programmer's Manual		STREQU


NAME
	strequ	 - tests for equality of two strings
	strnequ	 - tests for inequality of two strings
	striequ	 - test for equality of two strings, not case sensitive
	strinequ - tests for inequality of two strings, not case sensitive

SYNOPSIS
	#include <strlib.h>

	int strequ(const char *s1, const char *s2);
	int strnequ(const char *s1, const char *s2);
	int striequ(const char *s1, const char *s2);
	int strinequ(const char *s1, const char *s2);

DESCRIPTION
	All four are implemeted as macros that call strcmp() and stricmp().

	strequ() tests two strings for equality. If they are the same, 1
	is returned, and 0 if they differ. strnequ() tests two strings for
	difference. If the strings are different, 1 is returned and 0 if
	they are the same.

	striequ() is the same as strequ(), except the test is not case-
	sensitive. strinequ() is the same as strmequ() except the test
	is not case-sensitive.

EXAMPLE
	#include <stdio.h>
	#include <strlib.h>

	int
	main(int argc, char *argv[])
	{
		char *p1 = "Some test string";
		char *p2 = "Another one";
		char *p3 = "ANOTHer One";

		if( strequ(p1,p2) ) puts( "Oh, my: error!" );
		if( strnequ(p2,p3)) puts( "Makes sense" );
		if( striequ(p2,p3)) puts( "Yep, that's it" );

		return 0;
	}

