
STRCENT				PB-Lib C/C++ Library Programmer's Manual		STRCENT


NAME
	strcent - strcents a string into a buffer

SYNOPSIS
	#include <strlib.h>

	char *strcent(char *dest, const char *src, size_t len);

DESCRIPTION
	strcent() centers src into dest using width len by padding with
	spaces or truncating when necessary. Note that len will be filled,
	as strcent() does pad with whitespace. The destination buffer must
	be large enough to hold the new string.

RETURN VALUE
	dest

EXAMPLE
	#include <stdio.h>
	#include <strlib.h>

	int
	main(int argc, char *argv[])
	{
		char buf[100];

		printf( "%s\n", strcent(buf, "centered at 80 chars.", 80) );
		printf( "%s\n", strcent(buf, "centered at 37 chars.", 37) );
		printf( "%s\n", strcent(buf, "centered at 9 chars.", 9) );
		return 0;
	}

