
XLATPBL			PB-Lib C/C++ Library Programmer's Manual		XLATPBL


NAME
	xlatLoad - load a prompt definition from a language file
	xlatFree - free any memory allocated by the xlatLoad call
	xlatCompile - compile the language string to internal format
	xlatDisp - display the compiled string with color support

SYNOPSIS
	#include <proutil.h>

	int xlatLoad(int id, xlat_t *rec, const char *language);
	void xlatFree(xlat_t *rec);
	xlts_t xlatCompile(const xlat_t *rec);
	void xlatDisp(const xlts_t str, bool ansiOn);

DESCRIPTION
	The xlat??? package provides an easy way to use ProBoard's language
	files.  Currently, it does not support the @a|p@ mechanism for
	displaying text files or runnign PEX programs.

	xlatLoad() should be called for the language string number 'id'.  You
	can use the constants defined in <sys/_pbldefs.h> for the id number.
	The 'language' argument is a string with the language file to load.
	It shouldn't contain the extension, just the root name.  It's length
	is limited to 8 characters (i.e.  "ENGLISH").  If the requested file
	is not found, then the function will attempt to load the string from
	the default language file (added with PB v2.10).  If the function
	succeeds, the xlat_t record will be filled with information.  This
	structure is not intended to be for direct use, but here's its layout:

				typedef struct{
					LANGREC  def;   /* language definition        */
					char    *val;   /* string from the file       */
					char    *keys;  /* hotkey list, if applicable */
				} xlat_t;

	You can use this record if you want to utilize hotkeys or extract more
	relevant information about the language.  Note that the 'rec' pointer
	should point to previously allocated space or else the function will
	overwrite some memory location you don't want it to.

	If you just want to display the string, then you need to call
	xlatCompile() to translate it to an internal format.  Just pass the
	xlat_t record you obtained from xlatLoad() to this function.  It will
	return a 'xlts_t' type record, which is currently defined as

					typedef char* xlts_t;

	It will contain the compiled string which is ready to be displayed by
	the xlatDisp() function.  Note that xlts_t will be a static buffer and
	it will be overwritten by each call to xlatCompile().  The display
	function handles both color and black and white.  It's behavior is
	governed by the 'ansiOn' argument.  If it's TRUE, then color will be
	used (the offline version does not require ANSI.SYS).  If it is FALSE,
	all color settings will be parsed but ignored and the string will
	display in black and white.

	You should call xlatFree() for any structure you allocate with a call
	to xlatLoad().  Note that it is not permissible to use the same xlat_t
	record for successive calls to xlatLoad() without calls to xlatFree().
	The reason is that xlatLoad() allocates additional memory for each
	structure which should be freed.

RETURN VALUE
	On success, xlatLoad() returns 0, -1 otherwise.

	xlatDisp() and xlatFree() do not return anything.

	xlatCompile() returns a pointer to an internal static buffer which is
	overwritten by each call.

BUGS
	The package currently does not support the new mechanism of specifying
	text or PEX files in the language strings. The next version will.

	Also, the clear screen character will not be interpreted.  This is due
	to the bug in the language editor which would go berserk if you try to
	enter it.  This bug has been fixed in ProBoard v2.11 and the addition
	to the xlat??? package is on the wishlist.

