
UPLPROC			PB-Lib C/C++ Library Programmer's Manual		UPLPROC


NAME
	ulGetFirst - get first entry from the upload log
	ulGetNext - get next netry from the upload log

SYNOPSIS
	#include <proutil.h>

	int ulGetFirst(upload_t *rec);
	int ulGetNext(upload_t *rec);

DESCRIPTION
	This package provides support for easy processing of the UPLOAD.LOG
	logfile which is normally found in ProBoard's system directory.  This
	is a normal text file where each user upload is logged with the date,
	time, the file name and the uploader's name.

	These routines function similarly to the findfirst-findnext combo
	except that they format each record into a upload_t structure which
	can be used for processing.  The upload_t structure has the following
	layout:

						typedef struct{
						    char      file[13];
						    char      name[36];
						    struct tm date;
						} upload_t;

		'file'
			The name of the file (terminated with a '\0').

		'name'
			The name of the uploader (terminated with a '\0').

		'date'
			The upload date (only date and time).

	ulGetFirst() must be called first.  If successful (the file exists and
	is not empty), it will return 0 and the record pointed to by 'rec'
	will be filled with information.  Same goes for ulGetNext() which you
	call successively afterwards to obtain the next record from the file.

RETURN VALUE
	On success, both functions return 0 and the upload_t structure is
	filled with information.

	On error, both functions return -1 (*rec is undefined).

