
TFRAME			PB-Lib C/C++ Library Programmer's Manual		TFRAME


NAME
	tfGetEnable - get status of half-hour period for given day

SYNOPSIS
	#include <proutil.h>

	bool tfGetEnable(TimeFrame frame, const struct tm *timeRec);

DESCRIPTION
	TimeFrame is a structure that defines various periods of time in
	ProBoard's configuration.  For example, each menu entry has a time
	frame variable which determines when it is available.

	The TimeFrame is defined as a two-dimensional array of bytes, with six
	columns and seven rows.  The six columns represent the days of the
	week, starting with Monday = 0 and ending with Sunday = 6.  Note that
	this is different from the US convention of starting counting with
	Sunday.  Each row is an array of 7 * 8 = 48 bits, each representing a
	30 minute period, with 0:00-0:30 being bit 0, 0:30:1:00 - bit 1, and
	so on.  If the corresponding bit is set, this time frame is ON, else
	it is OFF, i.e. whatever uses this frame should not execute or allow
	access, or whatever.

	tfGetEnable() will use the structure pointed to by 'timeRec' in order
	to determine if the period defined in it is enabled in the time frame
	'frame' or not.  Note that this is a standard C library 'struct tm'
	record and must be filled correctly before passing it to the function.
	Note that you have to fill it in the conventional way, i.e.  Sunday ==
	0, not 6. tfGetEnable() will adjust itself automatically to the
	different value.

RETURN VALUE
	TRUE if the period is enabled and FALSE otherwise.

EXAMPLE
	See the E_TFRAME.C file for example.

