
PBKEYS			PB-Lib C/C++ Library Programmer's Manual		PBKEYS


NAME
	kbInit
	kbDeinit
	kbPeekKey
	kbGetKey
	kbFlush

SYNOPSIS
	#include <proutil.h>

	void kbInit(void);
	void kbDeinit(void);
	int kbPeekKey(bool *local);
	int kbGetKey(bool *local);
	void kbFlush(void);

DESCRIPTION
	This package provides a convenient way to handle extended keys within
	the ProBoard environment.  Currently, it supports the cursor keys,
	home, end, insert and delete.  Not all terminal emulation software
	handles those correctly.  As long as it sends the standard ANSI escape
	sequences, everything should be fine.

	kbInit() must be called before any keystroke processing can take
	place.  This function will install the local keyboard handler which is
	necessary to process correctly keys entered locally.

	kbDeinit() must be called after the handler is no longer needed.
	Failure to do so will leave the local handler resident and will cause
	erroneous (and difficult to track) problems with other programs.

	kbFlush() can be called is you want to flush the keyboard buffer.  For
	example, if you want to prompt for an answer to a particularly
	important question, you don't want a previously typed key to answer it
	before the user sees it.  This routine will flush the buffer and thus
	disable the typeahead.

	kbPeekKey() will return the next character from the keyboard buffer
	(but will not remove it from there).  Note that ProBoard's PeekKey()
	is not exactly a 'peek' function, but a 'get' since it will remove the
	keystroke from the buffer.  This function will return 0 if there's no
	key in the buffer or will return the character available (or any of
	the extended constants) and the variable pointed by 'local' will be
	set to TRUE if the character was entered locally and FALSE if it was
	entered from the remote site.

	kbGetKey() is used to fetch the actual key from the buffer.  Unlike
	kbPeekKey(), this function will remove the character from the buffer.
	Also, it will wait for a keystroke until one is available if the
	buffer is empty.  The variable pointed to by 'local' will be TRUE if
	the key was entered locally and FALSE if it was originated at the
	remote site.

	The keyboard buffer can hold up to 15 characters.  It is organized as
	a queue and once it is filled up, the oldest character will simply be
	overwritten by the new one.

EXTENDED CONSTANTS
	Keys are returned in a manner similar to PeekKey() and WaitKey().
	There are some extended keys recognized and the constants are given
	below (this is what the kbPeekKey() and kbGetKey() will return when
	those keys are entered).

			KEY_RT		- the right arrow key
			KEY_LT		- the left arrow key
			KEY_UP		- the up arrow key
			KEY_DN		- the down arrow key
			KEY_HOME	- the home key
			KEY_END		- the end key
			KEY_INS		- the insert key
			KEY_DEL		- the delete key

	The	functions do not recognize the PageUp and PageDown keys because
	they cannot be transmitted by the software (most of the terminal
	emulation programs I've seen reserve them for upload the download
	functions). It is easy to add them, though, if you wish.

RETURN VALUE
	kbInit(), kbDeinit(), and kbFlush() return nothing.

	kbPeekKey() returns 0 if there's no character available and the
	keystroke, if there is. It does not remove the key from the buffer.

	kbGetKey() waits for a keystroke and returns it.  It does remove it
	from the buffer.

BUGS
	You cannot use the cursor keys locally the way you might be used. If
	the software captures them before ProBoard sees them (and thse
	functions allow that), then you will not be able to use them to
	increment/decrement user's time.  This is an internal limitation of
	ProBoard with the keyboard handling.

