
PBINI			PB-Lib C/C++ Library Programmer's Manual		PBINI


NAME
	GetIniVar - get a parameter from an .INI file
	SetIniVar - set a parameter in the .INI file

SYNOPSIS
	#include <proutil.h>

	bool GetIniVar(char *filename, char *var, char *value, int len);
	bool SetIniVar(char *filename, char *var, char *value);

DESCRIPTION
	These functions are exact duplicates of the SDK's equivalents.  The
	difference is that these work offline too.  Here's the excerpt of the
	original documentation for the two:

	These functions can be used to read and write to .INI files. These
	files are similar to the files used by MS Windows. They can be
	used to store settings for your application (PEX). An example
	of a .INI file:

	      DataPath = C:\PB\PEX\MYPEX\DATA
	      ProgPath = C:\PB\PEX\MYPEX
	      MaxUsers = 10

	This is a standard ASCII file, with each line in the form
	   <varname> = <value>

	The value of a specific variable can be read by calling the
	function GetIniVar(). Setting a variable (writing to the .INI file
	or createing it if it doesn't exist yet) can be done by calling
	SetIniVar().

	The parameters for the functions are:

		'fname'
			Name of the .INI file.  The extension of the file will always
			be changed to .INI by ProBoard.

		'varname'
			Name of the variable (case insensitive)

		'value'
			For GetIniVar(), a pointer to a buffer where the variable's
			contents will be stored. For SetIniVar(), a pointer to the
			value of the variable.

		'max'
			Maximum number of characters that can be copied in 'value'
			(including trailing '\0')

	Note that even though the manual calls the files similar to MS
	Windows, they are not because they don't have section support.  For
	this (and for more functionality), see the alternate functions in the
	<stdini.h> file.  These will support ProBoard's INI files as well.  In
	fact, these two functions (as they come as a part of PB-Lib) are
	simply wrappers that call the extended ones.

RETURN VALUE
	On success, TRUE and FALSE is the file could not be opened or the
	variable does not exist.

SEE ALSO
	stdini.h functions for extended functionality
