
BOARDS			PB-Lib C/C++ Library Programmer's Manual		BOARDS


NAME
	GetBoard - get status of a board
	SetBoard - sets board to ON
	ToggleBoard - toggles state of board
	UnsetBoard - sets board to OFF
	UnsetAllBoards - sets all boards to OFF
	SetAllBoards - sets all boards to ON

SYNOPSIS
	#include <proutil.h>

	bool GetBoard(int num, combinedboards boards);
	void SetBoard(int num, combinedboards boards);
	void ToggleBoard(int num, combinedboards boards);
	void UnsetBoard(int num, combinedboards boards);
	void UnsetAllBoards(combinedboards boards);
	void SetAllBoards(combinedboards boards);

DESCRIPTION
	The 'combinedboards' structure is an array of bytes, with each bit
	corresponding to an area.  If the bit is set, the area is ON (included
	in message scans, for example), if the bit is OFF, the area is
	excluded.  Currently, there's a limit of 125 * 8 = 1000 areas that can
	be included in the combined boards (the first 1000).  This is a
	limitation of ProBoard and not PB-Lib.

	GetBoard() checks if area 'num' is ON or OFF.  No error checking is
	done on the 'num' parameter.

	SetBoard() will set 'num' area to ON regardless of its current state.

	ToggleBoard() will toggle the status of area 'num'.  If it was ON, it
	will be set to OFF, and vice versa.

	UnsetBoard() will turn area 'num' OFF regardless of its current state.

	UnsetAllBoards() will set all boards to OFF and SetAllBoards() will do
	exactly the opposite.

	Note that these routines are implemented as macros for fastest
	results.  If, for some reason, you want the functions (i.e. you need
	to have pointers to them or pass them to other functions), then you
	need to #define __BOARD_NOMAC before including the header file and
	this will give you the functions.

RETURN VALUE
	GetBoard() returns TRUE is the area is ON and FALSE otherwise.
	All other functions do not return anything.

