
WHATIS			PB-Lib C/C++ Library Programmer's Manual		WHATIS


NAME
	getFileType - get type of file

SYNOPSIS
	#include <whatis.h>
	int getFileType(const char *path);

DESCRIPTION
	getFileType() examines the file given by the 'path' argument and looks
	if it matches any of the internal values it recognizes.  This is done
	by opening the file and examining the header and (if necessary),
	checking some additional places within the file.  Usually, most typed
	files will identify themselves with a sequence of bytes in the header;
	this is what getFileType() looks for.  Other files require some more
	work as it is necessary to check offsets deeper within the file.  Note
	that file extensions are ignored completely and are not used in the
	identification process.  This is due to the fact that in any
	environment, these are volatile and subject to the user's whim.  Not
	so with our identification scheme.

	getFileType() recognizes files (the accent is placed on compressed
	archives) produced by the following utilities:  PKZIP, ARJ, LHA,
	PKLITE, PAK, ARC, PKPAK, DWC, RAR, ZOO, UCII, HAP, AIN, AINEXE, SQZ,
	SEZ, LZEXE and others. Also, GIF and JPEG files are recognized too.

FILE TYPE CONSTANTS
	When a file is recognized, one of the following constants is returned:

		ftAIN - file compressed by AIN (tested with v2.2)
		ftAINEXE - executable compressed with AINEXE (tested with v2.2)
		ftARC - file compressed with ARC or PKPAK
		ftARC7 - file compressed with ARC version later than 6.02
		ftARC7SX - self-extracting archive, compressed with ARC 6.02+
		ftARCSX - self-extracting archive, compressed with ARC or PKPAK
		ftARJ - file compressed with ARJ (tested with version 2.41a)
		ftARJSX - self-extracting file compressed with ARJ
		ftDWC - file compressed with DWC (tested with vA5.02)
		ftDWCSX - self-extracting archive, compressed with DWC
		ftEXE - regular executable
		ftGIF87 - GIF graphic image (old specification)
		ftGIF89 - GIF graphic image, new specification
		ftHAP - file compressed with HAP (tested with v3.00)
		ftJPEG - JPG graphic image
		ftLHA - file compressed with LHA (tested with v2.55b)
		ftLHASX - self-extracting archive, compressed with LHA
		ftLZEXE - executable compressed with LZEXE, version 0.91
		ftPAK - file compressed with PAK (tested with v2.51)
		ftPAKSX - self-extracting archive, compressed with PAK
		ftPKLITE - executable compressed with PKLITE (tested with v1.50)
		ftPKZIP - file compressed with PKZIP (tested with v2.04g)
		ftPKZIPSX - self-extracting archive, compressed with PKZIP
		ftRAR -	file compressed with RAR (tested with v1.53)
		ftRARSX - self-extracting archive, compressed with RAR
		ftSEZSX - self-extracting ZOO archive, compressed with SEZ
		ftSQZ - file compressed with SQZ (tested with v1.08.3)
		ftSQZSX - self-extracting archive, compressed with SQZ
		ftUC2 - file compressed with UCII (tested with revision 2)
		ftZOO - file compressed with ZOO (tested with v2.1)

RETURN VALUE
	On success, a ft??? constant is returned; -1 otherwise.

EXAMPLE
	See the example program WHATIS_X.C

BUGS
	The identifying scheme for self-extracting files created with ZIP2EXE
	is not very reliable, there seem to be at least two different offsets
	to test.

	The DWC files leave their signature at the end of the file.
	Sometimes, junk gets appended there and the recognition may fail.
	Since DWC is hardly a well-known compressor, this is of no big
	concern.

	SQZ and PKZIP self-extractors identify themselves as PKLITE-compressed
	executables.  The routine knows this and will check it accordingly.
	Therefore, if for some reason the signature is missing, the
	self-extractors will not be recognized.

