
STDINI			PB-Lib C/C++ Library Programmer's Manual		STDINI


NAME
	IniWrite    - writes an entry to the INI file
	IniReadStr  - reads a string entry from the INI file
	IniReadInt  - reads a signed integer entry from the INI file
	IniReadLong	- reads a signed long integer from the INI file
	IniReadBool - reads a boolean entry from the INI file

SYNOPSIS
	#include <stdini.h>

	int IniWrite(const char *file, const char *sec, const char *var
	   			 const char *value);
	int IniReadStr(const char *file, const char *sec, const char *var,
				char *value, const char *def);
	int IniReadInt(const char *file, const char *sec, const char *var,
				int *value, const int def);
	int IniReadLong(const char *file, const char *sec, const char *var,
				long *value, const long def);
	int IniReadBool(const char *file, const char *sec, const char *var,
				bool *value, const bool def);


DESCRIPTION
	All Ini* functions read and write Windows-style INI files. Unlike
	ProBoard-style INIs, those have section names and entry names. A
	section is specified within brackets, like that: [SectionOne]. You
	can have entries with same names in different sections. The Ini*
	functions also support ProBoard's flat format where only entries
	are allowed.

	You can provide default values via the 'def' parameter. They will
	be returned if any error occurs or the requested entry was not found.

	Any comment character is recognized, as long as no entries that are
	considered valid start with it (i.e. if you don't search for it).

	You can have whitespace before the entries (but not the sections)
	and before and after the '=' sign for the entries. Note that all
	whitespace after the '=' sign is skipped, so if you want to preserve
	it, you need to use the quotation marks for the string.

	All functions ignore case completely.

	IniWrite will modify or create (if necessary) a file with path given
	in the 'file' argument. If the 'sec' parameter is NULL, sections will
	effectively be ignored and all entries will be dumped at the start
	of the file. If the 'var' parameter is NULL, an empty section with
	name 'sec' will be created. If the 'value' parameter is NULL and
	'var' exists, it will be removed from the file. If both 'sec' and
	'var' are NULL, the behavior is undefined.

	IniReadStr will read a string (which means, any) entry from the INI
	file. If 'sec' is omitted, then sections will be ignored and entries
	will be located from the start of the file. If 'var' is NULL, the
	behavior is undefined. 'value' must be large enough to accomodate
	MAX_INI_LINE characters. You can check for toggles (entries that are
	there but don't have a right-side value) by simply calling IniReadStr.
	It does recognize those entries and will return success if one is
	found, pass NULL for 'def'.

	IniReadInt, IniReadLong function like IniReadStr except that they
	don't allow for toggles and accept only integers and longs,
	respectively. The values can be preceded by whitespace and (optionally)
	by a sign '+' or '-'. Those are handled correctly. If an invalid
	number is found, a wrong value might be returned with no error flag.

	IniReadBool reads boolean entries. The following are acceptable as
	right-side values: 'True', 'False', '0', '1' (with '0' meaning False
	and '1' meaning True). Everything else returns an error and the 'def'
	default value.

RETURN VALUE
	On success, the functions return 0, -1 otherwise.

EXAMPLE
	When you call IniWrite will all four parameters, like this:

		IniWrite( "SAMPLE.INI", "Section", "Variable", "Value One" );

	If the section "Section" does not exist, it will be created. Otherwise
	it will be searched for an entry "Variable". If the entry "Variable"
	does not exist, it will be created and the value will be "Value One".
	If "Variable" exists, its value will be changed to "Value One".

	When you call IniWrite like this:

		IniWrite( "SAMPLE.INI", NULL, "VariableTwo", "Something" );

	Sections will be ignored (they shouldn't be in the file) and the
	rest is like in the example above.

	When the call is:

		IniWrite( "SAMPLE.INI", "Section", "Variable", NULL )

	The entry "Varibale" under "Section" will be deleted (if found).

BUGS
	There is no way to delete sections. I am not sure I need this and
	that is why it's not there.

	As it stands, the write function is not very efficient, it copies
	the file while searching through it and finally renames the tempo-
	rary file to the original INI. It is neat and with the buffered
	IO (standard library, but NOT the SDK), it should be fast enough.

