
QSORT			PB-Lib C/C++ Library Programmer's Manual		QSORT


NAME
	qsort - performs a quick sort on an array of elements

SYNOPSIS
	#include "utils.h"

	void qsort(const void *base, size_t nelem, size_t width,
				int (*compare)(const void *, const void *));

DESCRIPTION
	qsort() is an implementation of the QuickSort algorithm invented and
	named by C.A.R. Hoare. qsort() sorts an array 'base' of 'nelem'
	elements in it, each of size 'width' by repeatedly calling the
	user-defined function 'compare'.  The comparison function is passed
	two pointers to elements being compared and should return values in
	the following manner:

		- if elem1 > elem2, returns an integer > 0

		- if elem1 == elem2, returns 0

		- if elem1 < elem2, returns an integer < 0

	'base' points to the first element of the array to be sorted.

	'nelem' is the number of elements in the array.

	'width' is the size of each element in bytes.

	Note that you cannot use the qsort() to sort an array twice using
	different keys and expecting that the second sort will sort within
	the first (e.g. you cannot sort files by name, then by date and
	expect that the date sort will be within the name sort).

	Remember, what the comparison function receives, are always pointers
	to the elements in the array. So, if you have an array of integers,
	it will receive pointers to integers. If you have an array of strings,
	it will receive pointers to pointers to characters. If you have an
	array of structures, it will receive pointers to those structures. Be
	careful to cast the void pointers to their proper type.

RETURN VALUE
	None.

EXAMPLE
	#include <stdio.h>
	#include <string.h>
	#include <sort.h>

	/* comment the following to test the integer sort */
	#define STR

	int sort_function( const void *a, const void *b);

	#if defined( STR )
	char *list[10] = {
				"cat", "carriage", "cabin", "cap", "cannister",
				"More here", "another", "doggy", "borland", "tommy"
	};
	#else
	int list[10] = { 34, 7, 0, 1, 1, 2653, 65, -32, -12, 382 };
	#endif

	int main(void)
	{
	   int  x;

	   qsort((void *)list, 10, sizeof(list[0]), sort_function);
	   for (x = 0; x < 10; x++)
	#if defined( STR )
		  printf("%s\n", list[x]);
	#else
		  printf("%d\n", list[x]);
	#endif
	   return 0;
	}

	int sort_function( const void *a, const void *b)
	{
	#if defined(STR)
		return( stricmp(*(char **)a,*(char **)b) );
	#else
		return *(int *)a - *(int *)b;
	#endif
	}

BUGS
	The current implementation does not use the 'median of three'
	technique which will reduce the likelihood of a bad selection
	for the middle element. We use literally the middle element.

