
DATE			PB-Lib C/C++ Library Programmer's Manual		DATE

NAME
	date_diff   - calculates the difference between two dates
	date_isleap - checks if year is leap (February has 29 days)
	date_julian - converts date to Julian format (number of day in the year)

SYNOPSIS
	#include <date.h>

	int date_diff( int day1, mon1, year1, day2, mon2, year2 );
	bool date_isleap( int year );
	int date_julian( int day, int mon, int year );

DESCRIPTION
	date_diff() calculates the difference (in days) between two dates.
	Note that no error checking is performed on the arguments.  The day
	values should be in the range 1-31 (depending on the month), the
	months can range from 1 to 12 and the years cannot be negative.

	date_isleap() checks if the given year is leap (i.e. if February has
	29 days). 'year' should be given in the normal Gregorian format, e.g.
	1995. Negative years are not supported.

	date_julian() calculates the number of the day in the given year. The
	day parameter should be in the range 1-31 (depending on the month),
	the month - in the range 1-12 and the year cannot be negative.  No
	checking is performed on the arguments.  Thus, for January 1 1995, you
	would pass 'day' = 1, 'mon' = 1, 'year' = 1995.

RETURN VALUE
	date_diff() returns the number of days difference between the dates.
	If the number is < 0, date1 is more recent than date2.  If it is
	greater than 0, date2 is more recent than date1.  0 indicates no
	difference.

	date_isleap returns TRUE is the year is leap and FALSE if not.

	date)julian returns the number of the day in the year, with January 1
	being day 1.

EXAMPLE
   #include <stdlib.h>
   #include <stdio.h>
   #include <date.h>

   void
   main( void )
   {
       int d1, m1, y1, d2, m2, y2;
       char buf[10];

       printf( "d1: " ); gets(buf); d1 = atoi(buf);
       printf( "m1: " ); gets(buf); m1 = atoi(buf);
       printf( "y1: " ); gets(buf); y1 = atoi(buf);
       printf( "d2: " ); gets(buf); d2 = atoi(buf);
       printf( "m2: " ); gets(buf); m2 = atoi(buf);
       printf( "y2: " ); gets(buf); y2 = atoi(buf);
       printf( "\nLeap: %d = %d, %d = %d\n",
           y1, date_isleap(y1), y2, date_isleap(y2) );
       printf( "\nDifference: %d\n", date_diff(d1,m1,y1,d2,m2,y2) );
   }

