
CRC32			PB-Lib C/C++ Library Programmer's Manual		CRC32


NAME
	UpdateCRC32 - updates the current CRC with new value
	fileCRC32   - calculates the 32-bit CRC of a file
	bufCRC32    - calculates the 32-bit CRC of a buffer

SYNOPSIS
	#include <crc32.h>

	extern dword tblCRC32[];

	dword UpdateCRC32(int c, dword crc);
	int   fileCRC32(const char *path, dword *crc);
	dword bufCRC32(const char *buf, size_t len);

DESCRIPTION
	UpdateCRC32 is implemeted as a macro.  It uses the tblCRC32 table with
	precalculated values to do an efficient update of the current CRC.  To
	use this macro directly, you need to initialize the 'crc' value to
	0xFFFFFFFFL (-1L).  After the input is exhausted, you need to
	complement the result.  Thus, the final 'crc' is actually ~crc.  If
	you are interested to see how the table was generated, refer to the
	program CRC32GEN.C:  it will write a .C file with the table and the
	UpdateCRC32 macro in them.  The algorithm for the generation is fully
	demonstrated there.

	fileCRC32 calculates the CRC of a file specified in path and places
	the result in *crc.

	bufCRC32 calculates the CRC of the buffer buf with len bytes in it.

RETURN VALUES
	UpdateCRC32 updates 'crc' adding the new 'c' value to it.

	On success, fileCRC32 returns 0, -1 otherwise, in which case the
	contents of '*crc' are undefined.

	bufCRC32 returns the CRC of the buffer.

EXAMPLE
	#include <stdio.h>
	#include <crc32.h>

	int
	main(int argc, char *argv[])
	{
		dword crc;

		if( --argc ){
			if( -1 == fileCRC32( argv[1], &crc ) )
				printf( "error: '%s' not readable\n", argv[1] );
			else printf( "CRC32: %08lx '%s'\n", crc, argv[1] );
		}
		else printf( "usage: %s filename\n", *argv );
		return 0;
	}


BUGS
	Philippe's implementation has a bug. The calculating function
	obviously returns a wrong value. Instead of ~crc, it returns the
	plain crc. To use the functions with ProBoard's CRCs, you need to
	negate the result. Thanks to Willem for that tip.

	Actually, it wasn't Philippe, it was the author of Remote Access.

ACKNOWLEDGEMENTS
	This is an implementation of 32 BIT ANSI X3.66 CRC.

	See the program CRC32GEN that generates the table and the macro.

	For a thorough discussion of CRCs, algorithms, their computation and
	implementation, see "A Painless Guide to CRC Error-Detection
	Algorithms" by Ross N. Williams. It is available for anonymous ftp
	from ftp.adelaide.edu.au as /pub/rocksoft/crc_v3.txt

	Also, see "The Working Programmer's Guide to Serial Protocols" by
	Tim Kientzle. It has a good discussion of CRCs and the math behind
	them. It also has a couple of suggested implementations for 12, 16
	and 32 bit CRCs with variations for XYZmodem and Kermit.

