BSEARCH			PB-Lib C/C++ Library Programmer's Manual		BSEARCH

NAME
	bsearch - performs a binary search on an array

SYNOPSIS
	#include <sort.h>

	void *bsearch(const void *key, const void *base, size_t nelem,
				  size_t width, int (*fcmp)(const void *, const void *));

DESCRIPTION
	bsearch() searches the array of 'nelem' elements pointed to by 'base'
	for an item matching the search 'key' and uses 'fcmp' to compare the
	two.  Because this is a binary search, the array must be in order for
	this function to work.  Also, there's no guarantee that the first
	matching entry will be the first one in the array.

		- 'base' is a pointer to the first element of the array.

		- 'nelem' is the number of elements in the array.

		- 'width' is the size (in bytes) of each element.

	The 'fcmp' comparison function is called each time a comparison is
	made with two arguments:  elem1 and elem2.  Each argument points to an
	item to be compared.  This function should compare the pointed two
	items (note that you are passed pointers to the items to compare, so
	be careful with items that are pointers themselves in the first place,
	then you need a second level of dereferencing them).  This functions
	should return the following integer values:

		- if *elem1 < *elem2, returns integer < 0

		- if *elem1 == *elem2, returns 0

		- if *elem1 > *elem2, returns integer > 0

RETURN VALUE
	bsearch() returns the address of the first entry in the array that
	matches the search key. If no match is found, 0 is returned.

DEALING WITH POINTERS
	Dealing with pointers might become tricky.  Refer to the example below
	to see how to search for strings in an array of strings (string names,
	recall, are just pointers to the first character of the string).

EXAMPLE
	#include <stdio.h>
	#include <sort.h>

	#ifdef INT_BSEARCH
	int compare(const void *p1, const void *p2)
	{
	   return(*(int *)&p1 - *(int *)&p2);
	}
	#else
	int compare(const void *p1, const void *p2)
	{
		return strcmp(*(char **)p1, *(char **)p2);
	}
	#endif

	int
	main(int argc, char *argv[])
	{
	#ifdef INT_BSEARCH
		int key = 634;
		int base[10] = { 0, 45, 87, 152, 439, 634, 763, 782, 900, 3521 };
	#else
		char *key = "doggy";
		char *base[5] = { "arghh", "dog", "doggy", "horse", "zippo" };
	#endif

		if( bsearch( &key, base, sizeof(base) / sizeof(base[0]),
			sizeof(int), compare ) )
			printf( "found in the table\n" );
		else printf( "not in the table.\n" );
		return 0;
	}
