
TELL			PB-Lib C/C++ Library Programmer's Manual		TELL

NAME
	tell - return the current position in a file

SYNOPSIS
	#include <fsys.h>

	long tell(int handle);

DESCRIPTION
	tell() gets the current position of the file pointer in the file
	associated with 'handle'.  It returns the result expressed in number
	of bytes from the beginning of the file.

RETURN VALUE
	On success, the offset is returned and -1L on error.

EXAMPLE
	#include <stdio.h>
	#include <fsys.h>

	void main(void)
	{
		int handle;
		char msg[] = "Hello, World!";

		if( -1 == (handle = open("TEST.$$$", O_CREAT | O_TEXT)))
			return -1;
		write( handle, msg, strlen(msg));
		printf( "offset: %ld\n", tell(handle) );
		close(handle);
	}
