
SRCHPATH		PB-Lib C/C++ Library Programmer's Manual		SRCHPATH


NAME
	searchPath - searches a path specification for a file

SYNOPSIS
	#include <fsys.h>

	char *searchPath(char *pathList, const char *filename);

DESCRIPTION
	searchPath searches the directories specified in 'pathList' for a file
	whose name is in 'filename'.  The 'pathList' can be a list of
	directories in standard MS-DOS PATH format, i.e. each directory is
	separated by a semi-colon (';'), like this:  "C:\BIN;C:\UTIL;C:\SYS";
	or it can be NULL, in which case searchPath searches first the current
	directory and then the directories in the MS-DOS PATH environment
	variable.

RETURN VALUE
	On success, the full path name is returned.  This one will contain the
	path and the filename.  On error, NULL is returned.  Note that on
	success, a pointer to a static buffer is returned.  It is overwritten
	on each call, so be sure to save the result if you need it.

EXAMPLE
	#include <stdio.h>
	#include <fsys.h>

	int main( void )
	{
		char buf[MAXPATH], *path;

		printf( "name? " ); gets(buf);
		if( NULL != (path = searchPath(NULL, buf)) ){
			printf( "srch: found '%s'\n", path );
		}
		else printf( "srch: no matches found.\n" );
		return 0;
	}


